using System;
using System.IO; 
using System.Data; 
using System.Collections; 
using Meta.Web;
using Meta.Web.Security;
using Meta.Data.Member;
using Meta.Data;
using MetaSite.Components.Providers; 
//51as/px./com
namespace MetaSite.Components
{
	/// <summary>
	/// Posts
	/// </summary>
	public class Posts
	{		

		#region GetPost
		
		public static Post GetPost(int postId) 
		{
			return Posts.GetPost(postId, false);
		}

		public static Post GetPost(int postId, bool trackViews) 
		{
			ContextData context = ContextData.Current;
		
			if (context.Items["Post" + postId] != null && !trackViews) 
			{
				return (Post) context.Items["Post" + postId];
			} 
			else 
			{				
				Post post = CommonDataProvider.GetPost(postId,trackViews);		
				CacheData.RemoveByPattern(string.Format("Forum-Topics-{0}",post.ForumId));
				context.Items["Post" + postId] = post;
				return post;
			}
		}
		#endregion

		public static ArrayList GetNoApprovedPostsInForum()
		{
			return CommonDataProvider.GetNoApprovedPostsInForum();            
		}

		public static DataTable GetNoApprovedPosts(int forumId)
		{
			return CommonDataProvider.GetNoApprovedPosts(forumId);            
		}

		public static void Approve(int postid)
		{
            CommonDataProvider.Approve(postid); 
		}

		public static void DeletePost(int postid)
		{
            CommonDataProvider.DeletePost(postid); 
		}
		
		public static Post AddPost(Post post) 
		{
			return AddPost (post, ContextData.Current.User);
		}

		public static Post AddPost (Post post, User postAuthor) 
		{
			ContextData Context = ContextData.Current;				

			Post newPost = CommonDataProvider.AddPost(post, postAuthor);			

			CacheData.RemoveByPattern(string.Format("Forum-Topics-{0}",newPost.ForumId));
			
			if(newPost.PostLevel > 1)
				CacheData.RemoveByPattern(string.Format("Forum-Posts-{0}",newPost.ParentId));	
		
			return newPost;
		}   
     
		public static DataTable GetPosts(int postId)
		{			
			ContextData context = ContextData.Current;
			string key = "Forum-Posts-{0}";
			string postCollectionKey = string.Format(key,postId);
			
			DataTable dt = CacheData.Get(postCollectionKey) as DataTable; 

			if (dt == null) 
			{	
				dt = CommonDataProvider.GetPosts(postId);

				CacheData.Insert(postCollectionKey,dt,6);
			}		

			return dt;
		}

		public static DataTable GetAdminPosts(int postId)
		{			
			DataTable dt = CommonDataProvider.GetPosts(postId,true);
			return dt;
		}
	
		public static void ClearPosts(int postId)
		{
			string key = "Forum-Posts-{0}";
			string postCollectionKey = string.Format(key,postId);
			CacheData.Remove(postCollectionKey);
		}
		
		public static void UpdatePost(Post post) 
		{			
			CommonDataProvider.UpdatePost(post);

			CacheData.RemoveByPattern(string.Format("Forum-Topics-{0}",post.ForumId));			
			CacheData.RemoveByPattern(string.Format("Forum-Posts-{0}",post.PostId));
			if(post.PostLevel > 1)
				CacheData.RemoveByPattern(string.Format("Forum-Posts-{0}",post.ParentId));			
		}		
	}
}
