using System;
using System.Data; 
using System.Collections;
using System.Collections.Specialized; 
using Meta.Web;
using Meta.Web.Security;
using Meta.Data.Member;
using Meta.Data;

namespace MetaSite.Components.Providers
{
	/// <summary>
	/// RolesProvider
	/// </summary>
	public class RolesProvider : IRolesProvider
	{
		string _Name;

		DataProvider _DataProvider;
		DataProvider _UsersInRoles;

		public RolesProvider()
		{	
			Initialize();
		}

		public void Initialize()
		{
			_DataProvider = new DataProvider("ms_Roles"); 
			_UsersInRoles = new DataProvider("ms_usersinroles"); 				
		}

		public RoleCollection GetRoleCollection()
		{
			DataTable t = GetRoles();
			RoleCollection rc = new RoleCollection();
			foreach( DataRow dr in t.Rows)
			{
				rc.Add(FormatRole(dr));
			}

			return rc;
		}

		public DataTable GetRoles()
		{  
            return _DataProvider.GetData().DefaultTable;  
		}

		public Role GetRole( string name)
		{
			DataTable t = _DataProvider.GetData("rolename = '"+ name +"'").DefaultTable;
  
			if ( t.Rows.Count > 0)
			{
				return FormatRole(t.Rows[0]); 
			}			
			return null;			
		}

		public Role GetRole(int roleId)
		{
			DataTable t = _DataProvider.GetData(" roleid = "+ roleId.ToString()).DefaultTable;
  
			if ( t.Rows.Count > 0)
			{
				return FormatRole(t.Rows[0]); 
			}			
			return null;		
		}

		public void UpdateRole(Role role)
		{
			CommonData cd = _DataProvider.GetData(" roleid = "+ role.RoleId.ToString());
  
			if(cd.Count == 0)
				return;

			DataRow dr = cd[0];
			
			dr["rolename"] = role.RoleName ;
			dr["description"] = role.Description;
			dr["Propertys"] =  role.Propertys.ValueString;

			_DataProvider.Update(cd);
		}

		public bool CanEdit( int roleid)
		{
			string sql = "select count(*) from {0} where roleid = {1}";
			int uc = (int)DataProvider.Execute(string.Format(sql,"ms_UsersInRoles",roleid.ToString())); 
			int fc = (int)DataProvider.Execute(string.Format(sql," ms_Permissions",roleid.ToString()));
            return 	(uc == 0 && fc == 0); 	
		}

		public static Role FormatRole(DataRow dr)
		{
			Role ro = new Role();
			ro .RoleId = (int)dr["roleid"];
			ro.RoleName = (string)dr["rolename"];
			ro.Description = dr["description"].ToString();
			ro.Propertys.AppendText(dr["Propertys"].ToString());
   
			return ro;
		}

		#region IRoleProvider Ա	

		public string Name
		{
			get { return _Name; }
			set { _Name = value; }
		}

		public void AddUsersToRoles(string[] usernames, string[] rolenames)
		{		

			foreach (string rolename in rolenames)
			{
				if (!RoleExists(rolename))
				{
					throw new Exception("Role name not found.");
				}
			}

			foreach (string username in usernames)
			{
				if (username.IndexOf(',') > 0)
				{
					throw new Exception("User names cannot contain commas.");
				}

				foreach (string rolename in rolenames)
				{
					if (IsUserInRole(username, rolename))
					{
						throw new Exception("User is already in role.");
					}
				}
			}


			CommonData ud = _UsersInRoles.CreateEmptyData();			

			foreach (string username in usernames)
			{
				foreach (string rolename in rolenames)
				{
					DataRow dr = ud.DefaultTable.NewRow();
					dr["UserId"] = DataProvider.Execute( "select userid from ms_users where username = '" + username +"'");
					dr["roleId"] = DataProvider.Execute( "select roleid from ms_roles where rolename = '" + rolename +"'");				
					ud.DefaultTable.Rows.Add(dr);  
				}
			}

			_UsersInRoles.Update(ud);

		}

		public bool RoleExists(string roleName)
		{			
			try
			{
				DataTable t = _DataProvider.GetData( "Rolename = '" + roleName + "'").DefaultTable ;
				return t.Rows.Count > 0;                				
			}
			catch (Exception e)
			{				
				throw e;				 
			}			
		}

		public string Permissions (string roleName)
		{
            DataTable t = _DataProvider.GetData( "Rolename = '" + roleName + "'").DefaultTable ;
			
			if ( t.Rows.Count == 0)
				throw new Exception("Role name not found.");

			return t.Rows[0]["propertys"].ToString();  
		}

		public void RemoveUsersFromRoles(string[] usernames, string[] rolenames)
		{
			foreach (string rolename in rolenames)
			{
				if (!RoleExists(rolename))
				{
					throw new Exception("Role name not found.");
				}
			}

			foreach (string username in usernames)
			{
				foreach (string rolename in rolenames)
				{
					DataProvider.Execute("delete  from ms_usersinroles where userid = (select userid from ms_users where username = '" + username + "') and "+
                                           " roleid = (select roleid from ms_roles where rolename = '" + rolename + "')");
				}
			}			
		}

		public bool IsUserInRole(string username, string rolename)
		{
			try
			{
				int uid = (int)DataProvider.Execute("select userid from ms_users where username = '" + username +"'");  
				int rid = (int)DataProvider.Execute("select roleid from ms_roles where rolename = '" + rolename +"'");  			

				DataTable t = _UsersInRoles.GetData( "userid = " + uid + " and Roleid ='" + rid + "'").DefaultTable ;
				return t.Rows.Count > 0 ;
			}
			catch
			{
				return false;
			}
		}

		public string[] GetRolesForUser(string username)
		{			
			string tmpRoleNames = "";		
	
			string userid = Users.GetUser(username).UserId.ToString();  

			try
			{
				DataTable t = _UsersInRoles.GetData( "userid = " + userid ).DefaultTable ;

				foreach(DataRow dr in t.Rows)
				{
					string rid = dr["roleid"].ToString(); 
					tmpRoleNames += DataProvider.Execute("select rolename from ms_roles where roleid = " + rid).ToString()+",";   
				}				
			}
			catch ( Exception e)
			{	
				throw e;				
			}		

			if (tmpRoleNames.Length > 0)
			{				
				tmpRoleNames = tmpRoleNames.Substring(0, tmpRoleNames.Length - 1);
				return tmpRoleNames.Split(',');
			}

			return new string[0];
		}

		public string[] GetUsersInRole(string roleName)
		{			
			string tmpRoleNames = "";	
			string rid = this.GetRole(roleName).RoleId.ToString(); 

			try
			{
				DataTable t = _UsersInRoles.GetData( "RoleId = " + rid ).DefaultTable ;

				foreach(DataRow dr in t.Rows)
				{
					int uid = int.Parse(dr["userid"].ToString());
					
					tmpRoleNames += Users.GetUser(uid).UserName+ ",";
				}				
			}
			catch ( Exception e)
			{	
				throw e;				
			}		

			if (tmpRoleNames.Length > 0)
			{				
				tmpRoleNames = tmpRoleNames.Substring(0, tmpRoleNames.Length - 1);
				return tmpRoleNames.Split(',');
			}

			return new string[0];
		}	

		public void CreateRole(string roleName)
		{
			if (roleName.IndexOf(',') > 0)
			{
				throw new Exception("Role names cannot contain commas.");
			}

			if (RoleExists(roleName))
			{
				throw new Exception("Role name already exists.");
			}

			CommonData cd = _DataProvider.CreateEmptyData(); 

			DataRow dr = cd.NewRow();
			dr["roleid"] = 0;
			dr["rolename"] = roleName;
			cd.AddRow(dr);
 
			_DataProvider.Update(cd); 
 
			//_DataProvider.Insert(roleName);		
			
		}

		public string[] GetAllRoles()
		{			
			string tmpRoleNames = "";			

			try
			{
				DataTable t = _DataProvider.GetData().DefaultTable;

				foreach(DataRow dr in t.Rows)
				{
                    tmpRoleNames += (string)dr["rolename"] + ",";
				}				
			}
			catch ( Exception e)
			{	
				throw e;				
			}		

			if (tmpRoleNames.Length > 0)
			{				
				tmpRoleNames = tmpRoleNames.Substring(0, tmpRoleNames.Length - 1);
				return tmpRoleNames.Split(',');
			}

			return new string[0];
		}

		public bool DeleteRole(string roleName, bool throwOnPopulatedRole)
		{			
			if (!RoleExists(roleName))
			{
				throw new Exception("Role does not exist.");
			}

			if (throwOnPopulatedRole && GetUsersInRole(roleName).Length > 0)
			{
				throw new Exception("Cannot delete a populated role.");
			}

			try
			{
                MetaSite.Components.Permissions.RemovePermission(this.GetRole(roleName));   
				_DataProvider.Delete( new string[]{  "Rolename = '" + roleName + "'"});
				_UsersInRoles.Delete ( new string[]{ "Rolename = '" + roleName + "'"});               
			}
			catch
			{
				return false;
			}			

			return true;
		}

		public string[] GetUserRoleNames(string username)
		{			
			string tmpRoleNames = "";			

			try
			{
				DataTable t = _UsersInRoles.GetData( "username = ( select userid from ms_users where username = '" + username + "')").DefaultTable;

				foreach(DataRow dr in t.Rows)
				{
					tmpRoleNames += (string)dr["roleName"] + ",";
				}				
			}
			catch ( Exception e)
			{	
				throw e;				
			}		

			if (tmpRoleNames.Length > 0)
			{				
				tmpRoleNames = tmpRoleNames.Substring(0, tmpRoleNames.Length - 1);
				return tmpRoleNames.Split(',');
			}

			return new string[0];
		}

		#endregion
	}
}
