using System;
using System.Data; 
using System.Collections.Specialized;  
using Meta.Web;
using Meta.Web.Security;
using Meta.Data.Member;
using Meta.Data;  
  
namespace MetaSite.Components.Providers
{
	/// <summary>
	/// UsersProvider
	/// </summary>
	public class UsersProvider : IUsersProvider
	{
		DataProvider _DataProvider;
		DataProvider _Profile;

		public UsersProvider()
		{
            _DataProvider = new DataProvider("ms_Users"); 	
			_Profile =   new DataProvider("ms_Profile"); 
		}
		
		public DataTable GetUsers()
		{  
			return _DataProvider.GetData().DefaultTable;  
		}

		public static bool ExistNick(string nick)
		{
			string sql = "select coiunt(*) from ms_Users where nickname = '{0}'"; 
            return ((int)DataProvider.Execute(string.Format(sql,nick))> 0); 
		}

		#region IUsersProvider Ա

		public static void Updatepassword(int userId,string password)
		{
			DataProvider.Execute(string.Format("update ms_Users set password = '{0}' where userid = {1}",password,userId));    
		}

		public bool ValidateUser(string username, string password)
		{	
			DataTable t = _DataProvider.GetData( "username = '"+username+"' and password='" +password+"'").DefaultTable;  
			DataProvider.Execute("update ms_Users set LastLoginDate = '" + DateTime.Now.ToString() + "' where username='"+ username+"'");  

			return (t.Rows.Count == 1);
		}

		public string GetUserNameByEmail(string email)
		{	
			DataTable t = _DataProvider.GetData( "email = '"+email+"'").DefaultTable;  
			if ( t.Rows.Count > 0)
			     return t.Rows[0]["username"].ToString();
			else
				return string.Empty;
		}		

		string _Name;

		public string Name
		{
			get { return _Name; }
			set { _Name = value; }
		}

		private User GetUser(DataRow row)
		{
			User u = null;

			try
			{
				u = new User((int)row["userid"],
					row["username"].ToString(),
					row["nickname"].ToString(),
					row["email"].ToString(),					
					DateTime.Parse(row["creationdate"].ToString()),
					DateTime.Parse(row["lastlogindate"].ToString()),
					DateTime.Parse(row["lastactivitydate"].ToString()));				

				DataTable t = _Profile.GetData( "userid = "+ row["userid"].ToString()).DefaultTable;	
		
				SetPropertys(u.Propertys,t.Rows[0]);  
			}
			catch
			{
                
			}
		
			return u;			
		}

		private void SetPropertys( NameValueCollection nv,DataRow row)
		{
			FieldCollection  dbms = _Profile.Fields; 				
 
			for(int i = 0 ;i< dbms.Count;i++)
			{
				Field f = dbms[i];
				nv.Add(f.Name,row[f.Name].ToString());
			}			
		}

		public User GetUser( string username, bool userIsOnline )
		{
			DataTable t = _DataProvider.GetData( "username = '"+username+"'").DefaultTable;  

			if ( t.Rows.Count > 0)
				return GetUser(t.Rows[0]);
			else			
	    		return null;
		}

		public User GetUser( int userid )
		{
			DataTable t = _DataProvider.GetData( "userid = "+ userid).DefaultTable;  

			if ( t.Rows.Count > 0)
				return GetUser(t.Rows[0]);
			else			
				return null;
		}

		private void UpdatePropertys( NameValueCollection propertys ) //
		{
			string userid = propertys["userid"];
			
			CommonData data = _Profile.GetData( "userid=" + userid );

			if ( data.DefaultTable.Rows.Count == 0 )
				return;
			
			DataRow r = data.DefaultTable.Rows[0];
			
			foreach( string name in propertys )
			{
				if ( name.ToLower() != "userid")
				{
					r[name] = propertys[name];
				}
			}

			_Profile.Update( data);            			
		}

		public void UpdateUser(User user)
		{
			UpdatePropertys(user.Propertys);

			CommonData data = _DataProvider.GetData ( "userid = "+ user.UserId );
   
			if ( data.DefaultTable.Rows.Count == 0 )
				return;
			
			DataRow r = data.DefaultTable.Rows[0];
 
			r["email"] = user.Email;
			r["isonline"] = user.IsOnline; 
			r["LastLoginDate"] = user.LastLoginDate;
			r["LastActivityDate"] = user.LastActivityDate; 

			_DataProvider.Update( data ); 
			
		}

		static int _MinRequiredPasswordLength = 4;
		public int MinRequiredPasswordLength
		{
			get	{	return _MinRequiredPasswordLength;}
			set { _MinRequiredPasswordLength = value;}
		}		

		public User CreateUser(string username, string nickname, string password, string email, out UserCreateStatus status)
		{			
			status = UserCreateStatus.Success; 

			string valiSql = " select count(*) from ms_users where {0}='{1}'";

			if( int.Parse(DataProvider.Execute(string.Format(valiSql,"username", username)).ToString()) > 0)
			{
				status = UserCreateStatus.DuplicateUserName;				
			}

			if( int.Parse(DataProvider.Execute(string.Format(valiSql,"nickname", nickname)).ToString()) > 0)
			{
				status = UserCreateStatus.DuplicateEmail;				
			}

			if ( status != UserCreateStatus.Success)
				return null;

		
			int id = (int)(_DataProvider.Insert( username,"",nickname,password,email,DateTime.Now,DateTime.Now,DateTime.Now,1));

			_Profile.Insert(id,0,0,0,0,""); 
			   
			return GetUser(username,true);
		}

		public UserCollection GetAllUsers(out int totalRecords)
		{	
			DataTable t = _DataProvider.GetData().DefaultTable;

			totalRecords = t.Rows.Count;

			UserCollection uc = new UserCollection();

			for(int i = 0; i< t.Rows.Count ;i++)
			{
				uc.Add(GetUser(t.Rows[i]));  
			} 
			
			return uc;
		}

		public string GetPassword(string username)
		{
			DataTable t = _DataProvider.GetData( "username = '"+username+"'").DefaultTable;  
			if ( t.Rows.Count > 0)
				return t.Rows[0]["password"].ToString();
			else
				return null;	
		}

		public bool DeleteUser(string username, bool deleteAllRelatedData)
		{			
			return ( _DataProvider.Delete( new string[]{ "username = '"+username+"'"}) == 1) ;
		}

		public bool ChangePassword(string username, string oldPassword, string newPassword)
		{
			CommonData data = _DataProvider.GetData( "username = '"+username+"' and password='" +oldPassword+"'");  
			
			if (data.DefaultTable.Rows.Count != 1)
				return false;
			else
			{
				data.DefaultTable.Rows[0]["password"] = newPassword;
				_DataProvider.Update(data);

				return true;
			}
		}

		public int GetNumberOfUsersOnline()
		{			
			return 0;
		}

		static int _UserIsOnlineTimeWindow;

		public int UserIsOnlineTimeWindow
		{
			get	{	return _UserIsOnlineTimeWindow;}
			set { _UserIsOnlineTimeWindow = value;}
		}

		#endregion
	}
}
