using System;
using System.Data;
using Meta.Web; 
using MetaSite.Components.Providers; 

namespace MetaSite.Components
{
	/// <summary>
	/// Resources
	/// </summary>
	public class Resources
	{
		public static Resource GetResource(int id) 
		{
            string key = "Resource-id-{0}";
            Resource res = CacheData.Get(string.Format(key,id.ToString())) as Resource;

            if (res == null)
            {
                res = CommonDataProvider.GetResource(id);
                CacheData.Insert(key, res, 6);
            }

            return res;			
		}

		public static Resource GetResource(string code) 
		{
            string key = "Resource-code-{0}";
            Resource res = CacheData.Get(string.Format(key, code)) as Resource;

            if (res == null)
            {
                res = CommonDataProvider.GetResource(code);
                CacheData.Insert(key, res, 6);
            }

            return res;						
		}

        public static DataTable GetResources(ref int pcount, int psize,int pid ) 
		{
            string key = string.Format("Resource-{0}-{1}", psize, pid);
            DataTable t = CacheData.Get( key) as DataTable;

            if (t == null)
            {
                t = CommonDataProvider.GetResources(psize, pid); 
                CacheData.Insert(key, t, 6);
            }

            pcount = CommonDataProvider.ResourcesCount();

            return t;					
		}

		public static DataTable GetResources(int sty) 
		{
            string key = "Resource-sry-{0}";
            DataTable t = CacheData.Get(string.Format(key,sty.ToString())) as DataTable;

            if (t == null)
            {
                t = CommonDataProvider.GetResources(sty); 
                CacheData.Insert(key, t, 6);
            }

            return t;				
		}

		public static void DeleteResource(int id)
		{
			CommonDataProvider.DeleteResource(id);
            CacheData.Remove("Resource");
            CacheData.Remove(string.Format("Resource-sty-{0}", id.ToString()));            
		}
		public static Resource AddResource(Resource r)
		{
            CacheData.Remove("Resource");           
			return CommonDataProvider.AddResource(r);           
		}	

		public static void UpdateResource(Resource r)
		{
			CommonDataProvider.UpdateResource(r);
            CacheData.Remove("Resource");
            CacheData.Remove(string.Format("Resource-id-{0}", r.Id.ToString()));
            CacheData.Remove(string.Format("Resource-code-{0}", r.Code));   
		}		
	}
}
