using System;
using System.Configuration; 
using System.Collections.Specialized; 

namespace MetaSite.Components
{
	/// <summary>
	/// SiteSettings
	/// </summary>
	public class SiteSettings
	{	
		#region"base"

		static NameValueCollection settings;	

		public static string Setting(string name)
		{		
			if ( settings == null)
                settings = ConfigurationManager.GetSection("System") as NameValueCollection; 

			return settings[name];			
		}

		public static int GetIntFromSettings(string name)
		{			
			try
			{
				return int.Parse(Setting(name)); 
			}
			catch
			{
				return -1;
			}			
		}

		#endregion

		#region"systemsettings"

		public static bool Approve
		{
			get
			{
				string val = Setting("Approve");

				if ( val == "1" || val.ToLower() == "true")
					return true;
				else
					return false;
			}
		}
		
		#endregion
	}
}
