using System;
using System.Globalization;
using System.Web;
using System.Web.UI;
using System.Xml;
using System.Xml.Serialization;
using System.Text;
using System.IO;
using Meta.Web; 


namespace MetaSite.Components
{
	/// <summary>
	/// ToolItem
	/// </summary>
	[Serializable]
	public class ToolItemCollection
	{
		private ToolItem[] _toolItems;
		
		[XmlArray("ToolItems")]
		public ToolItem[] ToolItems
		{
			get {  return this._toolItems; }
			set {  this._toolItems = value; }
		}
	}

	[Serializable]
	public class ToolItem
	{
		#region Private Members
		private string _text;
		private string _selects;
		private string _href;
		private string _target = string.Empty;
		private string _name;		
		private string _roles;
		private bool _enable = true;
		private ToolItem[] _children;		
		#endregion

		#region Public Properties
		/// <summary>
		/// Property Text (string)
		/// </summary>
		[XmlAttribute("text")]
		public string Text
		{
			get {  return this._text; }
			set {  this._text = value; }
		}
        
		/// <summary>
		/// Property Href (string)
		/// </summary>
		[XmlAttribute("href")]
		public string Href
		{
			get {  return this._href; }
			set {  this._href = value; }
		}

		/// <summary>
		/// Property Href (string)
		/// </summary>
		[XmlAttribute("target")]
		public string Target
		{
			get {  return this._target; }
			set {  this._target = value; }
		}		

		/// <summary>
		/// Property Name (string)
		/// </summary>
		[XmlAttribute("name")]
		public string Name
		{
			get {  return this._name; }
			set {  this._name = value; }
		}
		/// <summary>
		/// Property Name (string)
		/// </summary>
		[XmlAttribute("selects")]
		public string Selects
		{
			get {  return this._selects; }
			set {  this._selects = value; }
		}
	
		/// <summary>
		/// Property Roles (string)
		/// </summary>
		[XmlAttribute("roles")]
		public string Roles
		{
			get {  return this._roles; }
			set {  this._roles = value; }
		}

		/// <summary>
		/// Property Enable (bool)
		/// </summary>
		[XmlAttribute("enabled")]
		public bool Enabled
		{
			get {  return this._enable; }
			set {  this._enable = value; }
		}
	
		/// <summary>
		/// Property Children (Tab[])
		/// </summary>
		[XmlArray("SubItems")]
		public ToolItem[] Children
		{
			get {  return this._children; }
			set {  this._children = value; }
		}
		#endregion

		#region Has Helpers
		public bool HasChildren
		{
			get{return this.Children != null && this.Children.Length > 0;}
		}

		public bool HasSelects
		{
			get{return this.Selects != null && this.Selects.Length > 0;}
		}
	
		public bool HasRoles
		{
			get{ return ( this.Roles != null && this.Roles != string.Empty);}
		}
		#endregion
	}
}
