using System;
using System.Data;
using System.Web.Caching;
using Meta.Web; 
using MetaSite.Components.Providers;    

namespace MetaSite.Components
{
	/// <summary>
	/// Topics 
	/// </summary>
	public class Topics
	{
		/*public static DataTable GetTopics(int forumId) 
		{			
			string key = "Forum-Topics-{0}";
			string cacheKey = string.Format(key,forumId);			
		
			DataTable dt = CacheData.Get(cacheKey) as DataTable;
			if (dt != null)
				return dt;				

			dt  = CommonDataProvider.GetTopics(forumId,0);			
			CacheData.Insert(cacheKey,dt, CacheData.MinuteFactor,CacheItemPriority.Low);				
			return dt;
		}*/

        public static DataTable GetTopics(ref int pcount,int psize,int pid,int forumId)
        {
            pcount = CommonDataProvider.GetTopicsCount(forumId); 
            string key = "Forum-Topics-{0}-{1}-{2}";
            string cacheKey = string.Format(key, forumId,psize, pid );

            DataTable dt = CacheData.Get(cacheKey) as DataTable;
            if (dt != null)
                return dt;

            dt = CommonDataProvider.GetTopics(forumId,psize,pid);

            CacheData.Insert(cacheKey, dt, CacheData.MinuteFactor, CacheItemPriority.Low);

            return dt;
        }

        public static DataTable GetTopics(int forumId,int top)
        {
            string key = "Forum-Topics-Top-{0}-{1}";
            string cacheKey = string.Format(key, forumId,top);

            DataTable dt = CacheData.Get(cacheKey) as DataTable;
            if (dt != null)
                return dt;

            dt = CommonDataProvider.GetTopics(forumId,top);

            CacheData.Insert(cacheKey, dt, CacheData.MinuteFactor, CacheItemPriority.Low);

            return dt;
        }	

		public static Topic GetTopic(int TopicId)
		{
			string cacheKey = "Topic-" + TopicId;
			Topic topic = ContextData.Current.Items[cacheKey] as Topic;

			if(topic == null)
			{
				topic = CommonDataProvider.GetTopic(TopicId);
				ContextData.Current.Items.Add(cacheKey, topic);
			}

			return topic;
		}

		//public static DataTable GetHotTopics(int top,) 
	//	{
		//	return GetHotTopics(0,top); 
		//}

        public static DataTable GetHotTopics(ForumType type,int top) 
		{
			string key = string.Format("Forum-HotTopics-{0}-{1}",type,top);			
			DataTable dt = CacheData.Get(key) as DataTable;
			if (dt != null)
				return dt;		
			dt  = CommonDataProvider.GetHotTopics(type,top);			
			CacheData.Insert(key,dt, CacheData.MinuteFactor,CacheItemPriority.Low);					
			return dt;
		}

        public static DataTable GetHotTopics(int forumId,int top)
        {
            string key = string.Format("Forum-HotTopics-id-{0}-{1}",forumId,top);
            DataTable dt = CacheData.Get(key) as DataTable;
            if (dt != null)
                return dt;
            dt = CommonDataProvider.GetHotTopics(forumId,top);
            CacheData.Insert(key, dt, CacheData.MinuteFactor, CacheItemPriority.Low);
            return dt;
        }
	}
}
