﻿<%@ page language="C#" autoeventwireup="true" validaterequest="false" inherits="ColumnManage_ContentList, App_Web_vkwqxb1y" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>栏目内容列表</title>
    <link rel="stylesheet" href="../style/Common.css" />
    <link rel="stylesheet" href="../style/Frame.css" />

    <script type="text/javascript" src="../Script/Common.js"></script>
    <script type="text/javascript">
var btnHide, btnExpose, btnDelete;  //btnEdit, 
var CheckBoxes=[];
function Page_Init()
    {
	btnHide = $('btnHide');
	btnExpose = $('btnExpose');
	btnDelete = $('btnDelete');

	var inputs = document.getElementsByTagName('INPUT');
	for( var i=0, j=0; i<inputs.length; i++ ){
	    var input= inputs[i];
	    if( input.type=='checkbox' && !input.onclick ){
	        CheckBoxes[j++] = input;
	        input.onclick = FreshButton;
	    }
	}
    }

var SiteName, ColName;
function Page_Load()
    {	
	SiteName = Common.GetQueryString('sitename');
	ColName = Common.GetQueryString('colname');

	$('lkColumnEdit').href = 'ColumnEdit.aspx' + location.search;	
	FreshButton();
    }
function FreshButton()
    {
	var count = 0;
	for( var i=0; i<CheckBoxes.length; i++ ){
	    var chk = CheckBoxes[i];
	    if( chk && chk.checked ) {
	        count++;
	        if( count >= 2 ) break;
	    }
	}
	btnHide.disabled = true;
	btnExpose.disabled = true;
	btnDelete.disabled = true;
	if( count>=1 ){
	    btnHide.disabled = false;
	    btnExpose.disabled = false;
	    btnDelete.disabled = false;
	}
    }
function btnRowEdit_Click( obj )
    {
	var hfRec = obj.parentNode.parentNode.childNodes[0].childNodes[2];
	var row = hfRec.value;
	
	var url = new UrlText( 'ContentEdit.aspx', ['optype', 'editcontent'] );
	url.Add( ['colname', ColName], ['sitename', SiteName], ['recid', row ], 'uni' );
	location = url.Text;
    }
//	btnEdit = $('btnEdit');
//	btnEdit.disabled = true;
//	    if( count == 1 )
//	        btnEdit.disabled = false;
//	var ret = Common.ShowDialog( 1, url.Text, null, {width:760, height:500, offset:true} );
//	if( /^ok/i.test(ret) )
//	    location.reload( true );
    </script>
</head>
<body><form id="form1" runat="server">

    <div class="TopArea">
        <div class="LeftBlock">
            <span class="Heading">栏目内容列表</span>
            <asp:Label ID="lbColumnPath" runat="server" Text="[]" CssClass="Notes"/>
        </div>
        <div class="RightBlock">
            <a id="lkColumnEdit" href="#">编辑该栏目结构</a>
        </div>
    </div>

    <div class="ContentArea">
        <asp:GridView ID="gvContentList" runat="server" CellPadding="1"  CellSpacing="1"  CssClass="DataTable" PageSize="10"
                OnRowCreated="gvContentList_RowCreated" OnPageIndexChanging="gvContentList_PageIndexChanging" >
            <Columns>
                <asp:TemplateField HeaderText="">
                    <HeaderTemplate>
                        <asp:CheckBox ID="allCheck" runat="server" OnCheckedChanged="allCheck_CheckedChanged" AutoPostBack="True" />
                    </HeaderTemplate>
                    <ItemTemplate >
                        <asp:CheckBox ID="ItemCheck" runat="server"/>
                        <input id="hfRecId" type="hidden" runat="server" value='<%# DataBinder.Eval(Container.DataItem,"索引标识")%>'  /> 
                    </ItemTemplate>
                    <ItemStyle CssClass="checkCol" />
                </asp:TemplateField>
                <asp:TemplateField>
                    <ItemTemplate>
                        <input id="btnRowEdit" type="button" value="编辑" onclick="btnRowEdit_Click(this);" />
                    </ItemTemplate>
                    <ItemStyle Width="20"/>
                </asp:TemplateField>
            </Columns>   
            <AlternatingRowStyle CssClass="Alternating" />
        </asp:GridView>

        <div>
            <asp:Button ID="btnAdd" runat="server" CssClass="Button" Text="添加内容" OnClick="btnAdd_Click" Enabled="false" />
            <%--<asp:Button ID="btnEdit" runat="server" CssClass="Button" Text="编辑内容" OnClick="btnEdit_Click" Enabled="false" />--%>&nbsp;&nbsp;&nbsp;
            <asp:Button ID="btnHide" runat="server" CssClass="Button" Text="隐藏内容" OnClick="btnHide_Click" Enabled="false"/>
            <asp:Button ID="btnExpose" runat="server" CssClass="Button" Text="显示内容"  OnClick="btnExpose_Click" Enabled="false" />
            <asp:Button ID="btnDelete" runat="server" CssClass="Button" Text="删除内容" OnClientClick="return confirm('您确认要删除这些吗?')" OnClick="btnDelete_Click" Enabled="false" />
        </div>
        <asp:Label ID="lbInfo" runat="server" ForeColor="Red"/>
    </div>

</form>
<script type="text/javascript">
try{ Page_Init(); }catch(ex){;}
try{ if( Page_Resize ) window.onresize=Page_Resize; }catch(ex){;}
try{ if( Page_Load ) window.onload=Page_Load; }catch(ex){;}
</script>
</body>
</html>
        
