﻿<%@ page language="C#" autoeventwireup="true" inherits="PageEdit_CssEdit, App_Web_za61ov8a" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>HTML 页面编辑</title>
    <link rel="stylesheet" href="../style/Common.css" />
    <link rel="stylesheet" href="../style/Frame.css" />
    <style type="text/css">
#PageFrame{
    margin: 1px 3px;
    display: block;
}
    </style>

    <script type="text/javascript" src="../Script/Common.js"></script>
    <script type="text/javascript" >
var PageFrame, lnkPreview, btnPreview, btnSource;
function Page_Init()
    {
	PageFrame = $('PageFrame');
	lnkPreview = $('lnkPreview');
	btnPreview = $('btnPreview');
	btnSource = $('btnSource');
    }

var SiteName, SiteUrl, FilePath, FileUrl, CodePageUrl;
function Page_Load()
    {
	SiteName = Common.GetQueryString('sitename');
	if( !SiteName ) return;
	
	SiteUrl = $('hfSiteRootUrl').value;
	FilePath = $('hfPagePath').value;
	if( SiteUrl && FilePath ){
	    //-------------为调试的代码----------------
	    $('hfSiteRootUrl').value = SiteUrl = SiteUrl.replace(/localhost(:\d+)?/i,'localhost');
	    //-----------------------------------------
	    var file = new UrlText( SiteUrl, FilePath );
	    var code = new UrlText( 'HtmlCode.aspx', ['sitename', SiteName], ['path', FilePath] );
	    FileUrl = file.Text;
	    CodePageUrl = code.Text;
	    lnkPreview.href = FileUrl;
	    _Preview( FileUrl );
	    btnPreview.disabled = false;
	    btnSource.disabled = false;
	} else{
	    lnkPreview.innerText = '';
	}
    }

function Page_Resize()
    {
	var w, h;
	w = document.documentElement.clientWidth-6;
	if( w<0 ) w=0;
	h = document.documentElement.clientHeight-34;
	if( h<0 ) h=0;
	PageFrame.style.width = w;
	PageFrame.style.height = h;
    }

function btnSource_Click()
    {
	if( CodePageUrl )
	    PageFrame.src = CodePageUrl +'&uni='+ Common.UniqueValue();
    }

function btnPreview_Click()
    {
	_Preview( FileUrl );
    }

function _Preview( url )
    {
	if( url ){
	    PageFrame.src = url + '?uni='+Common.UniqueValue();
	    PageFrame.onreadystatechange = PageFrame_Load.bind( PageFrame );
	}
    }
function PageFrame_Load()
    {
	if( this.readyState == 'complete' ){
	    DisableLink( this.contentWindow );
	}
    }
function DisableLink( win )
    {
	if( !win || !win.document ) return;
	
	var linkList = win.document.getElementsByTagName('A');
	var n = linkList.length;   //alert(n);
	for( var i=0; i<n; i++ ){
	    var link = linkList[i];
	    link.onclick = function(){return false};
	    link.onmousedown = function(){return false};
	    link.onmouseup = function(){return false};
	}
    }

    </script>
</head>

<body scroll="no"><form id="form1" runat="server">

    <div class="TopArea">
        <div class="LeftBlock">
            <span class="Heading">HTML 页面编辑</span>
            <asp:Label ID="lbFileName" runat="server" Text="[]" CssClass="Notes"/>
        </div>
        <div class="RightBlock" style="margin: 3px 2px 0;">
            <asp:Label ID="lbInfo" runat="server" ForeColor="Red"/>
            [<a id="lnkPreview" href="#" target="_blank">预览</a>]
            <input id="btnPreview" class="Button" value="页面" type="button" onclick="btnPreview_Click();" disabled="disabled" />
            <input id="btnSource" class="Button" value="源代码" type="button" onclick="btnSource_Click();" disabled="disabled" />
        </div>
    </div>

    <iframe id="PageFrame" class="EditArea" frameborder="0" runat="server"></iframe>
    
    <asp:HiddenField ID="hfSiteRootUrl"  runat="server" /> 
    <asp:HiddenField ID="hfPagePath"  runat="server" /> 
    
</form>
<script type="text/javascript" language="javascript">
try{ Page_Init(); }catch(ex){;}
try{ Page_Resize(); window.onresize=Page_Resize; }catch(ex){;}
try{ Page_Load(); }catch(ex){;}
</script>
</body>
</html>
