using System;
using System.Data;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;

public partial class Part_ArticleContent : System.Web.UI.UserControl
{
    private PartAccess pAcc = null;
    private int aid = 0;

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            aid = Todo.GetInt( "aid", Request, -1 );
            if( aid < 0 ) return;

            pAcc = new PartAccess( this );
            if( pAcc.IsReady )
                PartShow();

        } catch( Exception ex ) {
            Todo.DebugOut( " Part_ArticleContent 쳣" + ex.Message );
        }
    }

    private void PartShow()
    {
        // ȡ 
        ContentAccess ca = new ContentAccess( this, "TableName" );
        DataTable dt = ca.Read( "[@ID=" + aid + "]", "name" );
        if( dt == null || dt.Rows.Count < 1 ) {
            lbHeading.InnerText = "ûҵ";
            return;
        }

        // ʾ µı
        DataRow dr = dt.Rows[0];
        string heading = Todo.Get( "Heading", dr );
        lbHeading.InnerText = heading;
        if( this.Page.Title == "" )
            this.Page.Title = heading;
        else
            this.Page.Title = heading + " - " + this.Page.Title;

        // ʾ
        ltrContent.Text = Todo.Get( "Content", dr );

        // ʾʱ
        string issueTime = Todo.Get( "IssueTime", dr );
        string format = pAcc.GetSetting( "issueTimeFormat" );
        lbIssueTime.InnerText = Todo.TimeFormat( issueTime, format );

        // ʾ  Դ  
        lbAuthor.InnerText = Todo.Get( "Author", dr );
        lbSource.InnerText = Todo.Get( "Source", dr );
        lbVisited.InnerText = Todo.Get( "Visited", dr );
    }
}
