using System;
using System.Data;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using BoyunBase;
using SiteCore;

public partial class Part_ArticleFullList : System.Web.UI.UserControl
{
    private PartAccess pAcs = null;
    private DataTable contDt = null;
    private bool isDbReady = false;

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            if( !IsPostBack ) { //״
                ReadData();
                BindData();
                ShowPager();
            } else {            //ط
                GetData();
            }

        } catch( Exception ex ) {
            Todo.DebugOut( " Part_ArticleFullList 쳣" + ex.Message );
        }
    }

    protected void PagerButton_Click( object sender, EventArgs e )
    {
        gvFullList.PageIndex = Convert.ToInt32( ((LinkButton)sender).CommandName );
        BindData();
        ShowPager();
    }

    protected void lstPageIndex_SelectedIndexChanged( object sender, EventArgs e )
    {
        gvFullList.PageIndex = lstPageIndex.SelectedIndex;
        BindData();
        ShowPager();
    }
    
    private void ReadData()     //
    {
        ContentAccess ca = new ContentAccess( this, "TableName" );
        DataTable dt = ca.Read( "[*]", "name" );
        if( dt == null && dt.Rows.Count > 0 ) return;
        contDt = dt;

        string contentPage = pAcs.GetSetting( "contentPage" );
        if( contentPage != "" )
            contentPage += "?aid=";
        else
            contentPage = "";

        bool isTimeVisable = pAcs.GetSettingBool( "isTimeVisable" );
        string TimeFormat = "";
        if( isTimeVisable ) {
            TimeFormat = pAcs.GetSetting( "issueTimeFormat" );
        }
        bool isOpenNew = pAcs.GetSettingBool( "isOpenNew" );
        string Target = "";
        if( isOpenNew ) Target = "_blank";
        else Target = "_self";

        Todo.AddDataCol( "Target", contDt );
        Todo.AddDataCol( "IssueTimeStr", contDt );
        Todo.AddDataCol( "LinkUrl", contDt );
        foreach( DataRow dr in contDt.Rows ) {
            if( contentPage != "" )
                dr["LinkUrl"] = contentPage + Todo.Get( "ID", dr );
            else
                dr["LinkUrl"] = "";
            dr["Target"] = Target;
            if( isTimeVisable )
                dr["IssueTimeStr"] = Todo.TimeFormat( Todo.Get( "IssueTime", dr ), TimeFormat );
        }
        Session.Add( "Part_ArticleFullList_Dt", dt );

        bool allowPaging = pAcs.GetSettingBool( "allowPaging" );
        if( allowPaging ) {
            gvFullList.AllowPaging = true;
            gvFullList.PageSize = pAcs.GetSettingInt( "pageSize", 10 );
        } else {
            gvFullList.AllowPaging = false;
            PagerArea.Visible = false;
        }

        isDbReady = true;
    }

    private void GetData()      // ڴ
    {
        if( Session["Part_ArticleFullList_Dt"] != null ) {
            contDt = (DataTable)Session["Part_ArticleFullList_Dt"];
            if( contDt.Rows.Count > 0 )
                isDbReady = true;
        }
    }

    private void BindData()     // 
    {
        if( isDbReady ) {
            gvFullList.DataSource = contDt;
            gvFullList.DataBind();
        }
    }

    private void ShowPager()    // ҳؼ ʾ
    {
        if( !gvFullList.AllowPaging ) return;

        int idx = gvFullList.PageIndex;
        int cnt = gvFullList.PageCount;
        if( cnt == 1 || idx <= 0 ) {
            lkFirst.Enabled = false;
            lkPrev.Enabled = false;
        } else {
            lkFirst.Enabled = true;
            lkPrev.Enabled = true;
            lkFirst.CommandName = "0";
            lkPrev.CommandName = (idx - 1).ToString();
        }

        if( cnt == 1 || idx >= (cnt - 1) ) {
            lkNext.Enabled = false;
            lkLast.Enabled = false;
        } else {
            lkNext.Enabled = true;
            lkLast.Enabled = true;
            lkNext.CommandName = (idx + 1).ToString();
            lkLast.CommandName = (cnt - 1).ToString();
        }

        if( !IsPostBack ) {
            lstPageIndex.Items.Clear();
            for( int i = 0; i <= (cnt - 1); i++ ) {
                lstPageIndex.Items.Add( new ListItem( "" + (i + 1) + "/" + cnt + "ҳ" ) );
            }
        }
        lstPageIndex.SelectedIndex = idx;
    }

}




    






