﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using BoyunBase;
using SiteCore;

public partial class Part_ArticleList : System.Web.UI.UserControl
{
    private PartAccess pAcs = null;
    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            pAcs = new PartAccess( this );
            if( pAcs.IsReady )
                PartShow();

        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_ArticleList 出现异常：" + ex.Message );
        }
    }

    protected void PartShow()//显示内容
    {
        ContentAccess ca = new ContentAccess( this, "TableName" );
        int topValue = pAcs.GetSettingInt( "topValue", 8 );
        DataTable dt = ca.Read( "[@top " + topValue + "]", "name" );
        if( dt == null || dt.Rows.Count < 1 ) {
            Todo.DebugOut( "Part_ArticleList 没有读取到数据" );
            return;
        }
        //路径
        string contentPage = pAcs.GetSetting( "contentPage" );
        if( contentPage != "" )
            contentPage += "?aid=";
        else
            contentPage = "";
        //是否显示时间
        bool isTimeVisable = pAcs.GetSettingBool( "isTimeVisable" );
        string timeFormat = "";
        if( isTimeVisable ) {
            timeFormat = pAcs.GetSetting( "timeFormat" );
        }
        //是否在新窗口打开
        bool isOpenNew = pAcs.GetSettingBool( "isOpenNew" );
        string Target = "";
        if( isOpenNew ) Target = "_blank";
        else Target = "_self";

        Todo.AddDataCol( "Target", dt );
        Todo.AddDataCol( "IssueTimeStr", dt );
        Todo.AddDataCol( "LinkUrl", dt );
        for( int i = 0; i < dt.Rows.Count; i++ ) {
            DataRow dr = dt.Rows[i];
            if( contentPage != "" )
                dr["LinkUrl"] = contentPage + Todo.Get( "ID", dr );
            else
                dr["LinkUrl"] = "";
            dr["Target"] = Target;
            if( isTimeVisable )
                dr["IssueTimeStr"] = Todo.TimeFormat( Todo.Get( "IssueTime", dr ), timeFormat );
        }

        rptList.DataSource = dt;
        rptList.DataBind();
    }
}


