﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;

public partial class Part_CorpGoodsShow_H : System.Web.UI.UserControl
{
    private PartAccess pAcs = null;

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            pAcs = new PartAccess( this );
            if( pAcs.IsReady )
                PartShow();

        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpGoodsShow_H 出现异常：" + ex.Message );
        }
    }

    private void PartShow()
    {
        ContentAccess ca = new ContentAccess( this, "TableName" );
        DataTable dt = ca.Read( "[*]", "name" );
        if( dt == null || dt.Rows.Count < 1 ) {
            Todo.DebugOut( "Part_CorpGoodsShow_V 没有读取到数据" );
            return;
        }

        string detailPage = pAcs.GetSetting( "detailPage" );
        if( detailPage != "" ) {
            detailPage += "?pid=";
        } else {
            detailPage = "";
        }

        string timeFormat = pAcs.GetSetting( "timeFormat" );
        bool isOpenNew = pAcs.GetSettingBool( "isOpenNew" );
        string target = "";
        if( isOpenNew ) target = "_blank";
        else target = "_self";

        Todo.AddDataCol( "Target", dt );
        Todo.AddDataCol( "IssueTimeStr", dt );
        Todo.AddDataCol( "LinkUrl", dt );
        foreach( DataRow dr in dt.Rows ) {
            if( detailPage != "" )
                dr["LinkUrl"] = detailPage + Todo.Get( "Id", dr );
            else
                dr["LinkUrl"] = "";
            //dr["ThumbPath"] = Todo.Get( "ThumbPath", dr ); //pAcs.ToRelUrl(  );
            dr["IssueTimeStr"] = Todo.TimeFormat( Todo.Get( "IssueTime", dr ), timeFormat );
            dr["Target"] = target;
        }
        int cnt = dt.Rows.Count * 140;
        demo1.Attributes.Add( "style", "width:" + cnt + "px;" );
        demo2.Attributes.Add( "style", "width:" + cnt + "px;" );

        rptGoodsList.DataSource = dt;
        rptGoodsList.DataBind();
    }
}
