﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using BoyunBase;
using SiteCore;

public partial class Part_CorpIntro : System.Web.UI.UserControl
{
    private PartAccess pAcc = null;
    private bool isBreak = false;
    private string content = "";
    private string picPath = "";

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( !IsPostBack ) {
                pAcc = new PartAccess( this );
                if( pAcc.IsReady )
                    PartShow();
            }
        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpIntro 出现异常：" + ex.Message );
        }
    }

    private void PartShow()
    {
        ReadContent();

        if( content != "" )
            ltrContent.Text = content;
        else
            ltrContent.Text = "公司介绍正在编写中，敬请期待!";

        bool IsImageVisible = pAcc.GetSettingBool( "IsImageVisible" );
        if( IsImageVisible ) {
            if( picPath != "" ) {
                imgIntro.Src = picPath;

                int w = Math.Abs( pAcc.GetSettingInt( "ImgWidth", 320 ) );
                int h = Math.Abs( pAcc.GetSettingInt( "ImgHeight", 320 ) );

                imgIntro.Attributes.Add( "onload", "javascript:changeImg(this," + w + "," + h + ")" );
            }
        } else {
            imgIntro.Visible = false;
        }

        if( isBreak ) {
            lnkFullPage.InnerText = pAcc.GetSetting( "FullLinkText" );

            string FullPagePath = pAcc.GetSetting( "FullPagePath" );
            lnkFullPage.HRef = FullPagePath;

            bool IsFullNewOpen = pAcc.GetSettingBool( "IsFullNewOpen" );
            if( IsFullNewOpen )
                lnkFullPage.Target = "_blank";
            else
                lnkFullPage.Target = "_self";
        } else {
            lnkFullPage.Visible = false;
        }
    }

    //获取文章内容完整版
    private void ReadContent()
    {
        try {
            ContentAccess ca = new ContentAccess( this, "TableName" );
            DataTable dt = ca.Read( "[*].(introText|picture)", "name" );
            if( dt == null || dt.Rows.Count < 1 ) return;

            picPath = Todo.Get( "picture", dt.Rows[0] );
            content = Todo.Get( "introText", dt.Rows[0] );
            if( content == "" ) return;

            bool IsContentBreak = pAcc.GetSettingBool( "IsContentBreak" );
            if( IsContentBreak ) {
                int BreakLength = pAcc.GetSettingInt( "BreakLength", 200 );
                if( content.Length > BreakLength ) {
                    content = content.Substring( 0, BreakLength );
                    isBreak = true;
                }
            }
            content = "&nbsp;&nbsp;&nbsp;" + content;

        } catch( Exception ex ) {
            Todo.DebugOut( "读取公司介绍内容出错：" + ex.Message );
        }
    }
}


    ////////////////////////////////////////////////////////////////
    // 文本截取的参考代码
    //private static Regex reg = new Regex( "(<[^>]+>|</[^>]+>|<[^>]+/>|\\\r\\\n|\\s+)", RegexOptions.IgnoreCase );
    //MatchCollection mc = reg.Matches( cont );
    //int iNum = 0;
    //string tempStr = "";
    //for( int i = 0; i < mc.Count; i++ ) {
    //    if( i == mc.Count - 1 ) break;
    //    tempStr += mc[i].Groups[1].Value;
    //}
    //iNum = tempStr.Length;
    //if( iLength < 50 || iLength > 260 )
    //    iLength = 50;
    ////////////////////////////////////////////////////////////////

/*
    <!--<styles>-->
        <!--<style name="divModule2" title="框架外壳层样式" locate="divModule2" cssAttr="class" styleAttr="style" cssClass="module2 movechildren" inlineStyle="top:385px;" />-->
        <!--<style name="divContent2" title="内容外壳层样式" locate="divContent2" cssAttr="class" styleAttr="style" cssClass="content2_2" inlineStyle="" />-->
        <!--<style name="divCompanyinfo" title="框架层样式" locate="divCompanyinfo" cssAttr="class" styleAttr="style" cssClass="companyinfo" inlineStyle="word-break:break-all;" />-->
        <!--<style name="imgIntro" title="图片样式" locate="imgIntro" cssAttr="class" styleAttr="style" cssClass="black-border" inlineStyle="border:0; filter:revealTrans(duration=2,transition=20);" />-->
    <!--</styles>-->

*/