﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;

public partial class Part_CorpLinks : System.Web.UI.UserControl
{
    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            PartAccess pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            int maxLinkCount = pAcs.GetSettingInt( "maxLinkCount", 5 );
            string query;
            if( maxLinkCount < 1 )
                query = "[*]";
            else
                query = "[@top " + maxLinkCount + "]";

            ContentAccess ca = new ContentAccess( this, "TableName" );
            DataTable dt = ca.Read( query, "name" );
            if( dt == null || dt.Rows.Count < 1 ) {
                Todo.DebugOut( "Part_CorpLinks 没有读取到数据" );
                return;
            }

            rptList.DataSource = dt;
            rptList.DataBind();

        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpLinks 出现异常：" + ex.Message );
        }
    }
}
