﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Collections.Specialized;
using BoyunBase;
using SiteCore;

public partial class Part_CorpLogo : System.Web.UI.UserControl
{
    private PartAccess pAcc = null;

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            pAcc = new PartAccess( this );
            if( pAcc.IsReady )
                PartShow();

        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpLogo 出现异常：" + ex.Message );
        }
    }

    private void PartShow()
    {
        try {
            ContentAccess ca = new ContentAccess( this, "TableName" );
            DataTable dt = ca.Read( "[*].(CnName|EnName|LogoImgPath)", "name" );
            if( dt == null || dt.Rows.Count < 1 ) return;

            DataRow dr = dt.Rows[0];
            string LogoImgPath = Todo.Get( "LogoImgPath", dr );
            log_img.Src = LogoImgPath;
            log_img.Attributes.Add( "onload", "changeImg(this, 80, 80);" );

            chinaname.InnerText = Todo.Get( "CnName", dr );
            enname.InnerText = Todo.Get( "EnName", dr );

        } catch( Exception ex ) {
            Todo.DebugOut( "读取 Part_CorpLogo 内容出现异常：" + ex.Message );
        }
    }
}
