using System;
using System.Data;
using System.Collections;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;
using System.Text.RegularExpressions;

public partial class Part_HtmlView : System.Web.UI.UserControl
{
    private static Regex txtRg = new Regex( "(\\s|&nbsp;|<p>|</p>)", RegexOptions.IgnoreCase );

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;
            string cont = "";

            PartAccess pAcs = new PartAccess( this );
            if( pAcs.IsReady ) {
                cont = pAcs.GetSetting( "HtmlContent" );
                if( cont != "" ) {
                    bool isContOK = true;
                    if( cont.Length < 60 ) {
                        string cont1 = txtRg.Replace( cont, "" );
                        if( cont1 == "" ) isContOK = false;
                    }
                    if( isContOK ) {
                        Todo.DebugOut( "Part_HtmlView ȡ" );
                        ltrHtmlShow.Text = cont;
                        return;
                    }
                }
            }

            ContentAccess ca = new ContentAccess( this, "TableName" );
            DataTable dt = ca.Read( "[*].(HyperCont)", "name" );
            if( dt != null && dt.Rows.Count > 0 ) {
                cont = dt.Rows[0]["HyperCont"].ToString();
                if( cont != "" ) {
                    Todo.DebugOut( "Part_HtmlView ȡ" );
                    ltrHtmlShow.Text = cont;
                    return;
                }
            }

        } catch( Exception ex ) {
            Todo.DebugOut( " Part_HtmlView 쳣" + ex.Message );
        }
    }
}
