using System;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using BoyunBase;
using SiteCore;

public partial class Part_VideoView : System.Web.UI.UserControl
{
    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            PartAccess pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            string moviePath = pAcs.GetSetting( "moviePath" );
            int width = pAcs.GetSettingInt( "width", -1 );
            int height = pAcs.GetSettingInt( "height", -1 );
            if( width < 20 ) width = 20;
            if( height < 20 ) height = 20;

            StringBuilder sb = new StringBuilder( 512 );
            sb.Append( "<object classid=\"CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95\" " );
            sb.Append( "width=\"" + width.ToString() + "px\" height=\"" + height.ToString() + "px\" >\n" );
            sb.Append( "<param name=\"ShowStatusBar\" value=\"-1\" />\n" );
            sb.Append( "<param name=\"Filename\" value=\"" + moviePath + "\">\n" );
            sb.Append( "<embed type=\"application/x-oleobject\" codebase=\"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\"></embed>\n" );
            sb.Append( "</object>\n" );

            this.ltrVideoView.Text = sb.ToString();

        } catch( Exception ex ) {
            Todo.DebugOut( " Part_VideoView 쳣" + ex.Message );
        }
    }
}
