﻿/* ============================================================================================ */
/*					Prototype 1.4.0 Start					*/

var Class = {
  create: function() {
    return function() {
      this.initialize.apply(this, arguments);
    }
  }
}

var Abstract = new Object();

Object.extend = function(destination, source) {
  for (property in source) {
    destination[property] = source[property];
  }
  return destination;
}

Object.inspect = function(object) {
  try {
    if (object == undefined) return 'undefined';
    if (object == null) return 'null';
    return object.inspect ? object.inspect() : object.toString();
  } catch (e) {
    if (e instanceof RangeError) return '...';
    throw e;
  }
}

Function.prototype.bind = function() {
  var __method = this, args = $A(arguments), object = args.shift();
  return function() {
    return __method.apply(object, args.concat($A(arguments)));
  }
}

Function.prototype.bindAsEventListener = function(object) {
  var __method = this;
  return function(event) {
    return __method.call(object, event || window.event);
  }
}

function $() {
  var elements = new Array();
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (typeof element == 'string')
      element = document.getElementById(element);
    if (arguments.length == 1)
      return element;
    elements.push(element);
  }
  return elements;
}

var $A = Array.from = function(iterable) {
  if (!iterable) return [];
  if (iterable.toArray) {
    return iterable.toArray();
  } else {
    var results = [];
    for (var i = 0; i < iterable.length; i++)
      results.push(iterable[i]);
    return results;
  }
}
/*					Prototype 1.4.0 End					*/
/* ============================================================================================ */



/* 扩展 String 类
/*    lengthEn 方法：
/*    widthEn 方法：
/*    cutBy 方法：
/* -------------------------------------------------------------------------------------------- */
Object.extend(String.prototype, {
    lengthEn : function(){
	var cArr = this.match(/[^\x00-\xff]/ig);
	return this.length + (cArr == null ? 0 : cArr.length);
    },
    widthEn : function( _fontSize ){
	var length = this.lengthEn();
	return length * _fontSize / 2;
    },
    cutBy : function( _fontSize, _length ){
	var cNum, i, len=3, rText, rNum;
	cNum = Math.floor( _length*2/_fontSize );
	for( i=0; i<this.length; i++ ){
	    len ++;
	    if( this.charCodeAt(i) > 255 ) len ++;
	    if( len >= cNum ){
	        rText = this.substring( 0, i+1 );
	        break;
	    }
	}
	rText += '..';
	if( (cNum-rText.lengthEn()) > 0 ) rText += '.';
	return rText;
    },
    Trim : function(){
	return this.replace( /(^\s*)|(\s*$)/g, '' );
    }
});

window.WidthEnOf = function( _pRef ){
    var t = _pRef.firstChild.nodeValue;
    var w = parseInt( _pRef.currentStyle.fontSize );
    if( _pRef.currentStyle.fontWeight=='700' )
        w++;
    return t.widthEn( w );
}


/* ============================================================================================ */
/*			  Options 类 / 抽象类				*/
/*  为继承类增加处理 Options 参数的功能，
/* ============================================================================================ */
Options = function(){};
Options.prototype = {
    DefaultOptions : {
    },
    SetOption : function( Options ){ // 实函数 允许在继承类的实例中直接使用
	this.Options = {};
	return Object.extend( Object.extend( this.Options, this.DefaultOptions ), Options || {} );
    }
};
/* */



/* ============================================================================================ */
/*			     XML 命名空间				*/
/* 包含 Source, ReadTree, ReadNode, //Reader 3个类			*/
/* ============================================================================================ */
/* 命名空间说明:
   应用场景:
    var CtrlsXmlSource = new XML.Source( {} );
    CtrlsXmlSource.Load( 'files/ctrls.xml' );
    CtrlsXmlSource.PrintTree();
    
    var CtrlsRead = new XML.ReadTree( CtrlsXmlSource );
/* -------------------------------------------------------------------------------------------- */
var XML = {
};


/* XML Base  类 / 抽象类 / 继承 Options
   实现 XML 全程调试功能 和 XML 系统对象的生成
/* -------------------------------------------------------------------------------------------- */
XML.Base = function(){};
XML.Base.prototype = Object.extend( (new Options()), {
    DefaultOptions : {			// 选项默认值
	IsDebug : false,
	DebugOutput : null
    },
    CreateXmlDom : function(){
	var oXmlDom;
	for( var i=0; i<this.DomVersion.length; i++ ){
	    try{
	        oXmlDom = new ActiveXObject( this.DomVersion[i] );
	        return oXmlDom;
	    } catch( e ){
	        // 忽略
	    }
	}
	throw new Error("Microsoft XML is not installed on your system!");
    },
    CreateXmlHttp : function(){
	var oXmlHttp;
	for( var i=0; i<this.XmlHttpVersion.length; i++ ){
	    try{
	        oXmlHttp = new ActiveXObject( this.XmlHttpVersion[i] );
	        return oXmlHttp;
	    } catch( e ){
	        // 忽略
	    }
	}
	throw new Error("Microsoft XML is not installed on your system!");
    },
    DebugPrint : function( text ){
	this.Options.DebugOutput.innerHTML += (text + '<br/>');
    },
    DomVersion : [	// XML Dom ActiveX 控件版本序列
	'MSXML2.DOMDocument.6.0',
	'MSXML2.DOMDocument.5.0',
	'MSXML2.DOMDocument.4.0',
	'MSXML2.DOMDocument.3.0',
	'MSXML2.DOMDocument',
	'Microsoft.XmlDom'
    ],
    XmlHttpVersion : [
	'MSXML2.XMLHTTP.6.0',
	'MSXML2.XMLHTTP.5.0',
	'MSXML2.XMLHTTP.4.0',
	'MSXML2.XMLHTTP.3.0',
	'MSXML2.XMLHTTP'
    ]
});


/* XML.Source 类 / 应用类 / 继承 XML.Base 类
/* 加载 XML 字符串/文件，生成 DOM，提供调试信息
/* -------------------------------------------------------------------------------------------- */
XML.Source = Class.create();
XML.Source.prototype = Object.extend( (new XML.Base()), {
    DefaultOptions : {			// 选项默认值
	IsDebug : false,
	IsAsync : true,
	DebugOutput : null
    },
    initialize : function( options ){	// 初始化函数 自动调用
	this.SetOption( options );
	this.XmlDom = this.CreateXmlDom();
	this.DomStatus = 'Blank';	//'Blank','Loading','Error','Ready'
	
	this._initSet_();
    },
    _initSet_ : function(){},		// 虚函数 在继承类实现自定义设置

    Load : function( xmlSource ){	// 加载 XML 源
	this.XmlDom.onreadystatechange = this._ReadyState_.bind(this);
	if( this.Options.IsDebug ) // 显示 DataAvail 调试信息
	    this.XmlDom.ondataavailable = this._PrintAvailStatus_.bind(this);
	
	this.XmlDom.async = false;//this.Options.IsAsync;
	try {
	    this.XmlDom.load( xmlSource );
	    return true;
	} catch(e){
	    throw new Error("XML Source Error!");
	    return false;
	}
    },
    PrintTree : function(){		// 显示节点树
	if( this.Options.IsDebug )
	    this.Options.DebugOutput.innerHTML += this.itrChild( this.XmlDom, " " );
    },

    _ReadyState_ : function(){		// 加载进程处理
	if( this.Options.IsDebug )
	    this._PrintLoadStatus_();
	if( this.XmlDom.readyState == 4 )
	    if( this.XmlDom.parseError.errorCode == 0 )
	    	;//XmlReadRef._loadReadyP();
	    else
	        this.DebugPrint( 'XML data load error!' );//alert('XML data load error!');
    },
    _PrintAvailStatus_ : function(){	// 加载xml数据的显示 调试用
	this.DebugPrint( 'Status: Data available.' );
    },
    _PrintLoadStatus_ : function(){	// 加载xml的状态显示 调试用
	var rs = this.XmlDom.readyState;
	this.DebugPrint( 'Status: ' + this.LoadStatus[rs] );
	if( rs == 4 ) {
	    var xmlErr = this.XmlDom.parseError;
	    var errStr = xmlErr.srcText;
	    errStr = errStr.replace( /\</g, '&lt;' );
	    errStr = errStr.replace( /\>/g, '&gt;' );
	    if( this.XmlDom.parseError.errorCode!=0 ){
	        this.DebugPrint( 'Status: Parse error.' );
	        this.DebugPrint( 'Problem in ' + xmlErr.url + ' line' + xmlErr.line +' position' + xmlErr.linepos +' :' );
	        this.DebugPrint( 'Error source: ' + errStr + '<br/>' + xmlErr.reason );
	        this.DebugPrint( 'Error code:' + xmlErr.errorCode );
	    } else
	        this.DebugPrint( 'Status: Data loaded alright.' );
	}
    },
    itrChild : function( node, _is ){	// 递归显示节点
	var text; // = _is+node.nodeName+'<br/>';

	text = ( _is + node.nodeName);
	if( node.nodeValue != null )
	    text += ('&nbsp;' + node.nodeValue);
	text += ('&nbsp;<span class="gTxt">(#' + this.NodeType[node.nodeType] + '#)' );

	if( node.attributes!=null && node.attributes.length>0) {
	    text += '&nbsp;(Attributes: ';
	    for( var i=0; i<node.attributes.length; i++ )
	        text += ( node.attributes[i].nodeName + '= \"' + node.attributes[i].nodeValue + '\"&nbsp;' );
	    text += ' )';
	}
	text += '</span><br/>';
	if( node.childNodes.length > 0 )
	    for( var i=0; i<node.childNodes.length; i++ )
	        text += this.itrChild( node.childNodes[i], _is+'&nbsp;&nbsp;&nbsp;' );
	return text;
    },

    NodeType : [ '',	// XML 节点类型名称
	'Element',		// 1
	'Attribute',		// 2
	'Text',			// 3
	'CDATA Section',	// 4
	'Entity reference',	// 5
	'Entity',		// 6
	'Processing instruction', // 7
	'Comment',		// 8
	'Document',		// 9
	'Document type',	// 10
	'Document fragment',	// 11
	'notation' 		// 12
    ],
    LoadStatus : [ '',	// XML 源加载状态
	'XML Source uninitialized.',	// 1
	'XML Source loading...',	// 2
	'XML Source loaded.',		// 3
	'XML Source load complete.' 	// 4
    ]
});
/* */



/* XML.Node 类 / 应用类 / 继承 XML.Base 类
/*======================================================================*/
XML.Node = Class.create();
XML.Node.prototype = Object.extend( (new XML.Base()), {
    initialize : function( nodeRef ){	// 初始化 可选是否初始化节点
	this.Elem = null;
	this._attr_ = null;
	this.Name = '';
	this.AttrNum = 0;
	this.ChildNum = 0;
	this.ParentElem = null;
	if( arguments.length >0 )
	    this.Select( nodeRef );
    },
    Select : function( nodeRef ){	// 选择节点 读取参数
	this.Elem = nodeRef;
	this.Name = nodeRef.nodeName;
//	this.Value = '';
	this._attr_ = nodeRef.attributes;
	try{
	    this.AttrNum = this._attr_.length;
	} catch(e){
	    this.AttrNum = 0;
	}
	this.ChildNum = nodeRef.childNodes.length;
	this.ParentElem = nodeRef.parentNode;
    },
    AttrBy : function( attrName ){	// 读取属性值 By attrName
	try{
	    return this._attr_.getNamedItem(attrName).value;
	} catch(e){
	    return '';
	}
    },
    Text : function(){		// 读取文本
	try {
	    return this.Elem.firstChild.nodeValue;
	} catch(e) {
	    return '';
	}
    },
    CData : function(){		// 读取 CDATA 文本
	if( this.Elem.firstChild && this.Elem.firstChild.nodeType==4 )
	    return this.Elem.firstChild.nodeValue;
	return '';
    },
    Xml : function(){		// 读取节点的 XML 原文
	return this.Elem.xml;
    }
});
/* */


/* XML.NodeReader 类 / 应用类 / 继承 XML.Node 类
/*======================================================================*/
XML.NodeReader = Class.create();
XML.NodeReader.prototype = Object.extend( (new XML.Node()), {
    initialize : function( xmlSource ){	// 初始化 可选是否初始化节点
	this.XmlDom = xmlSource.XmlDom;
	this.Elem = null;
	this._attr_ = null;
	this.Name = '';
	this.AttrNum = 0;
	this.ChildNum = 0;
	this.ParentElem = null;
	this.CycleStatus = 'Idle';// Run, Idle
//	if( arguments.length >0 )
//	    this.Select( nodeRef );
    },
    SelectRoot : function( tagName, i ){
//	var elem = this.XmlDom.documentElement.firstChild;	/////////////////////////////////
//	if( arguments.length > 0 ){
//	    if( arguments.length == 1 ) i = 0;
//	    elem = this.XmlDom.documentElement.getElementsByTagName( tagName )[i];
//	    if( elem == null )
//	        throw new Error( 'Select XML root node by tag name Error!' );
//	}
//	this.Select( elem );
//	return elem;


	var elem = this.XmlDom.documentElement;
	if( arguments.length > 0 ){
	    if( arguments.length == 1 ) i = 0;
	    elem = elem.getElementsByTagName( tagName )[i];
	    if( elem == null )
	        throw new Error( 'Select XML root node by tag name Error!' );
	}
	this.Select( elem );
	return elem;
    },
    GetFirstNodeByAttr : function( attr, value ){
	var i, e, a;
	for( i=0; i<this.Elem.childNodes.length; i++ ){
	    e = this.Elem.childNodes[i];
	    try{
	        a = e.attributes.getNamedItem(attr).value;
	    } catch(error){
	        a = '';
	    }
	    if( a==value ){
	        return e;
	    }
	}
	return false;
    },
    ToChild : function( i ){
	var elem;
	if( arguments.length == 0 )
	    elem = this.Elem.firstChild;
	else{
	    if( i == -1 )
	        elem = this.Elem.lastChild;
	    else
	        elem = this.Elem.childNodes[i];
	}
	if( elem == null ) return false;
	this.Select( elem );
	return true;
    },
    ToParent : function(){
	if( this.ParentElem == null )//Elem.parentNode == null )
	    return false;
	this.Select( this.ParentElem );//Elem.parentNode );
	return true;
    },
    ToNext : function(){
	var elem = this.Elem.nextSibling;
	if( elem == null ) return false;
	this.Select( elem );
	return true;
    }/*,
    CycleBegin : function(){
	if( this.CycleStatus == 'Idle' ){
	    if( this.ChildNum <= 0 )
	        return false;
	    if( !this.ToChild() )
	        return false;
	    else
	        return true;
	} else if( this.CycleStatus == 'Run'){
	    if( !this.ToNext() )
	        return false;
	    else
	        return true;
	}
    },
    CycleEnd : function(){
	;
    }*/
});
//	for( var i=0; i<this.ddlType.options.length; i++ ){
//	    if( this.ddlType.options[i].value == type ){
//	        this.ddlType.options[i].selected = true;
//	    }
//	}
/* */


/* XML.Request 类 / 应用类 / 继承 XML.Base 类
/*======================================================================*/
XML.Request = Class.create();
XML.Request.prototype = Object.extend( (new XML.Base()), {
//    DefaultOptions : {			// 选项默认值
//	IsDebug : false,
//	IsAsync : true,
//	DebugOutput : null,
//    },
    initialize : function( url, func, xmlSource ){	// 初始化函数 自动调用
//	this.SetOption( options );
	this.xmlReq = this.CreateXmlHttp();
	this.linkGoal = url;
	this.onRespn =  func;
	this.xmlSource = xmlSource;
    },
    XmlPostBack : function( xmlSource ){
	this.xmlReq.open( 'POST', this.linkGoal, true );
	this.xmlReq.setRequestHeader( 'Content-Type', 'text/xml' );
	this.xmlReq.onreadystatechange = this._OnPostBackReady_.bind(this);
	this.xmlReq.send( this.xmlSource.XmlDom.xml );
    },
    _OnPostBackReady_ : function(){
	if( this.xmlReq.readyState==4 ){
	    if( typeof this.onRespn == 'function' ){
	        this.onRespn( this.xmlReq.responseText );
	    }
	}
    }
//    XmlRequest : function(){	//_type, _uid, _sayText//'init' // 'msg', '2', //'query', '123;345;342;543;'
//	this.xmlReq.open( 'POST', this.linkGoal, true );
//	this.xmlReq.setRequestHeader( 'Content-Type', 'text/xml' );
//	this.xmlReq.onreadystatechange = this._OnReady_.bind(this);
//	this.xmlReq.send( this.xmlDom.xml );
//    },
//    _OnReady_ : function(){
//	if( this.xmlReq.readyState==4 ){
//	    var tDom = this.CreateXmlDom();
//	    tDom.loadXML( this.xmlReq.responseText );
//	    this.onRespn( tDom );
//	}
//    }
});
	//////////////////////////////////////////////////////////
	//		        Xml Link 类			//
	//////////////////////////////////////////////////////////
/**
var XmlLinkList = new Array();
function XmlLink( _url, _func )
    {
	this.xmlDom = CreateXMLDom();
	this.xmlReq = CreateXmlHttp();
	this.reqDirty = false;
	this.linkGoal = _url;
	this.onRespn =  _func;
	XmlLinkList[XmlLinkList.length] = this;
    }
cXmlLink.prototype.Request = function( _type, _uid, _sayText )//'init' // 'msg', '2', //'query', '123;345;342;543;'
    {
	var root, node;
	root = this.xmlDom.createElement('iMsg');
	node= this.xmlDom.createElement('q');
	node.setAttribute( 'type', _type );
	switch( _type ){
	    case 'init':
	        break;
	    case 'query':
	        node.setAttribute('openeduid', _uid );
	        break;
	    case 'msg':
	        node.setAttribute('dstuid', _uid );
	        var cdNode = this.xmlDom.createCDATASection('');
	        var tempText = _sayText.replace( ']]>', ']]&gt;' );
	        cdNode.text = tempText;
	        node.appendChild( cdNode );
	        break;
	}
	root.appendChild( node );
	this.xmlDom.appendChild( root );
//	alert( domRoot.xml);
	this.xmlReq.open( 'POST', this.linkGoal, true );
	this.xmlReq.setRequestHeader( 'Content-Type', 'text/xml' );
	this.xmlReq.onreadystatechange = this._OnReady_;
	this.reqDirty = false;
	this.xmlReq.send( this.xmlDom.xml );
	this.xmlDom.removeChild( this.xmlDom.documentElement );
    }
cXmlLink.prototype._OnReady_ = function()
    {
	for( var i=0; i<XmlLinkList.length; i++ ) {
//	    alert( XmlLinkList[i].reqDirty +' '+ XmlLinkList[i].xmlReq.readyState );
	    if( !XmlLinkList[i].reqDirty && XmlLinkList[i].xmlReq.readyState==4 ){
	        var tDom = CreateXMLDom();//new ActiveXObject('MSXML2.DOMDocument.4.0');
	        tDom.loadXML( XmlLinkList[i].xmlReq.responseText );
	        XmlLinkList[i].onRespn( tDom );
	        XmlLinkList[i].reqDirty = true;
//	        alert(  this.reqDirty );
//	        XmlLinkList[i].xmlReq.responseText = '';
//	        XmlLinkList[i].xmlReq.readyState = false;
//	        DealRespn( tDom );
//	        alert( XmlLinkList[i].xmlReq.responseText );
	    }
	}
    }
/* */



/*======================================================================*/
/*			     Time Interval 类				*/
/*======================================================================*/
cInterval = Class.create();
cInterval.prototype = {
    initialize : function( _func, _runAt, _frequency ){
	this.Timer = null;
	this.funcRef = _func;
	this.runAt = _runAt;
	this.count = 0;
	this.frequency = _frequency; 	// 循环周期 毫秒单位
	this.infiniteLoop = false;	// 无限循环
	this.state = 'stop';		// 定时器状态：'stop','run','pause'
    },
    Start : function(  _count ){	// 启动定时器
	if( _count>0 ){
	    this.infiniteLoop = false;
	    this.count = _count;
	} else{
	    this.infiniteLoop = true;
	    this.count = 0;
	}
	this.state = 'run';
	this.Timer = setInterval( this._Run_.bind(this), this.frequency );
    },
    Stop : function(){  	// 停止定时器
	this.state = 'stop';
	this.count = 0;
	this.infiniteLoop = false;
	clearInterval( this.Timer );
    },
    Pause : function(){ 	// 暂停定时器
	if( this.state=='run' ){
	    this.state = 'pause';
	    clearInterval( this.Timer );
	}
    },
    Resume : function(){ 	// (从暂停)恢复定时器
	if( this.state=='pause' ){
	    this.state = 'run';
	    this.Timer = setInterval( this._Run_.bind(this), this.frequency );
	}
    },
    _Run_ : function(){ 	// 定时器运行
	if( this.state!='run' ) return;
	this.funcRef.call( this.runAt,'');
	if( !this.infiniteLoop ){
	    if( this.count>0 ){
	        this.count--;
	    } else{
	        this.count = 0;
	        this.Stop();
	    }
	}
    }
};



/*======================================================================*/
/*				Button 命名空间				*/
/* 包含 Base, Link, Plus 3个类						*/
/*======================================================================*/
/*	Link	plus
normal	 *1	 *1
over	 *2	 *2
remind		 *3
active		 *4
down	 *3	 *5
disable	 *4

Menu.Link	Button.Link  --  OK
Tab.ClsBtn	Button.Link  dn  OK

Colglist.item	Button.Plus  --  0
System.Btn	Button.Plus  dn  3 -menu xml
Wind.Tab	Button.Plus  --  OK
/*----------------------------------------------------------------------*/
var Button = {
};

/* Button Base 类 / 抽象类 / 继承 Options 类
/*----------------------------------------------------------------------*/
Button.Base = function(){};
Button.Base.prototype = Object.extend( (new Options()), {
    _init_ : function( _parentElem, _parentWnd, _rootPopup, _allowDown ){
	this.parentElem = _parentElem;
	this.parentWnd = _parentWnd || window;
	this.parentDoc = this.parentWnd.document;
	this.rootPopup = _rootPopup;
	
	this.elemRef = this.parentDoc.createElement('div');//alert( this.parentElem.nodeName+' '+this.elemRef.nodeName )
	this.elemStyle = this.elemRef.style;
	this.parentElem.appendChild( this.elemRef );
	
	this.elemRef.onmouseover = this.MouseOver.bind(this);
	this.elemRef.onmouseout  = this.MouseOut.bind(this);
	this.elemRef.onmousedown = this.MouseDown.bind(this);
	this.elemRef.onmouseup   = this.MouseUp.bind(this);

	if( _allowDown ) this.allowDown = true;
	else             this.allowDown = false;
	this.isDown = false;
	this.blinkTimer = new cInterval( this._DynBlink_, this, 250 );//( _func, _runAt, _frequency )
	this._initSet_();
    },
    _initSet_ : function(){},	// 虚函数 在继承类实现自定义设置
    _DynBlink_ : function(){
	if( this.blinkTimer.count%2 == 1 )
	    this.SetShow('normal');
	else
	    this.SetShow('remind');
	if( this.blinkTimer.count <= 0 )
	    this.SetState('remind');
    },
// 鼠标事件直接处理 并调用外部的事件处理方法
    MouseOver : function(){
	this._MouseOver_();
	this.OnMouseOver();
//	this.parentWnd.event.cancelBubble = true;
    },
    MouseOut : function(){
	this._MouseOut_();
	this.OnMouseOut();
//	this.parentWnd.event.cancelBubble = true;
    },
    MouseDown : function(){
	this._MouseDown_();
	this.OnMouseDown();
//	this.parentWnd.event.cancelBubble = true;
    },
    MouseUp : function(){
	this._MouseUp_();
	this.OnMouseUp();
//	this.parentWnd.event.cancelBubble = true;
    },

    _MouseOver_ : function(){},	// 虚函数 在继承类实现系统鼠标事件的直接处理
    _MouseOut_  : function(){},	// 虚函数
    _MouseDown_ : function(){},	// 虚函数
    _MouseUp_   : function(){},	// 虚函数
    
    OnMouseOver : function(){}, 	// 事件接口 在类的外部实现，基于对象实现具体的事件处理
    OnMouseOut  : function(){},  	// 事件接口
    OnMouseDown : function(){}, 	// 事件接口
    OnMouseUp   : function(){},  	// 事件接口
    OnClick     : function(){},		// 事件接口

    SetShow  : function( _set ){},	// 虚函数 在继承类中必须实现!!!  //'normal','over','down','disable'
    CallBack : function(){}		// 回调虚函数 在继承类中实现
});

/* Button Link 类 / 抽象类 / 继承 Button.Base 抽象类
   支持 Enabled, Visible, down
/*----------------------------------------------------------------------*/
Button.Link = function(){};
Button.Link.prototype = Object.extend( (new Button.Base()), {
//  state : ['normal','over','down','disable'];
//  _init_ : function( _parentElem, _parentWnd, _rootPopup, _allowDown )
//  SetShow : function( _set ){}	// 虚函数 在继承类中必须实现!!! //'normal','over','down','disable'
    _initSet_ : function(){
	this.SetEnabled( true );
	this.SetVisible( true );
    },
//对象状态设置
    SetEnabled : function( _set ){
	if( _set == true ){
	    this.SetShow('normal');
	    this.enabled = true;
	} else{
	    this.enabled = false;
	    this.SetShow('disable');
	}
    },
    SetVisible : function( _set ){
	if( _set == true ){
	    this.elemStyle.display = 'block';
	    this.visible = true;
	} else{
	    this.visible = false;
	    this.elemStyle.display = 'none';
	}
    },
//鼠标事件直接处理 并调用外部的事件处理方法
    _MouseOver_ : function(){
	if( this.enabled ){
	    this.SetShow('over');//'normal','over','down','disable'
	} else
	    this.SetShow('disable');
    }, 
    _MouseOut_ : function(){
	if( this.enabled ){
	    this.SetShow('normal');
	    this.isDown = false;
	} else
	    this.SetShow('disable');
    },
    _MouseDown_ : function(){
	if( this.enabled && this.parentWnd.event.button==1 ){
	    if( this.allowDown ){
	        this.SetShow('down');
	        this.isDown = true;
	    }
	}
    },
    _MouseUp_ : function(){
	if( this.enabled && this.parentWnd.event.button==1 ){
	    if( !this.allowDown || this.isDown ){
	        this.SetShow('normal');
	        this.isDown = false;
	        this.CallBack();
	        this.OnClick();
	    }
	}
    }
});

/* Button Plus 类 / 抽象类 / 继承 Button.Base 抽象类 / 支持 blink active(popup/Check)
/* 派生 Popup, Check, 抽象类，派生 Tab, 应用类
/*----------------------------------------------------------------------*/
/*  state : ['normal','over','remind','active','down'];
    SetShow : function( _set ){}	// 虚函数 在继承类中必须实现!!!
    _init_ : function( _parentElem, _parentWnd, _rootPopup, _allowDown )
/*----------------------------------------------------------------------*/
Button.Plus = function(){};
Button.Plus.prototype = Object.extend( (new Button.Base()), {
// 对象状态设置
    SetState : function( _set ){
	this.blinkTimer.Stop();
	switch( _set ){	// State:  'normal','remind','blink','active',//'down','over',
	    case 'blink':	// blink = normal<>remind
	        if( this.state != 'normal' ) return;
	        this.blinkTimer.Start( BLINK_MAX_COUNT );
	        break;
	    case 'normal':
	        break;
	    case 'remind':
	        if( this.state == 'active' ) return;
	        break;
	    case 'active':
	        this.blinkTimer.Stop();
	        break;
	    default:
	        return;
	}
	this.state = _set;
	this.SetShow( _set );
    },
// 鼠标事件直接处理 并调用外部的事件处理方法
    _MouseOver_ : function(){
	this.blinkTimer.Pause();
	if( this.state != 'active' )
	    this.SetShow('over');
    },
    _MouseOut_ : function(){
	this.isDown = false;
	if( this.state != 'active' ){
	    this.SetShow( this.state );
	    this.blinkTimer.Resume();
	}
    },
    _MouseDown_ : function(){
	if( this.parentWnd.event.button==1 ){
	    if( this.state != 'active' && this.allowDown ){
	        this.isDown = true;
	        this.SetShow('down');
	    }
	}
    },
    _MouseUp_ : function(){
	if( this.parentWnd.event.button==1 ){
	    if( !this.allowDown || this.isDown ){
	        this.isDown = false;
	        if( this.state != 'active' ){
	            this.SetState('active');
	            this.CallBack();
	        }
	        this.OnClick();
	    }
	}
    }
});

/* Button Popup 类 / 抽象类 / 继承 Button.Plus / 支持 blink active(Popup)
/*----------------------------------------------------------------------*/
/*  state : ['normal','over','remind','active','down'];
    SetShow : function( _set ){}	// 虚函数 在继承类中必须实现!!!
    _init_ : function( _parentElem, _parentWnd, _rootPopup, _allowDown )
/*----------------------------------------------------------------------*/
Button.Popup = function(){};
Button.Popup.prototype = Object.extend( (new Button.Plus()), {
    _initSet_ : function(){	// 重载 _initSet_ 私有方法
	this.id = this.elemRef.id = XmlR.ReadAttr('id');
	this.elemRef.title = XmlR.ReadAttr('tip');
//	this.blinkTimer = new cInterval( this._DynBlink_, this, 250 );//( _func, _runAt, _frequency )
	this.activePopup = this.parentWnd.createPopup();
	this.activePopup.document.rootPopup = this.activePopup;
	this.activePopup.document.onmousedown = function(){
	    this.rootPopup.hide();
	}
	this.popupMenu = null;
	this.CallBack = function(){
	    this.activePopup.show( 0, 0, this.width, this.height, this.elemRef );
	    if( this.popupMenu ){
	        this.popupMenu.Show( 0, this.width, this.elemRef );
	    }
	};
    },
    GetRef : function(){
	return {
	    parentWnd : this.activePopup.document.parentWindow,
	    rootPopup : this.activePopup
	};
    },
    LinkPopup : function( _popupRef ){
	this.popupMenu = _popupRef;
    },
    _MouseUp_ : function(){
	if( this.parentWnd.event.button==1 ){
	    if( !this.allowDown || this.isDown ){
	        this.isDown = false;
	        this.SetState( 'normal');
	        this.CallBack();
	        this.OnClick();
	    }
	}
    }
});





/*======================================================================*/
/*				   Menu 类				*/
/* Menu 类 / 抽象类 / 继承 Options 类					*/
/*======================================================================*/
Menu = function(){};
Menu.prototype = Object.extend( (new Options()), {
    _init_ : function( _parentWnd, _rootPopup, _cssUrl ){// 内部构造函数 需在继承类的构造函数中调用
	this.parentWindow = _parentWnd || window;
	this.popupRef = this.parentWindow.createPopup();
	this.popupDoc = this.popupRef.document;
	this.popupWnd = this.popupRef.document.parentWindow;
	this.popupBody = this.popupRef.document.body;
	this.popupBodyStyle = this.popupBody.style;
	
	this.popupDoc.createStyleSheet( _cssUrl );
	this.popupDoc.oncontextmenu = function(){return false;}
	this.popupDoc.onselectstart = function(){return false;}
	
	this.rootPopup = _rootPopup;
	if( _rootPopup==null ) this.rootPopup = this.popupRef;
	this.left   = 0;
	this.top    = 0;
	this.width  = 0;
	this.height = 0;
	this.sizeDirty = false;
    },

    AddItem : function( _type, _value, _options ){},	// 虚函数(接口) 添加菜单项
    InsertItem : function(){},		// 虚函数(接口) 插入菜单项
    DeleteItem : function( _item ){},	// 虚函数(接口) 删除菜单项
    MoveItem : function(){},		// 虚函数(接口) 调整菜单项顺序
    
    Show : function( _left, _top, _dirLeft, _dirUp ){ // 实函数 可在继承类的实例中直接使用
	this.left = _left;	// if( _dirLeft ) this.left = _left - this.width;
	this.top = _top;	// if( _dirUp ) this.top = _top - this.height;
	if( this.sizeDirty ) this._sizeFresh_(); //alert('m');
	if( this.links ){	// 显示菜单时，清除 Menu Link 的异常状态
	    for( var i=0; i<this.links.length; i++ ){
	        this.links[i].SetShow('normal');
	    }
	}
//	alert( this.left+' '+this.top+' '+this.width+' '+this.height+' '+this.sizeDirty+this.popupRef);
	return this.popupRef.show( this.left, this.top, this.width, this.height, this.parentWindow.document.body );
    },
    IsShowed : function(){
	if( this.popupRef.isOpen ) return true;
	return false;
    },
    ShowTry : function( _left, _top, _dirLeft, _dirUp ){}, // 虚函数
    
    _sizeFresh_ : function(){} // 虚函数(接口) 刷新宽度、高度
});

/* Popup Menu 类 / 应用类 / 继承 Menu 类
/*======================================================================*/
cPopupMenu = Class.create();
cPopupMenu.prototype = Object.extend( (new Menu()), {
    initialize : function( _parentWnd, _rootPopup, _cssUrl ){
	this._init_( _parentWnd, _rootPopup, _cssUrl );
	this.popupBody.innerHTML += '<div class="PopupMenu"></div>';
	this.divRef = this.popupBody.firstChild;
	this.links = [];
	this.width = 140;
    },
    AddItem : function( _type, _options ){  // _value, _procType, _call ){// method: 'new-wind',
// 	alert( _type );
 	this.sizeDirty = true;
	var elem = this.popupDoc.createElement('p');
	switch( _type ){ // type:'link','divider','secHead'
	  case'link':
	    this.links[this.links.length] = new cMenuLink( this.divRef, this.popupWnd, this.rootPopup, _options );
	                                               //( _parentElem, _parentWnd, _rootPopup, _options )
//	    alert( this.divRef.lastChild.nodeName +' '+ this.divRef.lastChild.firstChild );
	    var len = WidthEnOf( this.divRef.lastChild ) + 36;
	    if( this.width<len ) this.width = len;
	    break;
	  case'divider':
	    elem.className = 'Divider';
	    this.divRef.appendChild( elem );
	    break;
	  case'secHead':
	    elem.className = 'SectionHead';
	    elem.innerText = _options.value;//alert( _options.value );
	    this.divRef.appendChild( elem );
	    break;
	}
    },
    AddItemByJson : function( jsonObj ){
	if( !jsonObj ) return;
	for( var i=0; i<jsonObj.length; i++ ){
	    var item = jsonObj[i];
	    if( item && item.type ){
	        this.AddItem( item.type, item );
	    }
	}
    },
    _sizeFresh_ : function(){ // 重载 Menu.Base 的 _sizeFresh_() 方法
	this.popupRef.show( 0, 0, this.width, 0 );
	this.height = this.popupBody.scrollHeight;
	this.popupRef.hide();
	this._sizeDirty_ = false;
    }
});

/* Menu Link 类 / 应用类 / 继承 Button.Link 类
/*======================================================================*/
cMenuLink = Class.create();
cMenuLink.prototype = Object.extend( (new Button.Link()), {
    initialize : function( _parentElem, _parentWnd, _rootPopup, _options ){
	this._init_( _parentElem, _parentWnd, _rootPopup, true );
	this.SetOption( _options );
	this.elemRef.className = this.Options.cssClass;
	this.elemRef.innerText = this.Options.value;
	if( this.Options.isBold )
	    this.elemRef.style.fontWeight = 'bold';
	switch( this.Options.method ){
	  case'none':
	    this.CallBack = function(){};
	    break;
	  case'function':
	    this.CallBack = function(){
	    	this.rootPopup.hide();
	        this.Options.funcRef.apply( this.Options.runAt, this.Options.parames )
	    };
	    break;
	  case'wind-page':
	    this.CallBack = function(){ 
	        this.rootPopup.hide();
	        OpenWind( 0, this.Options.featureStr, this.Options.action, this.Options.immediateOpen );
	    };
	    break;
	}
    },
// method:'none','wind-page','function',
//  *'none':	*'wind-page':		*'function':
//  |		| featureStr: ''	| funcRef: function(){}
//  |		| action: ''		| runAt: null
//  |		| immediateOpen: true,	| parames: null;
    DefaultOptions : {
	method : 'none',
	featureStr : '',
	action : '',
	immediateOpen : true,
	funcRef : function(){},
	runAt : null,
	parames : [],
	cssClass : 'Link',
	value : ''
    },
    SetShow : function( _set ){
	switch( _set ){ //'normal','over','down','disable'
	  case'normal':
	    this.elemRef.className = 'Link';
	    return;
	  case'over':
	    this.elemRef.className = 'LinkOv';
	    return;
	  case'down':
	  case'disable':
	    return;
	}
    }
});
/* */