﻿
/* ThumbView   缩略图视图
/* -------------------------------------------------------------------------------------------- */
var ThumbView = {}

/* ThumbView.Case 类 / 应用类 / 将来应继承自 TiledView.Case 类
/* -------------------------------------------------------------------------------------------- */
ThumbView.Case = Class.create();
ThumbView.Case.prototype = {
    initialize : function( elem, ajaxUrl, parames ){
	this.elemRef = elem;
	this.elemRef.className = 'ThumbCase';//alert(this.elemRef.className);
	this.elemStyle = this.elemRef.style;
	
	this.Nails = {};
	this.ActiveNail = null;//alert('cccc');
	this._ajax = new AjaxRequest( ajaxUrl, this.LoadByJson.bind(this), this._LoadError.bind(this) );
	
	this.allowUnselect = true;
	if( parames.allowUnselect === false )
	    this.allowUnselect = false;
	
	if( parames.onLoaded && typeof parames.onLoaded == 'function' )
	    this._LoadedFunc = parames.onLoaded;
	if( parames.onSelFunc && typeof parames.onSelFunc == 'function' )
	    this._SelFunc = parames.onSelFunc;
	if( parames.onUnselFunc && typeof parames.onUnselFunc == 'function' )
	    this._UnselFunc = parames.onUnselFunc;

	this.elemRef.onmousedown = this.OnMouseDown.bind(this);
    },
    // 加载 JSON 格式的站点数据数组
    LoadByJson : function( jsonText ){
	var jsons = eval( jsonText );
	if( !(jsons instanceof Array) ) return;
	
//	if( this.elemRef.innerHTML == '正在加载模版...' )
//	    this.elemRef.innerHTML = "";

	var nail, firstNail;
	for( var i=0; i<jsons.length; i++ ){
	    var json = jsons[i];  //alert( json.name+'   '+json.imgSrc );
	    if( !json || !json.name ) continue;
    	
	    nail = this.Nails[json.name];
	    if( nail ){
	        nail.Fresh( json );
	    } else{
	        nail = new ThumbView.Nail( this, json );
	        this.Nails[json.name] = nail;
	    }
	}
	if( this._LoadedFunc ) this._LoadedFunc();
    },
    LoadByRequest : function( postText, onLoaded ){
//	this.elemRef.innerHTML = '正在加载模版...';
	if( onLoaded && typeof onLoaded == 'function' )
	    this._LoadedFunc = onLoaded;
	this._ajax.Post( postText );
    },
    _LoadError : function( errMsg ){
	this.elemRef.innerHTML = '加载时出现错误：'+ errMsg;
    },
    ActivateNail : function( nail ){
	if( this.allowUnselect ){
	    if( this.ActiveNail )
	        this.ActiveNail.Unactive();	
	    if( nail ){
	        nail.Activate();
	        this.ActiveNail = nail;
	        if( this._SelFunc )
	            this._SelFunc( nail.name );	    
	    } else{
	        if( this._UnselFunc )
	            this._UnselFunc();
	        this.ActiveNail = null;
	    }
	} else{
	    if( nail ){
	        if( this.ActiveNail )
	            this.ActiveNail.Unactive();	
	            
	        nail.Activate();
	        this.ActiveNail = nail;
	        if( this._SelFunc )
	            this._SelFunc( nail.name );
	    }	    
	}	
    },
    Activate : function( name ){
	if( !name ) return;
	var nail = this.Nails[name];
	if( nail ) this.ActivateNail( nail );
    },
    OnMouseDown : function(){
	this.ActivateNail();
    }
};
/* -------------------------------------------------------------------------------------------- */

ThumbView.Nail = Class.create();
ThumbView.Nail.prototype = {
    initialize : function( parentCase, json, parentWnd ){
	if( !json || !json.name ) return;
	
	this.ParentCase = parentCase;
	this.parentElem = parentCase.elemRef;
	this.parentWnd = parentWnd || window;
	this.parentDoc = this.parentWnd.document;
	
	this.elemRef = this.parentDoc.createElement('div');
	this.elemRef.className = 'ThumbNail';
	this.elemRef.innerHTML = "<div class='Border'><div class='Image'></div></div><div class='Text'><span></span></div>";
	
	this.borderRef = this.elemRef.firstChild;
	this.imgRef    = this.borderRef.firstChild;
	this.imgStyle  = this.imgRef.style;
	this.textPnRef   = this.elemRef.childNodes[1];
	this.textRef   = this.textPnRef.firstChild;

	this.Fresh( json );		
	this.parentElem.appendChild( this.elemRef );
	
	this.borderRef.onmousedown = this.OnMouseDown.bind(this);
	this.textRef.onmousedown = this.OnMouseDown.bind(this);
    },
    Fresh : function( json ){
	if( !json || !json.name ) return;
	
	this.name = json.name;
	this.title = json.title;//alert(this.imgStyle+'  '+json.name +'  '+json.imgSrc);
	this.imgStyle.backgroundImage = 'url('+ json.imgSrc +')';
	this.textRef.innerText = this.title;
	this.elemRef.title = this.title;
    },
    Unactive : function(){
	this.elemRef.className = 'ThumbNail';
    },
    Activate : function(){
	this.elemRef.className = 'ThumbNail_Active';
    },
    OnMouseDown : function(){
	this.ParentCase.ActivateNail( this );
	this.parentWnd.event.cancelBubble = true;
    }
};
/* -------------------------------------------------------------------------------------------- */


