﻿// document.FactoryRootUrl
// document.SiteRootUrl
// document.PagePath

var DisableEvent = function(){
    event.returnValue = false;
    event.cancelBubble = false;
    return false;
}
var GetElemPos = function( e ){
    var box = e.getBoundingClientRect();
    var sLeft = Math.max(document.documentElement.scrollLeft, document.body.scrollLeft);
    var sTop  = Math.max(document.documentElement.scrollTop, document.body.scrollTop);

    return {left: box.left + sLeft,  right:  box.right + sLeft,  width: box.right - box.left,
            top:  box.top + sTop,    bottom: box.bottom + sTop,  height: box.bottom - box.top };
}

var TheHtml = document.documentElement;
var TheHead = document.documentElement.childNodes[0];
var TheBody = document.documentElement.childNodes[1];

var SiteName = document.SiteName;
var FactoryRootUrl = document.FactoryRootUrl;
var SiteRootUrl = document.SiteRootUrl;
var PagePath = document.PagePath;

var MaskLayer, ActiveLayer, OperLayer, WaitMsgBox, TempCase;
function Editor_Load()
    {
	MaskLayer = document.createElement('div');
	MaskLayer.id = 'MaskLayer';
	TheBody.appendChild( MaskLayer );
	
	ActiveLayer = document.createElement('div');
	ActiveLayer.id = 'ActiveLayer';
	TheBody.appendChild( ActiveLayer );

//	alert( MaskLayer+' '+ ActiveLayer );
//	PageId = $('HiddenField_PageId').value;
	Part.Init( MaskLayer, ActiveLayer );
	
	// 为DOM节点添加“拖放”事件响应
	
	// 封装已有 部件盒 部件  拆除事件、去href、加编辑外壳、加菜单
	LoadParts();
//	DisableLink();
	
	// 导入“工具箱”
//	ToolBoxPanel.Load();
	
	OperLayer = document.createElement('div');
	OperLayer.id = 'OperLayer';
	TheBody.appendChild( OperLayer );
	
//	WaitMsgBox = document.createElement('div');
//	WaitMsgBox.className = 'WaitMsgBox';
//	WaitMsgBox.innerHTML = '<span><b></b>正在操作</span>';
//	WaitMsgBox.onselectstart = DisableEvent;
//	WaitMsgBox.oncontextmenu = DisableEvent;
//	TheBody.appendChild( WaitMsgBox );
	
	var temp = document.createElement('div');
	TheBody.appendChild( temp );
	temp.style.display = 'none';
	TempCase = document.createElement('div');
	TempCase.id = 'TempCase';
	temp.appendChild( TempCase );
    }

function LoadParts()
    {
	var rgCase = new RegExp('^PartCase_?([0-9]+)$','i');
//	var rgBox = new RegExp('^PartBox_([0-9]{10,30})$','i');
	
	var divList = document.getElementsByTagName('DIV');
	for( var i=0; i<divList.length; i++ ){
	    // 处理 PartCase
	    var div = divList[i];
	    if( rgCase.test(div.id) ){
	        var c = new Part.PartCase( div );
	        Part.AddCase( c );
	    }
	}

	var tablist = document.getElementsByTagName('TABLE');
	for( var i=0; i<tablist.length; i++ ){
	    // 处理 Part // 给 TABLE 加外壳
	    var tab = tablist[i];
	    if( tab.partId && tab.partName && tab.partType ){//rgBox.test(tab.id) ){
	        var readyCase;
	        if( !tab.parentNode.PartCaseRef ){
	            readyCase = new Part.PartCase( tab.parentNode );
	            Part.AddCase( readyCase );
	        } else
	            readyCase = tab.parentNode.PartCaseRef;
	            
	        readyCase.LoadPart( tab );      //, tab.partId  RegExp.$1 );
	    }
        }
    }

	/*
	var marList = document.getElementsByTagName('MARQUEE');
	var n = marList.length;   //alert(n);
	for( var i=0; i<n; i++ ){
	    var mar = marList[i];
	    // 给MARQUEE加外壳
	    if( mar.partId && mar.partName && mar.partType ){ //rgBox.test(mar.id) ){
	        var readyCase;
	        if( mar.parentNode.PartCaseRef ){
	            readyCase = mar.parentNode.PartCaseRef;
	            readyCase.LoadPart( mar );    //, mar.partId  RegExp.$1 );
	        }
	    }
	    mar.scrollAmount = 0;
	}/**/
//function DisableLink()
//    {
//	var linkList = document.getElementsByTagName('A');
//	var n = linkList.length;   //alert(n);
//	for( var i=0; i<n; i++ ){
//	    var link = linkList[i];
//	    link.onclick = void;
//	    link.onmousedown = void;
//	    link.onmouseup = void;
//	}
//    }
/*



/* ============================================================================================ */
/*					   Part 命名空间					*/
/*												*/
/* 包含 Base, Part, AspxUcPart, ContainerPart,  个类						*/
/* ============================================================================================ */

/* 部件处理
/* -------------------------------------------------------------------------------------------- */
var Part = {
    InsertLine : null,
    Init : function( maskLay, activeLay, parentWnd ){
	this.Menu.Init();
	this.Menu.SetOrigin( 2, 32 );
	this.Mask.Init( maskLay, activeLay, this.Menu, parentWnd );
	this.Part.Init( maskLay, activeLay, this.Mask, parentWnd );
	
	this.InsertLine = (parentWnd||window).document.createElement('div');
	this.InsertLine.id = 'InsertLine';
	activeLay.appendChild( this.InsertLine );
    },
    CaseList: [],
    AddCase : function( c ){
	if( !c ) return;
	this.CaseList.push( c );
    }
};


/* Part.Mask 全局对象
   功能
/* -------------------------------------------------------------------------------------------- */
Part.Mask = {
    Init : function( maskLay, activeLay, menu, parentWnd ){
//	alert( 'Part.Mask Init' );
	this.ParentWnd = parentWnd || window;
	this.ParentDoc = this.ParentWnd.document;
	this.MaskLayer = maskLay;
	this.ActiveLayer = activeLay;
	this.Menu = menu;
	
	this.MaskLayer.innerHTML =  '<div class="MaskHead"></div> <div class="MaskLeft"></div>';
	this.MaskLayer.innerHTML += '<div class="MaskRight"></div> <div class="MaskFoot"></div>';
	this.MaskLayer.innerHTML += '<div class="MaskTitle"><h1><b></b><span>部件</span><a></a></h1></div>';
	
	this.MaskHead  = this.MaskLayer.childNodes[0];  this._AddCommonEventTo( this.MaskHead );
	this.MaskLeft  = this.MaskLayer.childNodes[1];  this._AddCommonEventTo( this.MaskLeft );
	this.MaskRight = this.MaskLayer.childNodes[2];  this._AddCommonEventTo( this.MaskRight );
	this.MaskFoot  = this.MaskLayer.childNodes[3];  this._AddCommonEventTo( this.MaskFoot );
	this.MaskTitle = this.MaskLayer.childNodes[4];  this._AddCommonEventTo( this.MaskTitle );
	this.MaskTitle.onmouseup   = this.TitleBar_MouseUp.bind(this);
	this.MaskTitle.onmousemove = this.TitleBar_MouseMove.bind(this);
	this.MaskTitle.ondragstart = this.TitleBar_DragStart.bind(this);
	this.MaskTitle.onselectstart = DisableEvent;
	
	this.MaskTitleIcon = this.MaskTitle.firstChild.childNodes[0];      this._AddCommonEventTo( this.MaskTitleIcon, true  );
	this.MaskTitleText = this.MaskTitle.firstChild.childNodes[1];      this._AddCommonEventTo( this.MaskTitleText, true  );
	this.MaskTitleMenuBtn = this.MaskTitle.firstChild.childNodes[2];   this._AddCommonEventTo( this.MaskTitleMenuBtn, true );
//	this.MaskTitleMenuBtn.onmousemove = DisableEvent;
//	this.MaskTitleMenuBtn.ondragstart = DisableEvent;
	
	this.Menu.Bind( this.MaskTitleMenuBtn, 'popupmenu' );
	
	this.IsFixed = false;
	document.onmousedown = window.onresize = function(){
	    Part.Mask.Unactivate();
	}
//	alert( 'Part.Mask Init ok;  Menu: '+ this.Menu);
    },
    _AddCommonEventTo : function( e, disMenu ){
	e.onmouseout  = this.OnMouseOut.bind(this);
	e.onmousedown = this.OnMouseDown.bind(this);
	e.ondblclick  = this.OnDoubleClick.bind(this);
	if( !disMenu ) this.Menu.Bind( e, 'ContextMenu' );
    },
    Activate : function( part, isFresh ){ // reader, type 
//	alert( 'Part.Mask Activate:' + part.Attr );
	if( !part || this.IsFPartMoving )
	    return;
	if( this.ActivePart == part && !isFresh )
	    return;
	if( this.IsFixed && this.ActivePart && Part.Menu.IsShowed() )
	    return;
	    
	this.ActivePart = part;
	this.ActiveElem = part.Elem;            //alert(this.ActiveElem.offsetWidth );
	this.IsFloating = part.Attr.IsFloating;
	if( this.IsFloating ){//alert(this.FloatLeft+'    '+ this.FloatTop)
	    this.FloatLeft = parseInt(part.Elem.currentStyle.left);
	    this.FloatTop = parseInt(part.Elem.currentStyle.top);    //alert( this.FloatLeft+'   '+this.FloatTop);
	    //alert(this.FloatLeft+'    '+ this.FloatTop)
	}
	
	var p = GetElemPos( this.ActiveElem );
	this.Left   = p.left;
	this.Top    = p.top;
	this.Right  = p.right;
	this.Bottom = p.bottom;
	this.Width  = p.width;
	this.Height = p.height;
	this._SetMaskPos();
	
	this.ActivePart = part;
	this.MaskTitleText.innerText = part.Attr.Title;
	this.MaskLayer.style.display = 'block';
	
	this._AddCommonEventTo( this.ActiveElem );
    },
    _SetMaskPos : function(){
	this.MaskHead.style.left = this.Left - 4;
	this.MaskHead.style.top  = this.Top - 6 - 20;
	this.MaskHead.style.width  = this.Width + 8 -2;
	this.MaskHead.style.height = 25;
	
	this.MaskLeft.style.left = this.Left - 4;
	this.MaskLeft.style.top  = this.Top;
	this.MaskLeft.style.width  = 3;
	this.MaskLeft.style.height = this.Height;
	
	this.MaskRight.style.left = this.Right;
	this.MaskRight.style.top  = this.Top;
	this.MaskRight.style.width  = 3;
	this.MaskRight.style.height = this.Height;
	
	this.MaskFoot.style.left = this.Left - 4;
	this.MaskFoot.style.top  = this.Bottom;
	this.MaskFoot.style.width  = this.Width + 8 -2;
	this.MaskFoot.style.height = 3;
	
	this.MaskTitle.style.left = this.Left - 1;
	this.MaskTitle.style.top  = this.Top - 3 - 20;
	this.MaskTitle.style.width  = this.Width + 2;
	this.MaskTitle.style.height = 20;
    },
    Unactivate : function(){
	this.MaskLayer.style.display = 'none';
	this.UnfixMask();
	if( this.ActivePart ){
	    this.ActiveElem.onmouseout = null;
	    this.ActivePart = null;
	}
    },
    FixMask : function(){
        this.IsFixed = true;
    },
    UnfixMask : function(){
        this.IsFixed = false;
    },
    OnMouseOut : function(){
	if( this.IsFixed ) return;
	var e = event.toElement
	while( e ){
	    if( e == this.ActiveElem || e == this.MaskLayer )
	        return;
	    e = e.parentNode;
	    if( e == TheBody ) break;
	};

        this.Unactivate();
        event.cancelBubble = true;
    },
    OnMouseDown : function(){
        this.FixMask();
        event.cancelBubble = true;
    },
    OnDoubleClick : function(){
        Part.Menu.operation('SetProperty');
    },
    TitleBar_MouseUp : function(){
	if( this.IsFPartMoving ){
	    // 拖动停止
	    this.IsFPartMoving = false;
	    this.MaskTitle.releaseCapture();
	    
	    var PartOp = new Part.Operate();
	    PartOp.MoveFloat( this.ActivePart, this.FloatLeft, this.FloatTop );
	}
    },
    TitleBar_MouseMove : function(){
	if( event.button != 1 ) return;

	if( this.IsFloating ){
	    if( !this.IsFPartMoving ){
	        // 开始拖动
	        this.IsFPartMoving = true;
	        this.MaskTitle.setCapture();//alert(parseInt(this.MaskTitle.currentStyle.left)+'    '+parseInt(this.MaskTitle.currentStyle.top))
	        this.offsetX = event.clientX - parseInt(this.MaskTitle.currentStyle.left);//this.MaskTitle.currentStyle.pixelLeft;
	        this.offsetY = event.clientY - parseInt(this.MaskTitle.currentStyle.top);//this.MaskTitle.currentStyle.pixelTop;        alert( this.offsetX +'    '+this.offsetY )
	        this.partOffX = event.clientX - this.FloatLeft;
	        this.partOffY = event.clientY - this.FloatTop;
	    } else{
	        // 拖动过程
	        var left = event.clientX - this.offsetX;
	        var top  = event.clientY - this.offsetY;
	        var fleft = event.clientX - this.partOffX;
	        var ftop  = event.clientY - this.partOffY;
	        this.SetPartPos( left - document.body.scrollLeft, top - document.body.scrollTop, fleft, ftop );
	    }	
	} else{
	    this.MaskTitle.dragDrop();
	}
    },
    TitleBar_DragStart : function(){
	var msg = 'ReadyPart;'+ this.ActivePart.Id +';'+ this.ActivePart.Attr.Type;
	event.dataTransfer.setData( 'text', msg );
    },
    SetPartPos : function( left, top, fleft, ftop ){
	var maxLeft = document.body.offsetWidth;
	var maxTop = document.body.offsetHeight;
		
	if( left>0 && left<maxLeft ) {
	    this.ActiveElem.style.left = fleft;
	    this.FloatLeft = fleft;
	    this.Left  = eval(left) + document.body.scrollLeft + 1;
	    this.Right = this.Left + this.Width;
	}	
	if( top>0 && top<maxTop ) {
	    this.ActiveElem.style.top  = ftop;
	    this.FloatTop = ftop;
	    this.Top = eval(top) + document.body.scrollTop + 23;
	    this.Bottom = this.Top + this.Height;
	}
	this._SetMaskPos();
    }
};
/* -------------------------------------------------------------------------------------------- */



/* Part.Menu 全局对象
   功能
/* -------------------------------------------------------------------------------------------- */
Part.Menu = {
    Origin : { Left:0, Top:0 },
    Init : function(){
	this.MenuObj = new cPopupMenu( ParentWindow, null, SiteRootUrl+'~sys/style/Menu.css' );
	this.MenuObj.AddItem( 'secHead', {value:'布局内部件'} );
	this.MenuObj.AddItem( 'link', {method:'function', value:'部件设置(P)...', funcRef: this.operation, parames:['SetPart'], runat: this} );
	this.MenuObj.AddItem( 'link', {method:'function', value:'样式设置(S)...', funcRef: this.operation, parames:['SetStyle'], runat: this} );
	this.MenuObj.AddItem( 'link', {method:'function', value:'内容绑定(C)...', funcRef: this.operation, parames:['BindContent'], runat: this} );
	this.MenuObj.AddItem( 'divider' );
	this.MenuObj.AddItem( 'link', {method:'function', value:'浮动(F)', funcRef: this.operation, parames:['Float'], runat: this} );
//	this.MenuObj.AddItem( 'link', {method:'function', value:'放入布局中(O)', funcRef: this.operation, parames:['EndFloat'], runat: this} );
//	this.MenuObj.AddItem( 'link', {method:'function', value:'浮动设置(L)...', funcRef: this.operation, parames:['SetFloat'], runat: this} );
//	this.MenuObj.AddItem( 'link', {method:'function', value:'样式模版(T)', funcRef: this.operation, parames:['StyleTemplate'], runat: this} );
//	this.MenuObj.AddItem( 'link', {method:'function', value:'标题和边框(T)', funcRef: this.operation, parames:['TitleBorder'], runat: this} );
//	this.MenuObj.AddItem( 'link', {method:'function', value:'内部结构编辑(E)', funcRef: this.operation, parames:['UcCodeEdit'], runat: this} );
	this.MenuObj.AddItem( 'divider' );
	this.MenuObj.AddItem( 'link', {method:'function', value:'刷新(E)', funcRef: this.operation, parames:['Fresh'], runat: this} );
	this.MenuObj.AddItem( 'link', {method:'function', value:'删除(D)', funcRef: this.operation, parames:['DeletePart'], runat: this} );
	this.MenuObj.AddItem( 'divider' );
	this.MenuObj.AddItem( 'link', {method:'function', value:'属性(R)', isBold: true, funcRef: this.operation, parames:['SetProperty'], runat: this} );

	this.FlMenuObj = new cPopupMenu( ParentWindow, null, SiteRootUrl+'~sys/style/Menu.css' );
	this.FlMenuObj.AddItem( 'secHead', {value:'浮动部件'} );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'部件设置(P)...', funcRef: this.operation, parames:['SetPart'], runat: this} );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'样式设置(S)...', funcRef: this.operation, parames:['SetStyle'], runat: this} );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'内容绑定(C)...', funcRef: this.operation, parames:['BindContent'], runat: this} );
	this.FlMenuObj.AddItem( 'divider' );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'浮动设置(L)...', funcRef: this.operation, parames:['SetFloat'], runat: this} );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'放回布局中(O)', funcRef: this.operation, parames:['EndFloat'], runat: this} );
	this.FlMenuObj.AddItem( 'divider' );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'刷新(E)', funcRef: this.operation, parames:['Fresh'], runat: this} );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'删除(D)', funcRef: this.operation, parames:['DeletePart'], runat: this} );
	this.FlMenuObj.AddItem( 'divider' );
	this.FlMenuObj.AddItem( 'link', {method:'function', value:'属性(R)', isBold: true, funcRef: this.operation, parames:['SetProperty'], runat: this} );
    },
    operation : function( op ){
	var ctrlId = Part.Mask.ActivePart.Attr.Id;
	var qr = new UrlText( ['SiteName', SiteName], ['PagePath', PagePath], ['ctrlId', ctrlId], 'uni' );
	
	var part = Part.Mask.ActivePart;
	var partOp = new Part.Operate();
	switch( op ){
	
	case'Fresh':
	    partOp.Fresh( part );
	    break;

	case'SetProperty':
	case'SetPart':
	    var sUrl = FactoryRootUrl+'PartConfig/Setting.aspx?'+ qr.Text;
	    var sMsg = Common.ShowDialog( 1, sUrl, null, {width:760,height:500} );
//	    self.parent.parent.FreshColumnTree();   //////////////////////////////// 暂时这样吧
//	    self.parent.parent.FreshFileTree();
	    if ( /^ok/i.test(sMsg) )
	        partOp.Fresh( part );
	    break;

	case'SetStyle':
	    var sUrl = FactoryRootUrl+'PartConfig/Style.aspx?'+ qr.Text;
	    var sMsg = Common.ShowDialog( 1, sUrl, null, {width:760,height:500} );
//	    self.parent.parent.FreshColumnTree();   //////////////////////////////// 暂时这样吧
//	    self.parent.parent.FreshFileTree();
	    if( /^ok/i.test(sMsg) )
	        partOp.Fresh( part );
	    break;
	    
	case'SetFloat':
	    var sUrl = FactoryRootUrl+'PartConfig/Float.aspx?'+ qr.Text;
	    var sMsg = Common.ShowDialog( 1, sUrl, null, {width:760,height:500} );
//	    self.parent.parent.FreshColumnTree();   //////////////////////////////// 暂时这样吧
//	    self.parent.parent.FreshFileTree();
	    if( /^ok/i.test(sMsg) )
	        partOp.Fresh( part );
	    break;
	    
	case'BindContent':
	    var sUrl = FactoryRootUrl+'PartConfig/BindColumn.aspx?'+ qr.Text;
	    var sMsg = Common.ShowDialog( 1, sUrl, null, {width:760,height:500} );
//	    self.parent.parent.FreshColumnTree();   //////////////////////////////// 暂时这样吧
//	    self.parent.parent.FreshFileTree();
	    if( /^ok/i.test(sMsg) )
	        partOp.Fresh( part );
	    break;
	        
	case'Float':
	    var p = GetElemPos( part.Elem );
	    var pp = GetElemPos( part.Elem.parentNode );
	    var posx = p.left - pp.left;
	    var posy = p.top - pp.top;
	    
	    partOp.Float( part, posx, posy, p.width, p.height );
	    break;
	    
	case'EndFloat':
	    partOp.EndFloat( part );
	    break;
	
	case'DeletePart':
	    if( confirm("您确认要删除该部件?") )
	        partOp.Delete( part );
	    break;
	}
    },
    Bind : function( elem, type ){
	if( !elem || !type ) return false;
	this.BindElem = elem;
	
	switch( type.toLowerCase() ){
	case'contextmenu':
	    elem.oncontextmenu = this._showContext.bind( this );
	    break;
	case'popupmenu':
	    elem.onclick = this._showPopup.bind( this );
	    elem.oncontextmenu = DisableEvent;
	    elem.ondblclick = DisableEvent;
	    break;
	}
    },
    SetOrigin : function( l, t ){
	this.Origin.Left = l;
	this.Origin.Top  = t;
    },
    IsShowed : function(){
	if( Part.Mask.ActivePart.Attr.IsFloating ){
	    return this.FlMenuObj.IsShowed();
	} else{
	    return this.MenuObj.IsShowed();
	}
    },
    _showContext : function(){
	var l = event.clientX + this.Origin.Left;
	var t = event.clientY + this.Origin.Top;// - 12;
	if( Part.Mask.ActivePart.Attr.IsFloating ){
	    this.FlMenuObj.Show( l, t );
	} else{
	    this.MenuObj.Show( l, t );	
	}
	return false;
    },
    _showPopup : function(){
	var l = event.clientX + this.Origin.Left - event.offsetX;// - 1;
	var t = event.clientY + this.Origin.Top - event.offsetY + event.srcElement.offsetHeight;// - 13;
	if( Part.Mask.ActivePart.Attr.IsFloating ){
	    this.FlMenuObj.Show( l, t );
	} else{
	    this.MenuObj.Show( l, t );
	}
//	this.MenuObj.Show( l, t );
	return false;
    }
};


/* Part Part 类 
/* -------------------------------------------------------------------------------------------- */
Part.Part = Class.create();
Part.Part.Init = function( maskLay, activeLay, maskObj, parentWnd ) //ctrlBox, xmlSrc, ctrlRoot, 
    {
	this.prototype.ParentWnd = parentWnd || window;
	this.prototype.ParentDoc = this.prototype.ParentWnd.document;
	this.prototype.MaskLayer = maskLay;
	this.prototype.ActiveLayer = activeLay;
	this.prototype.Mask = maskObj;
    };
Part.Part.prototype = {
    initialize : function( attrObj ){ //elem, pCase, pName, pId, pType ){
//	alert( 'Part.Part initialize, attrObj: ' + attrObj );
	if( !attrObj || !attrObj.Elem || !attrObj.Id ) return;
	this.Attr = attrObj;
	this.Elem = this.Attr.Elem;
	this.Id   = this.Attr.Id;
	
	this.Elem.id = 'P' + this.Id;
	this.Elem.className = 'PartBox';
	this.Elem.PartRef = this;
	
	if( this.Elem.offsetHeight <= 6 ){
	    this.Elem.style.height = '16px';
	}
	this.Elem.onresizeend = function(){
	    if( this.Elem.offsetHeight <= 6 ){
	        this.Elem.style.height = '16px';
	    }
	}

//	this.Elem.onmousedown = this.OnMouseDown.bind( this );
	this.Elem.onmousemove = this.OnMouseOver.bind( this );
	this.Elem.onmouseover = this.OnMouseOver.bind( this );
	this.Elem.ondragenter = this.OnDragEnter.bind( this );
	this.Elem.ondragover  = this.OnDragOver.bind( this );
	this.Elem.ondragleave = this.OnDragLeave.bind( this );
	this.Elem.ondrop      = this.OnDrop.bind( this );
    },
//    OnMouseDown : function(){
//	alert('OnMouseDown');
//	this.Mask.Activate( this );
//    },
    OnMouseOver : function(){
	this.Mask.Activate( this );
    },
    OnDragEnter : function(){
//	if( this.Attr.IsFloating ) return;
	if( this._drag_isOver ){    //window.alert( 'Enter _drag_isOver' );
	    event.cancelBubble = true;
	    event.returnValue = false;
	    return false;
	}
	var msg = event.dataTransfer.getData('text'); // 'NewPart;'+ this.Id +';'+ this.Type +';'+ this.Caption;
	var DragPartReg = new RegExp( '^(NewPart|ReadyPart);', 'gi' );
	if( DragPartReg.test(msg) ){            //window.alert('Enter start');
	    this._drag_isOver = true;
	    var p = GetElemPos( this.Elem );
	    this._drag_width  = p.width;    //this.Elem.offsetWidth;
	    this._drag_height = p.height;   //this.Elem.offsetHeight;
	    this._drag_left   = p.left;
	    this._drag_top    = p.top;
	    this._drag_right  = p.right;    //p.left + this._drag_width;
	    this._drag_bottom = p.bottom;   //p.top + this._drag_height;
	    event.cancelBubble = true;
	    event.returnValue = false;
	    return false;
	}                           //window.alert( 'Enter none' );
    },
    OnDragLeave : function(){	
	Part.InsertLine.style.display = 'none';
    },
    OnDragOver : function(){
//	if( this.Attr.IsFloating ) return;
	if( this._drag_isOver ){
	    var t = event.clientY + TheHtml.scrollTop;
	    var h = this._drag_top + (this._drag_height*0.5);  //alert(t +'    '+h)
	    if( t < h ){
	        Part.InsertLine.style.left = this._drag_left;
	        Part.InsertLine.style.top  = this._drag_top - 2;
	        Part.InsertLine.style.width = this._drag_width;
	        this._drag_pos = 'top';
	    } else{
	        Part.InsertLine.style.left = this._drag_left;
	        Part.InsertLine.style.top  = this._drag_bottom+1;
	        Part.InsertLine.style.width = this._drag_width;
	        this._drag_pos = 'bottom';
	    }
	    Part.InsertLine.style.display = 'block';
	    event.cancelBubble = true;
	    event.returnValue = false;
	    return false;
	}
	Part.InsertLine.style.display = 'none';
    },
    OnDrop : function(){
//	if( this.Attr.IsFloating ) return;
	Part.InsertLine.style.display = 'none';
	this._drag_isOver = false;
	
	var isFloating = this.Attr.IsFloating;
	var isLast = false;
	var isBottom = false;
	var pCaseNode = this.Elem.parentNode;
	var pns = pCaseNode.childNodes;
	for( var i=0; i<pns.length; i++ ){
	    if( pns[i] == this.Elem ) break;
	}
	if( this._drag_pos == 'bottom' ){
	    i ++;
	    if( i>=pns.length ) isLast = true;
	    isBottom = true;
	}
//	alert( pns.length +' '+ i );
	
	var msg = event.dataTransfer.getData('text');
	var strs = msg.split(';');
	var partOp = new Part.Operate();
	if( strs[0] == 'NewPart' ){   // NewPart;[PartName];[PartType];[[PartTitle]
	    var newElem = document.createElement('table');
	    if( isLast ) pCaseNode.appendChild( newElem );
	    else         pCaseNode.insertBefore( newElem, pns[i] );
	    
	    var partAttr ={
	        Id : '',
	        Elem : newElem,
	        Name : strs[1],
	        Type : strs[2],
	        Title : strs[3]
	    }
	    partOp.Append( partAttr, pCaseNode.PartCaseRef.Id, i );
	}
	else if( strs[0] == 'ReadyPart' ){  // ReadyPart;[PartId];[PartType]
	    var OldElem = $( 'P' + strs[1] );
	    var OldPart = OldElem.PartRef;
	    
	    if( !this._IsSameLocation( isBottom, OldElem ) ){
	        var newElem = document.createElement('table');
	        newElem.id = 'test';
	        if( isLast ) pCaseNode.appendChild( newElem );
	        else         pCaseNode.insertBefore( newElem, pns[i] );
    	    
	        var partAttr = OldPart.Attr;
//	        alert( partAttr.Name );
	        partOp.Move( OldPart, /*partAttr,*/ newElem, pCaseNode.PartCaseRef.Id, i );//    PartId, this.Id, 0, okCall );//( PartId, panelId, insPos, okCall )
	    }
	}
	event.cancelBubble = true;
    },
    _IsSameLocation : function( isBottom, elem ){
	if( elem.PartRef == this ) return true;
	if( isBottom && elem.previousSibling && elem.previousSibling.PartRef == this ) return true;
	if( !isBottom && elem.nextSibling && elem.nextSibling.PartRef == this ) return true;
    }
};
//this.ActiveLayer.innerHTML += ( '<br/> elem: ' + this.Elem );
//this.ActiveLayer.innerHTML += ( '<br/> elem left: ' +   this.Elem.currentStyle.left +' '+   this.Elem.clientLeft  +' '+   this.Elem.offsetLeft +' '+   this.Elem.scrollLeft );
//this.ActiveLayer.innerHTML += ( '<br/> elem top: ' +    this.Elem.currentStyle.top +' '+    this.Elem.clientTop  +' '+    this.Elem.offsetTop +' '+    this.Elem.scrollTop );
//this.ActiveLayer.innerHTML += ( '<br/> elem width: ' +  this.Elem.currentStyle.width +' '+  this.Elem.clientWidth +' '+   this.Elem.offsetWidth +' '+  this.Elem.scrollWidth );
//this.ActiveLayer.innerHTML += ( '<br/> elem height: ' + this.Elem.currentStyle.height +' '+ this.Elem.clientHeight  +' '+ this.Elem.offsetHeight +' '+ this.Elem.scrollHeight );

//var p =  this.Elem.parentNode;
//this.ActiveLayer.innerHTML += ( '<br/> p: '+ p.nodeName);
//this.ActiveLayer.innerHTML += ( '<br/> p left: ' +   p.currentStyle.left +' '+   p.clientLeft  +' '+   p.offsetLeft +' '+   p.scrollLeft );
//this.ActiveLayer.innerHTML += ( '<br/> p top: ' +    p.currentStyle.top +' '+    p.clientTop  +' '+    p.offsetTop +' '+    p.scrollTop );
//this.ActiveLayer.innerHTML += ( '<br/> p width: ' +  p.currentStyle.width +' '+  p.clientWidth +' '+   p.offsetWidth +' '+  p.scrollWidth );
//this.ActiveLayer.innerHTML += ( '<br/> p height: ' + p.currentStyle.height +' '+ p.clientHeight  +' '+ p.offsetHeight +' '+ p.scrollHeight );
/* -------------------------------------------------------------------------------------------- */



/* Part PartCase 类
/* -------------------------------------------------------------------------------------------- */
Part.PartCase = Class.create();
Part.PartCase.prototype = {
    initialize : function( elem ){
//	alert( 'Part.PartCase initialize, elem: ' + elem );
	if( !elem ) return;
	this.Elem = elem;
	this.Elem.PartCaseRef = this;
	this.Elem.className = 'PartCase';
	this.Id = elem.id;
	
	this.Elem.ondragenter = this.OnDragEnter.bind( this );
	this.Elem.ondragover  = this.OnDragOver.bind( this );
	this.Elem.ondragleave = this.OnDragLeave.bind( this );
	this.Elem.ondrop      = this.OnDrop.bind( this );
    },
    LoadPart : function( elem ){ //, id
	var partAttr ={
	    Elem : elem,
	    Id : elem.partId,
	    Name :  elem.partName || 'Part',
	    Type :  elem.partType || 'AspUcPart',
	    Title : elem.partTitle || '部件',
	    IsFloating : (elem.partFloat.toLowerCase()=='true')
	};
	var p = new Part.Part( partAttr ); //( elem, pCase, pName, pId, pType ){
    },
    OnDragEnter : function(){
	if( event.srcElement != this.Elem ) return;
	if( this.Elem.childNodes.length>0 ){
	    var parts = this.Elem.childNodes;
	    for( var i=0; i<parts.length; i++ ){
	        if( parts[i].currentStyle.position != 'absolute' ) return;
	    }
	}
	var msg = event.dataTransfer.getData('text'); // 'NewPart;'+ this.Id +';'+ this.Type +';'+ this.Caption;
	var DragPartReg = new RegExp( '^(NewPart|ReadyPart);', 'gi' );
	if( DragPartReg.test(msg) ){
	    this.Elem.className = 'PartCase_DragOver';
	    this._drag_isOver = true;
//	    this._drag_object = RegExp.$1;
//	    this._drag_msg = msg;	    
	    event.returnValue = false;
	    return false;
	}
    },
    OnDragOver : function(){
	if( this._drag_isOver ){
	    event.returnValue = false;
	    return false;
	}
    },
    OnDragLeave : function(){
	this.Elem.className = 'PartCase';
//	this.Elem.style.backgroundColor = '#f6d993';
	this._drag_isOver = false;
    },
    OnDrop : function(){
	this.Elem.className = 'PartCase';
//	this.Elem.style.backgroundColor = '#f6d993';
	this._drag_isOver = false;
	
	var msg = event.dataTransfer.getData('text');
	var strs = msg.split(';');
	var partOp = new Part.Operate();
	if( strs[0] == 'NewPart' ){   // NewPart;[PartName];[PartType];[[PartTitle]
	    var el = document.createElement('table');
	    this.Elem.appendChild( el );
	    var partAttr ={
	        Id : '',
	        Elem : el,
	        Name : strs[1],
	        Type : strs[2],
	        Title : strs[3]
	    }
	    partOp.Append( partAttr, this.Id, 0 );//( elem, partName, partTitle, panelId, insPos, okCall )
	}
	else if( strs[0] == 'ReadyPart' ){  // ReadyPart;[PartId];[PartType]
	    var OldElem = $( 'P' + strs[1] );
	    var partAttr = OldElem.PartRef.Attr;
	    
	    var newElem = document.createElement('table');
	    this.Elem.appendChild( newElem );
	    
	    partOp.Move( OldElem.PartRef,/*partAttr,*/ newElem, this.Id, 0 );//    PartId, this.Id, 0, okCall );//( PartId, panelId, insPos, okCall )
	}
    }
};
/* -------------------------------------------------------------------------------------------- */



/* Part Operate 类
/* -------------------------------------------------------------------------------------------- */
Part.Operate = Class.create();
Part.Operate.prototype = {
    xmlHttp : null,
    FirstRequestUrl : FactoryRootUrl + 'Editor/PageEditOp.aspx',
    WaitMsg : { add:'添加部件',
                move:'移动部件',
                del:'删除部件',
                fresh:'刷新部件',
                Float:'浮动部件',
                EndFloat:'放入布局',
                MoveFloat:'移动浮动部件' },
    
    initialize : function(){
//	alert('initialize');
	this.xmlHttp = (new XML.Base()).CreateXmlHttp();
	
	var idx = PagePath.lastIndexOf('\\') + 1;
	var apPath = PagePath.substring( 0, idx ) + '~ap.aspx';
	var url = new UrlText( SiteRootUrl, apPath );     //alert( url.Text );
	this.SecondRequestUrl = url.Text;
    },
    
    //////////////// 添加部件 开始/首次响应/二次响应
    Append : function( partAttr, panelId, insPos ){
//	alert('Append');
	this.Do = 'add';
	this.PartAttr  = partAttr;
	this.PanelId   = panelId;
	this.InsertPos = insPos;

	this.StartWait();
	var qr = new UrlText( ['opType', 'AddCtrl'], ['SiteName', SiteName], ['PagePath', PagePath] );
	qr.Add( ['partName', this.PartAttr.Name], ['panelId', this.PanelId], ['idx', this.InsertPos] );
	this.FirstRequest( qr.Text, this.AppendFisrtResp.bind(this) );
//	alert('Append ok');
    },
    AppendFisrtResp : function( partId ){
	this.PartAttr.Id = partId;
	
	var qr = new UrlText( ['PagePath', PagePath], ['ctrlId', this.PartAttr.Id], ['partName', this.PartAttr.Name] );
	this.SecondRequest( qr.Text, this.AppendResp.bind(this) );
    },
    AppendResp : function( strPart ){//alert('AppendResp 1 '+strPart);
	// 将用户控件 封装到指定的 PartBox 中
	if( !strPart ){
	    this.ClearWait();
	    return;
	}
	
	this._InsertCss( strPart, this.PartAttr.Id );   //alert('AppendResp 2 ');
	
	var table = this.PartAttr.Elem;
	var td = document.createElement('TD');
	var tr = document.createElement('TR');
	var tb = document.createElement('TBODY');
	tr.appendChild( td );
	tb.appendChild( tr );
	table.appendChild( tb );
	table.cellPadding = 0;
	table.cellSpacing = 0;
	
	this._FreshElem( strPart, table );//alert('AppendResp 3 ');
	var p = new Part.Part( this.PartAttr );//alert('AppendResp 4 ');
	Part.Mask.Activate( p );//alert('AppendResp 5 ');
	Part.Mask.FixMask();
	
//	var elem = this.PartAttr.Elem;
//	var pCase = table.parentNode;
	this.FreshCaseHeight( table.parentNode );

	this.PartAttr.Elem.OperateRef = null;
	this.ClearWait();
    },
    
    //////////////// 刷新部件显示 开始/  响应
    Fresh : function( part ){
//	alert('Fresh: '+ part +' '+ part.Id );
	this.Do = 'fresh';
	this.Part = part;
	this.PartId   = part.Id;
	this.PartAttr = part.Attr;
	
	this.StartWait();
	
	var qr = new UrlText( ['PagePath', PagePath], ['ctrlId', this.PartAttr.Id], ['partName', this.PartAttr.Name] );
	this.SecondRequest( qr.Text, this.FreshResp.bind(this) );
    },
    FreshResp : function( strPart ){
	//alert( 'Fresh Resp: '+ strPart );
	this._InsertCss( strPart, this.PartAttr.Id );
	this._FreshElem( strPart, this.PartAttr.Elem );
	this.PartAttr.Elem.OperateRef = null;
	
	Part.Mask.Activate( this.Part, true );
	Part.Mask.FixMask();
	
	this.FreshCaseHeight( this.PartAttr.Elem.parentNode );

	this.ClearWait();
    },
    _InsertCss : function( partHtml, id ){
	var styelHtml = '';
	styleExp = new RegExp( "\<style type\=\"text/css\" media\=\"screen\"\>([^\x00]*)\<\/style\>", "gi" ); 
	if( styleExp.test(partHtml) ){
	    styelHtml = RegExp.$1;
	    styelHtml = styelHtml.Trim();
	}   //alert('_InsertCss 1 '+styelHtml);
	if( styelHtml ){   //alert('_InsertCss 2 ');
	    var styleEl = null;
	    var sheeets = document.styleSheets;   //alert('_InsertCss 3 ');
	    for(var i=0; i<sheeets.length; i++ ){
	        if( sheeets[i].title == id )
	            styleEl =  sheeets[i];
	    }   //alert('_InsertCss 4 ');
	    if( !styleEl ){
	        styleEl = document.createStyleSheet();
	        styleEl.title = id;
	    }   //alert('_InsertCss 5 ');
	    styleEl.cssText = styelHtml;   //alert('_InsertCss 6 ');
	}
    },
    _FreshElem : function( strPart, elem ){         //alert('_FreshElem 0 ');//alert('elem.innerHTML='+elem.innerHTML);
	TempCase.innerHTML = strPart;               //alert('_FreshElem 1 ');//alert(elem.firstChild);
	var table = TempCase.firstChild;            //alert( 'table='+table.outerHTML );
	var thtml  = table.firstChild.firstChild.firstChild.innerHTML;      //alert(thtml)
//	var tstyle = table.style;          //alert(tstyle)
//	
//	elem.style.display  = tstyle.display;
//	elem.style.position = tstyle.position;      //alert(elem.style.position)
//	elem.style.left     = tstyle.left;          //alert(elem.style.left)
//	elem.style.top      = tstyle.top;           //alert(elem.style.top)	
//	elem.style.width    = tstyle.width;         //alert(elem.style.left)
//	elem.style.marginTop    = tstyle.marginTop;     //alert('marginTop: '+tstyle.marginTop+';   '+elem.style.marginTop)
//	elem.style.marginBottom = tstyle.marginBottom;  //alert('marginBottom: '+tstyle.marginBottom+';   '+elem.style.marginBottom)
//	elem.style.marginLeft   = tstyle.marginLeft;    //alert('marginLeft: '+tstyle.marginLeft+';   '+elem.style.marginLeft)
//	elem.style.marginRight  = tstyle.marginRight;   //alert('marginRight: '+tstyle.marginRight+';   '+elem.style.marginRight)
	var td = elem.firstChild.firstChild.firstChild;        //alert( '_FreshElem 4 '+td.nodeName );
	td.innerHTML = thtml;                       //alert('_FreshElem 5 ');//elem.outerHTML);
	TempCase.innerHTML = '';                    //alert('_FreshElem 6 ');
    },

    //////////////// 移动部件 开始/  响应
    Move : function( part,/*partAttr,*/ newElem, panelId, insPos ){
//	alert('Move');
	this.Do = 'move';
	this.Part = part;
	this.PartId   = part.Id;
	this.PartAttr  = part.Attr;//partAttr;
	this.NewElem   = newElem;
	this.PanelId   = panelId;
	this.InsertPos = insPos;

	this.StartWait();

	var qr = new UrlText( ['opType', 'movectrl'], ['SiteName', SiteName], ['PagePath', PagePath] );
	qr.Add( ['ctrlId', this.PartId ], ['panelId', this.PanelId], ['idx', this.InsertPos] );
	this.FirstRequest( qr.Text, this.MoveResp.bind(this) );
//	alert('Move ok');
    },
    MoveResp : function( partId ){/**/
	var html = this.PartAttr.Elem.outerHTML + '';
//	var i = html.indexOf('<DIV class=WaitMsgBox>');
//	if( i != -1 ) html = html.substring( 0, i );
	this.NewElem.outerHTML = html;
	this.PartAttr.Elem.parentNode.removeChild( this.PartAttr.Elem );
	this.FreshCaseHeight( this.PartAttr.Elem.parentNode );

	this.NewElem = $( 'P' + this.PartAttr.Id );
//	alert(this.NewElem.innerHTML);
	this.PartAttr.Elem = this.NewElem;
	
	// 将用户控件 封装到指定的 PartBox 中
	var p = new Part.Part( this.PartAttr );
	this.PartAttr.Elem.OperateRef = null;	
	Part.Mask.Activate( p );
	Part.Mask.FixMask();
	
	this.ClearWait();/**/
	this.Fresh( this.Part )
    },
    
    //////////////// 删除部件 开始/  响应
    Delete : function( part ){
//	alert('Delete: '+ part +' '+ part.Id );
	this.Do = 'del';
	this.Part = part;
	this.PartId   = part.Id;
	this.PartAttr = part.Attr;
	
	this.StartWait();

	// optype=remctrl&sitename=...&pagepath=...&ctrlid=...
	var qr = new UrlText( ['opType', 'remctrl'], ['SiteName', SiteName], ['PagePath', PagePath], ['ctrlId', this.PartAttr.Id ] );
	this.FirstRequest( qr.Text, this.DeleteResp.bind(this) );
    },
    DeleteResp : function( partId ){
//	alert( 'Delete Resp '+ partId +' '+ this.PartId );
	// 移除部件的 DOM 节点
	var elem = this.Part.Elem;
	var pCase = elem.parentNode;
	pCase.removeChild( elem );
	
	this.FreshCaseHeight( pCase );
	
	Part.Mask.Unactivate();
	
	this.ClearWait();
    },
    
    //////////////// 设置部件浮动
    Float : function( part, posX, posY, width, height ){
	this.Do = 'Float';
	this.Part = part;
	this.PartId   = part.Id;
	this.PartAttr = part.Attr;
	this.Part_PosX = posX;
	this.Part_PosY = posY;
	this.Part_Width = width;
	this.Part_Height = height;
	
	this.StartWait();

	var qr = new UrlText( ['opType', 'FloatCtrl'], ['SiteName', SiteName], ['PagePath', PagePath] );
	qr.Add( ['ctrlId', this.PartId ], ['posx', posX], ['posy', posY], ['width', width], ['height', height] );
	this.FirstRequest( qr.Text, this.FloatResp.bind(this) );
    },
    FloatResp : function(){
	var elem = this.PartAttr.Elem;
	var pCase = elem.parentNode;
	if( pCase.lastChild != elem ){
	    pCase.removeChild( elem );
	    pCase.appendChild( elem );
	}		
	pCase.style.position = 'relative';
		
	elem.style.position = 'absolute';   //alert( elem.style.width );
	elem.style.left = this.Part_PosX;
	elem.style.top = this.Part_PosY;
	if( elem.currentStyle.width == '100%' )
	    elem.style.width = 'auto';      //this.Part_Width;
	    
//	var elem = this.PartAttr.Elem;
//	var pCase = elem.parentNode;	
	
	this.FreshCaseHeight( pCase );
//	this._SetCaseHeight( pCase );
	this.PartAttr.IsFloating = true;

	Part.Mask.Activate( this.Part, true );
	Part.Mask.FixMask();

	this.ClearWait();
    },

    //////////////// 部件停止浮动 放入布局
    EndFloat : function( part ){
	this.Do = 'EndFloat';
	this.Part = part;
	this.PartId   = part.Id;
	this.PartAttr = part.Attr;
	
	this.StartWait();

	var qr = new UrlText( ['opType', 'EndFloat'], ['SiteName', SiteName], ['PagePath', PagePath], ['ctrlId', this.PartAttr.Id ] );
	this.FirstRequest( qr.Text, this.EndFloatResp.bind(this) );
    },
    EndFloatResp : function(){
	var elem = this.PartAttr.Elem;
	var pCase = elem.parentNode;
	if( pCase.firstChild != elem ){
	    var fElem = null;
	    for( var i=0; i<pCase.childNodes.length; i++ ){
	        if( pCase.childNodes[i].currentStyle.position == 'absolute' ){
	            fElem = pCase.childNodes[i];
	            break;
	        }
	    }
	    if( fElem && fElem != elem ){
	        pCase.insertBefore( elem, fElem );
	    }
	}	
	elem.style.position = 'static'; //alert( elem.style.width );
	elem.style.left = '';
	elem.style.top = '';
	if( elem.currentStyle.width == 'auto' )
	    elem.style.width = '100%';
	
	this.FreshCaseHeight( pCase );
//	this._SetCaseHeight( pCase );
	this.PartAttr.IsFloating = false;
	
	Part.Mask.Activate( this.Part, true );
	Part.Mask.FixMask();

	this.ClearWait();
    },
    
    //////////////// 移动 浮动部件
    MoveFloat : function( part, posX, posY ){
	this.Do = 'MoveFloat';
	this.Part = part;       //alert(this.Part);
	this.PartId   = part.Id;       //alert(this.PartId);
	this.PartAttr = part.Attr;
	
	this.StartWait();

	var qr = new UrlText( ['opType', 'MoveFloat'], ['SiteName', SiteName], ['PagePath', PagePath] );
	qr.Add( ['ctrlId', this.PartId ], ['posX', posX], ['posY', posY] );//, ['caseHeight',ch] );
	this.FirstRequest( qr.Text, this.MoveFloatResp.bind(this) );
    },
    MoveFloatResp : function(){
	var elem = this.PartAttr.Elem;
	var pCase = elem.parentNode;	
	
	this.FreshCaseHeight( pCase );
	
	Part.Mask.Activate( this.Part, true );
	Part.Mask.FixMask();
//	if( !Part.Mask.ActivePart ) alert('error  this.Part='+this.Part);

	this.ClearWait();
    },

    FreshCaseHeight : function( partCase ){//alert(partCase+'  '+partCase.PartCaseRef)
	if( !partCase || !partCase.PartCaseRef ) return;

	var caseId = partCase.PartCaseRef.Id;
	var ct = GetElemPos( partCase ).top;
	var pList = partCase.childNodes;   //alert(pList+'  '+pList.length+'   ct='+ct);
	var ah = 0, sh = 0;
	for(var i=0; i<pList.length; i++ ){
	    var p = pList[i];   //alert( p.style.position);
	    var l = GetElemPos( p );     //alert('l.bottom='+l.bottom);
	    var b = l.bottom - ct;              
	    if( p.currentStyle.position == 'absolute' ){
	        if( b > ah ) ah = b;
	    } else{
	        if( b > sh ) sh = b;
	    }
	    //alert( i + 'position:'+ p.style.position + ';   b='+b+';   sh='+sh );
	}       //alert(partCase.style.height+'  '+h);
	var ch = null; 
	var oldHeight = partCase.currentStyle.height; 
	var needFresh = true;
	if( ah>0 && ah>sh ){
	    ch = ah+'px'; //alert(oldHeight);
	    if( oldHeight == ch ) needFresh = false;
	} else{
	    ch = 'auto';
	    if( oldHeight=='' || oldHeight=='auto' ) needFresh = false;
	}
	partCase.style.height = ch;
	//alert('needFresh='+needFresh);

	if( needFresh ){
	    var qr = new UrlText( ['opType', 'CaseHeight'], ['SiteName', SiteName], ['PagePath', PagePath] );
	    qr.Add( ['partCase', caseId ], ['height',ch] );
	    this.FirstRequest( qr.Text, null );
	}
    },

    // 等待状态 处理  显示 /  中止 /  中止延时清除
    StartWait : function(){
	
	/*var e = document.createElement('div');
	e.className = 'WaitMsgBox';  //alert( this.PartAttr.Title );
	e.innerHTML = '<span><b></b>正在'+ this.WaitMsg[this.Do] +'“'+ this.PartAttr.Title +'”</span>';
	e.onselectstart = DisableEvent;
	e.oncontextmenu = DisableEvent;
//	this.PartAttr.Elem.className = 'OperatePart';
//	this.PartAttr.Elem.style.height = '26px';

	this.PartAttr.Elem.appendChild( e );
	this.PartAttr.Elem.OperateRef = this;
	this.WaitElem = e;*/
	
	OperLayer.style.display = 'block';//alert(OperLayer.className+'    '+document.documentElement.clientHeight);
//	alert('TheBody.offsetHeight'+ TheBody.offsetHeight +'    TheBody.clientHeight='+ TheBody.clientHeight );
//	alert('TheHtml.offsetHeight'+ TheHtml.offsetHeight +'    TheHtml.clientHeight='+ TheHtml.clientHeight );
	
	OperLayer.style.height = TheBody.clientHeight;// document.documentElement.offsetHeight;//clientHeight;
	ShowWaitingBox();
//	WaitMsgBox.style.display = 'block';
    },
    BreakWait : function(){
//	if( this.WaitElem ){
//	    this.WaitElem.className = 'WaitMsgBox_Err';  //alert( this.PartAttr.Title );
//	    this.WaitElem.innerHTML = '<span><b></b>'+this.WaitMsg[this.Do] +'“'+ this.PartAttr.Title +'”出错!</span>';
//	}
//	setTimeout( this.ClearWait.bind(this), 2000 );
    },
    ClearWait : function(){
/*        var pe = this.PartAttr.Elem;
	pe.OperateRef = null;
	pe.className = '';
	pe.style.height = 'auto';
        if( this.WaitElem ){
            pe.removeChild( this.WaitElem );
            if( pe.childNodes.length <= 0 )
                pe.parentNode.removeChild( pe );
        }*/
	OperLayer.style.display = 'none';
	OperLayer.style.height = '0px';
	CloseWaitingBox();
//	WaitMsgBox.style.display = 'none';
    },
    
    // 首次请求/回发响应   请求后台进行 文件的更改/复制
    FirstRequest : function( query, call ){ // pageId, panelId, partName ){
//	alert('First Request:\n'+ query);
	this._fir_callback = call;
	this.xmlHttp.open( "POST", this.FirstRequestUrl, true );
	this.xmlHttp.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded' );
	this.xmlHttp.onreadystatechange = this.FirstResponse.bind(this);
	this.xmlHttp.send( query );
    },
    FirstResponse : function(){
	if( this.xmlHttp.readyState != 4 )
	    return false;
//	alert( this.xmlHttp.responseText );
	if( this.xmlHttp.status == 200 || this.xmlHttp.status == 304 ){
	    // 从回发的文本中 提取出 CtrlId;
	    var strPart = this.xmlHttp.responseText;
	    if( /^ok;([0-9]+)$/i.test(strPart) ){   //alert("StartWait Start");
	        if( this._fir_callback )
	            this._fir_callback( RegExp.$1 );
	        return;
	    }
	}
	this.BreakWait();
    },
    // 二次请求/回发响应   请求站点后台的 仿真加载部件
    SecondRequest : function( query, call ){
//	alert('SecondRequest:\n'+ query +'  '+ this.SecondRequestUrl);
//	query += ('&PagePath=' + PagePath);
	this._sec_callback = call;
	this.xmlHttp.open( "POST", this.SecondRequestUrl, true );
	this.xmlHttp.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded' );
	this.xmlHttp.onreadystatechange = this.SecondResponse.bind(this);
	this.xmlHttp.send( query );
    },
    SecondResponse : function(){
	if( this.xmlHttp.readyState != 4 )
	    return false;
//	alert(this.xmlHttp.responseText);
	if( this.xmlHttp.status != 200 && this.xmlHttp.status != 304 ){
	    this.BreakWait();
	    alert('部件显示请求响应错误，错误号:'+this.xmlHttp.status+'\n\n'+ this.xmlHttp.responseText);
	    return false;
	}
	// 先验证回发的文本是否为错误信息
	var strPart = this.xmlHttp.responseText;
	var ErrRegExp = new RegExp( "^error;\\s*([^0x00]*)", "gi" );
	if( ErrRegExp.test(strPart) ){
	    this.BreakWait();
	    alert('WebIntelli 出现内部错误!\n\n 错误原因：'+ RegExp.$1 );
	    return false;
	}

	// 从回发的文本中 提取出 用户控件 部分
	var OpRegExp = new RegExp( "\<\!-- New Part Start --\>([^\x00]*)\<\!-- New Part End --\>", "gi" );
	if( OpRegExp.test(strPart) ){
	    strPart = RegExp.$1;
	    strPart = strPart.Trim();
	} else{
	    return;
	}
//	alert( strPart );
	OpRegExp = new RegExp( "\<div id\=\"PartCase\"\[^>]*>([^\x00]*)\<\/div\>$", "gi" );
	if( OpRegExp.test(strPart) ){
	    strPart = RegExp.$1;
	    strPart = strPart.Trim();
	}
	if( !strPart &&  this._sec_callback )
	    this._sec_callback( '' );
//	alert( strPart );
	 
	// 将 用户控件 中的事件 拆除
	OpRegExp = new RegExp( "(on[a-z]+=\")[^\"]*(\")", "gim" );
	strPart = strPart.replace( OpRegExp, "$1$2" );
//	alert( strPart );
	 
	// 将 用户控件 中的 <A> href 的内容用 # 替换
	OpRegExp = new RegExp( "(\<a[^\<\>]+href=\")[^\"]*(\"[^\<\>]*\>)", "gim" );
	strPart = strPart.replace( OpRegExp, "$1#$2" );
//	alert( strPart );
	
	// 将处理好 用户控件 插入 DOM 指定位置中
	if( this._sec_callback )
	    this._sec_callback( strPart );
    }
};

// JS加载完成，启动...
Editor_Load();