﻿
/* 数据表视图 控件  DataViewControls
---------------------------------
ThumbView   缩略图视图
TiledView   平铺视图
IconsView   图标视图
ListView    列表视图
DetailView  详细列表视图
ExcelTableView
---------------------------------*/

/* ThumbView   缩略图视图
/* -------------------------------------------------------------------------------------------- */
var ThumbView = {}

/* ThumbView.Case 类 / 应用类 / 将来应继承自 TiledView.Case 类
/* -------------------------------------------------------------------------------------------- */
ThumbView.Case = Class.create();
ThumbView.Case.prototype = {
    initialize : function( elem, ajaxUrl, selFunc, unselFunc ){
	this.elemRef = elem;
	this.elemRef.className = 'ThumbCase';
	this.elemStyle = this.elemRef.style;
	
	this.Nails = {};
	this.ActiveNail = null;
	this._ajax = new AjaxRequest( ajaxUrl, this.LoadByJson.bind(this), this._LoadError.bind(this) );
	if( typeof selFunc == 'function' )
	    this._SelFunc = selFunc;
	if( typeof unselFunc == 'function' )
	    this._UnselFunc = unselFunc;

	this.elemRef.onmousedown = this.OnMouseDown.bind(this);
    },
    // 加载 JSON 格式的站点数据数组
    LoadByJson : function( jsonText ){
	var jsons = eval( jsonText );
	if( !(jsons instanceof Array) ) return;
	
	if( this.elemRef.innerHTML == '正在加载模版...' )
	    this.elemRef.innerHTML = "";

	var nail, firstNail;
	for( var i=0; i<jsons.length; i++ ){
	    var json = jsons[i];
	    if( !json || !json.name ) continue;
    	
	    nail = this.Nails[json.name];
	    if( nail ){
	        nail.Fresh( json );
	    } else{
	        nail = new ThumbView.Nail( this, json );
	        this.Nails[json.name] = nail;
	    }
	}
    },
    LoadByRequest : function( postText ){
	this.elemRef.innerHTML = '正在加载模版...';
	this._ajax.Post( postText );
    },
    _LoadError : function( errMsg ){
	this.elemRef.innerHTML = '加载时出现错误：'+ errMsg;
    },
    ActivateNail : function( nail ){
	if( this.ActiveNail )
	    this.ActiveNail.Unactive();	
	if( nail ){
	    nail.Activate();
	    this.ActiveNail = nail;
	    if( this._SelFunc )
	        this._SelFunc( nail.name );	    
	} else{
	    if( this._UnselFunc )
	        this._UnselFunc();
	    this.ActiveNail = null;
	}
    },
    OnMouseDown : function(){
	this.ActivateNail();
    }
};
/* -------------------------------------------------------------------------------------------- */

ThumbView.Nail = Class.create();
ThumbView.Nail.prototype = {
    initialize : function( parentCase, json, parentWnd ){
	if( !json || !json.name ) return;
	
	this.ParentCase = parentCase;
	this.parentElem = parentCase.elemRef;
	this.parentWnd = parentWnd || window;
	this.parentDoc = this.parentWnd.document;
	
	this.elemRef = this.parentDoc.createElement('div');
	this.elemRef.className = 'ThumbNail';
	this.elemRef.innerHTML = "<div class='Border'><div class='Image'></div></div><div class='Text'><span></span></div>";
	
	this.borderRef = this.elemRef.firstChild;
	this.imgRef    = this.borderRef.firstChild;
	this.imgStyle  = this.imgRef.style;
	this.textPnRef   = this.elemRef.childNodes[1];
	this.textRef   = this.textPnRef.firstChild;

	this.Fresh( json );		
	this.parentElem.appendChild( this.elemRef );
	
	this.borderRef.onmousedown = this.OnMouseDown.bind(this);
	this.textRef.onmousedown = this.OnMouseDown.bind(this);
    },
    Fresh : function( json ){
	if( !json || !json.name ) return;
	
	this.name = json.name;
	this.title = json.title;//alert(this.imgStyle+'  '+json.name +'  '+json.imgSrc);
	this.imgStyle.backgroundImage = 'url('+ json.imgSrc +')';
	this.textRef.innerText = this.title;
	this.elemRef.title = this.title;
    },
    Unactive : function(){
	this.elemRef.className = 'ThumbNail';
//	this.iconStyle.backgroundPosition = '0px ' + this.iconStyle.backgroundPosition.split(' ')[1];
    },
    Activate : function(){
	this.elemRef.className = 'ThumbNail_Active';
//	this.iconStyle.backgroundPosition = '48px ' + this.iconStyle.backgroundPosition.split(" ")[1];
    },
    OnMouseDown : function(){
	this.ParentCase.ActivateNail( this );
	this.parentWnd.event.cancelBubble = true;
    }
};
/* -------------------------------------------------------------------------------------------- */


/* WebSite 类 / 应用类 / 将来应继承自 TiledView.Entity 类
/* -------------------------------------------------------------------------------------------- */
var WebSiteState = 
    [{ Text: '未知站点' },
     { Text: '无效空站点' },
     { Text: '正在运行', AllowEdit: true, IsAvail: true, RunPusText:'暂停', RunPusOp:'pause', BakRstText:'转为备份', BakRstOp:'backup' },
     { Text: '暂停',     IsAvail: true, RunPusText:'运行', RunPusOp:'run', BakRstText:'转为备份', BakRstOp:'backup' },
     { Text: '出错暂停' },
     { Text: '备份站点', BakRstText:'还原备份', BakRstOp:'restore' },
     { Text: '错误的备份' }];

WebSite = Class.create();
WebSite.prototype = {
    stateTexts : ['未知站点', '空站点', '正在运行', '暂停', '出错暂停', '备份站点', '错误的备份' ],
    
    initialize : function( parentCase, json, parentWnd ){
	if( !json || !json.name || json.state>6 || json.state<0 )
	    return;
	this.ParentCase = parentCase;
	this.parentElem = parentCase.elemRef;
	this.parentWnd = parentWnd || window;
	this.parentDoc = this.parentWnd.document;
	
	this.elemRef = this.parentDoc.createElement('div');
	this.elemRef.onmousedown = this.OnMouseDown.bind(this);
	
	this.elemRef.className = 'WebSite';
	this.elemRef.innerHTML = "<div class='Icon'></div><div class='Text'><div class='Line1'></div><div class='Line2'></div><div class='Line3'></div></div>";
	this.iconRef = this.elemRef.firstChild;
	this.iconStyle = this.iconRef.style;
	this.textRef1 = this.elemRef.childNodes[1].childNodes[0];
	this.textRef2 = this.elemRef.childNodes[1].childNodes[1];
	this.textRef3 = this.elemRef.childNodes[1].childNodes[2];
	
	this.state = 0;
	this.Fresh( json );
		
	this.parentElem.appendChild( this.elemRef );
    },
    Fresh : function( json ){
	if( !json || !json.name || json.state>6 || json.state<0 )
	    return;
	Object.extend( this, json );
	
	topoff=json.state*(-48);
	this.iconRef.style.backgroundPosition="0px "+topoff+"px";
	
	this.textRef1.innerText = this.title;
	this.textRef2.innerText = WebSiteState[this.state].Text;
	if( this.fullUrl )
	    this.textRef3.innerText = this.fullUrl;

	this.elemRef.title = this.title +' ['+ WebSiteState[this.state].Text +'] '+ this.fullUrl;
	
	this.OutHtml = '<p><b>'+ this.title +'</b></p>';
	this.OutHtml += '<p>状态：'+ WebSiteState[this.state].Text +'</p>';	
	if( this.pageCount )   this.OutHtml += '<p>页面数：'+ this.pageCount +'</p>';
	if( this.columnCount ) this.OutHtml += '<p>栏目数：'+ this.columnCount +'</p>';
	if( this.fullUrl )     this.OutHtml += '<p><a href="'+ this.fullUrl +'" target="_blank">预览站点</a></p>';
	this.OutHtml += '<a href="SiteDetail.htm?sitename='+ this.name +'">查看站点详情 >></a>';
    },
    Unactive : function(){
	this.elemRef.className = 'WebSite';
	this.iconStyle.backgroundPosition = '0px ' + this.iconStyle.backgroundPosition.split(' ')[1];
    },
    Activate : function(){
	this.elemRef.className = 'WebSite_Active';	
	this.iconStyle.backgroundPosition = '48px ' + this.iconStyle.backgroundPosition.split(" ")[1];
    },
    OnMouseDown : function(){
	this.ParentCase.ActivateSite( this );
	this.parentWnd.event.cancelBubble = true;
    }
};


/* SitesCase 类 / 应用类 / 将来应继承自 TiledView.Case 类
/* -------------------------------------------------------------------------------------------- */
SitesCase = Class.create();
SitesCase.prototype = {
    initialize : function( elem, ajaxUrl ){
	this.elemRef = elem;
	this.elemRef.className = 'TiledCase';
	this.elemStyle = this.elemRef.style;
	
	this.Sites = {};
	this.ActiveSite = null;
	this._ajax = new AjaxRequest( ajaxUrl, this.LoadByJson.bind(this), this._LoadError.bind(this) );
	
	this._InfoArea = $('InfoArea');
	this._btnEditSite = $('btnEditSite');

	this.elemRef.onmousedown = this.OnMouseDown.bind(this);
    },
//    NewByJson : function( json ){
//	var site = new WebSite( this, json );
//	this.Sites.push( site );
//    },
    // 加载 JSON 格式的站点数据数组
    LoadByJson : function( jsonText ){
	var jsons;
	try{
	    jsons = eval(jsonText);
	    if( !(jsons instanceof Array) ) throw new Error();
	} catch(e) { 
	    this.elemRef.innerHTML = '加载站点时出现错误：'+ e.message;
	    return; 
	}

	if( jsons.length <= 0 ){
	    this.elemRef.innerHTML = '没有站点，请选择“新建站点”功能创建新的站点。';
	    return;
	}
	
	if( this.elemRef.innerHTML == '正在加载站点...' )
	    this.elemRef.innerHTML = '';
	
	var site, firstSite;
	for( var i=0; i<jsons.length; i++ ){
	    var json = jsons[i];
	    if( !json || !json.name ) continue;
    	
	    site = this.Sites[json.name];
	    if( site ){
	        site.Fresh( json );
	    } else{
	        site = new WebSite( this, json );
	        this.Sites[json.name] = site;
	    }
	}
    },
    LoadByRequest : function( postText ){
	this.elemRef.innerHTML = '正在加载站点...';
	this._ajax.Post( postText );
    },
    _LoadError : function( errMsg ){
	this.elemRef.innerHTML = '加载站点时出现错误：'+ errMsg;
//	alert('err '+ errMsg);
    },
    ActivateSite : function( site ){
	if( this.ActiveSite )
	    this.ActiveSite.Unactive();	
	if( site ){
	    site.Activate();
	    this.ActiveSite = site;
	    
	    this._InfoArea.innerHTML = site.OutHtml;
	    var sta = WebSiteState[site.state];
	    this._btnEditSite.disabled = !(sta.AllowEdit);
	    
	} else{
	    this.ActiveSite = null;
	    
	    this._InfoArea.innerHTML = '<p>请选择站点进行操作。</p>';
	    this._btnEditSite.disabled = true;
	}
    },
    OnMouseDown : function(){
	this.ActivateSite();
    }
};

/* -------------------------------------------------------------------------------------------- */


