using System;
using System.Data;
using System.Collections;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;

public partial class Part_CommentAdd : System.Web.UI.UserControl
{
    private PartAccess pAcc = null;
    private bool isSettingReady = false;
    private string ArticleId = "";
    private string userName = "";

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            ArticleId = Todo.Get( "aid", Request );
            userName = Todo.Get( "User", Session );
            if( userName == "" ) userName = "ο";

            pAcc = new PartAccess( this );
            PartAccess pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            if( !IsPostBack ) {
                int mLen = Math.Abs( pAcc.GetSettingInt( "MaxLength", 150 ) ); // Todo.GetInt( "MaxLength", nvCol, 150 ) );
                txtContent.Attributes.Add( "onkeypress", "if (this.value.length>=" + mLen + "){event.returnValue=false}" );
            }
            isSettingReady = true;

        } catch( Exception ex ) {
            Todo.DebugOut( "[Part_CommentAdd.Page_Load] 쳣" + ex.Message );
        }
    }

    protected void btnSubmit_Click( object sender, EventArgs e )
    {
        string cont = txtContent.Value.Trim();
        string title = tbTitle.Value.Trim();
        tbTitle.Value = "";
        txtContent.Value = "";

        if( !isSettingReady || ArticleId == "" ) {
            Todo.DebugOut( "[Part_CommentAdd.btnSubmit_Click]  isSettingReady=" + isSettingReady + "   ArticleId=" + ArticleId );
            return;
        }
        if( cont == "" ) {
            Todo.DebugOut( "[Part_CommentAdd.btnSubmit_Click] ûΪ!" );
            return;
        }

        title = title.Replace( ",", "" );
        cont = cont.Replace( "\r\n", "<br/>" );
        cont = cont.Replace( ",", "" );
        cont = Server.UrlEncode( cont );
        cont = Server.UrlDecode( cont );

        string columnName = "ArticleId,UserName,Content,Title";
        string columnValue = ArticleId + "," + userName + "," + cont + "," + title;

        ContentAccess ca = new ContentAccess( this, "TableName" );
        bool isOK = ca.Write( "[*]", columnName, columnValue );

        if( !isOK ) {
            Todo.DebugOut( "[Part_CommentAdd.btnSubmit_Click] дݿʧ" );
            return;
        }
        string PageUrl = pAcc.GetSetting( "ListPagePath" );
        if( PageUrl != "" ) {
            PageUrl += ("?aid=" + ArticleId);
            try {
                Server.Transfer( PageUrl );
            } catch( Exception ex ) { Todo.DebugOut( "[Part_CommentAdd.btnSubmit_Click] ҳת쳣" + ex.Message ); }
        } else {
            PageUrl = Request.Path;
            PageUrl = PageUrl.Substring( PageUrl.IndexOf( "/" ) );
        }
    }
}
