﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using BoyunBase;
using SiteCore;

public partial class Part_CorpGoodsView : System.Web.UI.UserControl
{
    private PartAccess pAcs = null;
    private int TotalCount;//数据总数
    private int PageIndex; //页索引
    private int PageCount;//页总数
    private int PageSize;
    private DataTable dt;

    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( !IsPostBack ) {
                pAcs = new PartAccess( this );
                if( pAcs.IsReady ) {
                    GetData();
                    PartShow();
                }
            }
        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpGoodsView '出现异常：" + ex.Message );
        }
    }

    private void GetData()
    {
        ContentAccess ca = new ContentAccess( this, "TableName" );
        string key = Todo.Get( "key", Request ).Trim();

        if( key != "" ) {//条件判断
            dt = ca.Read( "[@GoodsTitle like '%" + key + "%']", "name" );
            if( dt == null || dt.Rows.Count < 1 ) {
                dt = ca.Read( "[@GoodsTitle like '%" + key + "']", "name" );
                if( dt == null || dt.Rows.Count < 1 ) {
                    dt = ca.Read( "[@GoodsTitle like '" + key + "%']", "name" );
                    if( dt == null || dt.Rows.Count < 1 ) {
                        lbMsg.Visible = true;
                        lbMsg.InnerText = "抱歉，没有找到与“" + key + "”相关的供应信息。";
                        return;
                    }
                }
            }
            lbMsg.Visible = true;
            lbMsg.InnerText = "搜索与“" + key + "”相关的供应信息：";
        } else {
            lbMsg.Visible = false;
            dt = ca.Read( "[*]", "name" );
            if( dt == null || dt.Rows.Count < 1 ) return;
        }//进行分页显示

        TotalCount = dt.Rows.Count;
        PageSize = pAcs.GetSettingInt( "PageSize", 12 ); //Todo.GetInt( "PageSize", nvCol, 12 );
        if( PageSize <= 4 ) {
            PageSize = 4;
        } else if( PageSize % 4 != 0 ) {
            PageSize = PageSize - (PageSize % 4) + 4;
        }
        PageCount = Convert.ToInt32( Math.Floor( Convert.ToDouble( TotalCount / PageSize ) ) + 1 );
        PageIndex = 1;

        //要用计算的都放到viewstate中
        Session["Part_CorpGoodsView_Dt"] = dt;
        //ViewState["TotalCount"] = TotalCount;
        //ViewState["PageSize"] = PageSize;
        //ViewState["PageCount"] = PageCount;
        //ViewState["PageIndex"] = PageIndex;
    }

    private void PartShow()//数据显示
    {
        if( dt == null && Session["Part_CorpGoodsView_Dt"] != null ) {
            dt = Session["Part_CorpGoodsView_Dt"] as DataTable;
        }
        if( dt == null || dt.Rows.Count < 1 ) return;

        //TotalCount = Todo.GetInt( "TotalCount", ViewState );
        //PageSize = Todo.GetInt( "PageSize", ViewState );
        //PageCount = Todo.GetInt( "PageCount", ViewState );
        //PageIndex = Todo.GetInt( "PageIndex", ViewState );

        // 分页 **
        // 显示页选择器
        // 分页选择处理

        int start, end;  //循环的起始、结束索引
        start = 0;// (PageIndex - 1) * PageSize;
        end = TotalCount;
        //if( (PageIndex * PageSize) > TotalCount )//最后一页了
        //{
        //    end = (PageIndex - 1) * PageSize + (PageSize - (PageIndex * PageSize - TotalCount));    //用前一页的总数加上pagesize－多出来的就是需要的最大索引了
        //} else {
        //    end = PageIndex * PageSize;
        //}

        string detailPage = pAcs.GetSetting( "detailPage" );  // 链接产品页 传递参数给 产品展示 部件
        if( detailPage != "" ) {
            detailPage += "?pid=";
        } else {
            detailPage = "";
        }

        string timeFormat = pAcs.GetSetting( "timeFormat" );
        bool isOpenNew = pAcs.GetSettingBool( "isOpenNew" );
        string target = "";
        if( isOpenNew ) target = "_blank";
        else target = "_self";

        Todo.AddDataCol( "Target", dt );
        Todo.AddDataCol( "IssueTimeStr", dt );
        Todo.AddDataCol( "LinkUrl", dt );
        foreach( DataRow dr in dt.Rows ) {
            if( detailPage != "" )
                dr["LinkUrl"] = detailPage + Todo.Get( "Id", dr );
            else
                dr["LinkUrl"] = "";
            //dr["ThumbPath"] = Todo.Get( "ThumbPath", dr ); //pAcs.ToRelUrl();
            dr["IssueTimeStr"] = Todo.TimeFormat( Todo.Get( "IssueTime", dr ), timeFormat );
            dr["Target"] = target;
        }

        rptGoodsList.DataSource = dt;
        rptGoodsList.DataBind();

    }
}

/*        
//string GoodsPagePath = pAcs.GetSetting( "GoodsPagePath" );  // 链接产品页 传递参数给 产品展示 部件
        //if( GoodsPagePath != "" ) {
        //    GoodsPagePath += "?pid=";
        //} else {
        //    GoodsPagePath = "";
        //}

        //string TimeFormat = pAcs.GetSetting( "IssueTimeFormat" );   
        //bool IsNewOpen = pAcs.GetSettingBool( "IssueTimeFormat" );  
        //string Target = "";
        //if( IsNewOpen ) Target = "_blank";
        //else Target = "_self";
        /*
        DataTable sdt = Todo.CreateDataTableBy( "LinkUrl, ThumbPath, Target, IssueTime, GoodsTitle" );
        if( sdt == null ) return;
        foreach( DataRow dr in dt.Rows ) {
            DataRow ndr = sdt.NewRow();
            ndr["GoodsTitle"] = Todo.Get( "GoodsTitle", dr );
            string pid = Todo.Get( "Id", dr );
            if( GoodsPagePath != "" && pid != "" )
                ndr["LinkUrl"] = GoodsPagePath + pid;
            else
                ndr["LinkUrl"] = "";
            //ndr["LinkUrl"] = Todo.Get( "LinkUrl", dr );
            ndr["ThumbPath"] = pAcs.ToRelUrl( Todo.Get( "ThumbPath", dr ) );
            ndr["IssueTime"] = Todo.TimeFormat( Todo.Get( "IssueTime", dr ), TimeFormat );
            ndr["Target"] = Target;
            sdt.Rows.Add( ndr );
        }*/


        //int cnt = rptGoodsList.Items.Count - 1;
        //for( int i = 0; i < cnt; i++ ) {
        //    if( i % 4 != 3 ) {
        //        rptGoodsList.Items[i].Controls[1].Visible = false;
        //    }
        //}
/*
                <!--<field name="LinkUrl" title="链接页URL" type="textLine" />-->
*/
//if( SiteTodo.ReadSetting( this, nvCol ) ) {
//    if( !IsPostBack ) {
//        GetData();
//    }
//    PartShow();
//}

//string strShowNum = Todo.Get( "ShowNumber", nvCol );
//if( strShowNum != "" )
//    PageSize = Convert.ToInt32( strShowNum );
//else {
//    PageSize = 8;
//    nvCol["ShowNumber"] = PageSize;
//}
//int i = sdt.Rows.Count - 1; i <= 0; i-- ) {
//if( i < start || i > end ) {
//    sdt.Rows[i].Delete();
//} else {
//}
/*
HtmlAnchor lnkDraftImg, lnkDraftText;
HtmlImage imgDraft; Label lbIssueTime;
for( int i = start, j = 0; i < end; i++, j++ ) {    //;   int i = 0; i < dt.Rows.Count; i++ ) {
    RepeaterItem item = rptGoodsList.Items[j];
    DataRow dr = Dt.Rows[i];

    //string GoodsTitle = Todo.Get( "GoodsTitle", dr );
    string LinkUrl = Todo.Get( "LinkUrl", dr );
    string ThumbPath = Todo.Get( "ThumbPath", dr );
    string IssueTime = Todo.Get( "IssueTime", dr );
    //LinkUrl = PartAccess.ConvertPathToFullUrl( LinkUrl, this );
    ThumbPath = PartAccess.ConvertPathToFullUrl( ThumbPath, this );

    try {
        lnkDraftImg = (HtmlAnchor)item.FindControl( "lnkDraftImg" );
        lnkDraftImg.HRef = LinkUrl;
        //lnkDraftImg.Title = GoodsTitle;
        lnkDraftImg.Target = Target;
    } catch( Exception ex ) { Todo.DebugOut( "Part_CorpGoodsView 操作 lnkDraftImg 控件出现异常：" + ex.Message ); }
    try {
        lnkDraftText = (HtmlAnchor)item.FindControl( "lnkDraftText" );
        lnkDraftText.HRef = LinkUrl;
        //lnkDraftText.InnerText = GoodsTitle;
        lnkDraftText.Target = Target;
    } catch( Exception ex ) { Todo.DebugOut( "Part_CorpGoodsView 操作 lnkDraftText 控件出现异常：" + ex.Message ); }
    try {
        imgDraft = (HtmlImage)item.FindControl( "imgDraft" );
        imgDraft.Src = ThumbPath;
        imgDraft.Alt = GoodsTitle;
    } catch( Exception ex ) { Todo.DebugOut( "Part_CorpGoodsView 操作 imgDraft 控件出现异常：" + ex.Message ); }
    try {
        lbIssueTime = (Label)item.FindControl( "lbIssueTime" );
        lbIssueTime.Text = Todo.TimeFormat( IssueTime, TimeFormat );
    } catch( Exception ex ) { Todo.DebugOut( "Part_CorpGoodsView 操作 lbIssueTime 控件出现异常：" + ex.Message ); }

    if( (i % 4 != 3) && (i != Dt.Rows.Count - 1) ) {
        item.Controls[7].Visible = false;
    }
}*/


        //PageIndex = 1;

        //ContentAccess ca = new ContentAccess( this, "TableName" );
        //Dt = ca.Read( "[*]", "name" );
        //if( Dt != null && Dt.Rows.Count != 0 ) {

            //PageSize = Todo.GetInt( "ShowNumber", nvCol, 8 );
            //TotalCount = Dt.Rows.Count;
            //PageCount = Convert.ToInt32( Math.Floor( Convert.ToDouble( TotalCount / PageSize ) ) + 1 );
            //rptGoodsList.DataSource = Dt;
            //rptGoodsList.DataBind();

        //    }

        //}

        //CtrlShow();
        /*
        HtmlGenericControl ul;
        if( Dt != null && Dt.Rows.Count != 0 ) {
            //int PageIndex = Convert.ToInt32( nvCol["PageIndex"] );
            //int PageCount = Convert.ToInt32( nvCol["PageCount"] );
            //int TotalCount = Convert.ToInt32( nvCol["TotalCount"] );
            //if( nvCol["ShowNumber"] != null )
            //    PageSize = Convert.ToInt32( nvCol["ShowNumber"] );

            aPageCount.InnerText = PageCount.ToString();
            aPageSize.InnerText = PageSize.ToString();
            aTotalCount.InnerText = TotalCount.ToString();
            aPageIndex.InnerText = PageIndex.ToString();

            int end;  //循环的最大索引
            if( (PageIndex * PageSize) > TotalCount )//最后一页了
            {
                //用前一页的总数加上pagesize－多出来的就是需要的最大索引了
                end = (PageIndex - 1) * PageSize + (PageSize - (PageIndex * PageSize - TotalCount));

            } else {
                end = PageIndex * PageSize;
            }

            //拿到索引后到ＤＡＴＡＴＡＢＬＥ中去取
            for( int i = PageIndex * PageSize - PageSize; i < end; i++ ) {
                string ThumbPath = "", TitleContext = "", LinkHref = "", issuanceTime = "";

                if( Dt.Rows[i]["ThumbPath"] != null ) {
                    ThumbPath = Dt.Rows[i]["ThumbPath"].ToString();
                }
                if( Dt.Rows[i]["TitleContext"] != null ) {
                    TitleContext = Dt.Rows[i]["TitleContext"].ToString();
                }
                if( Dt.Rows[i]["LinkHref"] != null ) {
                    LinkHref = Dt.Rows[i]["LinkHref"].ToString();
                }
                if( Dt.Rows[i]["issuanceTime"] != null ) {
                    //string DateFormat = Todo.Get( "DateFormat", nvCol );
                    issuanceTime = Dt.Rows[i]["issuanceTime"].ToString();
                    //issuanceTime = issuanceTime.ToString();
                    //DateTime s = new DateTime();
                    //s.ToString(
                }
                ThumbPath = PartAccess.ConvertPathToFullUrl( ThumbPath, this );//~!@
                //string sUrl = SiteTodo.GetUrlRootPath(Request.Url.AbsoluteUri);
                //ThumbPath = sUrl + ThumbPath;
                //ul = new HtmlGenericControl( "ul" );
                //string sTarget = "target=\"_self\"";
                //string sIsSelf = Todo.Get( "IsNewOpen", nvCol );
                //if( sIsSelf.ToLower() != "true" )
                //    sTarget = "target=\"_blank\"";


                //string li_ImgLink = "<li><a class=\"" + li_ImgLink_class + "\" href=\"" + LinkHref + "\" title=\"" + TitleContext + "\" style=\"" + li_ImgLink_s + "\" " + sTarget + "><img src=\"" + ThumbPath + "\" style=\"" + li_ImgLink_Img_s + "\" class=\"" + li_ImgLink_Img_class + "\" /></li>";
                //string li_LetterLink = "<li><a class=\"" + li_LetterLink_class + "\" style=\"" + li_LetterLink_s + "\" href=\"" + LinkHref + "\" " + sTarget + ">" + TitleContext + "</a></li>";
                //string li_Time = "<li>发布时间：" + issuanceTime + "</li>";
                //string li_Last = "<li></li>";

                //ul.InnerHtml = li_ImgLink + li_LetterLink + li_Time + li_Last;
                //ul.Attributes.Add( "class", ul_All_class );
                //ul.Attributes.Add( "style", ul_All_s );
                //demo1s.Controls.Add( ul );
            }
        }
        /*************/




        
        /*
        if( !IsPostBack ) {
            try {
                if( ReadSetting() ) {
                    PageIndex = 1;
                    ContentAccess ca = new ContentAccess( this, "TableName" );
                    DataTable Dt = ca.Read( "[*]", "name" );
                    if( Dt != null ) {
                        string strShowNum = Todo.Get( "ShowNumber", nvCol );
                        if( strShowNum != "" )
                            PageSize = Convert.ToInt32( strShowNum );
                        else {
                            PageSize = 8;
                            nvCol["ShowNumber"] = PageSize;
                        }
                        TotalCount = Dt.Rows.Count;
                        PageCount = Convert.ToInt32( Math.Floor( Convert.ToDouble( TotalCount / PageSize ) ) + 1 );

                        //要用计算的都放到nvCol中

                        nvCol["dataTable"] = Dt;
                        nvCol["PageIndex"] = PageIndex;
                        nvCol["TotalCount"] = TotalCount;
                        nvCol["PageCount"] = PageCount;
                    }
                    CtrlShow();
                }
            } catch( Exception ex ) {
                Todo.DebugOut( "产品列表：初始化错误！" );
                return;
            }
        }*/
    /*
    // 读setting 创建nvCol
    protected bool ReadSetting()
    {
        PartAccess pa = new PartAccess( this );
        if( !pa.IsReady ) return false;
        pa.FillSettingTo( nvCol );
        try {
            nvCol["li_ImgLink"] = pa.GetCssClass( "li_ImgLink" );
            nvCol["li_LetterLink"] = pa.GetCssClass( "li_LetterLink" );
            nvCol["li_ImgLink_Img"] = pa.GetCssClass( "li_ImgLink_Img" );
            nvCol["ul_All"] = pa.GetCssClass( "ul_All" );

            nvCol["li_ImgLink_s"] = pa.GetStyle( "li_ImgLink" );
            nvCol["li_LetterLink_s"] = pa.GetStyle( "li_LetterLink" );
            nvCol["li_ImgLink_Img_s"] = pa.GetStyle( "li_ImgLink_Img" );
            nvCol["ul_All_s"] = pa.GetStyle( "ul_All" );

        } catch {
            return false;
        }
        return true;
    }

    //获取数据，绑定数据
    private void CtrlShow()
    {


        //获取列表样式的值
        string li_ImgLink_class = "", li_LetterLink_class = "", li_ImgLink_Img_class = "", ul_All_class = "";
        string li_ImgLink_s = "", li_LetterLink_s = "", li_ImgLink_Img_s = "", ul_All_s = "";

        //CSS
        // if (nvCol["li_ImgLink"] != null)
        li_ImgLink_class = Todo.Get( "li_ImgLink", nvCol ); //nvCol["li_ImgLink"].ToString();
        // if (nvCol["li_LetterLink"] != null)
        li_LetterLink_class = Todo.Get( "li_LetterLink", nvCol );// nvCol["li_LetterLink"].ToString();
        // if (nvCol["li_ImgLink_Img"] != null)
        li_ImgLink_Img_class = Todo.Get( "li_ImgLink_Img", nvCol );// nvCol["li_ImgLink_Img"].ToString();
        // if (nvCol["ul_All"] != null)
        ul_All_class = Todo.Get( "ul_All", nvCol ); //nvCol["ul_All"].ToString();

        // 样式
        // if (nvCol["li_ImgLink_s"] != null)
        li_ImgLink_s = Todo.Get( "li_ImgLink_s", nvCol );// nvCol["li_ImgLink_s"].ToString();
        // if (nvCol["li_LetterLink_s"] != null)
        li_LetterLink_s = Todo.Get( "li_LetterLink_s", nvCol ); //nvCol["li_LetterLink_s"].ToString();
        //if (nvCol["li_ImgLink_Img_s"] != null)
        li_ImgLink_Img_s = Todo.Get( "li_ImgLink_Img_s", nvCol ); //nvCol["li_ImgLink_Img_s"].ToString();
        //if (nvCol["ul_All_s"] != null)
        ul_All_s = Todo.Get( "ul_All_s", nvCol ); //nvCol["ul_All_s"].ToString();

        //从nvCol中获取DataTable
        DataTable Dt = new DataTable();
        if( nvCol["dataTable"] != null ) {
            Dt = ((DataTable)nvCol["dataTable"]);
        }


        HtmlGenericControl ul;
        if( Dt != null && Dt.Rows.Count != 0 ) {
            int PageIndex = Convert.ToInt32( nvCol["PageIndex"] );
            int PageCount = Convert.ToInt32( nvCol["PageCount"] );
            int TotalCount = Convert.ToInt32( nvCol["TotalCount"] );

            int end;//循环的最大索引
            if( nvCol["ShowNumber"] != null )
                PageSize = Convert.ToInt32( nvCol["ShowNumber"] );
            aPageCount.InnerText = PageCount.ToString();
            aPageSize.InnerText = PageSize.ToString();
            aTotalCount.InnerText = TotalCount.ToString();
            aPageIndex.InnerText = PageIndex.ToString();

            if( PageIndex * PageSize - TotalCount > 0 )//最后一页了
            {
                //用前一页的总数加上pagesize－多出来的就是需要的最大索引了
                end = (PageIndex - 1) * PageSize + (PageSize - (PageIndex * PageSize - TotalCount));

            } else {
                end = PageIndex * PageSize;
            }

            //拿到索引后到ＤＡＴＡＴＡＢＬＥ中去取
            for( int i = PageIndex * PageSize - PageSize; i < end; i++ ) {
                string ThumbPath = "", TitleContext = "", LinkHref = "", issuanceTime = "";

                if( Dt.Rows[i]["ThumbPath"] != null ) {
                    ThumbPath = Dt.Rows[i]["ThumbPath"].ToString();
                }
                if( Dt.Rows[i]["TitleContext"] != null ) {
                    TitleContext = Dt.Rows[i]["TitleContext"].ToString();
                }
                if( Dt.Rows[i]["LinkHref"] != null ) {
                    LinkHref = Dt.Rows[i]["LinkHref"].ToString();
                }
                if( Dt.Rows[i]["issuanceTime"] != null ) {
                    //string DateFormat = Todo.Get( "DateFormat", nvCol );
                    issuanceTime = Dt.Rows[i]["issuanceTime"].ToString();
                    //issuanceTime = issuanceTime.ToString();
                    //DateTime s = new DateTime();
                    //s.ToString(
                }
                ThumbPath = PartAccess.ConvertPathToFullUrl( ThumbPath, this );//~!@
                //string sUrl = SiteTodo.GetUrlRootPath(Request.Url.AbsoluteUri);
                //ThumbPath = sUrl + ThumbPath;
                ul = new HtmlGenericControl( "ul" );
                string sTarget = "target=\"_self\"";
                string sIsSelf = Todo.Get( "IsNewOpen", nvCol );
                if( sIsSelf.ToLower() != "true" )
                    sTarget = "target=\"_blank\"";


                string li_ImgLink = "<li><a class=\"" + li_ImgLink_class + "\" href=\"" + LinkHref + "\" title=\"" + TitleContext + "\" style=\"" + li_ImgLink_s + "\" " + sTarget + "><img src=\"" + ThumbPath + "\" style=\"" + li_ImgLink_Img_s + "\" class=\"" + li_ImgLink_Img_class + "\" /></li>";
                string li_LetterLink = "<li><a class=\"" + li_LetterLink_class + "\" style=\"" + li_LetterLink_s + "\" href=\"" + LinkHref + "\" " + sTarget + ">" + TitleContext + "</a></li>";
                string li_Time = "<li>发布时间：" + issuanceTime + "</li>";
                string li_Last = "<li></li>";

                ul.InnerHtml = li_ImgLink + li_LetterLink + li_Time + li_Last;
                ul.Attributes.Add( "class", ul_All_class );
                ul.Attributes.Add( "style", ul_All_s );
                demo1s.Controls.Add( ul );
            }
        }
    }

    //控制按钮
    protected void ControlBut()
    {
        string strPageIndex = Todo.Get( "PageIndex", nvCol );
        string strPageCount = Todo.Get( "PageCount", nvCol );
        if( Convert.ToInt32( strPageIndex ) == 1 ) {
            lkUpPage.Enabled = false;
            lkDownPage.Enabled = true;
        } else if( Convert.ToInt32( strPageIndex ) == Convert.ToInt32( strPageCount ) ) {
            lkDownPage.Enabled = false;
            lkUpPage.Enabled = true;
        } else {
            lkDownPage.Enabled = true;
            lkUpPage.Enabled = true;
        }
    }

    //上一页
    protected void lkUpPage_Click( object sender, EventArgs e )
    {
        nvCol["PageIndex"] = Convert.ToInt32( nvCol["PageIndex"] ) - 1;
        CtrlShow();
        ControlBut();
    }

    //下一页
    protected void lkDownPage_Click( object sender, EventArgs e )
    {
        nvCol["PageIndex"] = Convert.ToInt32( nvCol["PageIndex"] ) + 1;
        CtrlShow();
        ControlBut();
    }

    //指定翻页
    protected void btnGo_ServerClick( object sender, EventArgs e )
    {
        nvCol["PageIndex"] = Convert.ToInt32( txtPageNum.Value );
        CtrlShow();
        ControlBut();
    }*/

/*
icon="1" hasAjax="false" hidden="false" Group="企业展示"
*/



/*
<%--<div id="all_offer_column" class="module2  mt7 ">      
    <div class="prolist" style="word-break:break-all;">
        <ul>
            <li class="mt20 cent">
                <a class="draft_no_link" href="" title="供应坡顶活动房" target="_blank">
                    img src="" class="border" />
                </a>
            </li>
            <li class="cent">
                <a class="draft_no_link" href="" target="_blank">供应坡顶活动房</a>
            </li>
            <li>发布时间：2007年12月17日 18:09</li>
            <li class="cent"></li>
        </ul>
        <div class="clr"></div>
    </div>
    <div class="clr"></div>
        
    <div class="pro_new_page mt10">
	<ul>
	    <li>
	        <span class="mr17">上一页</span>
	        <span class="orange">1</span>
	        <span class="ml10 mr10">|</span>
	        <a class="draft_no_link" href="">2</a>
	        <span class="mr17">
	            <a class="draft_no_link page_link ml17"  href="">下一页</a>
	        </span>
            </li>
        
	    <li>
	        <span>
	            共25条信息，当前显示第1-20条，共2页&nbsp;&nbsp;&nbsp;&nbsp;到第<input name="pageNum" id="pageNum" type="text" size="4" class="ml5 mr5" onkeypress="javascript:inputPageNum()"/>页&nbsp;
	            <input type="button" name="button_page" value="确认" class="ml5" onclick="javascript:gotoPage()"/>
	        </span>
	    </li>
	</ul>
    </div>    
</div>--%>*/
