﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using BoyunBase;
using SiteCore;

public partial class Part_CorpTopMenu : System.Web.UI.UserControl
{
    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            PartAccess pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            int maxLinkCount = pAcs.GetSettingInt( "maxLinkCount", 5 );
            string query;
            if( maxLinkCount < 1 )
                query = "[*]";
            else
                query = "[@top " + maxLinkCount + "]";

            ContentAccess ca = new ContentAccess( this, "TableName" );
            DataTable dt = ca.Read( query, "name" );
            if( dt == null || dt.Rows.Count < 1 ) {
                Todo.DebugOut( "Part_CorpTopMenu 没有读取到数据" );
                return;
            }

            // 处理 读取出来的内容
            bool isOpenNew = pAcs.GetSettingBool( "isOpenNew" );
            string target = "";
            if( isOpenNew ) target = "_blank";
            else target = "_self";

            Todo.AddDataCol( "target", dt );
            foreach( DataRow dr in dt.Rows ) {
                //string linkUrl = Todo.Get( "linkUrl", dr );
                //dr["linkUrl"] = Todo.Get( "linkUrl", dr ); //pAcs.ToRelUrl( linkUrl );
                dr["target"] = target;
            }

            rptList.DataSource = dt;
            rptList.DataBind();

        } catch( Exception ex ) {
            Todo.DebugOut( "加载 Part_CorpTopMenu 出现异常：" + ex.Message );
        }
    }
}
