using System;
using System.Text;
using System.Web;
using System.Web.UI;
using BoyunBase;
using SiteCore;

public partial class Part_FlashView : System.Web.UI.UserControl
{
    protected void Page_Load( object sender, EventArgs e )
    {
        try {
            if( IsPostBack ) return;

            PartAccess pAcs = new PartAccess( this );
            if( !pAcs.IsReady ) return;

            string flashPath = pAcs.GetSetting( "flashPath" );
            if( flashPath == "" ) {
                ltrFlashView.Text = "<div style=\"width:16px;\"></div>";
                return;
            }

            int width = pAcs.GetSettingInt( "width", -1 );
            int height = pAcs.GetSettingInt( "height", -1 );
            if( width < 20 ) width = 20;
            if( height < 20 ) height = 20;

            StringBuilder sb = new StringBuilder( 512 );
            sb.Append( "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" class=\"FlashShow\" ");
            sb.Append( "width=\"" + width.ToString() + "px\" height=\"" + height.ToString() + "px\" >\n" );
            sb.Append( "<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n" );
            sb.Append( "<param name=\"wmode\" value=\"transparent\" />\n" );
            sb.Append( "<param name=\"menu\" value=\"false\" />\n" );
            sb.Append( "<param name=\"quality\" value=\"high\" />\n" );
            sb.Append( "<param name=\"movie\" value=\"" + flashPath + "\">\n" );
            sb.Append( "</object>\n" );
            ltrFlashView.Text = sb.ToString();

        } catch( Exception ex ) {
            Todo.DebugOut( " Part_FlashView 쳣" + ex.Message );
        }
    }
}
