﻿using System;
using System.Collections.Generic;
using System.Text;

using YL.Common;
using System.Data;
using System.Data.SqlClient;

namespace YL.BLL
{
    /// <summary>
    /// 登录用户表
    /// </summary>
    public class TStaff
    {
        /// <summary>
        /// 用户登录
        /// </summary>
        /// <param name="sName"></param>
        /// <param name="sPwd"></param>
        /// <returns></returns>
        public static bool ValidateStaff(string sName, string sPwd)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [sName] from TStaff where [sName]=@sName and [sPwd]=@sPwd");
            SqlParameter[] param = 
            {
                SQLHelper.GetParameter("@sName",SqlDbType.NVarChar,50,"[sName]",sName),
                SQLHelper.GetParameter("@sPwd",SqlDbType.NVarChar,50,"[sPwd]",sPwd)
            };
            DataTable table = SQLHelper.ExecuteDt(sb.ToString(), param);
            if (table.Rows.Count > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static int AddStaff(string sName, string sPwd)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into TStaff (sName,sPwd) values(@sName,@sPwd)");
            SqlParameter[] param = 
            {
                SQLHelper.GetParameter("@sName",SqlDbType.NVarChar,50,"[sName]",sName),
                SQLHelper.GetParameter("@sPwd",SqlDbType.NVarChar,50,"[sPwd]",sPwd)
            };
            return SQLHelper.ExecuteSql(sb.ToString(), param);
        }
    }
}
