﻿using System;
using System.Collections.Generic;
using System.Text;

using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.Security;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace YL.Common
{
    public class Tools
    {
        #region 输出word,excel

        /// <summary>
        /// 用法：
        /// Tools.Export(GridView1, "application/ms-word", "123.doc");
        /// Tools.Export(GridView1, "application/vnd.ms-excel", "data.xls");
        /// </summary>
        /// <param name="gridView">GridView</param>
        /// <param name="FileType">类型</param>
        /// <param name="FileName">文件名</param>
        public static void Export(GridView gridView, string FileType, string FileName)
        {
            StringBuilder sb = new StringBuilder();
            StringWriter sw = new StringWriter(sb);
            HtmlTextWriter htw = new HtmlTextWriter(sw);

            Page page = new Page();
            HtmlForm form = new HtmlForm();

            gridView.EnableViewState = false;
            page.EnableEventValidation = false;
            page.DesignerInitialize();

            page.Controls.Add(form);
            form.Controls.Add(gridView);
            page.RenderControl(htw);

            HttpContext.Current.Response.Clear();
            HttpContext.Current.Response.Buffer = true;
            HttpContext.Current.Response.ContentType = FileType;
            HttpContext.Current.Response.AddHeader("Content-Disposition", "attachment;filename=" + FileName);
            HttpContext.Current.Response.Charset = "UTF-8";
            HttpContext.Current.Response.ContentEncoding = Encoding.Default;
            HttpContext.Current.Response.Write(sb.ToString());
            HttpContext.Current.Response.End();
        }

        #endregion

        #region 常用js输出
        /*参考:blog.csdn.net/zhoufoxcn/archive/2008/04/21/2312440.aspx
         */

        /// <summary>
        /// 输出简单提示
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="page"></param>
        public static void Alert(string msg, Page page)
        {
            string js = @"<Script language='JavaScript'>alert('" + msg + "');</Script>";
            if (!page.ClientScript.IsStartupScriptRegistered(page.GetType(), "alert"))
            {
                page.ClientScript.RegisterStartupScript(page.GetType(), "alert", js);
            }
            //page.ClientScript.RegisterStartupScript(page.GetType(), "alert", "alert('" + str + "!');", true);
        }

        #endregion
    }
}
