﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class edit_admin : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["uName"] == null)
            Response.Redirect("login.aspx");
        if (!IsPostBack)
            Bind();
    }
    private void Bind()
    {
        DataTable dt = YL.BLL.AKind.GetAll();
        foreach (DataRow row in dt.Rows)
        {
            ddlType.Items.Add(new ListItem(row["typeName"].ToString(), row["tId"].ToString()));
        }
        if (Request.QueryString["aid"] != null)
        {
            DataTable dtArticle = YL.BLL.AArticle.GetById(Request.QueryString["aid"].ToString());
            txtTitle.Text = dtArticle.Rows[0]["title"].ToString();
            txtSummary.Text = dtArticle.Rows[0]["summary"].ToString();
            this.txtTime.Text = dtArticle.Rows[0]["aTime"].ToString();
            this.txtContent.Text = dtArticle.Rows[0]["content"].ToString();
        }
        else
            txtTime.Text = DateTime.Now.ToString();
    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["aid"] != null)
        {
            //编辑
            YL.BLL.AArticle.Update(txtTitle.Text, txtSummary.Text, txtContent.Text, ddlType.SelectedValue, Request.QueryString["aid"].ToString());
        }
        else
        {
            //新增
            YL.BLL.AArticle.Add(txtTitle.Text, txtSummary.Text, txtContent.Text, ddlType.SelectedValue);
        }
        Response.Redirect("admin.aspx");
    }
}
