// JavaScript Document
	
	function JFramework(){
		
		var strVersion="20061006";
		var loadedScripts={};
		
		this.getVersion=function(){
			return strVersion;
		}
		
		this._createScriptId=function(strId){
			var strName="SCRIPT_",result="";
			if(strId.substring(0,strName.length)==strName)
				result=strId;
			else
				result=strName+strId;
			return result.toUpperCase();
		}
		
		this.execScript=function(strScripts,strId,strLanguage){
			var strTemp=this._createScriptId(strId);
			if(strTemp in loadedScripts){ return ;}
			if(JBrowser.agent==JBrowser.InternetExplorer){
				strScripts=this._leachExegesis(strScripts);
				window.execScript(strScripts,strLanguage);
				loadedScripts[strTemp]=false;
			}else{
				this.addScriptElement(strScripts,strId,strLanguage);
			}
		}
		
		this.addScriptElement=function(strScripts,strId,strLanguage){
			try{
				var strTemp=this._createScriptId(strId);
				if((strTemp in loadedScripts)&&$(strTemp)){ return ;}
				var objElement={};
				objElement.script=$c("SCRIPT");
				objElement.script.type="text/"+strLanguage;
				objElement.script.language=strLanguage;
				objElement.script.text=strScripts;
				objElement.script.id=strTemp;
				window.document.getElementByName("HEAD").appendChild(objElement.script);
				objElement=null;
				loadedScripts[strTemp]=true;
			}catch(Exception){}
		}
		
		this.removeScriptElement=function(strId){
			var strTemp=this._createScriptId(strId);
			if(!(strTemp in loadedScripts)||(!$(strTemp))){ return ;}
			var objElement=$(strTemp);
			if(objElement.nodeName!="SCRIPT") return ;
			window.document.getElementByName("HEAD").removeChild(objElement);
			objElement=null;
			delete loadedScripts[strTemp];
		}
		
		this._leachExegesis=function(strScripts){
			var objReg=/\<\!\-\-/ig;
			strScripts=strScripts.replace(objReg,"");
			objReg=/\-\-\>/ig;
			strScripts=strScripts.replace(objReg,"");
			return strScripts;
		}
		
		this._getScriptFileName=function(strUrl){
			var result=null;
			var intStartPos=strUrl.lastIndexOf("/");
			var intEndPos=strUrl.lastIndexOf(".");
			if(intStartPos==-1){
				intStartPos=0;
			}else{
				intStartPos++;
			}
			if(intEndPos>-1){
				result=strUrl.substring(intStartPos,intEndPos);	
			}
			return result;
		}
		
		this.loadScript=function(strUrl,strLanguage){
			var objAjax=new JAjax();
			var strName=this._getScriptFileName(strUrl);
			if(strName==null) return ;
			var strCodes=objAjax.getText("get",strUrl,null,null);
			if(strCodes!=null){
				this.execScript(strCodes,strName,strLanguage);	
			}
			objAjax=null;
		}
		
		this.loadScriptElement=function(strUrl,strLanguage){
			var objAjax=new JAjax();
			var strName=this._getScriptFileName(strUrl);
			if(strName==null) return ;
			var strCodes=objAjax.getText("get",strUrl,null,null);
			if(strCodes!=null){
				this.addScriptElement(strCodes,strName,strLanguage);	
			}
			objAjax=null;
		}
		
		this.isScriptElement=function(strId){
			strId=this._createScriptId(strId);
			return 	(strId in loadedScripts)&&(loadedScripts[strId])
		}
		
		this.createObject=function(){
			
			function JObject()	{
				this.className="JObject";
				this.base=null;
				
				this.extend=function(instance){
					var objTemp={};
					var strName=null;
					for(strName in this){
						objTemp[strName]=this[strName];	
					}
					for(strName in instance){
						this[strName]=instance[strName];	
					}
					for(strName in objTemp){
						this[strName]=objTemp[strName];	
					}
					objTemp=null;
				}
				
				this.clone=function(){
					var cloneObj=new JObject();
					cloneObj.extend(this);
					return cloneObj;
				}
				
				this.equals=function(equalsObj){
					var result=true;
					for(var method in equalsObj){
						if(this[method]!=equalsObj[method]){
							result=false;
							break;
						}
					}
					return result;
				}				
				this.initialize.apply(this,arguments);
			}
			return JObject;
		}
	}
	
	var System=new JFramework();
	
	function isAlien(a){
		return isObject(a) && typeof a.constructor != "function";
	}
	
	function isArray(a){
		return isObject(a) && a.constructor == Array;
	}
	
	function isBoolean(a){
		return typeof a =="boolean";
	}
	
	function isEmpty(obj){
		var i, v;
		if (isObject(obj)){
			for (i in obj){
				v = obj[i];
				if (isUndefined(v) && isFunction(v)){
					return false;
				}
			}
		}
		return true;
	}
	
	function isFunction(a){
		return typeof a == "function";
	}
	
	function isNull(a){
		return typeof a == "object" && !a;
	}
	
	function isNumber(a){
		return typeof a == "number";
	}	
		
	function isObject(a){
		return (a && typeof a == "object") || isFunction(a);
	}
	
	function isString(a){
		return typeof a == "string";
	}	
		
	function isUndefined(a){
		return typeof a == "undefined";
	} 
	
// * 字符串 类	
	String.prototype.className="String";

	String.prototype.trim=function(){
		return this.replace(/^\s+|\s+$/g, "");
	}

	String.prototype.lTrim=function(){
		return this.replace(/^\s+/, "");
	}

	String.prototype.rTrim=function(){
		return this.replace(/\s+$/, "");
	}

	String.prototype.escapeHTML=function() {
		var str = this;
        str=str.replace(/\&amp\;/ig,"&");
        str=str.replace(/\&lt\;/ig,"<");
        str=str.replace(/\&gt\;/ig,">");
        str=str.replace(/\&apos\;/ig,"'");
        str=str.replace(/\&quot\;/ig,"\"");
		return str;
	}

	String.prototype.unescapeHTML=function() {
		var str = this;
        str=str.replace(/\&/ig,"&amp;");
        str=str.replace(/\</ig,"&lt;");
        str=str.replace(/\>/ig,"&gt;");
        str=str.replace(/\'/ig,"&apos;");
        str=str.replace(/\"/ig,"&quot;");
		return str;
    }
	
	String.prototype.toArray=function(){
		return this.split("");	
	}

	String.prototype.endsWith = function(suffix) {
		return (this.substr(this.length - suffix.length) == suffix);
	}
	
	String.prototype.startsWith = function(prefix) {
		return (this.substr(0, prefix.length) == prefix);
	}
	
// * 字符串类静态方法
	String.format=function(format, args){
		var result = "";
		for (var i=0;;) {
			var open = format.indexOf("{", i);
			var close = format.indexOf("}", i);
			if ((open < 0) && (close < 0)) {
				result += format.slice(i);
				break;
			}
			if ((close > 0) && ((close < open) || (open < 0))) {
					if (format.charAt(close + 1) != "}") {
					throw new Error(" 缺少 \"}\"");
				}
				result += format.slice(i, close + 1);
				i = close + 2;
				continue;
			}
	
			result += format.slice(i, open);
			i = open + 1;
			if (format.charAt(i) == "{") {
				result += "{";
				i++;
				continue;
			}
			if (close < 0) throw new Error(" 缺少 \"{\"");
			var brace = format.slice(i, close).split(":");
	
			var argNumber = parseInt(brace[0]) + 1;
			if ((brace.length > 2) || isNaN(argNumber)) throw new Error("stringFormatInvalid");
			var arg = arguments[argNumber];
			if (typeof(arg) == "undefined" || arg == null) {
				arg = "";
			}
			result += arg.toString();	
			i = close + 1;
		}
		return result;
	}

	String.prototype.isEmpty=function(){
		return this.trim().length>0?false:true;
	}
	
// * Array 类
	Array.prototype.className="Array";
	
	Array.prototype.add = Array.prototype.queue = function(item) {
			this[this.length] = item;
	}
	
	Array.prototype.addRange = function(items) {
			this.push.apply(this, items);
	}
	
	Array.prototype.clear = function() {
		this.length = 0;
	}
	
	Array.prototype.clone = function() {
		if (this.length == 1) {
			return [this[0]];
		}
		else {
			return Array.apply(null, this);
		}
	}
	
	Array.prototype.contains = Array.prototype.exists = function(item) {
		return (this.indexOf(item) >= 0);
	}
	
	Array.prototype.dequeue = Array.prototype.shift;
	
	if (!isFunction(Array.prototype.indexOf)) {
		Array.prototype.indexOf = function(item, start) {
			if (typeof(item) == "undefined") return -1;
			var length = this.length;
			if (length != 0) {
					start = start - 0;
					if (isNaN(start)) {
						start = 0;
					}
					else {
						if (isFinite(start)) {
							start = start - (start % 1);
						}
					
						if (start < 0) {
							start = Math.max(0, length + start);
						}
					}
	
					for (var i = start; i < length; i++) {
						if (this[i] == item) {
							return i;
						}
				}
			}
			return -1;
		}
	}
	
	Array.prototype.insert = function(index, item) {
		this.splice(index, 0, item);
	}
		
	Array.prototype.remove = function(item) {
		var index = this.indexOf(item);
		if (index >= 0) {
			this.splice(index, 1);
		}
		return (index >= 0);
	}
	
	Array.prototype.removeAt = function(index) {
		this.splice(index, 1);
	}
	
	if (!isFunction(Array.prototype.pop)) {
		Array.prototype.pop=function () {
			return this.splice(this.length - 1, 1)[0];
		}
	}
	
	if (!isFunction(Array.prototype.push)) {
		Array.prototype.push=function () {
			this.splice.apply(this,[this.length,0].concat(Array.prototype.slice.apply(arguments)));
			return this.length;
		}
	}
	
	if (!isFunction(Array.prototype.shift)) {
		Array.prototype.shift=function () {
			return this.splice(0,1)[0];
		}
	}
	
	if (!isFunction(Array.prototype.splice)) {
		Array.prototype.splice=function (s, d) {
			var max=Math.max,min=Math.min,a =[],e,i=max(arguments.length-2,0),k=0,l=this.length,n,v,x;  
			s = s || 0;
			if (s < 0) {s += l;	}
			s = max(min(s, l), 0);  
			d = max(min(isNumber(d) ? d : l, l - s), 0);    
			v = i - d;
			n = l + v;
			while (k < d) {
				e = this[s + k];
				if (!isUndefined(e)) {
					a[k] = e;
				}
				k += 1;
			}
			x = l - s - d;
			if (v < 0) {
				k = s + i;
				while (x) {
					this[k] = this[k - v];
					k += 1;
					x -= 1;
				}
				this.length = n;
			}else if (v > 0) {
				k = 1;
				while (x) {
					this[n - k] = this[l - k];
					k += 1;
					x -= 1;
				}
			}
			for (k = 0; k < i; ++k) {
				this[s + k] = arguments[k + 2];
			}
			return a;
		}
	}
	
	if (!isFunction(Array.prototype.unshift)) {
		Array.prototype.unshift=function () {
			this.splice.apply(this,[0,0].concat(Array.prototype.slice.apply(arguments)));
			return this.length;
		}
	}
// * Function 静态方法
	Array.parse = function(value) {
		if (!value) return [];
		var v = eval(value);
		return v;
	}

// * Function 类
	Function.prototype.className="Function";
	Function.emptyFunction = Function.emptyMethod = function(){}
	Function.createDelegate = function(instance, method) {
		return function() {
			return method.apply(instance, arguments);
		}
	}
	Function.createCallback = function(method, context) {
		return function() {
			var l = arguments.length;
			if (l > 0) {
				var args = [];
				for (var i = 0; i < l; i++) {
					args[i] = arguments[i];
				}
				args[l] = context;
				return method.apply(this, args);
			}
			return method.call(this, context);
		}
	}

	RegExp.prototype.className="RegExp";
// * 数字
	Number.prototype.className="Number";
	
	Number.parse = function(value) {
		return parseFloat(value);
	}

	Date.prototype.className = "Date";
	
	Date.parse=function(strDate,pSeparator){
		var arrStrDate,arrStr,result,strSeparator;
		strSeparator=(pSeparator==null?"-":pSeparator)
		arrStrDate= strDate.split(" ");
		arrStr = arrStrDate[0].split(strSeparator);
		var nYear	= parseInt(arrStr[0],10);
		var nMonth	= parseInt(arrStr[1],10) - 1;
		var nDay	= parseInt(arrStr[2],10);
		var nHour	= 0;
		var nMinute = 0;
		var nSecond = 0;
		if(arrStrDate[1]){
			arrStr = arrStrDate[1].split(":");
			nHour	= parseInt(arrStr[0],10);
			nMinute = parseInt(arrStr[1],10);
			nSecond = parseInt(arrStr[2],10);
		}
		result=new Date(nYear, nMonth, nDay, nHour, nMinute, nSecond);
		return result;
	}
	
	Date.format=function(pDate,strPattern){
		if(pDate.className=="String"){
			pDate=Date.parse(pDate);
		}else if(pDate.className!="Date"){
			return null;	
		}
		var strResult=strPattern.toLowerCase();
		var temp=pDate.getHours();
		if(temp<10) temp="0"+temp;
		strResult=strResult.replace("hh",temp);

		temp=pDate.getMinutes();
		if(temp<10) temp="0"+temp;
		strResult=strResult.replace("mm",temp);
		
		temp=pDate.getSeconds();
		if(temp<10) temp="0"+temp;
		strResult=strResult.replace("ss",temp);
		
		strResult=strResult.replace("y",pDate.getYear());
		
		temp=pDate.getMonth()+1;
		if(temp<10) temp="0"+temp;
		strResult=strResult.replace("m",temp);
		
		temp=pDate.getDate();
		if(temp<10) temp="0"+temp;
		strResult=strResult.replace("d",temp);

		return strResult;
	}
	
	Date.compare=function(leftDate,rightDate){
		if(leftDate.getTime()==rightDate.getTime())
			return 0;
		else if(leftDate.getTime()<rightDate.getTime())
			return -1;
		else 
			return 1;
	}
	
	Date.isValidDate=function(strDate,pSeparator){
		var strSeparator=(pSeparator==null?"-":pSeparator);
		var objTempDate=Date.parse(strDate,strSeparator);
		var strPattern="y"+strSeparator+"m"+strSeparator+"d";
		var strTempDate=Date.format(objTempDate,strPattern);
		var arrParam=strDate.split(strSeparator);
		if (arrParam.length<2){ return false}
		strDate=arrParam[0];
		if(arrParam[1].length<2) arrParam[1]="0"+arrParam[1];
		strDate=strDate+strSeparator+arrParam[1];
		if(arrParam[2].length<2) arrParam[2]="0"+arrParam[2];
		strDate=strDate+strSeparator+arrParam[2];
		return strDate==strTempDate;
	}
	
	Date.addYear=function(objDate,intYear){
		objDate.setYear(objDate.getYear()+intYear);
		return  objDate;
	}
	
	Date.addMonth=function(objDate,intMonth){
		objDate.setMonth(objDate.getMonth()+intMonth);
		return  objDate;
	}

	Date.addDate=function(objDate,intDate){
		objDate.setDate(objDate.getDate()+intDate);
		return  objDate;
	}
	
	Date.addHours=function(objDate,intHours){
		objDate.setHours(objDate.getHours()+intHours);
		return  objDate;
	}

	Date.addMinutes=function(objDate,intMinutes){
		objDate.setMinutes(objDate.getMinutes()+intMinutes);
		return  objDate;
	}
	
	Date.addSeconds=function(objDate,intSeconds){
		objDate.setSeconds(objDate.getSeconds()+intSeconds);
		return  objDate;
	}
		
	Date.prototype.toChineseString=function(){
		return Date.format(this,"y-m-d hh:mm:ss");
	}
	
	Date.prototype.dateString=function(){
		return Date.format(this,"y-m-d");
	}
	
	Date.prototype.timeString=function(){
		return Date.format(this,"hh:mm:ss");
	}
	
// * 布尔对象
	Boolean.prototype.className = "Boolean";
// * 布尔对象 (静态方法)
	Boolean.parse = function(value) {
		if(value.className=="Boolean")
			return value;
		
		var v = value.toLowerCase();
		if (v == "false") return false;
		if (v == "true") return true;
		return null;
	}
	
// * 对象
	Object.prototype.className="Object";

// * 异常类
	Error.prototype.className="Error";
	
	if(!window) this.window=this;
	
// * 浏览器类 (判断各种浏览器类型)
	var JBrowser = {};
	
	JBrowser.InternetExplorer = {};
	JBrowser.Firefox = {};
	JBrowser.Safari = {};
	JBrowser.Opera = {};
	
	JBrowser.agent = null;
	JBrowser.hasDebuggerStatement = false;
	JBrowser.name = navigator.appName;
	JBrowser.version = parseFloat(navigator.appVersion);
	
	if (navigator.userAgent.indexOf(" MSIE ") > -1) {
		JBrowser.agent = JBrowser.InternetExplorer;
		JBrowser.version = parseFloat(navigator.userAgent.match(/MSIE (\d+\.\d+)/)[1]);
		JBrowser.hasDebuggerStatement = true;
	}
	else if (navigator.userAgent.indexOf(" Firefox/") > -1) {
		JBrowser.agent = JBrowser.Firefox;
		JBrowser.version = parseFloat(navigator.userAgent.match(/ Firefox\/(\d+\.\d+)/)[1]);
		JBrowser.name = "Firefox";
		JBrowser.hasDebuggerStatement = true;
	}
	else if (navigator.userAgent.indexOf(" Safari/") > -1) {
		JBrowser.agent = JBrowser.Safari;
		JBrowser.version = parseFloat(navigator.userAgent.match(/ Safari\/(\d+\.\d+)/)[1]);
		JBrowser.name = "Safari";
	}
	else if (navigator.userAgent.indexOf("Opera/") > -1) {
		JBrowser.agent = JBrowser.Opera;
	}

// * 哈稀类 (模拟了Java中的Hashtable类)
	var JHashtable=System.createObject();

	JHashtable.prototype.initialize=function(args){
		this.container={};
		this.length=-1;
		this.className="JHashtable";
	}

	JHashtable.prototype.put=function(Key,Item){
		if(!this.exists(Key)){
			this.container[Key]=Item;
			this.length++;
		}
	}

	JHashtable.prototype.replace=function(Key,Item){
		if(this.exists(Key)){
			this.container[Key]=Item;
		}
	}

	JHashtable.prototype.get=function(Key){
		if(!this.exists(Key))
			throw new Error("JHashtable 类的成员方法 get 中发生错误：没有找到键名“"+Key+"”。");
		return this.container[Key];	
	}

	JHashtable.prototype.exists=function(Key){
		return Key in this.container;
	}

	JHashtable.prototype.remove=function(Key){
		if(!this.exists[Key]){
			delete this.container[Key];
			this.length--;	
		}
	}

	JHashtable.prototype.removeAll=function(){
		for(var vari in this.container){
			delete this.container[vari];
		}
		this.length=-1;
	}

	JHashtable.prototype.toArray=function(){
		if(this.length<0) return null;
		var result=new Array(this.length);
		var i=0;
		for(var method in this.container){
			if(method!="className"){
				result[i]=this.container[method];
				i++;	
			}
		}
		return result;
	}
		
// * 字符串类

	var JStringBuilder=System.createObject();
	
	JStringBuilder.prototype.initialize=function(initialText){
		this.className="JStringBuilder";
		this._parts = [];
		this.append(initialText)
	}

	JStringBuilder.prototype.append=function(text){
        if (typeof(text) !== "undefined" && text !== null) {
            this._parts.push(text);
        }	
	}
	
	JStringBuilder.prototype.appendLine=function(text){
        this.append(text);
        this.append("\r\n");
	}
	
	JStringBuilder.prototype.clear=function(){
        this._parts = [];
	}
	
	JStringBuilder.prototype.isEmpty=function(){
        return (this._parts.length == 0);
	}
	
	JStringBuilder.prototype.toString=function(separator){
        return this._parts.join(separator || "");
	}
	
// * 大小类
	var JSize=System.createObject();
	
	JSize.prototype.initialize=function(Width,Height){
		 this.className="JSize";
		 this.Width=(typeof(Width)=="undefined"?0:Width);
		 this.Height=(typeof(Height)=="undefined"?0:Height);
	}
	
	JSize.prototype.minus=function(instance){
		return new JSize(this.Width-instance.Width,this.Height-instance.Height);
	}
	
	JSize.prototype.plus=function(instance){
		return new JSize(this.Width+instance.Width,this.Height+instance.Height);
	}
	
// * 随机类
	var JRandomize=System.createObject();
	
	JRandomize.prototype.initialize=function(){	
		this.random = Math.random;
		this.className="JRandomize";
		this.alphabet = "abcdefghijklmnopqrstuvwxyz";
	}
	
	JRandomize.prototype.toNumber=function(num){
		return Math.floor( this.random()*( Math.pow( 10, num || 1 ) ) );
	}
	
	JRandomize.prototype.inNumberRange=function( lo, hi){
		return ( Math.floor( this.random()*(hi*2) )%( hi-lo+1 ) )+lo; 
	}
	
	JRandomize.prototype.toAlpha=function(){
		var i = this.inNumberRange( 0, this.alphabet.length-1);
		return this.alphabet.charAt(i);
	}
	
	JRandomize.prototype.inAlphaRange=function(lo, hi){
		var i = this.inNumberRange( this.alphabet.indexOf(lo), this.alphabet.indexOf(hi) );
		return this.alphabet.charAt(i);
	}
	
	JRandomize.prototype.toId=function(num){
		return this.toAlpha()+this.toNumber( num || 3 );
	}
	
	
	
// * 输出流类
	var JHttpResponse=System.createObject();
	
	JHttpResponse.prototype.initialize=function(){
		this.className="JHttpResponse";	
		this._strStream=null;
	}
	
	JHttpResponse.prototype.getStream=function(){
		return this._strStream;	
	}
	
	JHttpResponse.prototype.setStream=function(stream){
		this._strStream=stream;	
	}
	
	JHttpResponse.prototype.write=function(strName,strValue){
		if(this._strStream!=null)
			this._strStream+="&"+strName+"="+escape(strValue);
		else
			this._strStream=strName+"="+escape(strValue);
	}
	
// * JTextEncoder 类 (各种编码转换)
/*	var JTextEncoder=System.createObject();
	
	JTextEncoder.prototype.initialize=function(){
		this.className="JTextEncoder";
		this.encodeModel=0;
		this._VBSEncode();
	}
	
	JTextEncoder.prototype._VBSEncode=function(){
			
		var strScript="";
		strScript="Function VBSEncoder(vIn)\n"+
			"	Dim strResult,theCarCode,nextCharCode,i\n"+
			"	strResult = \"\"\n"+
			"	For i = 1 To LenB(vIn)\n"+
			"		theCarCode = AscB(MidB(vIn,i,1))\n"+
			"		If theCarCode < &H80 Then\n"+
			"			strResult = strResult & Chr(theCarCode)\n"+
			"		Else\n"+
			"			nextCharCode = AscB(MidB(vIn,i+1,1))\n"+
			"			strResult = strResult & Chr(CLng(theCarCode) * &H100 + CInt(nextCharCode))\n"+
			"			i = i + 1\n"+
			"		End If\n"+
			"	Next\n"+
			"	VBSEncoder = strResult\n"+
			"End Function\n";
		System.execScript(strScript,"VBSEncoder","VBScript");
	}
	
	JTextEncoder.prototype.encode=function(stream,strEncodeType){
		if(this.encodeModel==0){
			try{
				var objEncode=new ActiveXObject("Adodb.Stream");
				objEncode.Type=1;
				objEncode.Mode=3;
				objEncode.Open();
				objEncode.Write(stream);
				objEncode.Position=0;
				objEncode.Type=2;
				objEncode.Charset=strEncodeType;
				stream=objEncode.ReadText();
				objEncode.Close();
				objEncode=null;
					alert("")
				return stream;
				
			}catch(Exception){
				
				return VBSEncoder(stream);
			}
		}else{
			
			return VBSEncoder(stream);
		}
	}*/

// * JAjax 类 
	var JAjax=System.createObject();
	
	JAjax.prototype.initialize=function(){
		this.className="JAjax";
		this.charsetType="utf-8";
		this.UrlDecodeMethod=1;
		//this._objEncoder=new JTextEncoder();
		//this._objEncoder.encodeModel=0;
		this._objXmlHttp=null;
		this._onTimeOut=null;
		// 
		this.timeOut=30000;
		//	readyState=1
		this.onLoading=null;
		//	readyState=2
		this.onLoaded=null;
		//	readyState=3
		this.onInteractive=null;
		//	readyState=4
		this.onComplete=null;
		//	statusCode=200
		this.onSuccess=null;
		//	statusCode != 200
		this.onError=null;
		// timeOut
		this.onTimeOut=null;
	}
	
	JAjax.prototype.getRequest=function(strMethod,strUrl,objResponse,objRequestHeaders){
		var strTemp;
		strTemp=this.getText(strMethod,strUrl,objResponse,objRequestHeaders);
		if(strTemp==null) return null;
		//alert(strTemp);
		return new JHttpRequest(strTemp,this.UrlDecodeMethod);
	}
	
	JAjax.prototype.getXml=function(strMethod,strUrl,objResponse,objRequestHeaders){
		this._process(strMethod,strUrl,false,objResponse,objRequestHeaders);
		if(!this._objXmlHttp) return null;
		var strTemp=this._objXmlHttp.responseXML;
		this._objXmlHttp=null;
		return strTemp;
	}
	
	JAjax.prototype.getText=function(strMethod,strUrl,objResponse,objRequestHeaders){
		
		this._process(strMethod,strUrl,false,objResponse,objRequestHeaders);
		if(!this._objXmlHttp){ return null;}
		var strTemp;

		strTemp=this._objXmlHttp.responseText;
		this._objXmlHttp=null;
		if(strTemp==null) return null;
		if (strTemp.search("<!--end-->")==-1){return strTemp;}
		strTemp=strTemp.split("<!--end-->")
		return strTemp[0];
	}
	
	JAjax.prototype.getHtml=function(strMethod,strUrl,objResponse,objRequestHeaders){
		var strHtml=this.getText(strMethod,strUrl,objResponse,objRequestHeaders);
		if(strHtml==null) return null;
		var objReg=/<body.+?>([\s\S]+?)<\/body>/ig;
		var strTemp=strHtml.match(objReg);
		if(strTemp){
			strHtml=strTemp[0].replace(/<body.+?>/ig,"").replace(/<\/body>/ig,"");
		}
		objReg=null;
		return strHtml;
	}
	
	JAjax.prototype.getStream=function(strMethod,strUrl,objResponse,objRequestHeaders){
		this._process(strMethod,strUrl,false,objResponse,objRequestHeaders);
		if(!this._objXmlHttp) return null;
		var strTemp=this._objXmlHttp.responseStream;
		this._objXmlHttp=null;
		return strTemp;
	}
	
	JAjax.prototype.getBody=function(strMethod,strUrl,objResponse,objRequestHeaders){
		this._process(strMethod,strUrl,false,objResponse,objRequestHeaders);
		if(!this._objXmlHttp) return null;
		var strTemp=this._objXmlHttp.responseBody;
		this._objXmlHttp=null;
		return strTemp;
	}

	JAjax.prototype.createXMLHTTP=function(){
		var sArrXMLHTTP=new Array("MSXML3.XMLHTTP","MSXML2.XMLHTTP","Microsoft.XMLHTTP","MSXML.XMLHTTP","MSXML2.ServerXMLHTTP");
		var oXMLHTTP=null;
		
		//if(window.XMLHttpRequest){
			try{
					oXMLHTTP= new XMLhttpRequest();
					//XMLHttpRequest
			}catch(e){
				
				for(var i=0;i<sArrXMLHTTP.length;i++){
					try{
							oXMLHTTP=new ActiveXObject(sArrXMLHTTP[i]);
							break;
					}catch(e){}
				}
			}
		//}
		if (oXMLHTTP==null){
			oXMLHTTP=new XMLHttpRequest() 
		}
		//alert(oXMLHTTP)
		/*for(var i=0;i<sArrXMLHTTP.length;i++){
			try{
					oXMLHTTP=new ActiveXObject(sArrXMLHTTP[i]);
					break;
			}catch(Exception){}
		}*/
		return oXMLHTTP;
	}
	
	JAjax.prototype._onreadystatechange=function(){
		if(this._objXmlHttp==null){
			if(typeof(this.onComplete)=="function"){
				this.onComplete(this,this._objXmlHttp);
			}
			return;
		}
		if (this._objXmlHttp.readyState == 1){
			if(typeof(this.onLoading)=="function"){
				this.onLoading(this,this._objXmlHttp);
			}
		}
		else if(this._objXmlHttp.readyState == 2){
			if(typeof(this.onLoaded)=="function"){
				this.onLoaded(this,this._objXmlHttp);
			}
		}
		else if(this._objXmlHttp.readyState == 3){
			if(typeof(this.onInteractive)=="function"){
				this.onInteractive(this,this._objXmlHttp);
			}
		}
		else if (this._objXmlHttp.readyState == 4){
			if(typeof(this.onComplete)=="function"){
				this.onComplete(this,this._objXmlHttp);
			}
			if (this._objXmlHttp.status == "200"){
				if(typeof(this.onSuccess)=="function"){
					this.onSuccess(this,this._objXmlHttp);
				}
			}
			else{
				if(typeof(this.onError)=="function"){
					this.onError(this,this._objXmlHttp);
				}
			}
			if(this._onTimeOut!=null){
				window.clearTimeout(this._onTimeOut);
				this._onTimeOut=null;
			}
		}
	}
	
	JAjax.prototype._process=function(strMethod,strUrl,isSync,objResponse,objRequestHeaders){
		
		this._objXmlHttp=null;
		this._objXmlHttp=this.createXMLHTTP();
		if(!this._objXmlHttp) return null;
		var sendStr="",strLength=0;
				
		this._objXmlHttp.onreadystatechange = Function.createDelegate(this,this._onreadystatechange);

		strMethod=strMethod.toUpperCase();
		if(objResponse) strLength=objResponse.getStream().length+strUrl.length;
		
		if(typeof(this.onTimeOut)=="function"&&this.timeout>0) this._onTimeOut=window.setTimeout(this.onTimeOut,this.timeOut);

		if(objResponse){
			if(strMethod=="POST"){
				sendStr=objResponse.getStream();
			}else{
				if(strUrl.indexOf("?")>-1)
					strUrl+="&"+objResponse.getStream();
				else
					strUrl+="?"+objResponse.getStream();
			}
		}
		
		objResponse=null;
		objResponse=new JHttpResponse();
		objResponse.write("JAjax-Send_Time",(new Date().toChineseString()));
		
		if(strUrl.indexOf("?")>-1)
			strUrl+="&"+objResponse.getStream();
		else
			strUrl+="?"+objResponse.getStream();
			
			
		this._objXmlHttp.open(strMethod,strUrl,isSync);
		
		if(typeof(objRequestHeaders)=="Function"){
			for(var header in objRequestHeaders){
				this._objXmlHttp.setRequestHeader(header,objRequestHeaders[header]); 
			}
		}else{
			this._objXmlHttp.setRequestHeader("Content-Length",strLength); 
			this._objXmlHttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		}
		this._objXmlHttp.send(sendStr);
		
		
	}
	
	JAjax.prototype.updater=function(strMethod,strUrl,objResponse,objRequestHeaders){
		this._process(strMethod,strUrl,true,objResponse,objRequestHeaders);
	}
	
	JAjax.prototype.submit=function(objForm,strMethod,isAys,objResponse){
		objResponse=Form.serialize(objForm,objResponse);
		if(isAys){
			return this.getText(strMethod,objForm.getAttribute("action"),objResponse,null);
		}else{
			this.updater(strMethod,objForm.getAttribute("action"),objResponse,null);
		}
	}

// * Cookie 类
	var JHttpCookie=System.createObject();
	
	JHttpCookie.prototype.initialize=function(name,value,expires,path,domain,secure){
		this.className="JHttpCookie";
		this.name=name;
		this.value=value;
		this.expires=(expires==null)?null:expires;
		this.path=(path==null)?null:path;
		this.domain=(domain==null)?null:domain;
		this.secure=(secure==null)?null:secure;
	}

	JHttpCookie.prototype.toString=function(){
		var result=this.name+"="+this.value;
		if(this.expires) result+="; expires="+this.expires;
		if(this.path) result+="; path="+this.path;
		if(this.domain) result+="; domain="+this.domain;
		if(this.secure) result+="; secure="+this.secure;
		return result;
	}

	JHttpCookie.prototype.toCookieString=function(){
		var result=this.name+"="+escape(this.value);
		if(this.expires) result+="; expires="+this.expires;
		if(this.path) result+="; path="+this.path;
		if(this.domain) result+="; domain="+this.domain;
		if(this.secure) result+="; secure="+this.secure;
		return result;
	}
	
// * Cookie 操作类
	var JHttpCookieManager=System.createObject();
	
	JHttpCookieManager.prototype.initialize=function(){
		this.extend(new JHashtable());
		this.className="JHttpCookieManager";
		this.stream=document.cookie;
		if(this.stream.length>0){
			if(this.stream.indexOf(";")>1)	{
				var strArray=this.stream.split(";");
				for(var i=0;i<strArray.length;i++)	{
					if(strArray[i].indexOf("=")>1)	{
						this.parseCookie(strArray[i]);
					}
				}
			}
			else
			{
				if(this.stream.indexOf("=")>1){
					this.parseCookie(this.stream);
				}
			}
		}
	}

	JHttpCookieManager.prototype.parseCookie=function(str){
			var strName,strValue,iPos;
			iPos=str.indexOf("=");
			strName=str.substring(0,iPos).trim();
			strValue=unescape(str.substring(iPos+1,str.length));
			this.put(strName,strValue);
	}

	JHttpCookieManager.prototype.addCookie=function(objCookie){
			document.cookie=objCookie.toCookieString();
			if(this.exists(objCookie.name)){
				this.replace(objCookie.name,objCookie.value);
			}else{
				this.put(objCookie.name,objCookie.value);
			}
	}

	JHttpCookieManager.prototype.removeCookie=function(strName){
			if(this.exists(strName)){
				var tempCookie=new Cookie(strName,"");
				tempCookie.expires="expires=Fri, 02-Jan-1970 00:00:00 GMT";
				document.cookie=tempCookie.toCookieString();
				this.remove(strName);
			}
	}

	JHttpCookieManager.prototype.removeAllCookie=function(){
		   for(var vari in this.container){
				this.removeCookie(vari);   
		   }
	}

	JHttpCookieManager.prototype.getCookieValue=function(strParam){
			if(this.exists(strParam)){
				return this.get(strParam);
			}
	}

	JHttpCookieManager.prototype.getCookie=function(strParam){
			return new Cookie(strParam,this.getCookieValue(strParam));	
	}

// * 事件类
	var JEvent=System.createObject();
	
	JEvent.prototype.initialize=function(){
		this.className="JEvent";
		this.KEY_BACKSPACE=8;
		this.KEY_TAB=9;
		this.KEY_RETURN=13;
		this.KEY_ESC=27;
		this.KEY_LEFT=37;
		this.KEY_UP=38;
		this.KEY_RIGHT=39;
		this.KEY_DOWN=40;
		this.KEY_DELETE=46;
	}
	
	JEvent.prototype.element=function(event) {
		return event.target || event.srcElement;
    }

	JEvent.prototype.isLeftClick=function(event) {
		return (((event.which) && (event.which == 1)) ||
			((event.button) && (event.button == 1)));
    }

	JEvent.prototype.pointerX=function(event) {
		return event.pageX || (event.clientX +
			(document.documentElement.scrollLeft || document.body.scrollLeft));
	}

	JEvent.prototype.pointerY=function(event) {
		return event.pageY || (event.clientY +
			(document.documentElement.scrollTop || document.body.scrollTop));
    }

	JEvent.prototype.stop=function(event) {
		if (event.preventDefault) {
			event.preventDefault();
			event.stopPropagation();
		} else {
			event.returnValue = false;
			event.cancelBubble = true;
		}
    }

	JEvent.prototype.findElement=function(event, tagName) {
		var element = this.element(event);
		while (element.parentNode && (!element.tagName ||
			(element.tagName.toUpperCase() != tagName.toUpperCase())))
		element = element.parentNode;
		return element;
    }
	
	JEvent.prototype.attachEvent=function(objElement,strEvent,objFunction){
		if(JBrowser.agent == JBrowser.Firefox){
			objElement.addEventListener(strEvent,objFunction);
		}else{
			objElement.attachEvent(strEvent,objFunction);
		}
	}
	
	JEvent.prototype.detachEvent=function(objElement,strEvent,objFunction){
		if(JBrowser.agent == JBrowser.Firefox){
			objElement.removeEventListener(strEvent,objFunction,true);
		}else{
			objElement.detachEvent(strEvent,objFunction);
		}
	}

	if(!window.Event) window.Event=new JEvent();
// * DHTML 操作类
	function $() {
		var elements = new Array();
		for (var i = 0; i < arguments.length; i++) {
			var element = arguments[i];
			if (typeof element == "string")
				  element = document.getElementById(element);
			if (arguments.length == 1)
				  return element;
			elements.push(element);
		}
		return elements;
	}

	function $c(strElementType){
		return document.createElement(strElementType);
	}
	
	function $w(str){
		document.write(str);	
	}

	var JDomElement=System.createObject();

	JDomElement.prototype.initialize=function(){
		this.className="JDomElement";	
	}
	
	JDomElement.prototype.addCssClass = function(element, className) {
		if (!this.containsCssClass(element, className)) {
			element.className += " " + className;
		}
	}

	JDomElement.prototype.containsCssClass = function(element, className) {
		return element.className.split(" ").contains(className);
	}

	JDomElement.prototype.getBounds = function(element) {
		var offset = this.getLocation(element);
		return { x: offset.x, y: offset.y, width: element.offsetWidth, height: element.offsetHeight };
	}

	JDomElement.prototype.getElementById = function(id, element) {
		if (!element) return document.getElementById(id);
		if (element.getElementById) return element.getElementById(id);
	
		var nodeQueue = [];
		var childNodes = element.childNodes;
		for (var i = 0; i < childNodes.length; i++) {
			var node = childNodes[i];
			if (node.nodeType == 1) {
				nodeQueue[nodeQueue.length] = node;
			}
		}
	
		while (nodeQueue.length) {
			node = nodeQueue.shift();
			if (node.id == id) {
				return node;
			}
			childNodes = node.childNodes;
			for (i = 0; i < childNodes.length; i++) {
				node = childNodes[i];
				if (node.nodeType == 1) {
					nodeQueue[nodeQueue.length] = node;
				}
			}
		}
	
		return null;
	}

	JDomElement.prototype.getLocation = function(element) {
		var offsetX = 0;
		var offsetY = 0;
		var parent;
		for (parent = element; parent; parent = parent.offsetParent) {
			if (parent.offsetLeft) {
				offsetX += parent.offsetLeft;
			}
			if (parent.offsetTop) {
				offsetY += parent.offsetTop;
			}
		}
		return { x: offsetX, y: offsetY };
	}
	
	JDomElement.prototype.setLocationToCenter = function(element) {
		var element=$(element)
		element.style.left=(parseInt(document.body.clientWidth,10)/2)-(parseInt(element.offsetWidth,10)/2);
		element.style.top=(parseInt(document.body.clientHeight,10)/2)+(parseInt(element.offsetHeight,10)/2);
	}

	JDomElement.prototype.removeCssClass = function(element, className) {
		var currentClassName = " " + element.className + " ";
		var index = currentClassName.indexOf(" " + className + " ");
		if (index >= 0) {
			element.className = (currentClassName.substr(0, index) + " " +
				currentClassName.substring(index + className.length + 1, currentClassName.length)).trim();
		}
	}

	JDomElement.prototype.setLocation = function(element, x, y) {
		var style = element.style;
		style.position = "absolute";
		style.left = x + "px";
		style.top = y + "px";
	}
	
	JDomElement.prototype.toggleCssClass = function(element, className) {
		if (this.containsCssClass(element, className)) {
			this.removeCssClass(element, className);
		}
		else {
			this.addCssClass(element, className);
		}
	}
	
	JDomElement.prototype.visible=function(element) {
		return $(element).style.display != "none";
	}

	JDomElement.prototype.toggle=function() {
		for (var i = 0; i < arguments.length; i++) {
		 	var element = $(arguments[i]);
		 	Element[Element.visible(element) ? "hide" : "show"](element);
		}
	}

	JDomElement.prototype.hide=function() {
		for (var i = 0; i < arguments.length; i++) {
			var element = $(arguments[i]);
			element.style.display = "none";
		}
	}

	JDomElement.prototype.show=function() {
		for (var i = 0; i < arguments.length; i++) {
			var element = $(arguments[i]);
			element.style.display = "";
		}
	}

	JDomElement.prototype.remove=function(element) {
		element = $(element);
		element.parentNode.removeChild(element);
	}

	JDomElement.prototype.getHeight=function(element) {
		element = $(element);
		return element.offsetHeight;
    }
	
	JDomElement.prototype.getWidth=function(element) {
		
		element = $(element);
		return element.offsetWidth;
    }
			
	JDomElement.prototype.empty=function(element) {
		return $(element).innerHTML.match(/^\s*$/);
    }
	
	JDomElement.prototype.scrollTo=function(element) {
		element = $(element);
		var x = element.x ? element.x : element.offsetLeft,
			y = element.y ? element.y : element.offsetTop;
		window.scrollTo(x, y);
    }
	
	JDomElement.prototype.getStyle=function(element, style) {
		element = $(element);
		var value = element.style[style];
		if (!value) {
		  if (document.defaultView && document.defaultView.getComputedStyle) {
			var css = document.defaultView.getComputedStyle(element, null);
			value = css ? css.getPropertyValue(style) : null;
		  } else if (element.currentStyle) {
			value = element.currentStyle[style];
		  }
		}

		if (window.opera && ["left", "top", "right", "bottom"].indexOf(style)>-1)
		    if (this.getStyle(element, "position") == "static")
		  		value = "auto";
		return value == "auto" ? null : value;
	}
			
	JDomElement.prototype.setStyle=function(element, style) {
		element = $(element);
		for (var name in style)
		  element.style[name] = style[name];
	}
	
	JDomElement.prototype.getDimensions=function(element) {
		element = $(element);
		if (this.getStyle(element, "display") != "none")
			return {width: element.offsetWidth, height: element.offsetHeight};
		var els = element.style;
		var originalVisibility = els.visibility;
		var originalPosition = els.position;
		els.visibility = "hidden";
		els.position = "absolute";
		els.display = "";
		var originalWidth = element.clientWidth;
		var originalHeight = element.clientHeight;
		els.display = "none";
		els.position = originalPosition;
		els.visibility = originalVisibility;
		return {width: originalWidth, height: originalHeight};
	
	}
	
	//if(!window.Element) window.Element=new JDomElement();
	
	 var Element=new JDomElement();
	
// * 表单 操作类
	var JForm=System.createObject();
	JForm.prototype.initialize=function(){
		this.className="JForm";
	}
	
	JForm.prototype.serialize=function(form,objResponse) {
		var objForm=null;
		if(isString(objForm))
			objForm = this.getElements($(form));
		else
			objForm = form;
		var elements=objForm.elements;
		if(objResponse==null)
			objResponse=new JHttpResponse();
		for (var i=0;i<elements.length;i++) {
			var element = elements[i];
			if (!element.disabled) {
				switch(element.type) {
					case "text": case "password": case "hidden": case "textarea": 
						objResponse.write(element.name,element.value);
						break;
					case "select-one":
						if (element.selectedIndex>=0) {
							objResponse.write(element.name,element.options[element.selectedIndex].value);
						}
						break;
					case "select-multiple":
						for (var j=0; j<element.options.length; j++) {
							if (element.options[j].selected) {
								objResponse.write(element.name,element.options[j].value);
							}
						}
						break;
					case "checkbox": case "radio":
						if (element.checked) {
							objResponse.write(element.name,element.value);
						}
					break;
				}
			}
		}
		return objResponse;
	}
	
	JForm.prototype.getElements=function(form) {
		form = $(form);
		return form.elements;
	}
	
	JForm.prototype.getInputs=function(form, typeName, name) {
		form = $(form);
		var inputs = form.getElementsByTagName("input");
		if (!typeName && !name)
			return inputs;
		var matchingInputs = new Array();
		for (var i = 0; i < inputs.length; i++) {
			var input = inputs[i];
			if ((typeName && input.type != typeName) ||
				(name && input.name != name))
			continue;
			matchingInputs.push(input);
		}
		return matchingInputs;
	}
	
	JForm.prototype.disable=function(form) {
		var elements = this.getElements(form);
		for (var i = 0; i < elements.length; i++) {
			var element = elements[i];
			element.blur();
			element.disabled = "true";
		}
	}
	
	JForm.prototype.enable=function(form) {
		var elements = this.getElements(form);
		for (var i = 0; i < elements.length; i++) {
			var element = elements[i];
			element.disabled = "false";
		}
	}
			
	JForm.prototype.reset=function(form) {
		$(form).reset();
	}
	
	if(!window.Form) window.Form=new JForm();