<%@ Page language="c#" AutoEventWireup="false" Inherits="Brettle.Web.NeatUpload.ProgressPage" %>
<%@ Register TagPrefix="Upload" Namespace="Brettle.Web.NeatUpload" Assembly="Brettle.Web.NeatUpload" %>
<html>
	<head>
		<title>Upload Progress</title>
		<link rel="stylesheet" type="text/css" title="default" href="default.css" />		
		<style type="text/css">
<!--
		body, form, table, tr, td {
			margin: 0px;
			border: 0px none;
			padding: 0px;
		}

		#progressDisplayCenterer {
	vertical-align: middle;
	width: 100%;
		}
		
		#progressDisplay {
			vertical-align: middle;
			width: 100%;
		}
		
		#barTd {
			width: 100%;
		}
		
		#statusDiv {
	border-width: 1px;
	border-style: solid;
	padding: 0px;
	position: relative;
	width: 100%;
	text-align: center;
	z-index: 1;
	height: 6px;
	overflow: hidden;
		}
		
		#barDiv,#barDetailsDiv {
	border: 0px none;
	margin: 0px;
	padding: 0px;
	position: absolute;
	top: 0pt;
	left: 0pt;
	z-index: -1;
	height: 100%;
	width: 75%;
		}
.StatusMessage_01 {
	text-align: center;
}
-->
		</style>
	</head>
	<body>
		<form id="dummyForm" runat="server">
<table id="progressDisplay" class="ProgressDisplay">
		<tr>
		<td id="barTd" >
			<div id="statusDiv" runat="server" class="StatusMessage">
				<Upload:DetailsDiv id="barDetailsDiv" runat="server" UseHtml4="true"
					 Width='<%# Unit.Percentage(Math.Floor(100*FractionComplete)) %>' class="ProgressBar" 
                    Height="10px"></Upload:DetailsDiv>	
			</div>
            <div id="statusDiv_01"  class="StatusMessage_01">
            <Upload:DetailsSpan id="normalInProgress" runat="server" WhenStatus="NormalInProgress" style="font-weight: normal; white-space: nowrap;">
					<%# FormatCount(BytesRead) %>/<%# FormatCount(BytesTotal) %> <%# CountUnits %>
					<span style="color:red;">(<%# String.Format("{0:0%}", FractionComplete) %>)</span>  <%# FormatRate(BytesPerSec) %>
					 <%# FormatTimeSpan(TimeRemaining) %>
			  </Upload:DetailsSpan>
				<Upload:DetailsSpan id="chunkedInProgress" runat="server" WhenStatus="ChunkedInProgress" style="font-weight: normal; white-space: nowrap;">
					<%# FormatCount(BytesRead) %> <%# CountUnits %>
					at <%# FormatRate(BytesPerSec) %>
					- <%# FormatTimeSpan(TimeElapsed) %> elapsed
				</Upload:DetailsSpan>
				<Upload:DetailsSpan id="completed" runat="server" WhenStatus="Completed">
					Complete: <%# FormatCount(BytesRead) %> <%# CountUnits %>
					at <%# FormatRate(BytesPerSec) %>
					took <%# FormatTimeSpan(TimeElapsed) %>
				</Upload:DetailsSpan>
				<Upload:DetailsSpan id="cancelled" runat="server" WhenStatus="Cancelled">
					Cancelled!
				</Upload:DetailsSpan>
				<Upload:DetailsSpan id="rejected" runat="server" WhenStatus="Rejected">
					Rejected: <%# Rejection != null ? Rejection.Message : "" %>
				</Upload:DetailsSpan>
				<Upload:DetailsSpan id="error" runat="server" WhenStatus="Failed">
					Error: <%# Failure != null ? Failure.Message : "" %>
				</Upload:DetailsSpan>
			</div>
		</td>
		<td style="display:none;">
			<asp:HyperLink id="cancel" runat="server" Visible='<%# CancelVisible %>' NavigateUrl='<%# CancelUrl %>' title="Cancel Upload" class="ImageButton" ><img id="cancelImage" runat="server" src="cancel.png" alt="Cancel Upload" /></asp:HyperLink>
			<asp:HyperLink id="refresh" runat="server" Visible='<%# StartRefreshVisible %>' NavigateUrl='<%# StartRefreshUrl %>' title="Refresh" class="ImageButton" ><img id="refreshImage" runat="server" src="refresh.png" alt="Refresh" /></asp:HyperLink>
			<asp:HyperLink id="stopRefresh" runat="server" Visible='<%# StopRefreshVisible %>' NavigateUrl='<%# StopRefreshUrl %>' title="Stop Refreshing" class="ImageButton"><img id="stopRefreshImage" runat="server" src="stop_refresh.png" alt="Stop Refreshing" /></asp:HyperLink>
		</td>
		</tr>
		</table>
		</form>
	</body>
</html>
