using System;
using System.IO;
using System.Web;
using System.Net;
using System.Text;
using System.Xml;
using System.Data;
using MyFunc;
using NetCMS.DALProfile;
using System.Collections.Generic;
namespace NetCMS.API.PDO
{
	public class PDOAction
	{
		//		MyMD5 getMD5 = new MyMD5();

		/// <summary>
		/// ϵ¼
		/// </summary>
		/// <param name="username">û</param>
		/// <param name="password">û루δܣ</param>
		/// <param name="saveDays">Cookie</param>
		public void Login(string username, string password, int saveDays)
		{
            string LoginString = "";
            Login(username, password, saveDays, ref LoginString);
            Fetch.Trace(LoginString);
        }
        public void Login(string username, string password, int saveDays, ref string LoginString)
        {
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "login", 0);
			pdo.SetValue("username", username, 1);
			pdo.SetValue("password", password, 0);
            string pwdkey = cfg["SYSKEY"];
            pwdkey = Text.MD5(username + pwdkey);
            pdo.SetValue("syskey", pwdkey, 0);

			int savecookie = 0;
			if (saveDays >= 7)  savecookie = 1;
			if (saveDays >= 30) savecookie = 2;
			if (saveDays >= 365) savecookie = 3;

			pdo.SetValue("savecookie", savecookie.ToString(), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
                //UtilityHandler.Prompt(pdo.Message);
			}
			HttpContext.Current.Response.Buffer = true;
            LoginString = pdo.SetCookie(username, password, savecookie.ToString());
		}

		/// <summary>
		/// ˳
		/// </summary>
		/// <param name="username">û</param>
		public void Logout(string username)
		{
            string Outstring = "";
            Logout(username, ref Outstring);
            Fetch.Trace(Outstring);
		}
        public void Logout(string username, ref string Outstring)
        {
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "logout", 0);
			pdo.SetValue("username", username, 1);
			//			pdo.SetValue("syskey", getMD5.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
                //UtilityHandler.Prompt(pdo.Message);
            }
            Outstring = pdo.SetCookie(username, "", "0");
		}

		/// <summary>
		/// ɾһû
		/// </summary>
		/// <param name="names">û , ָ</param>
		public void DeleteUsers(string names)
		{
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "delete", 0);

			//ûǰָĵȥΪָһοɾû
			names = names.Replace("'","");
			pdo.SetValue("username", names, 1);
			//			pdo.SetValue("syskey", getMD5.MD5(names + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(names + cfg["SYSKEY"]), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
				//UtilityHandler.Prompt(pdo.Message);
			}
		}

		/// <summary>
		/// û/
		/// </summary>
		/// <param name="username">û</param>
		/// <param name="userstatus">ͣ1Ϊ0Ϊ ,2 Ϊ</param>
		public void LockUser(string username, int userstatus)
		{
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "lock", 0);

			pdo.SetValue("username", username, 1);
			//			pdo.SetValue("syskey", getMD5.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SetValue("userstatus", userstatus.ToString(), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
				//UtilityHandler.Prompt(pdo.Message);
			}
		}

		/// <summary>
		/// ûǷڣעûдݿ֮ǰҪô˺ж
		/// ˴δûʼַҪʼַظɷ͸ӿڽм
		/// </summary>
		/// <param name="username">û</param>
        ///         
        public void CheckName(string username)
        {
           CheckName( username, "");
        }
        public void CheckName(string username, string email)
		{
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "checkname", 0);

			pdo.SetValue("username", username, 1);
            if (email.Length != 0)
            {
                pdo.SetValue("email", email, 1);
            }
			//			pdo.SetValue("syskey", getMD5.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
				//UtilityHandler.Prompt(pdo.Message);
			}
		}
        public string checkEmail(string username, string email)
        {
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
            pdo.SetValue("action", "checkemail", 0);
            pdo.SetValue("username", username, 1);
            pdo.SetValue("email", email, 1);
			//			pdo.SetValue("syskey", getMD5.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(username + cfg["SYSKEY"]), 0);
			pdo.SendHttpData();
			if (pdo.Status == "1")
			{ 
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
				return pdo.Message;
				//UtilityHandler.Prompt(pdo.Message);
			}
			return "success";
        }
		/// <summary>
		/// ӿڳȡûϢͿԲvoidǼϻ
		/// DvbbsҪʹⷽĹܣ˺Բд
		/// </summary>
		/// <param name="username">û</param>

		public void RegUser(string name, string password, int experience, int money, string sex, string email, string face, string question, string answer, string truename, string info, string signature, string firstid, string lastip, int logins, bool isactivated, string referrer)
		{
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "reguser", 0);
			//			pdo.SetValue("syskey", getMD5.MD5(name + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(name + cfg["SYSKEY"]), 0);
			pdo.SetValue("username", name, 1);
			pdo.SetValue("password", password, 0);
			pdo.SetValue("email", email, 0);
			pdo.SetValue("question", question, 1);
			pdo.SetValue("answer", answer, 1);
			// DvbbsԱ෴0Ϊԣ1ΪŮ
			if (sex == "0")
				sex = "1";
			else
				sex = "0";

			pdo.SetValue("gender", sex, 0);

			string[] infoarr 		= info.Split('	');
			// homepage, qq, msn, telephone, mobile, address
			if (infoarr != null && infoarr.Length >= 6)
			{
				pdo.SetValue("homepage", infoarr[0], 1);
				pdo.SetValue("qq", infoarr[1], 0);
				pdo.SetValue("msn", infoarr[2], 1);
				pdo.SetValue("telephone", infoarr[3], 0);
				pdo.SetValue("mobile", infoarr[4], 0);
				pdo.SetValue("address", infoarr[5], 1);
			}
			pdo.SetValue("userip", lastip, 0);
			pdo.SetValue("experience", experience.ToString(), 0);
			pdo.SetValue("ticket", money.ToString(), 0);

			int t = 0;
				
			if (!isactivated)
			{
				t = 4;
			}
			pdo.SetValue("userstatus", t.ToString(), 0);
			pdo.SetValue("truename", truename, 0);
			pdo.SendHttpData();

			Fetch.Trace(pdo.SetCookie(name, password, experience.ToString()));

			if (pdo.Status == "1")
			{
				//ڴ˴ִɾעû 
                string Sql = "delete from " + Fetch.TablePrefix + "sys_user where username='" + Text.SqlEncode(name) + "'";
                DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
                HttpContext.Current.Response.Write(pdo.Message);
                HttpContext.Current.Response.End();
				//UtilityHandler.Prompt(pdo.Message);				
			}
		}

		public void UpdateUser(string name, string password, string answer, string email, string question, string truename, string info, string userface, string sex)
		{
			NetCMS.API.PDO.PDOData pdo = new NetCMS.API.PDO.PDOData();
			Dictionary<string,string> cfg = new Config("/api/pdo.config").Dict;
			pdo.SetValue("action", "update", 0);
			//			pdo.SetValue("syskey", getMD5.MD5(name + cfg["SYSKEY"]), 0);
			pdo.SetValue("syskey", Text.MD5(name + cfg["SYSKEY"]), 0);
			pdo.SetValue("username", name, 1);
			pdo.SetValue("password", password, 0);
			pdo.SetValue("email", email, 1);
			if (answer != null)
			{
				pdo.SetValue("answer", answer, 1);
			}
			if (question != null)
			{
				pdo.SetValue("question", question, 1);
			}

			//Աã粻޸
			if (sex == "0")
				sex = "1";
			else
			{
				if (sex == "1")
					sex = "0";
				else
					sex = "";
			}
			pdo.SetValue("gender", sex, 0);

			string[] infoarr 		= info.Split('	');
			// homepage, qq, msn, telephone, mobile, address
			if (infoarr != null && infoarr.Length >= 6)
			{
				pdo.SetValue("homepage", infoarr[0], 1);
				pdo.SetValue("qq", infoarr[1], 0);
				pdo.SetValue("msn", infoarr[2], 1);
				pdo.SetValue("telephone", infoarr[3], 0);
				pdo.SetValue("mobile", infoarr[4], 0);
				pdo.SetValue("address", infoarr[5], 0);
			}

			pdo.SetValue("truename", truename, 0);
			pdo.SendHttpData();
		}
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <returns>true|false</returns>
        public bool Enabled()
        {
            Dictionary<string, string> cfg = new Config("/api/pdo.config").Dict;
            if (!bool.Parse(cfg["ENABLED"]) && bool.Parse(cfg["MAINSYSTEM"]))
            {
                return false;
            }
            return true;
        }
	}
}