using System;
using System.IO;
using System.Web;
using System.Net;
using System.Text;
using System.Xml;
using MyFunc;
using System.Collections.Generic;

namespace NetCMS.API.PDO
{
	public class PDOData
	{
        public Dictionary<string, string> config;
		public string AppID, Status, Message;
		private XmlDocument		xmlDoc;
		private string xmlPath, syskey, urls;

		public PDOData()
		{
			Status  = "1";
			Message = "";

            xmlPath = HttpContext.Current.Server.MapPath("/api/pdo.user.xml");

			config  = new Config("/api/pdo.config").Dict;
			AppID   = config["APPID"];
			syskey  = config["SYSKEY"];
			urls    = config["URLS"].Trim();

			xmlDoc  = new XmlDocument();
			try
			{
				xmlDoc.Load(xmlPath);
			}
			catch
			{
				xmlDoc.LoadXml("<?xml version=\"1.0\" encoding=\"gb2312\"?><root/>");
			}
			SetValue("appid", AppID, 0);
		}

		public void SetValue(string name, string value, int type)
		{
			name = name.ToLower();
			XmlNode node = null;
			node = xmlDoc.DocumentElement.SelectSingleNode(name);
			if (node == null)
			{
				node = xmlDoc.DocumentElement.AppendChild(xmlDoc.CreateNode("element", name, ""));
			}	
			if (type == 1)
			{
				node.InnerText = "";
				node.AppendChild(xmlDoc.CreateCDataSection(value.Replace("]]>","]]&gt;")));
			}
			else
			{
				node.InnerText = value;
			}
		}

		public string GetValue(string name)
		{
			XmlNode node = null;
			node = xmlDoc.DocumentElement.SelectSingleNode(name);
			if (node != null)
			{
				return node.InnerText;
			}	
			return "null";
		}

		public void SendHttpData()
		{
			XmlDocument xml = new XmlDocument();
			string []arrurls = urls.Split('|');
			foreach(string url in arrurls)
			{
				if (url == "")
					continue;

				WebRequest request = WebRequest.Create(url);
				request.Method = "POST";
				string sendData = xmlDoc.InnerXml;
				byte[] byteArray = Encoding.Default.GetBytes(sendData);

				Stream dataStream = request.GetRequestStream();
				dataStream.Write(byteArray, 0, byteArray.Length);
				dataStream.Close();

				WebResponse response = request.GetResponse();
				dataStream = response.GetResponseStream();
				StreamReader reader = new StreamReader(dataStream, System.Text.Encoding.GetEncoding("gb2312"));
				string responseXml = reader.ReadToEnd();

				try
				{
					xml.LoadXml(responseXml);

					string appid   = xml.DocumentElement.SelectSingleNode("appid").InnerText;
					string status  = xml.DocumentElement.SelectSingleNode("status").InnerText;
					string message = xml.DocumentElement.SelectSingleNode("body/message").InnerText;
					Message = message + "(" + appid + "ʾ)";
					Status  = status;
					if (status == "1")
					{
						return;
					}
				}
				catch
				{
					Status = "1";
					Message = "ݴ";
					return;
				}
			}
		}

		public string SetCookie(string c_username, string c_password, string c_type)
		{
			//			MyMD5 getMD5 = new MyMD5();
			System.Text.StringBuilder sb = new System.Text.StringBuilder();
			string tmpPWD;
			string []arrurls = urls.Split('|');
			foreach(string url in arrurls)
			{
				if (c_password != "")
					//					tmpPWD = getMD5.MD5(c_password);
					tmpPWD = Text.MD5(c_password,32);
				else
					tmpPWD = "";

				sb.Append("<iframe width=\"0\" height=\"0\" src=\"" + url + "?syskey=" + Text.MD5(c_username + syskey) + "&username=" + Fetch.UrlEncode(c_username) +"&password=" + tmpPWD + "&rawpassword=" + Fetch.UrlEncode(c_password) + "&savecookie=" + Fetch.UrlEncode(c_type) + "\"></iframe>");
			}
			//			getMD5 = null;

			HttpContext.Current.Items["ApiCrossDomain"] = sb.ToString();

			return sb.ToString();
		}

		public void PrintXmlData()
		{
			HttpContext.Current.Response.Clear();
			HttpContext.Current.Response.ContentType = "text/xml";
			HttpContext.Current.Response.Expires = 0;
			HttpContext.Current.Response.Write("<?xml version=\"1.0\" encoding=\"gb2312\"?>\n");
			HttpContext.Current.Response.Write(xmlDoc);
		}
	}
}