using System;
using System.Collections;
using System.Collections.Specialized;
using System.Data;
using System.IO;
using System.Xml;
using System.Web;
using Dvbbs.Utils;
namespace Dvbbs.Api.Web
{
	public class ServicePage : Dvbbs.Utils.Origin
	{
		private readonly string __AppId = string.Empty, __SysKey = string.Empty;
		private readonly string[]	__ReqAppIdList = new string[]{"dvbbs", "powereasy", "oblog", "other"};
		private string			__ResponseBodyMessage = "ɹ";
		private bool			__IsSuccess = true, __Finished = false;
		private readonly Config __ApiCfg = null;

		// ͻ˷͹
		private NameValueCollection __RequestData, __ResponseChoiceList;

		public ServicePage()
		{
			__ApiCfg = new Config(Server.MapPath("./pdo.config"));
			__SysKey = __ApiCfg["SYSKEY"];
			__AppId = __ApiCfg["APPID"];
		}

		protected override void OnInit(EventArgs e)
		{
			try
			{
                if (!bool.Parse(__ApiCfg["ENABLED"]) && bool.Parse(__ApiCfg["MAINSYSTEM"]))
                {
                    this.__Throw("Ͻӿδ");
                    return;
                }

				//  Cookie (ʵֿ¼ע)
				if (Fetch.Get("syskey").Length > 0 && Fetch.Get("username").Length > 0)
				{
					this.__SaveCookie();
				}
				else
				{
					// ʼ
					__Initialize();

					// дڵ
#if (DEBUG)
					ResponseChoiceList["MD5_SysKey"] = Text.MD5(__RequestData["username"] + __SysKey, 8, 16);
#endif

					// 룬Ӧ/
					__ProcessRequest();
				}
			}
			catch (Exception ex)
			{
				// ʧܣ쳣
				__ProcessException(ex);
			}
			finally
			{
				// β
				__Finish();
			}
		}

		// ʼ
		private void __Initialize()
		{
			//  HTTP ͷ
			Response.ContentType = "text/xml";
			Response.ContentEncoding = System.Text.Encoding.GetEncoding("gb2312");

			// ʼ __RequestData 
			__RequestData = new NameValueCollection();

			// еݲǼص __RequestData 
			XmlTextReader reader = null;
			try
			{
				reader = new XmlTextReader(Request.InputStream);
				reader.WhitespaceHandling = WhitespaceHandling.None;
				reader.MoveToContent();

				string value = string.Empty;
				while (reader.Read())
				{
					if (1 == reader.Depth && reader.IsStartElement())
					{
						value = reader.ReadString();
						if (null == value || 0 == value.Length)
						{
							__RequestData[reader.Name] = string.Empty;
						}
						else
						{
							__RequestData[reader.Name] = Server.UrlDecode(value);
						}
					}
				}
			}
			finally
			{
				if (null != reader)
				{
					reader.Close();
					reader = null;
				}
			}
		}

		// 룬Ӧ/
		private void __ProcessRequest()
		{
			// ֤ʶ appid
			if (!__CheckAppId())
			{
				this.__Throw("ʶ " + __RequestData["appid"] + "Ϸ");
				return;
			}

			// ֤ȫ syskey
			if (!__CheckSysKey())
			{
				this.__Throw("ȫ벻ȷ");
				//		this.__Throw("ȫ벻ȷ" + Text.MD5("admin" + __SysKey, 8, 16));
				return;
			}

			switch (__RequestData["action"])
			{
                case "checkemail":	//	
                    __CheckEmail();
                    break;
				case "checkname":	//	ûǷע
					__CheckUser();
					break;
				case "reguser":		//	עû
					__RegisterUser();
					break;
				case "login":		//	û¼
					__UserLogin();
					break;
				case "update":		//	û
					__UpdateUserInfo();
					break;
				case "delete":		//	ɾû
					__DeleteUser();
					break;
				case "getinfo":		//	ѯûϢ
					__GetUserInfo();
					break;
                case "logout":		//	˳
                    __logout();
                    break;
				case "lock":		//	û
					__lock();
					break;
				default:
					this.__Throw("δָĲͣ");
					return;
			}
		}
		private void __lock() 
		{ 
            

		}
        /// <summary>
        /// ˳ϵͳ
        /// </summary>
        private void __logout()
        {
            try
            {
                if (Cookie.Get("user") == null)
                {
                    return;
                }

               Dvbbs.bbs.Entity.User user = Dvbbs.bbs.Entity.User.Current;

                Cookie.Remove("login_" + Fetch.UrlEncode(user.Name));

                conn.Execute("update " + Dvbbs.Utils.Fetch.TablePrefix + "user set isonline=0 where username='" + Text.SqlEncode(user.Name) + "'");

                HttpCookie cSession = Cookie.Get("session");
                if (cSession == null)
                    conn.Execute("update " + Dvbbs.Utils.Fetch.TablePrefix + "online set power=0, username='ο' where username='" + Text.SqlEncode(user.Name) + "'");
                else
                    conn.Execute("update " + Dvbbs.Utils.Fetch.TablePrefix + "online set power=0, username='ο' where id='" + cSession.Values["sessionid"].ToString() + "'");

                Cookie.Remove("user");
                Caching.Remove("OnlineList");

                string redirect = string.Empty;
                string referrer = Fetch.Referrer.ToLower();
                if (referrer.IndexOf("user_") == -1 && referrer.IndexOf("/index.aspx") == -1)
                {
                    redirect = "RefText,RefHref|";
                }
                SessionState.Set("pop_strategy", null);
                SessionState.Set("exp_strategy", null);
                SessionState.Set("mng_strategy", null);
                conn.Close();
            }
            catch
            {
            }
        }
		private void __ProcessException(Exception ex)
		{
			this.__Throw(ex.ToString());
		}

		// β
		private void __Finish()
		{
			if (__Finished)
			{
				return;
			}

			__Finished = true;

			base.Finish();

			XmlTextWriter writer = null;
			try
			{
				writer = new XmlTextWriter(Response.Output);
				
				writer.Formatting = Formatting.Indented;
				
				writer.WriteStartDocument();

				writer.WriteStartElement("root");

				writer.WriteStartElement("appid");
				writer.WriteString(__AppId);
				writer.WriteEndElement();

				writer.WriteStartElement("status");
				writer.WriteString(__IsSuccess ? "0" : "1");
				writer.WriteEndElement();

				writer.WriteStartElement("needcookie");
				if (null != __RequestData)
				{
					writer.WriteString("1" == __RequestData["needcookie"] ? "1" : "0");
				}
				writer.WriteEndElement();

				writer.WriteStartElement("body");
					
				writer.WriteStartElement("message");
				writer.WriteString(__ResponseBodyMessage);
				writer.WriteEndElement();
				
				// ѡб׷ӽ
				if (null != __ResponseChoiceList && __ResponseChoiceList.Count > 0)
				{
					string key = null;
					for (int i = 0; i < __ResponseChoiceList.Count; i++)
					{
						key = __ResponseChoiceList.GetKey(i);
						if (null != key && key.Length > 0)
						{
							writer.WriteStartElement(key);
							writer.WriteString(__ResponseChoiceList[i]);
							writer.WriteEndElement();
						}
					}
				}

				writer.WriteEndElement();

				writer.WriteEndElement();

				writer.WriteEndDocument();
			}
			finally
			{
				if (null != writer)
				{
					writer.Close();
					writer = null;
				}
			}
#if DEBUG
			using (StreamWriter fwriter = new StreamWriter(Server.MapPath("./api.log"), false))
			{
				if (0 == Fetch.Get("syskey").Length && 0 == Fetch.Get("username").Length && null != __RequestData)
				{
					foreach (string key in __RequestData.Keys)
					{
						fwriter.Write("<" + key + ">" + __RequestData[key] + "</" + key + ">\r\n");
					}

					fwriter.Write("\r\n\r\n");
				}

				fwriter.Write("Request.QueryString:\r\n");
				foreach (string key in Request.QueryString.Keys)
				{
					fwriter.Write("" + key + "=" + Request.QueryString[key] + "\r\n");
				}
				
				fwriter.Write("Request.Form:\r\n");
				foreach (string key in Request.Form.Keys)
				{
					fwriter.Write("" + key + "=" + Request.Form[key] + "\r\n");
				}
			}
#endif
		}

		// ͬ Cookie
		private void __SaveCookie()
		{
			//	ʼ __RequestData 
			__RequestData = new NameValueCollection();

			// ṩû֤ǷעҪ
			string user_name = Fetch.Get("username");
			__RequestData["username"] = user_name;
            //if (!__CheckUser(user_name))
            //{
            //    return;
            //}

			// 鰲ȫ
			string sys_key = Fetch.Get("syskey");
			if (null == sys_key || 0 == sys_key.Length)
			{
				this.__Throw("ȫ벻Ϊգ");
				return;
			}
			if (!this.__ValidateMD5(user_name + this.__SysKey, sys_key))
			{
				this.__Throw("ȫ벻ȷ");
				return;
			}

			// һ洢
			string user_pwd = Fetch.Get("password");

			// user_pwd ΪգҪעû
			if (0 == user_pwd.Length)
			{
				// ߱ɾû
				HttpCookie c_session = Dvbbs.Utils.Cookie.Get("session");
				if (null == c_session)
				{
					conn.ExecuteNonQuery(
						"UPDATE " + Fetch.TablePrefix + "online SET power=0, username='ο' WHERE username=@UserName",
						conn.CreateParameter("@UserName", DbType.String, user_name)
						);
				}
				else
				{
					conn.ExecuteNonQuery(
						"UPDATE " + Fetch.TablePrefix + "online SET power=0, username='ο' WHERE id=@Id",
						conn.CreateParameter("@Id", DbType.String, c_session.Values["sessionid"])
						);
				}

				// ɾû Cookies
				Dvbbs.Utils.Cookie.Remove("user");

				// ɾ߻
				Caching.Remove("OnlineList");
				
				SessionState.Set("pop_strategy", null);
				SessionState.Set("exp_strategy", null);
				SessionState.Set("mng_strategy", null);
			}
			else	// user_pwd Ϊգһ¼
			{
				__RequestData["action"] = "login";
				__RequestData["syskey"] = Fetch.Get("syskey");
				__RequestData["password"] = user_pwd;
				__RequestData["savecookie"] = Fetch.Get("savecookie");

				// õ¼
				this.__UserLogin();
			}
			
			// ָʾֹ this.__Finish()
			this.__Finished = true;

			// ͷԴ
			Finish();
		}

		// ֤ʶ appid
		private bool __CheckAppId()
		{
			string appid = __RequestData["appid"];
			if (null == appid || 0 == appid.Length)
			{
				return false;
			}
			for (int i = 0; i < __ReqAppIdList.Length; i++)
			{
				if (-1 != appid.IndexOf(__ReqAppIdList[i]))
				{
					return true;
				}
			}
			return false;
		}

		// ֤ȫ syskey
		private bool __CheckSysKey()
		{
			string username = __RequestData["username"];
			if (null == username || 0 == username.Length)
			{
				return false;
			}

			string syskey = __RequestData["syskey"];
			if (null == syskey || 0 == syskey.Length)
			{
				return false;
			}
			if (!this.__ValidateMD5(username + __SysKey, syskey))
			{
				return false;
			}

			return true;
		}

		private void __Throw(string errorMessage)
		{
			this.__IsSuccess = false;
			this.__ResponseBodyMessage = "Dvbbs.Net Api ʾ" + errorMessage;
			this.__Finish();
			Response.End();
		}
		private void __SetSuccessMessage(string errorMessage)
		{
			this.__IsSuccess = true;
			this.__ResponseBodyMessage = errorMessage;
		}

		private bool __ValidateMD5(string rawString, string md5String)
		{
			if (null == rawString || 0 == rawString.Length || null == md5String || 0 == md5String.Length)
			{
				return false;
			}

			// ʹ UTF-8  MD5 
			//			string utf8_md5 = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(rawString, "MD5").ToLower();
			string utf8_md5 = Text.MD5(rawString, System.Text.Encoding.UTF8);
			if (32 == md5String.Length && utf8_md5 == md5String)
			{
				return true;
			}
			else if (16 == md5String.Length && utf8_md5.Substring(8, 16) == md5String)
			{
				return true;
			}

			//  Request.ContentEncoding  MD5 
			string req_enc_md5 = Text.MD5(rawString, Request.ContentEncoding);
			if (32 == md5String.Length && req_enc_md5 == md5String)
			{
				return true;
			}
			else if (16 == md5String.Length && req_enc_md5.Substring(8, 16) == md5String)
			{
				return true;
			}

			return false;
		}




		//-------------------------------------------------------------
		// ṩûemailеĻ֤ǷעҪ
		private bool __CheckUser()
		{
			return this.__CheckUser(__RequestData["username"]);
		}
        private bool __CheckEmail()
        {
            string email = __RequestData["email"];
            if (null != email && email.Length > 0)
            {
                if (-1 == email.IndexOf("@") || -1 == email.IndexOf("."))
                {
                    this.__Throw("ȷ");
                    return false;
                }
                // ʼǷѱʹ
                int count = int.Parse(conn.GetScalar("SELECT COUNT(1) FROM " + Fetch.TablePrefix + "user WHERE UserEmail<>@UserEmail", conn.CreateParameter("@UserEmail", DbType.String, email)).ToString());
                if (count > 0)
                {
                    this.__Throw("ʼ" + email + "ѱʹã");
                    return false;
                }
            }

            return true;
        }
		private bool __CheckUser(string userName)
		{
			if (null == userName || 0 == userName.Length)
			{
				this.__Throw("ûδã");
				return false;
			}
			int limit = int.Parse(config["LengthOfName"]);

			// û
			if(bool.Parse(Config.Settings["ChineseNameOnly"].ToString()) && !RegExp.isChinese(userName))
			{
				this.__Throw("Բûֻ2-" + (limit / 2).ToString() + "֣ܰĸ֣");
				return false;
			}
			if (base.Len(userName.Trim()) < 3 || base.Len(userName.Trim()) > limit)
			{
				this.__Throw("ûǳΪ3-" + limit.ToString() + "ĸֻ2-" + (limit / 2).ToString() + "֣");
				return false;
			}

			// ûǷַ
			string chars = @"!@#$%^&*()+=|\/?<>,.:;'""`[]{}";
			for (int i = 0; i < chars.Length; i++)
			{
				if (-1 != userName.IndexOf(chars[i]))
				{
					this.__Throw("ûֻĸֻģַ");
					return false;
				}
			}

			// עûģʱûǷѱעᣬʼǷѱʹ
            if ("reguser" == __RequestData["action"] || "checkname" == __RequestData["action"])
			{
                // ʼʽ
                string email = __RequestData["email"];
                if (null != email && email.Length > 0)
                {
                    if (-1 == email.IndexOf("@") || -1 == email.IndexOf("."))
                    {
                        this.__Throw("ȷ");
                        return false;
                    }
				    // ʼǷѱʹ
				    int count = int.Parse(conn.GetScalar("SELECT COUNT(1) FROM " + Fetch.TablePrefix + "user WHERE UserEmail=@UserEmail", conn.CreateParameter("@UserEmail", DbType.String, email)).ToString());
				    if (count > 0)
				    {
					    this.__Throw("ʼ" + email + "ѱʹã");
					    return false;
				    }
                }

			    // ûǷѱע
			    if (int.Parse(conn.GetScalar("SELECT COUNT(1) FROM " + Fetch.TablePrefix + "user WHERE username=@UserName", conn.CreateParameter("@UserName", DbType.String, userName)).ToString()) > 0)
			    {
				    this.__Throw("û" + userName + "ѱעᣡ");
				    return false;
			    }
			}

			return true;
		}

		//	עû
		private void __RegisterUser()
		{
			// 鵱ǰ̳Ƿע»Ա
			if (!bool.Parse(config["EnableUserRegistration"]))
			{
				this.__Throw("̳ʱע»Ա");
				return;
			}

			// ṩû֤ǷעҪ
			if (!__CheckUser())
			{
				return;
			}

			// 
			string user_pwd = __RequestData["password"];
			if (null == user_pwd || user_pwd.Length < 6 || user_pwd.Length > 20)
			{
				this.__Throw("ӦΪ6-20λ");
				return;
			}

			string question = __RequestData["question"];
			if (null == question || 0 == question.Length)
			{
				//this.__Throw("дһ⣡");
				//return;
			}

			string answer = __RequestData["answer"];
			if (null == answer || 0 == answer.Length)
			{
				//this.__Throw("дһ𰸣");
				//return;
			}

			string user_sex = __RequestData["gender"];
			if (null == user_sex || 0 == user_sex.Length || "1" == user_sex)
			{
				user_sex = "false";	//	Ա 
			}
			else
			{
				user_sex = "true";	//	Ա Ů
			}
            string md5pwd = Text.MD5(user_pwd, Request.ContentEncoding, 8, 16);
        
			// ûϢݿ
			int effected_rows = conn.ExecuteNonQuery(
				"INSERT INTO " + Fetch.TablePrefix + "user(username, [UserPassword], UserEP, UserSex, UserEmail, UserQuesion, UserAnswer, UserFace, UserInfo, usergroupid) VALUES(@UserName, @UserPassword, 0, @UserSex, @UserEmail, @UserQuesion, @UserAnswer, '1.gif', '', 9)",
				conn.CreateParameter("@UserName", DbType.String, __RequestData["username"]),
                conn.CreateParameter("@UserPassword", DbType.String, md5pwd),
				// Dvbbs.Net.dv_user.usersex=0Ϊ
				conn.CreateParameter("@UserSex", DbType.Boolean, user_sex),
				conn.CreateParameter("@UserEmail", DbType.String, __RequestData["email"]),
				conn.CreateParameter("@UserQuesion", DbType.String, question),
				conn.CreateParameter("@UserAnswer", DbType.String, answer)
				);
			if (effected_rows > 0)
			{
				// »ļ statistic.xml  עûд
				string[] elements = {"NewUserName", "Users"};
				string[] values   = Dvbbs.bbs.Handlers.StatisticHandler.GetValues(elements);
				values[0] = __RequestData["username"];
				values[1] = (int.Parse(values[1])+1).ToString();
				Dvbbs.bbs.Handlers.StatisticHandler.SetValues(elements, values);

				this.__SetSuccessMessage("ɹעᣡ");
			}
			else
			{
				this.__Throw("עʧܣϢδ֪ԭ");
			}
		}

		//	û¼
		private void __UserLogin()
		{
           
			// û
			string user_name = __RequestData["username"];
			if (null == user_name || 0 == user_name.Length)
			{
				this.__Throw("û");
				return;
			}

			// 
			string user_pwd = __RequestData["password"];
			if (null == user_pwd || 0 == user_pwd.Length)
			{
				this.__Throw("룡");
				return;
			}

			// Ŀ IP Ƿ񱻾ܾ¼
			if (Dvbbs.bbs.Handlers.UserHandler.IsDeniedIp(conn))
			{
				this.__Throw("ԲڵIPѱܾ¼̳");
				return;
			}

			// ݿȡû
			DataTable dt = conn.GetDataTable("SELECT TOP 1 UserLastIP, randpass, buycredit, sellcredit,trafutong, UserTopic, UserPost, userisclassical, UserDel, UserLogins, UserFace, LastLogin, UserGroupID, UserPower, LockUser, unlocktime, UserPassword,truepassword, UserEP, [UserMoney], UserID, UserName, JoinDate, isactivated, albumtotal, favalbumtotal, favphotototal FROM " + Fetch.TablePrefix + "user WHERE username=@UserName and isdelete=0", conn.CreateParameter("@UserName", DbType.String, user_name));

			// ΪǷڴû
			if (null == dt || 0 == dt.Rows.Count)
			{
				Cookie.Remove("user");
				this.__Throw("¼ʧܣûڣ");
				return;
			}

			DataRow dr = dt.Rows[0];
			
			// ûǷѱ
			/*
			if (bool.Parse(dr["LockUser"].ToString()) && !(dr["unlocktime"] is DBNull))
			{
				if ((DateTime)dr["unlocktime"] > DateTime.Today)
				{
					Cookie.Remove("user");
					string unlockDay = ((DateTime)dr["unlocktime"]).ToString("D");
					this.__Throw("ʺѾᣬʱʹãΪ: " + unlockDay);
					return;
				}
			}*/
			if (dr["LockUser"].ToString() == "1")
			{
				if (!(dr["unlocktime"] is DBNull) && (DateTime)dr["unlocktime"] > DateTime.Today)
				{
					string unlockDay = ((DateTime)dr["unlocktime"]).ToString("D");
					Cookie.Remove("user");
					this.__Throw("ʺѾʱʹãΪ: " + unlockDay);
					return;
				}
				else
				{
					this.__Throw("ʺѾʱʹ!");
				}
			}

			// Ƿȷ
			// APIӿ1.0淶ǲܵģһЩϵͳ˼ܣҪ
			// user_pwd һ¼
			bool is_validate = false;
			string encrypted_password = dr["UserPassword"].ToString();
            
            if (user_pwd.Length > 8)
            {
                if (encrypted_password == user_pwd.Substring(8, 16))
                {
                    is_validate = true;
                }
            }
           
            if (user_pwd == encrypted_password && ! is_validate)
			{
				is_validate = true;
			}
			else
			{
				// ʹ UTF-8  MD5 ܣȻȽ
				string utf8_md5 = Text.MD5(user_pwd, System.Text.Encoding.UTF8);
				if (32 == encrypted_password.Length && utf8_md5 == encrypted_password)
				{
					is_validate = true;
				}
				if (16 == encrypted_password.Length && utf8_md5.Substring(8, 16) == encrypted_password)
				{
					is_validate = true;
				}

				// ʹ Request.ContentEncoding  MD5 ܣȻȽ
				if (!is_validate)
				{
					string req_enc_md5 = Text.MD5(user_pwd, Request.ContentEncoding);
					if (32 == encrypted_password.Length && req_enc_md5 == encrypted_password)
					{
						is_validate = true;
					}
					if (16 == encrypted_password.Length && req_enc_md5.Substring(8, 16) == encrypted_password)
					{
						is_validate = true;
					}
				}
			}
			if (!is_validate)
			{
				Cookie.Remove("user");
				this.__Throw("¼ʧܣ벻ȷ");
				return;
			}

			// ûǷѱ
			if (!bool.Parse(dr["isactivated"].ToString()))
			{
				Cookie.Remove("user");
				this.__Throw("ԲעʺδԱ̳ĿǰעԱҪͨʹãμעϢԱ˼ſɵ¼");
				return;
			}

			// ¼Ϣͨû¼״̬ Cookies 
			HttpCookie cUser = Cookie.Get("user");
			string isFade    = "0";

			string randpass = Text.MD5(new Random().Next(6000,90000).ToString());

			if (null == cUser)
			{
				cUser  = Cookie.Set("user");
			}
			else
			{
				isFade = cUser.Values["fade"];
			}
			cUser.Values["name"]			= HttpContext.Current.Server.UrlEncode(user_name.Trim());
			cUser.Values["userid"]			= dr["userid"].ToString();
			cUser.Values["roleid"]			= dr["usergroupid"].ToString();
			cUser.Values["power"]			= dr["usergroupid"].ToString();
			cUser.Values["dv_truepassword"] = randpass;
			cUser.Values["experience"]		= dr["UserEP"].ToString();
			cUser.Values["money"]			= dr["UserMoney"].ToString();
			cUser.Values["token1"]			= Text.GenerateToken(dr["usergroupid"].ToString() + encrypted_password + user_name + ((DateTime)dr["joindate"]).ToString("yyyy-MM-dd H:mm:ss"));
			cUser.Values["token2"]			= encrypted_password;
			cUser.Values["jointime"]		= ((DateTime)dr["joindate"]).ToString("G");
			cUser.Values["fade"]			= isFade;
			cUser.Values["face"]			= Dvbbs.Utils.Text.TextEncode(dr["UserFace"].ToString());
			cUser.Values["userpost"]		= dr["UserPost"].ToString();
			cUser.Values["userisclassical"]	= dr["userisclassical"].ToString();
			cUser.Values["userdel"]			= dr["UserDel"].ToString();
			cUser.Values["userlogins"]		= dr["UserLogins"].ToString();
			cUser.Values["usertopic"]		= dr["UserTopic"].ToString();
			cUser.Values["trafutong"]		= dr["trafutong"].ToString();
			cUser.Values["buycredit"]		= dr["buycredit"].ToString();
			cUser.Values["sellcredit"]		= dr["sellcredit"].ToString();
			cUser.Values["albumtotal"]		= dr["albumtotal"].ToString();
			cUser.Values["favalbumtotal"]	= dr["favalbumtotal"].ToString();
			cUser.Values["favphotototal"]	= dr["favphotototal"].ToString();
			cUser.Values["randpass"]		= randpass;
			cUser.Values["logdate"]			= System.DateTime.Now.ToString();
			cUser.Values["UserLastIP"]		= dr["UserLastIP"].ToString();
			int save_days = 0;
			if (null != __RequestData["savecookie"] && __RequestData["savecookie"].Length > 0)
			{
				save_days = int.Parse(__RequestData["savecookie"]);
			}
			if (save_days > 0)
			{
				cUser.Expires = DateTime.Today.AddDays(save_days);
				cUser.Values["expires"] = DateTime.Today.AddDays(save_days).ToString("G");
			}
			else
			{
				if (cUser.Values["expires"] != string.Empty && cUser.Values["expires"] != null)
				{
					cUser.Expires = DateTime.Parse(cUser.Values["expires"]);
				}
			}
			Cookie.Save(cUser);      
			SessionState.Set("pop_strategy" + Fetch.UrlEncode(user_name), null);
			SessionState.Set("exp_strategy" + Fetch.UrlEncode(user_name), null);
			SessionState.Set("mng_strategy" + Fetch.UrlEncode(user_name), null);

			// û״̬ 
			conn.ExecuteNonQuery(
				"UPDATE " + Fetch.TablePrefix + "user SET LockUser=0, isonline=1, randpass=@RandPass, LastLogin=" + conn.DbDateFunc + ", UserLogins=UserLogins+1, UserLastIP=@UserLastIp, truepassword=@TruePassword WHERE username=@UserName",
				conn.CreateParameter("@RandPass", DbType.String, randpass),
				conn.CreateParameter("@UserLastIp", DbType.String, Fetch.UserIp),
				conn.CreateParameter("@UserName", DbType.String, user_name),
				conn.CreateParameter("@TruePassword", DbType.String, randpass)
				);

			// ɾҪ Cookies
			Caching.Remove("OnlineList");

			this.__SetSuccessMessage("¼ɹ");
		}

		//	û
		private void __UpdateUserInfo()
		{
			// ṩû֤ǷҪ(еʼ˷ҲԵʼм)
			if (!__CheckUser())
			{
				return;
			}

			//			// 
			//			if (null != __RequestData["password"] && 0 == __RequestData["password"].Length)
			//			{
			//				this.__Throw("ûʱд룡");
			//				return;
			//			}
			//
			//			// һ
			//			if (null != __RequestData["question"] && 0 == __RequestData["question"].Length)
			//			{
			//				this.__Throw("ûʱҪ޸һ⣬д");
			//				return;
			//			}
			//
			//			// һ
			//			if (null != __RequestData["answer"] && 0 == __RequestData["answer"].Length)
			//			{
			//				this.__Throw("ûʱҪ޸һ𰸣д");
			//				return;
			//			}

			System.Text.StringBuilder sb = new System.Text.StringBuilder ("UPDATE " + Fetch.TablePrefix + "user SET username=username");

			// Start ƴ SQL 
			// 
			if (null != __RequestData["password"] && __RequestData["password"].Length > 0)
			{
				sb.Append(", UserPassword='" + Text.SqlEncode(Text.MD5(__RequestData["password"])) + "'");
			}
			// µʼ
			if (null != __RequestData["email"] && __RequestData["email"].Length > 0)
			{
				sb.Append(", UserEmail='" + Text.SqlEncode(__RequestData["email"]) + "'");
			}
			// һ
			if (null != __RequestData["question"] && __RequestData["question"].Length > 0)
			{
				sb.Append(", UserQuesion='" + Text.SqlEncode(__RequestData["question"]) + "'");
			}
			// һ
			if (null != __RequestData["answer"] && __RequestData["answer"].Length > 0)
			{
				sb.Append(", UserAnswer='" + Text.SqlEncode(Text.MD5(__RequestData["answer"])) + "'");
			}
			// ʵ
			if (null != __RequestData["truename"] && __RequestData["truename"].Length > 0)
			{
				sb.Append(", truename='" + Text.SqlEncode(__RequestData["truename"]) + "'");
			}
			// Ա
			if (null != __RequestData["gender"] && __RequestData["gender"].Length > 0)
			{
				sb.Append(", UserSex=" + ("0" == __RequestData["gender"] ? "1" : "0"));
			}
			// 
			if (null != __RequestData["birthday"] && __RequestData["birthday"].Length > 0)
			{
				// Nothing to do
			}
			//  QQ
			if (null != __RequestData["qq"] && __RequestData["qq"].Length > 0)
			{
				// Nothing to do
			}
			//  MSN
			if (null != __RequestData["msn"] && __RequestData["msn"].Length > 0)
			{
				// Nothing to do
			}
			// ƶ绰
			if (null != __RequestData["mobile"] && __RequestData["mobile"].Length > 0)
			{
				// Nothing to do
			}
			// ͨ绰
			if (null != __RequestData["telephone"] && __RequestData["telephone"].Length > 0)
			{
				// Nothing to do
			}
			// ûϵַ
			if (null != __RequestData["address"] && __RequestData["address"].Length > 0)
			{
				// Nothing to do
			}
			// û
			if (null != __RequestData["zipcode"] && __RequestData["zipcode"].Length > 0)
			{
				// Nothing to do
			}
			// ûҳ
			if (null != __RequestData["homepage"] && __RequestData["homepage"].Length > 0)
			{
				// Nothing to do
			}
			// ûעʱڵIP
			if (null != __RequestData["userip"] && __RequestData["userip"].Length > 0)
			{
				// Nothing to do
			}
			// ûעʱ
			if (null != __RequestData["jointime"] && __RequestData["jointime"].Length > 0)
			{
				// Nothing to do
			}
			// ûķ
			if (null != __RequestData["posts"] && __RequestData["posts"].Length > 0)
			{
				// Nothing to do
			}

			object  _info = conn.GetScalar("select top 1 UserInfo from " + Fetch.TablePrefix + "user where username='" + Text.SqlEncode(__RequestData["username"]) + "'");
			string[] _info_arr = null;
			string _info_str = "";
			if(null != _info)
			{
				//homepage, qq, msn, telephone, mobile, address
				_info_arr = _info.ToString().Split('	');
				_info_str += (null == __RequestData["homepage"] || __RequestData["homepage"].Length == 0 ? (null == _info_arr[0] || _info_arr[0].Length == 0 ? "http://" : _info_arr[0]) : __RequestData["homepage"]) + "	";
				_info_str += (null == __RequestData["qq"] || __RequestData["qq"].Length == 0 ? (null == _info_arr[1] || _info_arr[1].Length == 0 ? " " : _info_arr[1]) : __RequestData["qq"]) + "	";
				_info_str += (null == __RequestData["msn"] || __RequestData["msn"].Length == 0 ? (null == _info_arr[2]  || _info_arr[2].Length == 0 ? " " : _info_arr[2]) : __RequestData["msn"]) + "	";
				_info_str += (null == __RequestData["telephone"] || __RequestData["telephone"].Length == 0 ? (null == _info_arr[3] || _info_arr[3].Length == 0 ? " " : _info_arr[3]) : __RequestData["telephone"]) + "	";
				_info_str += (null == __RequestData["mobile"]  || __RequestData["mobile"].Length == 0 ? (null == _info_arr[4] || _info_arr[4].Length == 0 ? " " : _info_arr[4]) : __RequestData["mobile"]) + "	";
				_info_str += (null == __RequestData["address"] || __RequestData["address"].Length == 0  ? (null == _info_arr[5] || _info_arr[5].Length == 0 ? " " : _info_arr[5]) : __RequestData["address"]) + "	";
			}
			sb.Append(", UserInfo='" + Text.SqlEncode(_info_str) + "'");
			//			sb.Append(" WHERE username='" + Text.SqlEncode(__RequestData["username"]) + "' AND UserPassword='" + Text.SqlEncode(Text.MD5(__RequestData["password"], 8, 16)) + "'");
			sb.Append(" WHERE username='" + Text.SqlEncode(__RequestData["username"]) + "'");
			// End ƴ SQL 
			
			
			// ִ SQL 
			conn.ExecuteNonQuery(sb.ToString());

			this.__SetSuccessMessage("ûϸ³ɹ");
		}

		//	ɾû
		private void __DeleteUser()
		{
			// ṩû֤ǷҪ(еʼ˷ҲԵʼм)
			string req_user_name = __RequestData["username"];
			if (null == req_user_name || 0 == req_user_name.Length)
			{
				this.__Throw("ɾûʧܣԭǣδû");
				return;
			}

			string[] user_name_list = req_user_name.Split(',');
			if (null == user_name_list || 0 == user_name_list.Length)
			{
				this.__Throw("ɾûʧܣԭǣûʽϷ");
				return;
			}

			// ÿһҪɾûǷϷ
			for (int i = 0; i < user_name_list.Length; i++)
			{
				if (!__CheckUser(user_name_list[i]))
				{
					return;
				}
			}

			System.Text.StringBuilder sb = new System.Text.StringBuilder("' '");
			for (int i = 0; i < user_name_list.Length; i++)
			{
				sb.Append(", '" + Text.SqlEncode(user_name_list[i]) + "'");
			}

			conn.ExecuteNonQuery("UPDATE " + Fetch.TablePrefix + "user SET isdelete=1 WHERE username IN(" + sb.ToString() + ")");

			// »ļ statistic.xml  עûд
			string[] elements = {"NewUserName", "Users"};
			string[] values   = Dvbbs.bbs.Handlers.StatisticHandler.GetValues(elements);

			int users = int.Parse(values[1]);
			if (users > 0)
			{
				values[1] = (users - 1).ToString();
			}
			if (-1 != Array.IndexOf(user_name_list, values[0]))
			{
				//object obj = conn.GetScalar("SELECT TOP 1 username FROM " + Fetch.TablePrefix + "user ORDER BY userid DESC");
				object obj = conn.GetScalar("SELECT TOP 1 userid FROM " + Fetch.TablePrefix + "user WHERE isdelete=0 ORDER BY userid DESC");
				if (null != obj)
				{
					values[0] = conn.GetScalar("SELECT TOP 1 username FROM " + Fetch.TablePrefix + "user WHERE userid=" + obj.ToString()).ToString();
				}
			}
			Dvbbs.bbs.Handlers.StatisticHandler.SetValues(elements, values);

			this.__SetSuccessMessage("ѳɹɾָû");
		}

		//	ѯûϢ
		private void __GetUserInfo()
		{
			// ṩû֤ǷҪ(еʼ˷ҲԵʼм)
			if (!__CheckUser())
			{
				return;
			}

			// ݿȡû
			string fld_list = null;
			if (conn.Provider == DbProviderEnum.Access)
			{
				fld_list = "username, UserEmail AS email, UserQuesion AS question, UserAnswer AS answer, truename, IIF(UserSex=0, 1, 0) AS gender, '' AS birthday, '' AS qq, '' AS msn, '' AS mobile, '' AS telephone, '' AS address, '' AS zipcode, '' AS homepage, firstip AS userip, JoinDate AS jointime, '' AS experience, '' AS ticket, '' AS valuation, UserMoney AS balance, UserPost AS posts, LockUser AS userstatus";
			}
			else
			{
				fld_list = "username, UserEmail AS email, UserQuesion AS question, UserAnswer AS answer, truename, (CASE WHEN UserSex=0 THEN 1 ELSE 0 END) AS gender, '' AS birthday, '' AS qq, '' AS msn, '' AS mobile, '' AS telephone, '' AS address, '' AS zipcode, '' AS homepage, firstip AS userip, JoinDate AS jointime, '' AS experience, '' AS ticket, '' AS valuation, UserMoney AS balance, UserPost AS posts, LockUser AS userstatus";
			}
			DataTable dt = conn.GetDataTable(
				"SELECT " + fld_list + " FROM " + Fetch.TablePrefix + "user WHERE username=@UserName",
				conn.CreateParameter("@UserName", DbType.String, __RequestData["username"])
				);

			if (null == dt || 0 == dt.Rows.Count)
			{
				this.__Throw("Ҫҵûڣ");
				return;
			}

			DataRow dr = dt.Rows[0];

			// ÿѡ XML б
			ResponseChoiceList["savecookie"] = "0";
			for (int i = 0; i < dt.Columns.Count; i++)
			{
				ResponseChoiceList[dt.Columns[i].ColumnName] = dr[dt.Columns[i]].ToString();
			}
		}

		// Properties
		private NameValueCollection ResponseChoiceList
		{
			get
			{
				if (null == __ResponseChoiceList)
				{
					__ResponseChoiceList = new NameValueCollection();
				}
				return __ResponseChoiceList;
			}
		}
	}
}