﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.IO;
using System.Collections.Generic;
using System.Text;
using NetCMS.Model;
using NetCMS.DALFactory;

namespace NetCMS.Content
{
    public class NewsJS
    {
        private INewsJS dal;
        public NewsJS()
        {
            dal = DataAccess.CreateNewsJS();
        }
        public IList<NewsJSInfo> GetPage(int PageIndex, int PageSize, out int RecordCount, out int PageCount, int JsType)
        {
            return dal.GetPage(PageIndex, PageSize, out RecordCount, out PageCount, JsType);
        }
        public void Delete(string id)
        {
            dal.Delete(id);
        }
        public DataTable GetJSFilePage(int PageIndex, int PageSize, out int RecordCount, out int PageCount, int id)
        {
            return dal.GetJSFilePage(PageIndex, PageSize, out  RecordCount, out  PageCount, id);
        }
        public DataTable GetJSFiles(string jsid)
        {
            return dal.GetJSFiles(jsid);
        }
        public void RemoveNews(int id)
        {
            dal.RemoveNews(id);
        }
        public NewsJSInfo GetSingle(int id)
        {
            return dal.GetSingle(id);
        }
        public void Update(NewsJSInfo info)
        {
            dal.Update(info);
            EstablishJsFile(info);
        }
        /// <summary>
        /// 重新生成JS文件
        /// </summary>
        /// <param name="id"></param>
        public void RebuildFile(int id)
        {
            NewsJSInfo info = GetSingle(id);
            EstablishJsFile(info);
        }
        public void Add(NewsJSInfo info)
        {
            info.JsID = dal.Add(info);
            EstablishJsFile(info);
        }
        private void EstablishJsFile(NewsJSInfo info)
        {
            string JsContent = "";
            string TmpContent = GetJsTmpContent(info.JsTempletID);
            if (TmpContent.Trim() != "")
            {
                if (info.jsType == 0)
                {
                    #region 系统JS
                    NetCMS.Publish.CommonData.Initialize();
                    NetCMS.Publish.LabelMass JsLbl = new NetCMS.Publish.LabelMass(TmpContent, "", "", "", 0, 0, 0, 0);
                    JsLbl.TemplateType = NetCMS.Publish.TempType.News;
                    JsLbl.ParseContent();
                    JsContent = JsLbl.Analyse_List(null, null);
                    #endregion 系统JS
                }
                else
                {
                    #region 自由JS
                    DataTable dt = GetJSFiles(info.JsID);
                    //int NewsID=0;
                    if (dt != null && dt.Rows.Count > 0)
                    {
                        NetCMS.Publish.CommonData.Initialize();
                        foreach (DataRow r in dt.Rows)
                        {
                            NetCMS.Publish.LabelMass JsLbl = new NetCMS.Publish.LabelMass(TmpContent, "", "", r["NewsId"].ToString(), 0, 0, 0, 0);
                            JsLbl.TemplateType = NetCMS.Publish.TempType.News;
                            //bug修改，自由JS处理不应该ParseContent,by arjun 2006-6-17
                            JsContent += JsLbl.Analyse_ReadNews(0, 0, 0, 0, TmpContent, "", 1, 1, 0);
                        }
                    }
                    #endregion 自由JS
                }
            }
            JsContent = JsContent.Replace("\r\n", " ");
            string JsPath = info.jssavepath;
            if (JsPath.Substring(JsPath.Length - 1, 1) != "\\")
                JsPath += "\\";
            JsPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\" + JsPath;
            if (!Directory.Exists(JsPath))
                Directory.CreateDirectory(JsPath);
            string FileName = JsPath + info.jsfilename + ".js";
            using (StreamWriter sw = new StreamWriter(FileName, false))
            {
                string FileContent = "document.write('";
                FileContent += JsContent.Replace("'","\'");
                FileContent += "');";
                sw.Write(FileContent);
            }
        }
        private string GetJsTmpContent(string jstmpid)
        {
            return dal.GetJsTmpContent(jstmpid);
        }
    }
}
