﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Data;
using NetCMS.Model;
using NetCMS.DALFactory;

namespace NetCMS.Content
{
    public class Special
    {
        private ISpecial sc;
        private string str_dirDumm = NetCMS.Config.UIConfig.dirDumm;
        private string str_rootpath = NetCMS.Common.ServerInfo.GetRootPath();

        public Special()
        {
            sc = DataAccess.CreateSpecial();
            if (str_dirDumm != "" && str_dirDumm != null && str_dirDumm != string.Empty)
                str_dirDumm = "\\" + str_dirDumm;
        }

        public DataTable getChildList(string classid)
        {
            DataTable dt = sc.getChildList(classid);
            return dt;
        }

        public void Lock(string id)
        {
            sc.Lock(id);
        }

        public void UnLock(string id)
        {
            sc.UnLock(id);
        }

        public void PDel(string id)
        {
            sc.PDel(id);
        }

        public void PDels(string id)
        {
            DataTable dt = sc.getSpeacilInfo(id);
            if (dt != null)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string savepath = dt.Rows[i]["SavePath"].ToString();
                    string spename = dt.Rows[i]["specialEName"].ToString();
                    string savedirpath = dt.Rows[i]["saveDirPath"].ToString();
                    string filename = dt.Rows[i]["FileName"].ToString();
                    string fileexname = dt.Rows[i]["FileEXName"].ToString();

                    string FilePath = str_rootpath + str_dirDumm + savepath + "\\" + spename + "\\" + savedirpath + "\\" + filename + "." + fileexname;
                    string DirPath = str_rootpath + str_dirDumm + savepath + "\\" + spename + "\\" + savedirpath;
                    NetCMS.Common.Public.DelFile(DirPath, FilePath);
                }
                dt.Clear();
                dt.Dispose();
            }
            sc.PDels(id);
        }

        public void PLock(string id)
        {
            sc.PLock(id);
        }

        public void PUnLock(string id)
        {
            sc.PUnLock(id);
        }

        public string getSpicaelNewsNum(string id)
        {
            string newsNum = sc.getSpicaelNewsNum(id);
            return newsNum;
        }

        public string Add(NetCMS.Model.SpecialInfo sci)
        {
            return sc.Add(sci);
        }

        public int Edit(NetCMS.Model.SpecialInfo sci)
        {
            DataTable dt = sc.getSpeacilInfo(sci.SpecialID);
            if (dt != null)
            {
                string savepath = dt.Rows[0]["SavePath"].ToString();
                string spename = dt.Rows[0]["specialEName"].ToString();
                string savedirpath = dt.Rows[0]["saveDirPath"].ToString();
                string filename = dt.Rows[0]["FileName"].ToString();
                string fileexname = dt.Rows[0]["FileEXName"].ToString();

                string FilePath = str_rootpath + str_dirDumm + savepath + "\\" + spename + "\\" + savedirpath + "\\" + filename + "." + fileexname;
                string DirPath = str_rootpath + str_dirDumm + savepath + "\\" + spename + "\\" + savedirpath;
                NetCMS.Common.Public.DelFile(DirPath, FilePath);
                dt.Clear();
                dt.Dispose();
            }

            int resultl = sc.Edit(sci);
            return resultl;
        }

        public DataTable getSpeacilInfo(string id)
        {
            DataTable dt = sc.getSpeacilInfo(id);
            return dt;
        }
    }
}
