﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using NetCMS.DALFactory;
using NetCMS.Model;

namespace NetCMS.Content
{
    public class Survey
    {
        private ISurvey dal;
        public Survey()
        {
            dal = NetCMS.DALFactory.DataAccess.CreateSurvey();
        }
        #region ManageVote.aspx
        public DataTable sel_voteById(int idt, int flag)
        {
            return dal.sel_voteById(idt, flag);
        }
        public VoteTopicInfo GetTopic(int tid)
        {
            return dal.GetTopic(tid);
        }
        public IList<VoteItemInfo> GetItemsByTopic(int tid)
        {
            return dal.GetItemsByTopic(tid);
        }
        /// <summary>
        /// 取得投票主题
        /// </summary>
        /// <param name="tid"></param>
        /// <returns></returns>
        public string GetVoteTitle(int tid)
        {
            return dal.GetVoteTitle(tid);
        }
        /// <summary>
        /// 取得某IP最后投票的时间
        /// </summary>
        /// <param name="TID"></param>
        /// <param name="IPAddr"></param>
        /// <param name="UserNum">如果为null或空，则不根据用户编号搜索</param>
        /// <returns></returns>
        public object GetLastVoteTimeByIP(int TID, string IPAddr, string UserNum)
        {
            return dal.GetLastVoteTimeByIP(TID, IPAddr, UserNum);
        }
        public string GetVoteItemName(int iid)
        {
            return dal.GetVoteItemName(iid);
        }
        public DataTable sel_voteByStr(string str, int flag)
        {
            return dal.sel_voteByStr(str, flag);
        }
        public string GetUserName(string usernum)
        {
            if (usernum == null || usernum.Trim() == string.Empty)
                return string.Empty;
            else
                return dal.GetUserName(usernum);
        }
        public int del_voteSql(string CheckboxArray, int flag)
        {
            return dal.del_voteSql(CheckboxArray, flag);
        }
        public int Del_voteManage(int RID, int flag)
        {
            return dal.Del_voteManage(RID, flag);
        }

        #endregion

        #region setClass.aspx
        public bool Del_voteSql(int VID, int flag)
        {
            return dal.Del_voteSql(VID, flag);
        }
        public int Add(string Str_ClassName, string Str_Description, string SiteID)
        {
            return dal.Add(Str_ClassName, Str_Description, SiteID);
        }
        public void del_voteInfoSql(string CheckboxArray, bool flag)
        {
            dal.del_voteInfoSql(CheckboxArray, flag);
        }
        public void del_strVoteSql(int tid, int flag)
        {
            dal.del_strVoteSql(tid, flag);
        }
        public int Update_Str_InSql(string Str_ClassNameE, string Str_DescriptionE, int VID)
        {
            return dal.Update_Str_InSql(Str_ClassNameE, Str_DescriptionE, VID);
        }
        public bool del_VoteInfo(int flag)
        {
            return dal.del_VoteInfo(flag);
        }
        #endregion

        #region setItem.aspx
        public int EditItem(VoteItemInfo info)
        {
            return dal.EditItem(info);
        }
        public DataTable sel_voteInfo(int flag)
        {
            return dal.sel_voteInfo(flag);
        }
        #endregion

        #region setParam.aspx
        public int Update_Str_InSqls(int IPtime, byte IsReg, string IpLimit)
        {
            return dal.Update_Str_InSqls(IPtime,IsReg,IpLimit);
        }
        #endregion

        #region setSteps.aspx
        public int sel_Str_CheckSql(string Str_vote_CNameSe, string Str_vote_CNameUse)
        {
            return dal.sel_Str_CheckSql(Str_vote_CNameSe, Str_vote_CNameUse);
        }
        public int Add_Str_InSql(string Str_vote_CNameSe, string Str_vote_CNameUse, string Str_StepsN, string SiteID)
        {
            return dal.Add_Str_InSql(Str_vote_CNameSe, Str_vote_CNameUse, Str_StepsN, SiteID);
        }
        public int del_InfoVote(int flag)
        {
            return dal.del_InfoVote(flag);
        }
        public int update_voteSteps(string Str_votecnameEditse, string Str_votecnameEditue, string Str_NumEdit, int SID)
        {
            return dal.update_voteSteps(Str_votecnameEditse, Str_votecnameEditue, Str_NumEdit, SID);
        }
        #endregion

        #region setTitle.aspx
        public int EditTopic(VoteTopicInfo info)
        {
            return dal.EditTopic(info);
        }
        #endregion
        public void add_voteManage(int[] SelIID, int tid, string othercontent, string strvip, string UserNum)
        {
            dal.add_voteManage(SelIID, tid, othercontent, strvip, UserNum);
        }
        public int sel_IP()
        {
            return dal.sel_IP();
        }
        /// <summary>
        /// 投票统计
        /// </summary>
        /// <param name="tid"></param>
        /// <param name="totalvote"></param>
        /// <returns></returns>
        public DataTable GetVoteStat(int tid, out int totalvote)
        {
            return dal.GetVoteStat(tid, out totalvote);
        }
    }
}