﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;

namespace NetCMS.DALFactory
{
    public interface IAdminGroup
    {
        int add(NetCMS.Model.AdminGroupInfo agci);
        int Edit(NetCMS.Model.AdminGroupInfo agci);
        void Del(string id);
        DataTable getInfo(string id);
        DataTable getClassList(string col, string TbName, string sqlselect);
        DataTable getColCname(string colname, string TbName, string classid, string id);
        /// <summary>
        /// 根据管理员编号读取所属会员组编号
        /// </summary>
        /// <param name="userNum">会员编号</param>
        /// <returns></returns>
        string getAdminGroup(string userNum);
        /// <summary>
        /// 获取管理员组信息
        /// </summary>
        /// <param name="UserGroupNumber">管理员组编号</param>
        /// <returns></returns>
        IDataReader getAdminGroups(string UserGroupNumber);

        /// <summary>
        /// 判断管理员是不是超级管理员
        /// </summary>
        /// <param name="usernum"></param>
        /// <returns></returns>
        string GetAdminIsSuper(string usernum);
    }
    public sealed partial class DataAccess
    {
        public static IAdminGroup CreateAdminGroup()
        {
            string className = path + ".AdminGroup";
            return (IAdminGroup)Assembly.Load(path).CreateInstance(className);
        }
    }
}
