﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using NetCMS.Model;

namespace NetCMS.DALFactory
{
    public interface INewsJS
    {
        IList<NewsJSInfo> GetPage(int PageIndex, int PageSize, out int RecordCount, out int PageCount, int JsType);
        void Delete(string id);
        DataTable GetJSFilePage(int PageIndex, int PageSize, out int RecordCount, out int PageCount, int id);
        void RemoveNews(int id);
        NewsJSInfo GetSingle(int id);
        void Update(NewsJSInfo info);
        string Add(NewsJSInfo info);
        string GetJsTmpContent(string jstmpid);
        DataTable GetJSFiles(string jsid);
    }

    public sealed partial class DataAccess
    {
        public static INewsJS CreateNewsJS()
        {
            string className = path + ".NewsJS";
            return (INewsJS)Assembly.Load(path).CreateInstance(className);
        }
    }
}
