﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using NetCMS.Model;
using NetCMS.DALFactory;
using NetCMS.DALProfile;
using NetCMS.Config;

namespace NetCMS.DALSQLServer
{
    public class AdminGroup : DbBase, IAdminGroup
    {
        private string SiteID;
        public AdminGroup()
        {
            SiteID = NetCMS.Global.Current.SiteID;
        }
        /// <summary>
        /// 增加管理员组
        /// </summary>
        /// <param name="agci">构造参数</param>
        /// <returns></returns>
        public int add(NetCMS.Model.AdminGroupInfo agci)
        {
            string checkSql = "";
            int recordCount = 0;
            string AdminGruopNum = NetCMS.Common.Rand.Number(8);
            while (true)
            {
                checkSql = "select count(*) from " + Pre + "sys_AdminGroup where adminGroupNumber='" + AdminGruopNum + "'";
                recordCount = (int)DbHelper.ExecuteScalar(CommandType.Text, checkSql, null);
                if (recordCount < 1)
                    break;
                else
                    AdminGruopNum = NetCMS.Common.Rand.Number(12, true);
            }
            checkSql = "select count(*) from " + Pre + "sys_AdminGroup where GroupName='" + agci.GroupName + "'";
            recordCount = (int)DbHelper.ExecuteScalar(CommandType.Text, checkSql, null);
            if (recordCount > 0)
            {
                throw new Exception("管理员组名称重复,请重新添加!");
            }
            string Sql = "insert into " + Pre + "sys_AdminGroup (";
            Sql += "adminGroupNumber,GroupName,ClassList,channelList,SpecialList,CreatTime,SiteID";
            Sql += ") values ('" + AdminGruopNum + "',";
            Sql += "@GroupName,@ClassList,@channelList,@SpecialList,@CreatTime,@SiteID)";
            SqlParameter[] param = GetAdminGroupParameters(agci);
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        public int Edit(NetCMS.Model.AdminGroupInfo agci)
        {
            string str_Sql = "Update " + Pre + "sys_AdminGroup Set ClassList=@ClassList,SpecialList=@SpecialList,";
            str_Sql += "channelList=@channelList Where adminGroupNumber='" + agci.adminGroupNumber + "'";

            SqlParameter[] param = GetAdminGroupParameters(agci);
            return DbHelper.ExecuteNonQuery(CommandType.Text, str_Sql, param);
        }

        public void Del(string id)
        {
            string str_Sql = "Delete From  " + Pre + "sys_AdminGroup where adminGroupNumber='" + id + "'";
            DbHelper.ExecuteNonQuery(CommandType.Text, str_Sql, null);
        }

        public DataTable getInfo(string id)
        {
            string str_Sql = "Select adminGroupNumber,GroupName,ClassList,SpecialList,channelList From " + Pre + "sys_AdminGroup Where SiteID='" + SiteID + "' and adminGroupNumber='" + id + "'";
            return DbHelper.ExecuteTable(CommandType.Text, str_Sql, null);
        }

        public DataTable getClassList(string col, string TbName, string sqlselect)
        {
            string str_Sql = "Select " + col + " From " + Pre + TbName + " " + sqlselect + " Order By ID Asc";
            return DbHelper.ExecuteTable(CommandType.Text, str_Sql, null);
        }

        public DataTable getColCname(string colname, string TbName, string classid, string id)
        {
            string str_Sql = "Select " + colname + " From " + Pre + TbName + " Where " + classid + "='" + id + "'";
            return DbHelper.ExecuteTable(CommandType.Text, str_Sql, null);
        }

        private SqlParameter[] GetAdminGroupParameters(NetCMS.Model.AdminGroupInfo agci)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@adminGroupNumber", SqlDbType.NVarChar, 8);
            param[0].Value = agci.adminGroupNumber;
            param[1] = new SqlParameter("@GroupName", SqlDbType.NVarChar, 20);
            param[1].Value = agci.GroupName;
            param[2] = new SqlParameter("@ClassList", SqlDbType.NText);
            param[2].Value = agci.ClassList;
            param[3] = new SqlParameter("@SpecialList", SqlDbType.NText);
            param[3].Value = agci.SpecialList;

            param[4] = new SqlParameter("@channelList", SqlDbType.NText);
            param[4].Value = agci.channelList;
            param[5] = new SqlParameter("@CreatTime", SqlDbType.DateTime, 8);
            param[5].Value = agci.CreatTime;
            param[6] = new SqlParameter("@SiteID", SqlDbType.NVarChar, 12);
            param[6].Value = agci.SiteID;
            return param;
        }

        /// <summary>
        /// 根据管理员编号读取所属会员组编号
        /// </summary>
        /// <param name="userNum">会员编号</param>
        /// <returns></returns>
        public string getAdminGroup(string userNum)
        {
            SqlParameter param = new SqlParameter("@UserNum", userNum);
            string sql = "select AdminGroupNumber from NT_sys_admin where UserNum=@UserNum";
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql,param));
        }

        /// <summary>
        /// 获取管理员组信息
        /// </summary>
        /// <param name="UserGroupNumber">管理员组编号</param>
        /// <returns></returns>
        public IDataReader getAdminGroups(string UserGroupNumber)
        {
            SqlParameter param = new SqlParameter("@adminGroupNumber", UserGroupNumber);
            string sql = "select ClassList,SpecialList,channelList from " + Pre + "sys_AdminGroup where adminGroupNumber=@adminGroupNumber";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 判断管理员是不是超级管理员
        /// </summary>
        /// <param name="usernum"></param>
        /// <returns></returns>
        public string GetAdminIsSuper(string usernum)
        {
            SqlParameter param = new SqlParameter("@UserNum", usernum);
            string Sql = "select isSuper from " + Pre + "sys_Admin where UserNum=@UserNum";
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
        }
    }
}
