﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Web;
using System.IO;
using System.Data;
using System.Data.SqlClient;

namespace NetCMS.Install
{
    public class Comm
    {
        /// <summary>
        /// 获得当前绝对路径
        /// </summary>
        /// <param name="strPath">指定的路径</param>
        /// <returns>绝对路径</returns>
        public static string GetMapPath(string strPath)
        {
            if (HttpContext.Current != null)
            {
                return HttpContext.Current.Server.MapPath(strPath);
            }
            else //非web程序引用
            {
                return System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, strPath);
            }
        }


        /// <summary>
        /// 返回文件是否存在
        /// </summary>
        /// <param name="filename">文件名</param>
        /// <returns>是否存在</returns>
        public static bool FileExists(string filename)
        {
            return System.IO.File.Exists(filename);
        }


        /// <summary>
        /// 执行SQL语句
        /// </summary>
        /// <param name="connStr">数据库联接字符串</param>
        /// <param name="DatabaseName">数据库名称</param>
        /// <param name="Sql">Sql语句</param>
        public static void ExecuteSql(string connStr, string DatabaseName, string Sql)
        {
            SqlConnection conn = new SqlConnection(connStr);
            SqlCommand cmd = new SqlCommand(Sql, conn);

            conn.Open();
            conn.ChangeDatabase(DatabaseName);
            try
            {
                cmd.ExecuteNonQuery();
            }
            finally
            {
                conn.Close();
            }
        }

        /// <summary>
        /// 检查文件否具有读写删除权限  Edit By Puloon
        /// </summary>
        /// <param name="FilePath">文件路径</param>
        /// <returns>如果具有返回true否则false</returns>
        public static bool CheckFilePopedom(string FilePath)
        {
            bool b_tf = true;
            StreamReader sr = new System.IO.StreamReader(FilePath, System.Text.Encoding.UTF8);
            string s_FileContent = sr.ReadToEnd();
            sr.Close();
            try
            {
                File.Delete(FilePath);
                StreamWriter sw = new StreamWriter(FilePath, true, System.Text.Encoding.UTF8);
                sw.Write(s_FileContent);
                sw.Close();
            }
            catch (Exception e)
            {
                b_tf = false;
            }
            return b_tf;
        }


        public static string CysDir(ref bool error, string DirPath)
        {
            string s_Cresult = "";

            DirectoryInfo[] ChildDirectory;                         
            FileInfo[] fileInfo;
            DirectoryInfo Directory = new DirectoryInfo(DirPath);

            ChildDirectory = Directory.GetDirectories("*.*"); 
            fileInfo = Directory.GetFiles();               

            foreach (DirectoryInfo dirInfo in ChildDirectory)       
            {
                if (dirInfo.Name != "image" && dirInfo.Name != "css")
                {
                    s_Cresult += CysDir(ref error, DirPath + "\\" + dirInfo.Name);
                }
            }

            foreach (FileInfo DirFile in fileInfo) 
            {
                if (DirFile.Name != "finishinstall.aspx" && DirFile.Name != "Index.aspx" && DirFile.Name != "step1.aspx" && DirFile.Name != "step2.aspx" && DirFile.Name != "step3.aspx" && DirFile.Name != "step4.aspx" && DirFile.Name != "step_End.aspx")
                {
                    if (CheckFilePopedom(DirPath + "\\" + DirFile.Name) == false)
                    {
                        error = true;
                        string s_FilePath = DirPath.Replace(Comm.GetMapPath(@"..\"), "");
                        s_Cresult += "<tr style=\"height:15px\"><td bgcolor='#ffffff' width='5%'><img src='image/error.gif' width='16'" +
                                     " height='16'></td><td bgcolor='#ffffff' width='95%'>" + s_FilePath + "\\" + DirFile.Name + "没有读写" +
                                     "及删除权限,相关问题详见安装文档!</td></tr>";
                    }
                }
            }
            return s_Cresult;
        }
    }
}
