﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.IO;
using System.Text;
using System.Web;
using System.Web.UI;

namespace NetCMS.Install
{
    public class Config
    {
        public static string title = null;
        public static string corpRight = null;
        public static string style = null;
        public static string logo = null;
        public static string producename = null;
        public static string regprotocol = null;

        static Config()
        {
            title = "NETCMS V1.0 Install";
            corpRight = "<div align=\"center\" style=\"position:relative ; padding-top:60px;font-size:14px; font-family: Arial\">" +
                        "<hr style=\"height:1; width:600; height:1; color:#CCCCCC\" />Powered by NETCMS 1.7(.net Framework 2.x/3.x)" +
                        " <br />(c) 2008 <a href=\"http://www.aspxcms.com\" target=\"_blank\"><b>aspxCms Inc.</b></a></div>";
            style = "<LINK rev=\"stylesheet\" media=\"all\" href=\"css/styles.css\" type=\"text/css\" rel=\"stylesheet\">";
            logo = "<img border=\"0\" src=\"image/logo.jpg\">";
            producename = "NETCMS V1.0";

            HttpContext context = HttpContext.Current;
            string filename = null;
            if (context != null)
                filename = context.Server.MapPath("/Install/rotocol.txt");
            else
                filename = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "/Install/rotocol.txt");

            regprotocol = File.ReadAllText(filename,Encoding.Default);
        }

        public static string InitialSystemValidCheck(ref bool error)
        {
            error = false;
            StringBuilder sb = new StringBuilder();
            sb.Append("<table cellSpacing='0' cellPadding='0' width='90%' align='center' border='0' bgcolor='#666666' style='font-size:12px'>");

            HttpContext context = HttpContext.Current;

            string filename = null;
            if (context != null)
                filename = context.Server.MapPath("/Web.config");
            else
                filename = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Web.config");

            //系统BIN目录检查
            sb.Append(IISSystemBINCheck(ref error));

            //检查Web.config文件的有效性
            if (!Comm.FileExists(filename) && (!GetRootWebconfigPath()))
            {
                sb.Append("<tr style=\"height:15px\"><td bgcolor='#ffffff' width='5%'><img src='image/error.gif' width='16'" +
                          " height='16'></td><td bgcolor='#ffffff' width='95%'>系统配置文件 Web.config 没有放置正确, " +
                          "相关问题详见安装文档!</td></tr>");
                error = true;
            }
            else
            {
                if (Comm.CheckFilePopedom(filename) == false)
                {
                    sb.Append("<tr style=\"height:15px\"><td bgcolor='#ffffff' width='5%'><img src='image/error.gif' width='16'" +
                              " height='16'></td><td bgcolor='#ffffff' width='95%'>系统配置文件 Web.config 没有读写及删除权限, " +
                              "相关问题详见安装文档!</td></tr>");
                    error = true;
                }
                else
                {
                    sb.Append("<tr style=\"height:15px\"><td bgcolor='#ffffff' width='5%'><img src='image/ok.gif' " +
                              "width='16' height='16'></td><td bgcolor='#ffffff' width='95%'>系统配置文件 Web.config 验证通过!</td></tr>");
                }
            }

            //检查安装目录下各文件是否具有读写及删除权限
            sb.Append(Comm.CysDir(ref error, Comm.GetMapPath(@"..\Install")));

            sb.Append("</table>");
            return sb.ToString();
        }

        /// <summary>
        /// 检查BIN目录内DLL是否完整
        /// </summary>
        /// <param name="error"></param>
        /// <returns></returns>
        public static string IISSystemBINCheck(ref bool error)
        {
            string binfolderpath = HttpRuntime.BinDirectory;

            string result = "";
            try
            {
                string[] assemblylist = new string[] { "NetCMS.Content.dll", "NetCMS.Common.dll", "NetCMS.Config.dll", "NetCMS.Control.dll" ,
                                                    "NetCMS.DALFactory.dll","NetCMS.DALProfile.dll","NetCMS.Global.dll","NetCMS.Model.dll",
                                                    "NetCMS.Publish.dll","NetCMS.DALSQLServer.dll","NetCMS.Web.dll","NetCMS.Web.UI.dll",
                                                    "Intelligencia.UrlRewriter.dll","Interop.ADODB.dll","Interop.JRO.dll",
                                                    "Ajax.dll","CBMD5.dll"};
                foreach (string assembly in assemblylist)
                {
                    if (!File.Exists(binfolderpath + assembly))
                    {
                        result += "<tr><td bgcolor='#ffffff' width='5%'><img src='image/error.gif' width='16' height='16'>" +
                                  "</td><td bgcolor='#ffffff' width='95%'>" + assembly + " 文件放置不正确<br/>请将所有的dll文件复制" +
                                  "到目录 " + binfolderpath + " 中.</td></tr>";
                        error = true;
                    }
                    else
                    {
                        result += "<tr><td bgcolor='#ffffff' width='5%'><img src='image/ok.gif' width='16' height='16'>" +
                                  "</td><td bgcolor='#ffffff' width='95%'>" + assembly + " 文件放置正确.</td></tr>";
                    }
                }
            }
            catch
            {
                result += "<tr><td bgcolor='#ffffff' width='5%'><img src='image/error.gif' width='16' height='16'>" +
                          "</td><td bgcolor='#ffffff' width='95%'>请将所有的dll文件复制到目录 " + binfolderpath + " 中.</td></tr>";
                error = true;
            }
            return result;
        }

        /// <summary>
        /// 检查Web.config
        /// </summary>
        /// <returns></returns>
        public static bool GetRootWebconfigPath()
        {
            try
            {
                HttpContext context = HttpContext.Current;
                string webconfigpath = Path.Combine(context.Request.PhysicalApplicationPath, "web.config");

                //如果文件不存在退出
                if (!Comm.FileExists(webconfigpath))
                {
                    return false;
                }
                else
                {
                    return true;
                }
            }
            catch
            {
                return false;
            }
        }

        public static bool SystemFolderCheck(string foldername)
        {
            string physicsPath = Comm.GetMapPath(@"..\" + foldername);
            try
            {
                using (FileStream fs = new FileStream(physicsPath + "\\a.txt", FileMode.Create, FileAccess.ReadWrite, FileShare.ReadWrite))
                {
                    fs.Close();
                }

                System.IO.File.Delete(physicsPath + "\\a.txt");

                return true;
            }
            catch
            {
                return false;
            }
        }

    }


}
