﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using NetCMS.Config;
using NetCMS.DALFactory;
using NetCMS.Model;

namespace NetCMS.Publish
{
    public class CommonData
    {
        private static NetCMS.DALFactory.IPublish dal;
        private static readonly object LockPad = new object();
        public static NetCMS.DALFactory.IPublish DalPublish
        {
            get
            {
                if (dal == null)
                    dal = DataAccess.CreatePublish();
                return dal;
            }
        }
        public static IList<PubClassInfo> NewsClass = new List<PubClassInfo>();
        public static IList<PubSpecialInfo> NewsSpecial = new List<PubSpecialInfo>();
        public static IList<PubCHClassInfo> CHClass = new List<PubCHClassInfo>();
        public static IList<PubCHSpecialInfo> CHSpecial = new List<PubCHSpecialInfo>();
        /// <summary>
        /// 取得网站域名的根目录(绝对路径及相对路径)
        /// </summary>
        public static string SiteDomain;

        public static string getUrl()
        {
            string flg = "";
            string dirdumm = NetCMS.Config.UIConfig.dirDumm;

            if (dirdumm != "" && dirdumm != null)
                dirdumm = "/" + dirdumm;
            string linkType = NetCMS.Common.Public.readparamConfig("linkTypeConfig");
            string sitedomain = NetCMS.Common.Public.readparamConfig("siteDomain");
            if (linkType == "1")
            {
                if (sitedomain.IndexOf("http://") > -1) { flg = sitedomain + dirdumm; }
                else { flg = "http://" + sitedomain + dirdumm; }
            }
            else { flg = dirdumm; }
            //rd.Close();
            return flg;
        }
        /// <summary>
        /// 初始化数据函数
        /// </summary>
        /// <param name="cn"></param>
        public static void Initialize()
        {
            SiteDomain = getUrl();
            NewsClass.Clear();
            NewsSpecial.Clear();
            NewsClass = CommonData.DalPublish.GetClassList();
            CHClass = CommonData.DalPublish.GetCHClassList();
            NewsSpecial = CommonData.DalPublish.GetSpecialList();
            CHSpecial = CommonData.DalPublish.GetCHSpecialList();
        }
        /// <summary>
        /// 取得栏目的相关信息,必须是没有放在回收站中的
        /// </summary>
        public static PubClassInfo GetClassById(string classid)
        {
            foreach (PubClassInfo cl in NewsClass)
            {
                if (cl.ClassID.Equals(classid))
                    return cl;
            }
            return null;
        }

        /// <summary>
        /// 取得频道栏目的相关信息
        /// </summary>
        public static PubCHClassInfo GetCHClassById(int ID)
        {
            foreach (PubCHClassInfo ccl in CHClass)
            {
                if (ccl.Id.Equals(ID))
                    return ccl;
            }
            return null;
        }

        /// <summary>
        /// 取得专题的相关信息,必须是没有放在回收站中的
        /// </summary>
        public static PubSpecialInfo GetSpecial(string specialid)
        {
            foreach (PubSpecialInfo sp in NewsSpecial)
            {
                if (sp.SpecialID.Equals(specialid))
                    return sp;
            }
            return null;
        }

        /// <summary>
        /// 取得专题的相关信息,必须是没有放在回收站中的
        /// </summary>
        public static PubCHSpecialInfo GetCHSpecial(int ID)
        {
            foreach (PubCHSpecialInfo sp in CHSpecial)
            {
                if (sp.Id.Equals(ID))
                    return sp;
            }
            return null;
        }

        public string getNewsURLFormID(string NewsID, string DataLib)
        {
            string URLSTR = "";
            string ReadType = NetCMS.Common.Public.readparamConfig("ReviewType");
            IDataReader rd = DalPublish.GetNewsInfoAndClassInfo(NewsID, DataLib);
            if (rd.Read())
            {
                if (rd["NewsType"].ToString() == "2")
                {
                    URLSTR = rd["URLaddress"].ToString();
                }
                else
                {
                    if (rd["isDelPoint"].ToString() != "0")
                    {
                        URLSTR = "/Content.aspx?id=" + NewsID;
                    }
                    else
                    {
                        if (ReadType == "1")
                        {
                            URLSTR = "/Content.aspx?id=" + NewsID;
                        }
                        else
                        {
                            URLSTR = rd["SavePath1"].ToString() + "/" + rd["SaveClassframe"] + "/" + rd["SavePath"].ToString() + "/" + rd["FileName"].ToString() + rd["FileEXName"].ToString();
                        }
                    }
                    URLSTR = URLSTR.Replace("//", "/");
                    URLSTR = getUrl() + URLSTR;
                }
            }
            rd.Close();
            return URLSTR;
        }
    }
}
