//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.IO;
using System.Configuration;
using System.Text.RegularExpressions;
using NetCMS.Config;
using NetCMS.Model;

namespace NetCMS.Publish
{
    public class General
    {
        public static string strgTemplet = NetCMS.Config.UIConfig.dirTemplet;
        public static string RootInstallDir = NetCMS.Publish.CommonData.SiteDomain;
        public static string InstallDir = "{$InstallDir}";
        public static string TempletDir = "{$TempletDir}";
        /// <summary>
        /// дHTMLļ
        /// </summary>
        /// <param name="Content"></param>
        /// <param name="FilePath">·</param>
        public static void WriteHtml(string Content, string FilePath)
        {
            string getContent = "";
            string getajaxJS = "<script language=\"javascript\" type=\"text/javascript\" src=\"" + CommonData.SiteDomain + "/configuration/js/Prototype.js\"></script>\r\n";
            getajaxJS += "<script language=\"javascript\" type=\"text/javascript\" src=\"" + CommonData.SiteDomain + "/configuration/js/jspublic.js\"></script>\r\n";
            getajaxJS += "<script language=\"javascript\" type=\"text/javascript\" src=\"" + CommonData.SiteDomain + "/configuration/js/public.js\"></script>\r\n";
            string byCreat = "<!--Created by NETCMS v1.0 at " + DateTime.Now + "-->\r\n";
            try
            {
                string Dir = FilePath.Substring(0, FilePath.LastIndexOf("\\"));
                if (!Directory.Exists(Dir))
                    Directory.CreateDirectory(Dir);
                using (StreamWriter sw = new StreamWriter(FilePath, false))
                {
                    if (Regex.Match(Content, @"\</head\>[\s\S]*\<body", RegexOptions.IgnoreCase | RegexOptions.Compiled).Success)
                    {
                        getContent = Regex.Replace(Content, "<body", getajaxJS + byCreat + "<body", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    }
                    else
                    {
                        getContent = getajaxJS + byCreat + Content;
                    }
                    //滻
                    getContent = (getContent.Replace(InstallDir, RootInstallDir)).Replace(TempletDir, strgTemplet);
                    sw.Write(getContent);
                    sw.Dispose();
                }
            }
            catch
            { }
        }
        /// <summary>
        /// ļ
        /// </summary>
        /// <param name="Path">Ŀ¼·</param>
        public static void CreateDirectory(string Path)
        {
            if (!Directory.Exists(Path))
                Directory.CreateDirectory(Path);
        }
        /// <summary>
        /// ȡHTMLļ
        /// </summary>
        /// <param name="Path">·</param>
        /// <returns></returns>
        public static string ReadHtml(string Path)
        {
            string result = string.Empty;
            if (File.Exists(Path))
            {
                try
                {
                    using (StreamReader sr = new StreamReader(Path))
                    {
                        result = sr.ReadToEnd();
                    }
                }
                catch
                { }
            }
            else
            {
                result = "ģ岻!";
            }
            return result;
        }
        /// <summary>
        /// Web.ConfigȡĿ¼
        /// </summary>
        /// <returns></returns>
        public static string VirtualDir()
        {
            return System.Configuration.ConfigurationManager.AppSettings["dirDumm"];
        }

        /// <summary>
        /// ĿXML
        /// </summary>
        /// <param name="ClassID"></param>
        /// <returns></returns>
        public static bool publishXML(string ClassID)
        {
            bool state = false;
            try
            {
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string xmlSTR = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
                xmlSTR += "<?xml-stylesheet type=\"text/css\" href=\"" + CommonData.SiteDomain + "/sysImages/css/rss.css\"?>\r\n";
                xmlSTR += "<rss version=\"2.0\">\r\n";
                xmlSTR += "<channel>\r\n";
                DataTable dt = CommonData.DalPublish.GetLastNews(50, ClassID);
                string ClassEname = "none";
                if (dt != null && dt.Rows.Count > 0)
                {
                    string ClassSTR = "/" + dt.Rows[0]["savepath1"].ToString() + "/" + dt.Rows[0]["SaveClassframe"].ToString() + "/" + dt.Rows[0]["ClassSaveRule"];
                    if (ClassID == "0")
                    {
                        xmlSTR += "<title>RSS</title>\r\n";
                        xmlSTR += "<link>" + CommonData.SiteDomain + "/xml/Content/all/news.xml</link>\r\n";
                    }
                    else
                    {
                        xmlSTR += "<title>" + dt.Rows[0]["ClassCName"].ToString() + "</title>\r\n";
                        xmlSTR += "<link>" + CommonData.SiteDomain + ClassSTR.Replace("//", "/") + "</link>\r\n";
                    }
                    xmlSTR += "<description>RSS_by NetCMS for aspxcms Inc.</description>\r\n";
                    ClassEname = dt.Rows[0]["ClassEName"].ToString();
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        xmlSTR += "<item id=\"" + (i + 1) + "\">\r\n";
                        xmlSTR += "<title><![CDATA[" + dt.Rows[i]["NewsTitle"].ToString() + "]]></title>\r\n";
                        string linkstr = CommonData.SiteDomain + "/" + dt.Rows[i]["savepath1"].ToString() + "/" + dt.Rows[i]["SaveClassframe"].ToString() + "/" + dt.Rows[i]["FileName"].ToString() + dt.Rows[i]["FileEXName"].ToString();
                        xmlSTR += "<link>" + linkstr.Replace("//", "/") + "</link>\r\n";
                        string ContentSTR = dt.Rows[i]["Content"].ToString();
                        if (ContentSTR != string.Empty && ContentSTR != null)
                        {
                            xmlSTR += "<description><![CDATA[" + NetCMS.Common.Input.FilterHTML(NetCMS.Common.Input.GetSubString(ContentSTR, 200)) + "]]></description>\r\n";
                        }
                        else
                        {
                            xmlSTR += "<description><![CDATA[]]></description>\r\n";
                        }
                        xmlSTR += "<pubDate>" + dt.Rows[i]["CreatTime"].ToString() + "</pubDate>\r\n";
                        xmlSTR += "</item>\r\n";
                    }
                    xmlSTR += "</channel>\r\n";
                    xmlSTR += "</rss>\r\n";
                    string filePath = SiteRootPath + "\\xml\\Content\\" + ClassEname + ".xml";
                    if (ClassID == "0")
                    {
                        filePath = SiteRootPath + "\\xml\\Content\\all\\news.xml";
                    }

                    using (StreamWriter sw = new StreamWriter(filePath, false))
                    {
                        sw.Write(xmlSTR);
                        sw.Dispose();
                    }
                    state = true;
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ĿXML", "ClassID:" + ClassID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// ƵĿXML
        /// </summary>
        /// <param name="ClassID"></param>
        /// <returns></returns>
        public static bool publishCHXML(int ClassID, int ChID)
        {
            bool state = false;
            try
            {
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string xmlSTR = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
                xmlSTR += "<?xml-stylesheet type=\"text/css\" href=\"" + CommonData.SiteDomain + "/sysImages/css/rss.css\"?>\r\n";
                xmlSTR += "<rss version=\"2.0\">\r\n";
                xmlSTR += "<channel>\r\n";
                DataTable dt = CommonData.DalPublish.GetLastCHNews(50, ClassID, ChID);
                string ClassEname = "none";
                string dirHTML = NetCMS.Common.Public.readCHparamConfig("htmldir", ChID);
                dirHTML = dirHTML.Replace("{@dirHTML}", NetCMS.Config.UIConfig.dirHtml);
                if (dt != null && dt.Rows.Count > 0)
                {
                    string ClassSTR = "/" + dirHTML + "/" + dt.Rows[0]["savepath1"].ToString() + "/" + dt.Rows[0]["fileName"].ToString();
                    ClassSTR = ClassSTR.Replace("//", "/");
                    if (ClassID == 0)
                    {
                        xmlSTR += "<title>RSS</title>\r\n";
                        xmlSTR += "<link>" + CommonData.SiteDomain + "/xml/channel/" + ChID + "_index.xml</link>\r\n";
                    }
                    else
                    {
                        xmlSTR += "<title>" + dt.Rows[0]["ClassCName"].ToString() + "</title>\r\n";
                        xmlSTR += "<link>" + CommonData.SiteDomain + ClassSTR.Replace("//", "/") + "</link>\r\n";
                    }
                    xmlSTR += "<description>RSS_by NetCMS for aspxcms Inc.</description>\r\n";
                    ClassEname = dt.Rows[0]["ClassEName"].ToString();
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        xmlSTR += "<item id=\"" + (i + 1) + "\">\r\n";
                        xmlSTR += "<title><![CDATA[" + dt.Rows[i]["Title"].ToString() + "]]></title>\r\n";
                        string linkstr = "/" + dirHTML + "/" + dt.Rows[i]["savepath1"].ToString() + "/" + dt.Rows[i]["SavePath"].ToString() + "/" + dt.Rows[i]["FileName"].ToString();
                        xmlSTR += "<link>" + CommonData.SiteDomain + linkstr.Replace("//", "/") + "</link>\r\n";
                        string ContentSTR = dt.Rows[i]["Content"].ToString();
                        if (ContentSTR != string.Empty && ContentSTR != null)
                        {
                            xmlSTR += "<description><![CDATA[" + NetCMS.Common.Input.FilterHTML(NetCMS.Common.Input.GetSubString(ContentSTR, 200)) + "]]></description>\r\n";
                        }
                        else
                        {
                            xmlSTR += "<description><![CDATA[]]></description>\r\n";
                        }
                        xmlSTR += "<pubDate>" + dt.Rows[i]["CreatTime"].ToString() + "</pubDate>\r\n";
                        xmlSTR += "</item>\r\n";
                    }
                    xmlSTR += "</channel>\r\n";
                    xmlSTR += "</rss>\r\n";
                    string filePath = SiteRootPath + "\\xml\\channel\\" + ChID + "_" + dt.Rows[0]["id1"].ToString() + ".xml";
                    if (ClassID == 0)
                    {
                        filePath = SiteRootPath + "\\xml\\channel\\" + ChID + "_index.xml";
                    }

                    using (StreamWriter sw = new StreamWriter(filePath, false))
                    {
                        sw.Write(xmlSTR);
                        sw.Dispose();
                    }
                    state = true;
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ĿXML,ƵID" + ChID + "", "ClassID:" + ClassID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// ɹ鵵
        /// </summary>
        /// <param name="ClassID"></param>
        /// <returns></returns>
        public static bool publishHistryIndex(int Numday)
        {
            bool state = false;
            try
            {
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string historydir = NetCMS.Config.UIConfig.dirPige;
                string dimm = NetCMS.Config.UIConfig.dirDumm;
                string dirTemplet = NetCMS.Config.UIConfig.dirTemplet;
                if (dimm.Trim() != string.Empty)
                {
                    dimm = "/" + dimm;
                }
                DataTable dt = CommonData.DalPublish.Gethistory(Numday);
                if (dt != null && dt.Rows.Count > 0)
                {
                    string TempletPath = "/{@dirtemplet}/Content/indexPage.html";
                    TempletPath = TempletPath.Replace("/", "\\").ToLower();
                    TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", dirTemplet);
                    TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                    string Content = ReadHtml(TempletPath);
                    string liststr = "";
                    string urls = "";
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        urls = dimm + "/history-" + dt.Rows[i]["newsid"].ToString() + ".aspx";
                        urls = urls.Replace("//", "/");
                        liststr += "<li><a href=\"" + urls + "\">" + dt.Rows[i]["NewsTitle"].ToString() + "</a></li>";
                    }
                    Content = Content.Replace("{#history_list}", liststr);
                    Content = Content.Replace("{#history_PageTitle}", "ʷѯ__" + DateTime.Now.AddDays((-Numday)).ToShortDateString() + "");
                    string filePath = SiteRootPath + historydir + "\\" + getResultPage(NetCMS.Common.Public.readparamConfig("SaveIndexPage"), DateTime.Now.AddDays((-Numday)), "", "history") + "\\index.html";
                    dt.Clear(); dt.Dispose();
                    WriteHtml(Content, filePath);
                    state = true;
                }

            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ʷĵ", "\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }


        /// <summary>
        /// ҳ棬ʺÿÿĿ10վ
        /// </summary>
        /// <param name="ClassID"></param>
        /// <returns></returns>
        public static bool publishClassIndex(string ClassID)
        {
            CommonData.Initialize();
            bool state = false;
            try
            {
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string historydir = NetCMS.Config.UIConfig.dirPige;
                string dimm = NetCMS.Config.UIConfig.dirDumm;
                string dirTemplet = NetCMS.Config.UIConfig.dirTemplet;
                PubClassInfo info = CommonData.GetClassById(ClassID);
                if (info != null)
                {
                    string TempletPath = info.ClassTemplet;
                    TempletPath = TempletPath.Replace("/", "\\").ToLower();
                    TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", dirTemplet);
                    TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                    Template newsTemplate = new Template(TempletPath, TempType.Class);
                    newsTemplate.NewsID = null;
                    newsTemplate.ClassID = ClassID;
                    newsTemplate.GetHTML();
                    newsTemplate.ReplaceLabels();
                   
                    newsTemplate.ReplaceIMLabels();
                    string filePath = SiteRootPath + historydir + "\\" + getResultPage(info.ClassIndexRule, DateTime.Now, ClassID, info.ClassEName) + "\\" + info.ClassEName + ".html";
                    string p1js = "<span style=\"text-align:center;\" id=\"gPtypenowdiv" + DateTime.Now.ToShortDateString() + "\">...</span>";
                    p1js += "<script language=\"javascript\" type=\"text/javascript\">";
                    p1js += "pubajax('/configuration/system/public.aspx','NowStr=" + DateTime.Now.ToShortDateString() + "&ruleStr=1','gPtypenowdiv" + DateTime.Now.ToShortDateString() + "');";
                    p1js += "</script>";
                    WriteHtml(newsTemplate.FinallyContent.Replace("{NT:NewsLIST}", "").Replace("{/NT:NewsLIST}", "").Replace("{$NT:P1}", p1js), filePath);
                }
                state = true;
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ", "ClassID:" + ClassID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// ɵҳ
        /// </summary>
        /// <returns></returns>
        public static bool publishPage(string ClassID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveNewsPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                string dim = NetCMS.Config.UIConfig.dirDumm;
                IDataReader rd = CommonData.DalPublish.GetSinglePageClass(ClassID);
                while (rd.Read())
                {
                    TempletPath = rd.GetString(0);
                    TempletPath = TempletPath.Replace("/", "\\").ToLower();
                    TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                    TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                    saveNewsPath = rd["SavePath"].ToString();
                    Template newsTemplate = new Template(TempletPath, TempType.Class);
                    newsTemplate.NewsID = null;
                    newsTemplate.ClassID = ClassID;
                    newsTemplate.GetHTML();
                    newsTemplate.ReplaceLabels();
                    newsTemplate.ReplaceIMLabels();
                    string finallyContent = newsTemplate.FinallyContent;
                    finallyContent = finallyContent.Replace("{#Page_Title}", rd["ClassCName"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_MetaKey}", rd["MetaKeywords"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_MetaDesc}", rd["MetaDescript"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_Content}", rd["PageContent"].ToString());
                    if (dim.Trim() != string.Empty)
                    {
                        dim = "/" + dim;
                    }
                    finallyContent = finallyContent.Replace("{#Page_Navi}", "<a href=\"" + dim + "/\">ҳ</a> >> " + rd["ClassCName"].ToString());
                    WriteHtml(finallyContent, SiteRootPath + saveNewsPath);
                    state = true;
                }
                rd.Close();
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ɵҳ", "ClassID:" + ClassID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// ɵҳ(Ƶ)
        /// </summary>
        /// <returns></returns>
        public static bool publishChPage(int ClassID, int ChID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveNewsPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                string dim = NetCMS.Config.UIConfig.dirDumm;
                IDataReader rd = CommonData.DalPublish.GetSingleCHPageClass(ClassID);
                while (rd.Read())
                {
                    TempletPath = rd.GetString(0);
                    TempletPath = TempletPath.Replace("/", "\\").ToLower();
                    TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                    TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                    saveNewsPath = rd["SavePath"].ToString() + rd["FileName"].ToString();
                    saveNewsPath = saveNewsPath.Replace("//", "");
                    Template newsTemplate = new Template(TempletPath, TempType.ChClass);
                    newsTemplate.CHNewsID = 0;
                    newsTemplate.CHClassID = ClassID;
                    newsTemplate.ChID = ChID;
                    newsTemplate.GetHTML();
                    newsTemplate.ReplaceLabels();
                    newsTemplate.ReplaceIMLabels();
                    string finallyContent = newsTemplate.FinallyContent;
                    finallyContent = finallyContent.Replace("{#Page_Title}", rd["ClassCName"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_MetaKey}", rd["KeyMeta"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_MetaDesc}", rd["DescMeta"].ToString());
                    finallyContent = finallyContent.Replace("{#Page_Content}", rd["PageContent"].ToString());
                    if (dim.Trim() != string.Empty)
                    {
                        dim = "/" + dim;
                    }
                    finallyContent = finallyContent.Replace("{#Page_Navi}", "<a href=\"" + dim + "/\">ҳ</a> >>  >> " + rd["ClassCName"].ToString());
                    WriteHtml(finallyContent, SiteRootPath + saveNewsPath);
                    state = true;
                }
                rd.Close();
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ɵҳ,ƵID:" + ChID + "", "ClassID:" + ClassID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="classID">ŵID</param>
        /// <param name="classID">ĿID</param>
        /// <returns>ɹ־</returns>
        public static bool publishSingleNews(string newsID, string classID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveNewsPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                IDataReader rd = CommonData.DalPublish.GetNewsSavePath(newsID);
                while (rd.Read())
                {
                    if (rd["isDelPoint"].ToString() == "0")
                    {
                        TempletPath = rd["templet"].ToString();
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                        saveNewsPath = "\\" + rd["SavePath1"].ToString().Trim('\\').Trim('/') + "\\" + rd["SaveClassframe"].ToString().Trim('\\').Trim('/') + "\\" + rd["SavePath"].ToString().Trim('\\').Trim('/') + "\\" + rd["FileName"].ToString().Trim('\\').Trim('/') + rd["FileEXName"].ToString().Trim('\\').Trim('/');
                        Template newsTemplate = new Template(TempletPath, TempType.News);
                        newsTemplate.NewsID = newsID;
                        newsTemplate.ClassID = classID;
                        newsTemplate.GetHTML();
                        newsTemplate.ReplaceLabels();
                        newsTemplate.ReplaceIMLabels();
                        string FinlContent = newsTemplate.FinallyContent;
                        if (newsTemplate.MyTempType == TempType.News)
                        {
                            int pos1 = FinlContent.IndexOf("<!-NT:STAR=");
                            int pos2 = FinlContent.IndexOf("NT:END->");
                            if (pos1 > -1)
                            {
                                int getFiledot = saveNewsPath.LastIndexOf(".");
                                int getFileg = saveNewsPath.LastIndexOf("\\");
                                string getFileName = saveNewsPath.Substring((getFileg + 1), ((getFiledot - getFileg) - 1));
                                string getFileEXName = saveNewsPath.Substring(getFiledot);
                                string PageHead = FinlContent.Substring(0, pos1);
                                string PageEnd = FinlContent.Substring(pos2 + 8);
                                string PageMid = FinlContent.Substring(pos1 + 11, pos2 - pos1 - 11);
                                string[] ArrayCon = PageMid.Split(new string[] { "[NT:PAGE]" }, StringSplitOptions.RemoveEmptyEntries);
                                int n = ArrayCon.Length;
                                //if (ArrayCon[n - 1] == null || ArrayCon[n - 1].Trim() == string.Empty)
                                //    n--;
                                for (int i = 0; i < n; i++)
                                {
                                    string filepath = SiteRootPath + saveNewsPath;
                                    if (i > 0)
                                    {
                                        int laspot = filepath.LastIndexOf('.');
                                        filepath = filepath.Substring(0, laspot) + "_" + (i + 1) + filepath.Substring(laspot);
                                    }
                                    string PageContent = PageHead + ArrayCon[i] + PageEnd;
                                    string getFileContent = ReplaceResultPage(rd["NewsID"].ToString(), PageContent.Replace("[NT:PAGE]", "").Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), getFileName, getFileEXName, n, (i + 1), 0);
                                    WriteHtml(getFileContent, filepath);
                                }
                            }
                            else
                            {
                                WriteHtml(FinlContent.Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), SiteRootPath + saveNewsPath);
                            }
                        }
                        state = true;
                    }
                    else
                    {
                        state = false;
                    }
                }
                rd.Close();
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ", "NewsID:" + newsID + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// Ϣ(Ƶ)
        /// </summary>
        public static bool publishCHSingleNews(int newsID, int classID, int ChID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveNewsPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                IDataReader rd = CommonData.DalPublish.GetCHNewsSavePath(newsID, ChID);
                while (rd.Read())
                {
                    if (rd["isDelPoint"].ToString() == "0")
                    {
                        TempletPath = rd["templet"].ToString();
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                        string dirHTML = NetCMS.Common.Public.readCHparamConfig("htmldir", ChID);
                        dirHTML = dirHTML.Replace("{@dirHTML}", NetCMS.Config.UIConfig.dirHtml);
                        saveNewsPath = "\\" + dirHTML.Trim('\\').Trim('/') + "\\" + rd["SavePath1"].ToString().Trim('\\').Trim('/') + "\\" + rd["SavePath"].ToString().Trim('\\').Trim('/') + "\\" + rd["FileName"].ToString().Trim('\\').Trim('/');
                        Template newsTemplate = new Template(TempletPath, TempType.ChNews);
                        newsTemplate.CHNewsID = newsID;
                        newsTemplate.CHClassID = classID;
                        newsTemplate.ChID = ChID;
                        newsTemplate.GetHTML();
                        newsTemplate.ReplaceLabels();
                        newsTemplate.ReplaceIMLabels();
                        string FinlContent = newsTemplate.FinallyContent;
                        if (newsTemplate.MyTempType == TempType.ChNews)
                        {
                            int pos1 = FinlContent.IndexOf("<!-NT:STAR=");
                            int pos2 = FinlContent.IndexOf("NT:END->");
                            if (pos1 > -1)
                            {
                                int getFiledot = saveNewsPath.LastIndexOf(".");
                                int getFileg = saveNewsPath.LastIndexOf("\\");
                                string getFileName = saveNewsPath.Substring((getFileg + 1), ((getFiledot - getFileg) - 1));
                                string getFileEXName = saveNewsPath.Substring(getFiledot);
                                string PageHead = FinlContent.Substring(0, pos1);
                                string PageEnd = FinlContent.Substring(pos2 + 8);
                                string PageMid = FinlContent.Substring(pos1 + 11, pos2 - pos1 - 11);
                                string[] ArrayCon = PageMid.Split(new string[] { "[NT:PAGE]" }, StringSplitOptions.RemoveEmptyEntries);
                                int n = ArrayCon.Length;
                                for (int i = 0; i < n; i++)
                                {
                                    string filepath = SiteRootPath + saveNewsPath;
                                    if (i > 0)
                                    {
                                        int laspot = filepath.LastIndexOf('.');
                                        filepath = filepath.Substring(0, laspot) + "_" + (i + 1) + filepath.Substring(laspot);
                                    }
                                    string PageContent = PageHead + ArrayCon[i] + PageEnd;
                                    string getFileContent = ReplaceResultPage(rd["id"].ToString(), PageContent.Replace("[NT:PAGE]", "").Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), getFileName, getFileEXName, n, (i + 1), 0);
                                    WriteHtml(getFileContent, filepath);
                                }
                            }
                            else
                            {
                                WriteHtml(FinlContent.Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), SiteRootPath + saveNewsPath);
                            }
                        }
                        state = true;
                    }
                    else
                    {
                        state = false;
                    }
                }
                rd.Close();
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" (ƵID" + ChID + ")", "ID:" + newsID.ToString() + "\r\n\r\n" + e.ToString(), "");
                state = false;
            }
            return state;
        }

        /// <summary>
        /// Ŀ
        /// </summary>
        /// <param name="classID">ĿID</param>
        /// <returns>ɹ־</returns>
        public bool publishSingleClass(string classID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveClassPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath();
                string strTempletDir = strgTemplet;
                PubClassInfo info = CommonData.GetClassById(classID);
                if (info != null)
                {
                    if (info.isDelPoint == 0)
                    {
                        TempletPath = info.ClassTemplet;
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                        string TMPSavePath = info.SavePath.Trim();
                        if (TMPSavePath.Substring(0, 1) != "/")
                        {
                            TMPSavePath = "\\" + TMPSavePath;
                        }
                        saveClassPath = (TMPSavePath + "\\" + info.SaveClassframe + '\\' + info.ClassSaveRule.Trim()).Replace("/", @"\\");
                        Template classTemplate = new Template(TempletPath, TempType.Class);
                        classTemplate.ClassID = classID;
                        classTemplate.GetHTML();
                        string TmpPath = SiteRootPath + saveClassPath;
                        replaceTempg(classTemplate, TmpPath, classID, "class");
                        state = true;
                    }
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" Ŀ", "classID:" + classID + "\r\n\r\n" + e.ToString(), "");
            }
            return state;
        }

        /// <summary>
        /// Ŀ(Ƶ)
        /// </summary>
        public bool publishCHSingleClass(int classID, int ChID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveClassPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath();
                string strTempletDir = strgTemplet;
                PubCHClassInfo info = CommonData.GetCHClassById(classID);
                if (info != null)
                {
                    if (info.isDelPoint == 0)
                    {
                        TempletPath = info.Templet;
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                        string TMPSavePath = info.SavePath.Trim();
                        string dirHTML = NetCMS.Common.Public.readCHparamConfig("htmldir", ChID);
                        dirHTML = dirHTML.Replace("{@dirHTML}", NetCMS.Config.UIConfig.dirHtml);
                        TMPSavePath = dirHTML + "/" + TMPSavePath;
                        TMPSavePath = TMPSavePath.Replace("//", "/");
                        if (TMPSavePath.Substring(0, 1) != "/")
                        {
                            TMPSavePath = "\\" + TMPSavePath;
                        }
                        saveClassPath = (TMPSavePath + "\\" + info.FileName.Trim()).Replace("/", @"\\");
                        Template classTemplate = new Template(TempletPath, TempType.ChClass);
                        classTemplate.CHClassID = classID;
                        classTemplate.ChID = ChID;
                        classTemplate.GetHTML();
                        string TmpPath = SiteRootPath + saveClassPath;
                        replaceTempg(classTemplate, TmpPath, classID.ToString(), "class");
                        state = true;
                    }
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" Ŀ,ƵID" + ChID + "", "classID:" + classID.ToString() + "\r\n\r\n" + e.ToString(), "");
            }
            return state;
        }
        /// <summary>
        /// ר
        /// </summary>
        /// <param name="specialID">רID</param>
        /// <returns>ɹ־</returns>
        public bool publishSingleSpecial(string specialID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveSpecialPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                PubSpecialInfo info = CommonData.GetSpecial(specialID);
                if (info != null)
                {
                    if (info.isDelPoint == 0)
                    {
                        TempletPath = info.Templet;
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                        saveSpecialPath = "\\" + info.SavePath.Trim('\\').Trim('/') + "\\" + info.saveDirPath.Trim('\\').Trim('/') + '\\' + info.FileName + info.FileEXName;
                        Template specialTemplate = new Template(TempletPath, TempType.Special);
                        specialTemplate.SpecialID = specialID;
                        specialTemplate.GetHTML();
                        specialTemplate.ReplaceLabels();
                        specialTemplate.ReplaceIMLabels();
                        replaceTempg(specialTemplate, SiteRootPath + saveSpecialPath, specialID, "special");
                        state = true;
                    }
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ר", "specialID:" + specialID + "\r\n\r\n" + e.ToString(), "");
            }
            return state;
        }

        /// <summary>
        /// ר(Ƶ)
        /// </summary>
        public bool publishCHSingleSpecial(int specialID, int ChID)
        {
            bool state = false;
            try
            {
                CommonData.Initialize();
                string saveSpecialPath = string.Empty;
                string TempletPath = string.Empty;
                string SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
                string strTempletDir = strgTemplet;
                PubCHSpecialInfo info = CommonData.GetCHSpecial(specialID);
                if (info != null)
                {
                    TempletPath = info.templet;
                    TempletPath = TempletPath.Replace("/", "\\");
                    TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                    string dirHTML = NetCMS.Common.Public.readCHparamConfig("htmldir", ChID);
                    dirHTML = dirHTML.Replace("{@dirHTML}", NetCMS.Config.UIConfig.dirHtml);
                    TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                    saveSpecialPath = dirHTML.Trim('\\').Trim('/') + "\\" + info.savePath.Trim('\\').Trim('/') + '\\' + info.filename;
                    Template specialTemplate = new Template(TempletPath, TempType.Chspecial);
                    specialTemplate.CHSpecialID = specialID;
                    specialTemplate.ChID = ChID;
                    specialTemplate.GetHTML();
                    specialTemplate.ReplaceLabels();
                    specialTemplate.ReplaceIMLabels();
                    replaceTempg(specialTemplate, SiteRootPath + saveSpecialPath, specialID.ToString(), "special");
                    state = true;
                }
            }
            catch (Exception e)
            {
                NetCMS.Common.Public.savePublicLogFiles(" ר,ƵID:" + ChID + "", "specialID:" + specialID + "\r\n\r\n" + e.ToString(), "");
            }
            return state;
        }


        /// <summary>
        /// ģ
        /// </summary>
        /// <param name="tempRe">ģʵ</param>
        public void replaceTempg(Template tempRe, string savePath, string id, string ContentType)
        {
            tempRe.ReplaceLabels();
            tempRe.ReplaceIMLabels();
            savePath = savePath.Replace("/", @"\\");
            savePath = savePath.Replace(@"\\\\", @"\\");
            if (tempRe.MyTempType == TempType.Class || tempRe.MyTempType == TempType.Special || tempRe.MyTempType == TempType.ChClass || tempRe.MyTempType == TempType.Chspecial)
            {
                string FinlContent = tempRe.FinallyContent;
                int pos1 = FinlContent.IndexOf("{NT:NewsLIST}");
                int pos2 = FinlContent.IndexOf("{/NT:NewsLIST}");
                string filepath = savePath;
                string TmpPath = savePath;
                if (pos2 > pos1 && pos1 > -1)
                {
                    int getFiledot = savePath.LastIndexOf(".");
                    int getFileg = savePath.LastIndexOf("\\");
                    string getFileName = savePath.Substring((getFileg + 1), ((getFiledot - getFileg) - 1));
                    string getFileEXName = savePath.Substring(getFiledot);
                    #region ҳ
                    string PageHead = FinlContent.Substring(0, pos1);
                    string PageEnd = FinlContent.Substring(pos2 + 14);
                    string PageMid = FinlContent.Substring(pos1 + 13, pos2 - pos1 - 13);
                    string pattern = @"\{\$NT\:P[01]\}\{Page\:\d\$[^\$]{0,6}\$[^\$}]{0,}\}";
                    Regex reg = new Regex(pattern, RegexOptions.Compiled);
                    Match match = reg.Match(PageMid);
                    if (match.Success)
                    {
                        if (NetCMS.Config.verConfig.PublicType == "0" || tempRe.MyTempType == TempType.ChClass || tempRe.MyTempType == TempType.Chspecial)
                        {
                            string PageStr = match.Value;
                            int posPage = PageStr.IndexOf("}{Page:");

                            string postResult = PageStr.Substring(posPage + 7);
                            postResult = postResult.TrimEnd('}');
                            string[] postResultARR = postResult.Split('$');
                            string postResult_style = postResultARR[0];
                            string postResult_color = postResultARR[1];
                            string postResult_css = postResultARR[2];
                            string postResult_css1 = "";
                            if (postResult_css.Trim() != string.Empty)
                            {
                                postResult_css1 = " class=\"" + postResult_css + "\"";
                            }
                            string[] ArrayCon = reg.Split(PageMid);
                            int n = ArrayCon.Length;
                            if (ArrayCon[n - 1] == null || ArrayCon[n - 1].Trim() == string.Empty)
                                n--;
                            for (int i = 0; i < n; i++)
                            {
                                string getPageStr = "";
                                if (i > 0)
                                {
                                    int laspot = TmpPath.LastIndexOf('.');
                                    filepath = TmpPath.Substring(0, laspot) + "_" + (i + 1) + TmpPath.Substring(laspot);
                                }
                                UltiPublish gpl = new UltiPublish(true);
                                getPageStr = gpl.getPagelist(postResult_style, i, getFileName, getFileEXName, postResult_color, postResult_css1, n, id, ContentType, 0);
                                string PageContent = PageHead + ArrayCon[i] + getPageStr + PageEnd;

                                General.WriteHtml(PageContent, filepath);
                            }
                            if (n > 0)
                            {
                                return;
                            }
                        }
                    }
                    #endregion
                }
            }
            string p1js = "<span style=\"text-align:center;\" id=\"gPtypenowdiv" + DateTime.Now.ToShortDateString() + "\">...</span>";
            p1js += "<script language=\"javascript\" type=\"text/javascript\">";
            p1js += "pubajax('/configuration/system/public.aspx','NowStr=" + DateTime.Now.ToShortDateString() + "&ruleStr=1','gPtypenowdiv" + DateTime.Now.ToShortDateString() + "');";
            p1js += "</script>";
            WriteHtml(tempRe.FinallyContent.Replace("{NT:NewsLIST}", "").Replace("{/NT:NewsLIST}", "").Replace("{$NT:P1}", p1js), savePath);
        }


        /// <summary>
        /// 滻·ҳ
        /// </summary>
        /// <returns></returns>
        public static string ReplaceResultPage(string NewsID, string Content, string FileName, string EXName, int PageCount, int CurrentPage, int isPop)
        {
            string getContent = "";
            string ReadType = NetCMS.Common.Public.readparamConfig("ReviewType");
            //ҳ
            if (Content.IndexOf("{#PageStartLink}") > -1)
            {
                if (ReadType == "1")
                {
                    Content = Content.Replace("{#PageStartLink}", "Content.aspx?id=" + NewsID + "");
                }
                else
                {
                    if (isPop == 1)
                    {
                        Content = Content.Replace("{#PageStartLink}", "Content.aspx?id=" + NewsID + "");
                    }
                    else
                    {
                        Content = Content.Replace("{#PageStartLink}", FileName + EXName);
                    }
                }
            }
            //һҳ
            if (Content.IndexOf("{#PageEndLink}") > -1)
            {
                if (ReadType == "1")
                {
                    Content = Content.Replace("{#PageEndLink}", "Content.aspx?id=" + NewsID + "&Page=" + PageCount + "");
                }
                else
                {
                    if (isPop == 1)
                    {
                        Content = Content.Replace("{#PageStartLink}", "Content.aspx?id=" + NewsID + "&Page=" + PageCount + "");
                    }
                    else
                    {
                        Content = Content.Replace("{#PageEndLink}", FileName + "_" + PageCount + EXName);
                    }
                }
            }
            //һҳ
            if (Content.IndexOf("{#PagePreLink}") > -1)
            {
                if (CurrentPage <= 2)
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PagePreLink}", "Content.aspx?id=" + NewsID + "");
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PagePreLink}", "Content?id=" + NewsID + "");
                        }
                        else
                        {
                            Content = Content.Replace("{#PagePreLink}", FileName + EXName);
                        }
                    }
                }
                else
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PagePreLink}", FileName + "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage - 1));
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PagePreLink}", FileName + "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage - 1));
                        }
                        else
                        {
                            Content = Content.Replace("{#PagePreLink}", FileName + "_" + (CurrentPage - 1) + EXName);
                        }
                    }
                }
            }
            //һҳ
            if (Content.IndexOf("{#PageNextLink}") > -1)
            {
                if (CurrentPage == PageCount)
                {
                    Content = Content.Replace("{#PageNextLink}", "javascript:void(0);");
                }
                else
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PageNextLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage + 1) + "");
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PageNextLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage + 1) + "");
                        }
                        else
                        {
                            Content = Content.Replace("{#PageNextLink}", FileName + "_" + (CurrentPage + 1) + EXName);
                        }
                    }
                }
            }
            //ʮҳ
            if (Content.IndexOf("{#PagePreTenLink}") > -1)
            {
                if (CurrentPage < 10)
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PagePreTenLink}", "Content.aspx?id=" + NewsID + "");
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PagePreTenLink}", "Content.aspx?id=" + NewsID + "");
                        }
                        else
                        {
                            Content = Content.Replace("{#PagePreTenLink}", FileName + EXName);
                        }
                    }
                }
                else
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PagePreTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage - 10));
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PagePreTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage - 10));
                        }
                        else
                        {
                            Content = Content.Replace("{#PagePreTenLink}", FileName + "_" + (CurrentPage - 10) + EXName);
                        }
                    }
                }
            }
            //ʮҳ
            if (Content.IndexOf("{#PageNextTenLink}") > -1)
            {
                if ((CurrentPage + 10) > PageCount)
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PageNextTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (PageCount));
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PageNextTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (PageCount));
                        }
                        else
                        {
                            Content = Content.Replace("{#PageNextTenLink}", FileName + "_" + (PageCount) + EXName);
                        }
                    }
                }
                else
                {
                    if (ReadType == "1")
                    {
                        Content = Content.Replace("{#PageNextTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage + 10));
                    }
                    else
                    {
                        if (isPop == 1)
                        {
                            Content = Content.Replace("{#PageNextTenLink}", "Content.aspx?id=" + NewsID + "&Page=" + (CurrentPage + 10));
                        }
                        else
                        {
                            Content = Content.Replace("{#PageNextTenLink}", FileName + "_" + (CurrentPage + 10) + EXName);
                        }
                    }
                }
            }
            //
            if (Content.IndexOf("{#PageCount}") > -1)
            {
                Content = Content.Replace("{#PageCount}", PageCount.ToString());
            }
            //ǰҳ
            if (Content.IndexOf("{#PageCurrentNews}") > -1)
            {
                Content = Content.Replace("{#PageCurrentNews}", CurrentPage.ToString());
            }

            if (Content.IndexOf("{#NewsPage:Loop") > -1 && Content.IndexOf("{/@NewsPage:Loop}") > -1)
            {

            }
            getContent = Content;
            return getContent;
        }

        public static string getResultPage(string _Content, DateTime _DateTime, string ClassID, string EName)
        {
            string _Str = "";
            if (_Content != string.Empty)
            {
                _Str = _Content.ToLower();
                string year02 = ((_DateTime.Year).ToString()).PadRight(2);
                string year04 = (_DateTime.Year).ToString();
                string month = (_DateTime.Month).ToString();
                string day = (_DateTime.Day).ToString();
                string hour = (_DateTime.Hour).ToString();
                string minute = (_DateTime.Minute).ToString();
                string second = (_DateTime.Second).ToString();
                _Str = _Str.Replace("{@year02}", year02);
                _Str = _Str.Replace("{@year04}", year04);
                _Str = _Str.Replace("{@month}", month);
                _Str = _Str.Replace("{@day}", day);
                _Str = _Str.Replace("{@second}", second);
                _Str = _Str.Replace("{@minute}", minute);
                _Str = _Str.Replace("{@hour}", hour);
                _Str = _Str.Replace("{@ename}", EName);
                if (_Str.IndexOf("{@ram", 0) != -1)
                {
                    for (int i = 0; i <= 9; i++)
                    {
                        _Str = _Str.Replace("{@ram" + i + "_0}", NetCMS.Common.Rand.Number(i));
                        _Str = _Str.Replace("{@ram" + i + "_1}", NetCMS.Common.Rand.Str_char(i));
                        _Str = _Str.Replace("{@ram" + i + "_2}", NetCMS.Common.Rand.Str(i));
                    }
                }
            }
            return _Str;
        }

    }
}
