﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Text.RegularExpressions;
using NetCMS.Config;

namespace NetCMS.Publish
{
    public class DynamicLabel : Label
    {
        /// <summary>
        /// 标签内容
        /// </summary>
        private string LabelContent = string.Empty;
        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="labelname">标签名称</param>
        public DynamicLabel(string labelname, LabelType labeltype)
            : base(labelname, labeltype)
        {
            //LblMassList = new List<LabelMass>();
        }
        
        public override void GetContentFromDB()
        {
            string getType = _LabelName;
            string result = "";
            if (_LabelName.Trim() == "{NT_DynClassLD}")
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=ClassList,NT:ListType=News,NT:PageStyle=0$$30$]·<a href=\"{#URL}\"><a href=\"{#URL}\">{#Title}</a></a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.Trim() == "{NT_DynClassLDC}")
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=ClassList,NT:ListType=News,NT:PageStyle=0$$30$,NT:SubNews=true]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.IndexOf("{NT_DynClassD_") > -1)
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=List,NT:Number=10,NT:NewsType=Last,NT:ClassID=" + (_LabelName.Replace("{NT_DynClassD_", "")).TrimEnd('}') + "]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }

            else if (_LabelName.IndexOf("{NT_DynClassDC_") > -1)
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=List,NT:Number=10,NT:NewsType=Last,NT:SubNews=true,NT:ClassID=" + (_LabelName.Replace("{NT_DynClassDC_", "")).TrimEnd('}') + "]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }

            else if (_LabelName.IndexOf("{NT_DynClassR_") > -1)
            {
                result = "[NT:unLoop,NT:SiteID=0,NT:LabelType=RSS,NT:ClassID=" + (_LabelName.Replace("{NT_DynClassR_", "")).TrimEnd('}') + "][/NT:unLoop]";
            }
            else if (_LabelName.IndexOf("{NT_DynClassC_") > -1)
            {
                result = "[NT:unLoop,NT:SiteID=0,NT:LabelType=ClassNaviRead,NT:ClassID=" + (_LabelName.Replace("{NT_DynClassC_", "")).TrimEnd('}') + ",NT:ClassTitleNumber=30,NT:ClassNaviTitleNumber=150][/NT:unLoop]";
            }
            else if (_LabelName.IndexOf("{NT_DynClassC_") > -1)
            {
                result = "[NT:unLoop,NT:SiteID=0,NT:LabelType=ClassNaviRead,NT:ClassID=" + (_LabelName.Replace("{NT_DynClassC_", "")).TrimEnd('}') + ",NT:ClassTitleNumber=30,NT:ClassNaviTitleNumber=150][/NT:unLoop]";
            }
            else if (_LabelName.Trim() == "{NT_DynSpecialLD}")
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=ClassList,NT:ListType=Special,NT:PageStyle=0$$30$]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.Trim() == "{NT_DynSpecialLDC}")
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=ClassList,NT:ListType=Special,NT:PageStyle=0$$30$,NT:SubNews=true]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.IndexOf("{NT_DynSpecialD_") > -1)
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=List,NT:Number=10,NT:NewsType=Special,NT:SpecialID=" + (_LabelName.Replace("{NT_DynSpecialD_", "")).TrimEnd('}') + "]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.IndexOf("{NT_DynSpecialDC_") > -1)
            {
                result = "[NT:Loop,NT:SiteID=0,NT:LabelType=List,NT:Number=10,NT:NewsType=Special,NT:SubNews=true,NT:SpecialID=" + (_LabelName.Replace("{NT_DynSpecialDC_", "")).TrimEnd('}') + "]·<a href=\"{#URL}\">{#Title}</a>  <span style=\"color:#999999;font-size:10px\">({#Date:Month}-{#Date:Day})</span>[/NT:Loop]";
            }
            else if (_LabelName.IndexOf("{NT_DynSpecialC_") > -1)
            {
                result = "[NT:unLoop,NT:SiteID=0,NT:LabelType=SpeicalNaviRead,NT:SpecialID=" + (_LabelName.Replace("{NT_DynSpecialC_", "")).TrimEnd('}') + ",NT:SpecialTitleNumber=30,NT:SpecialNaviTitleNumber=150][/NT:unLoop]";
            }
            LabelContent = result;
        }
        /// <summary>
        /// 解析自定义标签内容
        /// </summary>
        protected void ParseLabelConetent()
        {
            //_FinalHtmlCode = LabelContent;
            string pattern = @"\[NT:unLoop,[^\]]+\][\s\S]*?\[/NT:unLoop\]|\[NT:Loop,[^\]]+\][\s\S]*?\[/NT:Loop\]";
            Regex reg = new Regex(pattern, RegexOptions.Compiled);
            string content = LabelContent;
            Match m = reg.Match(content);
            while (m.Success)
            {
                string mass = m.Value.Trim();
                LabelMass labelmass = new LabelMass(mass, this._CurrentClassID, this._CurrentSpecialID, this._CurrentNewsID,this._CurrentChID,this._CurrentCHClassID,this._CurrentCHSpecialID,this._CurrentCHNewsID);
                labelmass.TemplateType = this._TemplateType;
                labelmass.ParseContent();
                string s = labelmass.Parse();
                content = content.Replace(mass, s);
                m = reg.Match(content);
            }
            this._FinalHtmlCode = content;
        }
        /// <summary>
        /// 生成最终的HTML代码
        /// </summary>
        /// <param name="cn"></param>
        public override void MakeHtmlCode()
        {
            ParseLabelConetent();
        }

    }
}
