﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using NetCMS.Common;
using NetCMS.Control;
using NetCMS.Config;
using NetCMS.Model;

namespace NetCMS.Publish
{
    public partial class UltiPublish
    {
        private const string MsgFormat = "正在发布{0}，共需要发布{1}条，正在发布第{2}条，成功{3}条，<a href=\"error/GetError.aspx?d=now\" title=\"点击查看错误信息\"><span style=\"color:red;\">失败{4}条</span></a>{5}";
        /// <summary>
        /// 是否发布主页、新闻、栏目、专题，bool标志
        /// </summary>
        private bool _isPubindex;
        public bool IsPublishIndex
        {
            set { _isPubindex = value; }
        }
        /// <summary>
        /// 是否发布新闻，bool标志
        /// </summary>
        private bool _isPubNews;
        public bool IsPubNews
        {
            set { _isPubNews = value; }
        }
        /// <summary>
        /// 是否发布栏目索引文件，bool标志
        /// </summary>
        private bool _isClassIndex;
        /// <summary>
        /// 是否发布栏目索引文件，bool标志
        /// </summary>
        public bool isClassIndex
        {
            set { _isClassIndex = value; }
        }
        /// <summary>
        /// 是否发布栏目，bool标志
        /// </summary>
        private bool _isPubClass;
        public bool IsPubClass
        {
            set { _isPubClass = value; }
        }
        /// <summary>
        /// 是否发布专题，bool标志
        /// </summary>
        private bool _isPubSpecial;
        public bool IsPubSpecial
        {
            set { _isPubSpecial = value; }
        }
        //-----------------------------------------------------------------
        /// <summary>
        /// 发布新闻方式标志
        /// </summary>
        private int _newsFlag;
        public int newsFlag
        {
            set { _newsFlag = value; }
        }
        /// <summary>
        /// 发布新闻的字符串参数
        /// </summary>
        private string _strNewsParams = string.Empty;
        public string strNewsParams
        {
            set { _strNewsParams = value; }
        }
        /// <summary>
        /// 发布栏目方式标志
        /// </summary>
        private int _ClassFlag;
        public int ClassFlag
        {
            set { _ClassFlag = value; }
        }
        /// <summary>
        /// 发布栏目的字符串参数
        /// </summary>
        private string _strClassParams = string.Empty;
        public string strClassParams
        {
            set { _strClassParams = value; }
        }
        /// <summary>
        /// 发布专题方式标志
        /// </summary>
        private int _specialFlag;
        public int specialFlag
        {
            set { _specialFlag = value; }
        }
        /// <summary>
        /// 发布专题的字符串参数
        /// </summary>
        private string _strSpecialParams = string.Empty;
        public string strSpecialParams
        {
            set { _strSpecialParams = value; }
        }
        //-----------------------------------------------------------------
        /// <summary>
        /// 模板路径
        /// </summary>
        private string TempletPath;
        /// <summary>
        /// 模板实例列表
        /// </summary>
        private IList<Template> templateList = new List<Template>();
        /// <summary>
        /// 所发布成功的新闻、栏目、专题的ID列表
        /// </summary>
        private IList<string> succeedList = new List<string>();
        /// <summary>
        /// 发布失败的新闻、栏目、专题的ID、异常信息
        /// </summary>
        private IList<string> failedList = new List<string>();
        //-----------------------------------------------------------------
        /// <summary>
        /// 是否显示生成进度条标志
        /// </summary>
        private bool _isProgressBar;
        /// <summary>
        /// 要发布的新闻条数
        /// </summary>
        private int nNewsCount = 0;
        /// <summary>
        /// 要发布的栏目数
        /// </summary>
        private int nClassCount = 0;
        /// <summary>
        /// 要发布的专题数
        /// </summary>
        private int nSpecialCount = 0;
        /// <summary>
        /// 当前的用户名
        /// </summary>
        private string userName = string.Empty;
        /// <summary>
        /// 网站根目录物理路径
        /// </summary>
        public string SiteRootPath = string.Empty;
        /// <summary>
        /// 生成每一条新闻的路径
        /// </summary>
        private string saveNewsPath = string.Empty;
        /// <summary>
        /// 生成每一个栏目的路径
        /// </summary>
        private string saveClassPath = string.Empty;
        /// <summary>
        /// 生成每一个专题的路径
        /// </summary>
        private string saveSpecialPath = string.Empty;
        /// <summary>
        /// 获取模板目录
        /// </summary>
        private string strTempletDir = NetCMS.Config.UIConfig.dirTemplet;
        /// <summary>
        /// 构造函数,传入标志和页面信息字符串
        /// </summary>
        /// <param name="_tempPath"></param>        
        public UltiPublish(bool isProgressBar)
        {
            _isProgressBar = isProgressBar;
            // SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath() + "\\";
            SiteRootPath = NetCMS.Common.ServerInfo.GetRootPath();
        }
        //-----------------------------------------------------------------
        /// <summary>
        /// 关闭所有数据库连接
        /// </summary>
        public void CloseAllConnection()
        {

        }
        //-----------------------------------------------------------------
        /// <summary>
        /// 开始发布
        /// </summary>
        public void StartPublish()
        {
            CommonData.Initialize();
            HProgressBar.Start();
            if (_isPubindex) { ultiPublishIndex(); }
            if (_isPubNews) { ultiPublishNews(); }
            if (_isPubClass) { ultiPublishClass(); }
            if (_isPubSpecial) { ultiPublishSpecial(); }
        }
        /// <summary>
        /// 生成主页
        /// </summary>
        private void ultiPublishIndex()
        {
            try
            {
                HProgressBar.Roll("正在发布主页", 0);
                string indexname = "index.html";
                TempletPath = NetCMS.Common.Public.readparamConfig("IndexTemplet"); //rd["IndexTemplet"].ToString();
                TempletPath = TempletPath.Replace("/", "\\");
                TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                indexname = NetCMS.Common.Public.readparamConfig("IndexFileName");//rd["IndexFileName"].ToString();
                Template indexTemp = new Template(SiteRootPath.Trim('\\') + TempletPath, TempType.Index);
                indexTemp.GetHTML();
                indexTemp.ReplaceLabels();
                indexTemp.ReplaceIMLabels();
                General.WriteHtml(indexTemp.FinallyContent, SiteRootPath.TrimEnd('\\') + "\\" + indexname);
                General.publishXML("0");
                //发布今日历史文档
                General.publishHistryIndex(0);
                HProgressBar.Roll("发布主页成功。&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a> &nbsp; <a class=\"list_link\" href=\"../../" + indexname + "\" target=\"_blank\">浏览首页</a>", 100);
            }
            catch (Exception ex)
            {
                NetCMS.Common.Public.savePublicLogFiles("□□□发布主页", "【错误描述：】\r\n" + ex.ToString(), "");
                HProgressBar.Roll("发布主页失败。<a href=\"error/geterror.aspx?\">查看日志</a>", 0);
            }
        }
        /// <summary>
        /// 生成所有新闻
        /// </summary>
        private void ultiPublishNews()
        {
            using (IDataReader rd = getAllNews())
            {
                int num = 0;
                int succeedNum = 0;
                int failedNum = 0;
                bool flag = false;
                if (nNewsCount > 0)
                {
                    while (rd.Read())
                    {
                        flag = true;
                        TempletPath = rd["templet"].ToString();
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        setSaveNewsPath(rd["classID"].ToString(), rd["SavePath"].ToString(), rd["FileName"].ToString(), rd["FileEXName"].ToString());
                        bool state = publishSingleNews(rd["newsID"].ToString(), rd["datalib"].ToString(), rd["classID"].ToString());//发布一条新闻，返回成功与否                                              
                        num += 1;
                        if (state)
                        {
                            succeedNum++;
                        }
                        else
                        {
                            failedNum++;
                        }
                        string msg = string.Format(MsgFormat, "新闻", nNewsCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布新闻成功。&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a> &nbsp;&nbsp;&nbsp; <a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                        HProgressBar.Roll(msg, (num * 100 / nNewsCount));
                    }
                }
                else
                {
                    HProgressBar.Roll("没有新闻", 0);
                }
                rd.Close();
                if (!flag)
                {
                    string msg = string.Format(MsgFormat, "新闻", nNewsCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布新闻成功。&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a> &nbsp;&nbsp;&nbsp; <a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                    if (nNewsCount > 0)
                    {
                        HProgressBar.Roll(msg, (num * 100 / nNewsCount));
                    }
                    else
                    {
                        HProgressBar.Roll("没有新闻", 0);
                    }
                }
            }
            if (templateList.Count != 0)
            {
                templateList.Clear();
            }
            if (failedList.Count != 0)
            {
                for (int i = 0; i < failedList.Count; i++)
                {
                    NetCMS.Common.Public.savePublicLogFiles("□□□发布新闻", "【ID】:" + failedList[i].Split('$')[0] + "\r\n【错误描述：】\r\n" + failedList[i].Split('$')[1], "");
                }
                failedList.Clear();
            }
            if (succeedList.Count != 0)
            {
                updateNewsIsHtml(DBConfig.TableNamePrefix + "news", "isHtml", "newsID");
            }
        }
        /// <summary>
        /// 为saveNewsPath赋值
        /// </summary>
        /// <param name="classID">新闻所属栏目的ID</param>
        /// <param name="SavePath">新闻表中SavePath字段的值</param>
        /// <param name="FileName">新闻表中FileName字段的值</param>
        /// <param name="FileName">新闻表中FileName字段的值</param>
        private void setSaveNewsPath(string classID, string SavePath, string FileName, string FileEXName)
        {
            PubClassInfo info = CommonData.GetClassById(classID);
            if (info != null)
            {
                saveNewsPath = "\\" + info.SavePath.Trim('\\').Trim('/') + "\\" + info.SaveClassframe.Trim('\\').Trim('/') + "\\" + SavePath.Trim('\\').Trim('/') + "\\" + FileName.Trim('\\').Trim('/') + FileEXName.Trim('\\').Trim('/');
            }
        }
        /// <summary>
        /// 设置已发布新闻、栏目的IsHtml
        /// </summary>
        private void updateNewsIsHtml(string tableName, string isHtml, string idField)
        {
            try
            {
                CommonData.DalPublish.UpdateNewsIsHtml(tableName, isHtml, idField, succeedList);
            }
            catch
            {
                //写日志
            }
            finally
            {
                succeedList.Clear();
            }
        }
        /// <summary>
        /// 生成所有栏目
        /// </summary>
        public void ultiPublishClass()
        {
            using (IDataReader rd = getAllClass())
            {
                int num = 0;
                int succeedNum = 0;
                int failedNum = 0;
                bool HasRows = false;
                if (nClassCount > 0)
                {
                    while (rd.Read())
                    {
                        HasRows = true;
                        TempletPath = rd["classtemplet"].ToString();
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        string TmpsaveClassPath = "\\" + rd["savePath"].ToString().Trim('\\').Trim('/') + "\\" + rd["SaveClassframe"].ToString().Trim('\\').Trim('/') + '\\' + rd["ClassSaveRule"].ToString().Trim('\\').Trim('/');
                        saveClassPath = TmpsaveClassPath.Replace("/", "\\");
                        string strClassId = rd["classid"].ToString();
                        bool state = publishSingleClass(strClassId, rd["Datalib"].ToString());
                        if (_isClassIndex)
                        {
                            General.publishClassIndex(strClassId);
                        }
                        num += 1;
                        if (state)
                        {
                            succeedNum++;
                        }
                        else
                        {
                            failedNum++;
                        }
                        string msg = string.Format(MsgFormat, "栏目", nClassCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布栏目成功&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a>&nbsp;&nbsp;<a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                        HProgressBar.Roll(msg, (num * 100 / nClassCount));
                    }
                }
                else
                {
                    HProgressBar.Roll("没有栏目", 0);
                }
                rd.Close();
                if (!HasRows)
                {
                    string msg = string.Format(MsgFormat, "栏目", nClassCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布栏目成功&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a>&nbsp;&nbsp;<a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                    if (nClassCount > 0)
                    {
                        HProgressBar.Roll(msg, (num * 100 / nClassCount));
                    }
                    else
                    {
                        HProgressBar.Roll("没有栏目", 0);
                    }
                }
            }
            if (templateList.Count != 0)
            {
                templateList.Clear();
            }
            if (failedList.Count != 0)
            {
                for (int i = 0; i < failedList.Count; i++)
                {
                    NetCMS.Common.Public.savePublicLogFiles("□□□发布栏目", "【ID】:" + failedList[i].Split('$')[0] + "\r\n【错误描述：】\r\n" + failedList[i].Split('$')[1], "");
                }
                failedList.Clear();
            }
            if (succeedList.Count != 0)
            {
                updateNewsIsHtml(DBConfig.TableNamePrefix + "news_class", "isunHtml", "cLassID");
            }

        }
        /// <summary>
        /// 生成所有专题
        /// </summary>
        public void ultiPublishSpecial()
        {
            float num = 0;
            int succeedNum = 0;
            int failedNum = 0;
            bool HasRows = false;
            IDataReader rd = getAllSpecials();
            {
                if (nSpecialCount > 0)
                {
                    while (rd.Read())
                    {
                        HasRows = true;
                        TempletPath = rd["Templet"].ToString();
                        TempletPath = TempletPath.Replace("/", "\\");
                        TempletPath = TempletPath.ToLower().Replace("{@dirtemplet}", strTempletDir);
                        string TmpsaveSpecialPath = "\\" + rd["SavePath"].ToString().Trim('\\').Trim('/') + "\\" + rd["saveDirPath"].ToString().Trim('\\').Trim('/') + '\\' + rd["FileName"].ToString().Trim('\\').Trim('/') + rd["FileEXName"].ToString().Trim('\\').Trim('/');
                        saveSpecialPath = TmpsaveSpecialPath.Replace("{@dirHtml}", NetCMS.Config.UIConfig.dirHtml).Replace("/", "\\"); ;
                        bool state = publishSingleSpecial(rd["specialID"].ToString());
                        if (state)
                        {
                            num += 1;
                            succeedNum++;
                        }
                        else
                        {
                            failedNum++;
                        }
                        string msg = string.Format(MsgFormat, "专题", nSpecialCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布栏目成功。&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a> &nbsp;&nbsp;&nbsp; <a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                        HProgressBar.Roll(msg, (int)(num / nSpecialCount) * 100);
                    }
                }
                else
                {
                    HProgressBar.Roll("没有专题", 0);
                }
                rd.Close();
                if (!HasRows)
                {
                    string msg = string.Format(MsgFormat, "专题", nSpecialCount.ToString(), ((int)num).ToString(), succeedNum.ToString(), failedNum.ToString(), "发布栏目成功。&nbsp;&nbsp;<a class=\"list_link\" href=\"javascript:history.back();\">返 回</a> &nbsp;&nbsp;&nbsp; <a class=\"list_link\" href=\"../../index.html\" target=\"_blank\">浏览首页</a>");
                    HProgressBar.Roll(msg, (int)(num / nSpecialCount) * 100);
                }
            }
            if (templateList.Count != 0)
            {
                templateList.Clear();
            }
            if (failedList.Count != 0)
            {
                for (int i = 0; i < failedList.Count; i++)
                {
                    NetCMS.Common.Public.savePublicLogFiles("□□□发布专题", "【ID】:" + failedList[i].Split('$')[0] + "\r\n【错误描述：】\r\n" + failedList[i].Split('$')[1], "");
                }
                failedList.Clear();
            }
        }
        /// <summary>
        /// 发布一条新闻
        /// </summary>
        /// <param name="newsID">单条新闻的ID</param>
        /// <param name="datalib">该条新闻所在的表</param>
        /// <returns>成功与否标志</returns>
        public bool publishSingleNews(string newsID, string datalib, string classID)
        {
            try
            {
                TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                bool existFlag = false;
                if (templateList.Count != 0)
                {
                    foreach (Template temp in templateList)
                    {
                        if (TempletPath == temp.TempFilePath)
                        {
                            existFlag = true;
                            temp.NewsID = newsID;
                            makeHtmlFile(temp, existFlag, classID, newsID);
                            break;
                        }
                    }
                    if (!existFlag)
                    {
                        Template newsTemplate = new Template(TempletPath, TempType.News);
                        newsTemplate.NewsID = newsID;
                        newsTemplate.GetHTML();
                        makeHtmlFile(newsTemplate, existFlag, classID, newsID);
                    }
                }
                else
                {
                    Template newsTemplate = new Template(TempletPath, TempType.News);
                    newsTemplate.NewsID = newsID;
                    newsTemplate.GetHTML();
                    makeHtmlFile(newsTemplate, existFlag, classID, newsID);
                }
                succeedList.Add(newsID);
                return true;
            }
            catch (Exception e)
            {
                failedList.Add(newsID + "$" + e.Message);
                NetCMS.Common.Public.savePublicLogFiles("□□□发布新闻", "【ID】:" + classID + "\r\n【错误描述：】\r\n" + e.ToString(), "");
                return false;
            }
        }
        /// <summary>
        /// 发布一个栏目
        /// </summary>
        /// <param name="classID">单个栏目的ID</param>
        /// <param name="datalib">该栏目所在的表</param>
        /// <returns>成功与否标志</returns>
        public bool publishSingleClass(string classID, string datalib)
        {
            try
            {
                TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                bool existFlag = false;
                if (templateList.Count != 0)
                {
                    foreach (Template temp in templateList)
                    {
                        if (TempletPath == temp.TempFilePath)
                        {
                            existFlag = true;
                            temp.ClassID = classID;
                            replaceTemp(temp, existFlag, saveClassPath, classID, "class");
                            break;
                        }
                    }
                    if (!existFlag)
                    {
                        Template classTemplate = new Template(TempletPath, TempType.Class);
                        classTemplate.ClassID = classID;
                        classTemplate.GetHTML();
                        replaceTemp(classTemplate, existFlag, saveClassPath, classID, "class");
                    }
                }
                else
                {
                    Template classTemplate = new Template(TempletPath, TempType.Class);
                    classTemplate.ClassID = classID;
                    classTemplate.GetHTML();
                    replaceTemp(classTemplate, existFlag, saveClassPath, classID, "class");
                }
                succeedList.Add(classID);
                return true;
            }
            catch (Exception e)
            {
                failedList.Add(classID + "$" + e.Message);
                NetCMS.Common.Public.savePublicLogFiles("□□□发布栏目", "【ID】:" + classID + "\r\n【错误描述：】\r\n" + e.ToString(), "");
                return false;
            }
        }
        /// <summary>
        /// 发布一个专题
        /// </summary>
        /// <param name="specialID">专题ID</param>
        /// <returns>成功与否标志</returns>
        public bool publishSingleSpecial(string specialID)
        {
            try
            {
                TempletPath = SiteRootPath.Trim('\\') + TempletPath;
                bool existFlag = false;
                if (templateList.Count != 0)
                {
                    foreach (Template temp in templateList)
                    {
                        if (TempletPath == temp.TempFilePath)
                        {
                            existFlag = true;
                            temp.SpecialID = specialID;
                            replaceTemp(temp, existFlag, saveSpecialPath, specialID, "special");
                            break;
                        }
                    }
                    if (!existFlag)
                    {
                        Template specialTemplate = new Template(TempletPath, TempType.Special);
                        specialTemplate.SpecialID = specialID;
                        specialTemplate.GetHTML();
                        replaceTemp(specialTemplate, existFlag, saveSpecialPath, specialID, "special");
                    }
                }
                else
                {
                    Template specialTemplate = new Template(TempletPath, TempType.Special);
                    specialTemplate.SpecialID = specialID;
                    specialTemplate.GetHTML();
                    replaceTemp(specialTemplate, existFlag, saveSpecialPath, specialID, "special");
                }
                succeedList.Add(specialID);
                return true;
            }
            catch (Exception e)
            {
                failedList.Add(specialID + "$" + e.Message);
                return false;
            }
        }
        /// <summary>
        /// 处理模板
        /// </summary>
        /// <param name="tempRe">模板实例</param>
        /// <param name="existFlag">该模板是否存在于模板列表</param>
        protected void replaceTemp(Template tempRe, bool existFlag, string savePath, string id, string ContentType)
        {
            tempRe.ReplaceLabels();
            tempRe.ReplaceIMLabels();
            if (tempRe.MyTempType == TempType.Class || tempRe.MyTempType == TempType.Special || tempRe.MyTempType == TempType.ChClass || tempRe.MyTempType == TempType.Chspecial)
            {
                string FinlContent = tempRe.FinallyContent;
                int pos1 = FinlContent.IndexOf("{NT:NewsLIST}");
                int pos2 = FinlContent.IndexOf("{/NT:NewsLIST}");
                string filepath = SiteRootPath + savePath;
                string TmpPath = SiteRootPath + savePath;
                if (pos2 > pos1 && pos1 > -1)
                {
                    int getFiledot = savePath.LastIndexOf(".");
                    int getFileg = savePath.LastIndexOf("\\");
                    string getFileName = savePath.Substring((getFileg + 1), ((getFiledot - getFileg) - 1));
                    string getFileEXName = savePath.Substring(getFiledot);
                    #region 处理分页
                    string PageHead = FinlContent.Substring(0, pos1);
                    string PageEnd = FinlContent.Substring(pos2 + 14);
                    string PageMid = FinlContent.Substring(pos1 + 13, pos2 - pos1 - 13);
                    //类型$颜色$css
                    string pattern = @"\{\$NT\:P[01]\}\{Page\:\d\$[^\$]{0,6}\$[^\$]{0,50}\}";
                    Regex reg = new Regex(pattern, RegexOptions.Compiled);
                    Match match = reg.Match(PageMid);
                    if (match.Success)
                    {
                        if (NetCMS.Config.verConfig.PublicType == "0" || tempRe.MyTempType == TempType.ChClass || tempRe.MyTempType == TempType.Chspecial)
                        {
                            string PageStr = match.Value;
                            int posPage = PageStr.IndexOf("}{Page:");

                            string postResult = PageStr.Substring(posPage + 7);
                            postResult = postResult.TrimEnd('}');

                            string[] postResultARR = postResult.Split('$');
                            string postResult_style = postResultARR[0];
                            string postResult_color = postResultARR[1];
                            string postResult_css = postResultARR[2];
                            string postResult_css1 = "";
                            if (postResult_css.Trim() != string.Empty)
                            {
                                postResult_css1 = " class=\"" + postResult_css + "\"";
                            }
                            string[] ArrayCon = reg.Split(PageMid);
                            int n = ArrayCon.Length;
                            if (ArrayCon[n - 1] == null || ArrayCon[n - 1].Trim() == string.Empty)
                                n--;
                            for (int i = 0; i < n; i++)
                            {
                                string getPageStr = "";
                                if (i > 0)
                                {
                                    int laspot = TmpPath.LastIndexOf('.');
                                    filepath = TmpPath.Substring(0, laspot) + "_" + (i + 1) + TmpPath.Substring(laspot);
                                }
                                getPageStr = getPagelist(postResult_style, i, getFileName, getFileEXName, postResult_color, postResult_css1, n, id, ContentType, 0);
                                string PageContent = PageHead + ArrayCon[i] + getPageStr + PageEnd;

                                General.WriteHtml(PageContent, filepath);
                            }
                            if (n > 0)
                            {
                                if (!existFlag)
                                {
                                    templateList.Add(tempRe);
                                }
                                return;
                            }
                        }
                    }
                    #endregion
                }
            }
            string p1js = "<span style=\"text-align:center;\" id=\"gPtypenowdiv" + DateTime.Now.ToShortDateString() + "\">加载中...</span>";
            p1js += "<script language=\"javascript\" type=\"text/javascript\">";
            p1js += "pubajax('/configuration/system/public.aspx','NowStr=" + DateTime.Now.ToShortDateString() + "&ruleStr=1','gPtypenowdiv" + DateTime.Now.ToShortDateString() + "');";
            p1js += "</script>";
            General.WriteHtml(tempRe.FinallyContent.Replace("{NT:NewsLIST}", "").Replace("{/NT:NewsLIST}", "").Replace("{$NT:P1}", p1js), SiteRootPath + savePath);
            if (!existFlag)
            {
                templateList.Add(tempRe);
            }
        }

        /// <summary>
        /// 得到分页样式
        /// </summary>
        /// <param name="Input"></param>
        /// <param name="sColor"></param>
        /// <param name="Css"></param>
        /// <returns></returns>
        public static string getPageStyle(string Input, string sColor)
        {
            string colorstr = "";
            if (sColor.Trim() != string.Empty)
            {
                colorstr = " style=\"color:" + sColor + "\"";
            }
             return Input;
        }

        public string getPageresult(string ID, string ReadType, string ContentType, int ConstStr, string getFileName, string getFileEXName, int isPop)
        {

            string getURL = string.Empty;
            string CHSTR = string.Empty;
            if (_ChID != 0)
            {
                CHSTR = "&ChID=" + _ChID.ToString() + "";
            }
            if (ReadType == "1")
            {
                if (ContentType == "class")
                {
                    if (ConstStr == 0)
                    {
                        getURL = "list.aspx?ID=" + ID + CHSTR;
                    }
                    else
                    {
                        getURL = "list.aspx?ID=" + ID + "&Page=" + ConstStr + CHSTR;
                    }
                }
                else
                {
                    if (ConstStr == 0)
                    {
                        getURL = "Special.aspx?SpecialID=" + ID + CHSTR;
                    }
                    else
                    {
                        getURL = "Special.aspx?SpecialID=" + ID + "&Page=" + ConstStr + CHSTR;
                    }
                }
            }
            else
            {
                if (isPop == 0)
                {
                    if (ConstStr == 0)
                    {
                        getURL = getFileName + getFileEXName;
                    }
                    else
                    {
                        getURL = getFileName + "_" + ConstStr + getFileEXName;
                    }
                }
                else
                {
                    if (ContentType == "class")
                    {
                        if (ConstStr == 0)
                        {
                            getURL = "list.aspx?ID=" + ID + CHSTR;
                        }
                        else
                        {
                            getURL = "list.aspx?ID=" + ID + "&Page=" + ConstStr + CHSTR;
                        }
                    }
                    else
                    {
                        if (ConstStr == 0)
                        {
                            getURL = "Special.aspx?SpecialID=" + ID + CHSTR;
                        }
                        else
                        {
                            getURL = "Special.aspx?SpecialID=" + ID + "&Page=" + ConstStr + CHSTR;
                        }
                    }
                }
            }
            return getURL;
        }

        /// <summary>
        /// 得到分页样式
        /// </summary>
        /// <param name="Numstr"></param>
        /// <param name="i"></param>
        /// <param name="getFileName"></param>
        /// <param name="getFileEXName"></param>
        /// <param name="postResult_color"></param>
        /// <param name="postResult_css"></param>
        /// <param name="n"></param>
        /// <returns></returns>
        public string getPagelist(string Numstr, int i, string getFileName, string getFileEXName, string postResult_color, string postResult_css, int n, string ID, string ContentType, int isPop)
        {
            string Pagestr = string.Empty;
            string ReadType = NetCMS.Common.Public.readparamConfig("ReviewType");
            switch (Numstr)
            {
                case "0":
                    Pagestr += "<div " + postResult_css + ">";
                    if (i == 0)
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"首页\">" + getPageStyle("首页", postResult_color) + "</a>";
                    }
                    else
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"首页\">" + getPageStyle("首页", postResult_color) + "</a>";
                        if (i == 1)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上一页\">" + getPageStyle("上一页", postResult_color) + "</a>";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, i, getFileName, getFileEXName, isPop) + "\" title=\"上一页\">" + getPageStyle("上一页", postResult_color) + "</a>";
                        }
                    }
                    if (n < 10)
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("上十页", postResult_color) + "</a>";
                        for (int m = i; m < n; m++)
                        {
                            if (m == i)
                            {
                                Pagestr += "<strong>" + getPageStyle("" + (m + 1), postResult_color) + "</strong>&nbsp;";
                            }
                            else
                            {
                                if (m == 0)
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>";
                                }
                                else
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (m + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>";
                                }
                            }
                        }
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"下十页\">" + getPageStyle("下十页", postResult_color) + "</a>";
                    }
                    else if (n > 10)
                    {
                        if (i < 11)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("上十页", postResult_color) + "</a>";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, ((i + 1) - 10), getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("上十页", postResult_color) + "</a>";
                        }
                        int mjs = (i + 10);
                        if ((n - i) < 10)
                        {
                            mjs = n;
                        }
                        for (int m = i; m < (mjs); m++)
                        {
                            if (m == i)
                            {
                                Pagestr += "<strong>" + getPageStyle("" + (m + 1), postResult_color) + "</strong>&nbsp;";
                            }
                            else
                            {
                                if (m == 0)
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>";
                                }
                                else
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (m + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>";
                                }
                            }
                        }
                        if ((i + 10) > n)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"下十页\">" + getPageStyle("下十页", postResult_color) + "</a>";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, ((i + 1) + 10), getFileName, getFileEXName, isPop) + "\" title=\"下十页\">" + getPageStyle("下十页", postResult_color) + "</a>";
                        }
                    }
                    if (i == (n - 1))
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"尾页\">" + getPageStyle("尾页", postResult_color) + "</a></div>";
                    }
                    else
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (i + 2), getFileName, getFileEXName, isPop) + "\" title=\"下一页\">" + getPageStyle("下一页", postResult_color) + "</a>";
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"尾页\">" + getPageStyle("尾页", postResult_color) + "</a></div>";
                    }
                    break;
                case "1":
                    Pagestr += "<div " + postResult_css + ">";
                    if ((i + 1) > 2)
                    {
                        Pagestr += "&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, i, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("上一页", postResult_color) + "</a>&nbsp;&nbsp;";
                    }
                    else
                    {
                        if (i == 0)
                        {
                            Pagestr += "&nbsp;" + getPageStyle("上一页", postResult_color) + "&nbsp;&nbsp;";
                        }
                        else
                        {
                            Pagestr += "&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("上一页", postResult_color) + "</a>&nbsp;&nbsp;";
                        }
                    }
                    for (int j = 0; j < n; j++)
                    {
                        if (j == i)
                        {
                            Pagestr += "<strong>" + getPageStyle("第" + (j + 1) + "页", postResult_color) + "</strong>&nbsp;";
                        }
                        else
                        {
                            if (j == 0)
                            {
                                Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("第" + (j + 1) + "页", postResult_color) + "</a>&nbsp;";
                            }
                            else
                            {
                                Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (j + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("第" + (j + 1) + "页", postResult_color) + "</a>&nbsp;";
                            }
                        }
                    }
                    if ((i + 1) == n)
                    {
                        Pagestr += "&nbsp;&nbsp;" + getPageStyle("下一页", postResult_color) + "&nbsp;";
                    }
                    else
                    {
                        Pagestr += "&nbsp;&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, (i + 2), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("下一页", postResult_color) + "</a>&nbsp;";
                    }
                    Pagestr += "</div>";
                    break;
                case "2":
                    Pagestr += "<div " + postResult_css + ">";
                    if ((i + 1) > 2)
                    {
                        Pagestr += "&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, i, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("上一页", postResult_color) + "</a>&nbsp;&nbsp;";
                    }
                    else
                    {
                        if (i == 0)
                        {
                            Pagestr += "&nbsp;" + getPageStyle("上一页", postResult_color) + "&nbsp;&nbsp;";
                        }
                        else
                        {
                            Pagestr += "&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("上一页", postResult_color) + "</a>&nbsp;&nbsp;";
                        }
                    }
                    for (int j = 0; j < n; j++)
                    {
                        if (j == i)
                        {
                            Pagestr += "<strong>" + getPageStyle("" + (j + 1), postResult_color) + "</strong>&nbsp;";
                        }
                        else
                        {
                            if (j == 0)
                            {
                                Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (j + 1), postResult_color) + "</a>&nbsp;";
                            }
                            else
                            {
                                Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (j + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (j + 1), postResult_color) + "</a>&nbsp;";
                            }
                        }
                    }
                    if ((i + 1) == n)
                    {
                        Pagestr += "&nbsp;&nbsp;" + getPageStyle("下一页", postResult_color) + "&nbsp;";
                    }
                    else
                    {
                        Pagestr += "&nbsp;&nbsp;<a href=\"" + getPageresult(ID, ReadType, ContentType, (i + 2), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("下一页", postResult_color) + "</a>&nbsp;";
                    }
                    Pagestr += "</div>";
                    break;
                default:
                    Pagestr += "<div " + postResult_css + ">共" + n + "页,&nbsp;当前第" + (i + 1) + "页,&nbsp;";
                    if (i == 0)
                    {
                        Pagestr += getPageStyle("<font face=webdings title=\"首页\">9</font>", postResult_color) + "&nbsp;";
                        Pagestr += getPageStyle("<font face=webdings title=\"上一页\">3</font>", postResult_color) + "&nbsp;";
                    }
                    else
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"首页\">" + getPageStyle("<font face=webdings>9</font>", postResult_color) + "</a>&nbsp;";
                        if (i == 1)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上一页\">" + getPageStyle("<font face=webdings>3</font>", postResult_color) + "</a>&nbsp;";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, i, getFileName, getFileEXName, isPop) + "\" title=\"上一页\">" + getPageStyle("<font face=webdings>3</font>", postResult_color) + "</a>&nbsp;";
                        }
                    }
                    if (n < 10)
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("<font face=webdings>7</font>", postResult_color) + "</a>&nbsp;";
                        for (int m = i; m < n; m++)
                        {
                            if (m == i)
                            {
                                Pagestr += "<strong>" + getPageStyle("" + (m + 1), postResult_color) + "</strong>&nbsp;";
                            }
                            else
                            {
                                if (m == 0)
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>&nbsp;";
                                }
                                else
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (m + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>&nbsp;";
                                }
                            }
                        }
                        Pagestr += getPageStyle("<font face=webdings>8</font>", postResult_color) + "&nbsp;";
                    }
                    else if (n > 10)
                    {
                        if (i < 11)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("<font face=webdings>7</font>", postResult_color) + "</a>&nbsp;";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, ((i + 1) - 10), getFileName, getFileEXName, isPop) + "\" title=\"上十页\">" + getPageStyle("<font face=webdings>7</font>", postResult_color) + "</a>&nbsp;";
                        }
                        int mjs = (i + 10);
                        if ((n - i) < 10)
                        {
                            mjs = n;
                        }
                        for (int m = i; m < (mjs); m++)
                        {
                            if (m == i)
                            {
                                Pagestr += "<strong>" + getPageStyle("" + (m + 1), postResult_color) + "</strong>&nbsp;";
                            }
                            else
                            {
                                if (m == 0)
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, 0, getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>&nbsp;";
                                }
                                else
                                {
                                    Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (m + 1), getFileName, getFileEXName, isPop) + "\">" + getPageStyle("" + (m + 1), postResult_color) + "</a>&nbsp;";
                                }
                            }
                        }
                        if ((i + 10) > n)
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"下十页\">" + getPageStyle("<font face=webdings>8</font>", postResult_color) + "</a>&nbsp;";
                        }
                        else
                        {
                            Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, ((i + 1) + 10), getFileName, getFileEXName, isPop) + "\" title=\"下十页\">" + getPageStyle("<font face=webdings>8</font>", postResult_color) + "</a>&nbsp;";
                        }
                    }
                    if (i == (n - 1))
                    {
                        Pagestr += getPageStyle("<font face=webdings title=\"下一页\">4</font>", postResult_color) + "&nbsp;&nbsp;";
                        Pagestr += getPageStyle("<font face=webdings title=\"尾页\">:</font>", postResult_color) + "</div>";
                    }
                    else
                    {
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, (i + 2), getFileName, getFileEXName, isPop) + "\" title=\"下一页\">" + getPageStyle("<font face=webdings>4</font>", postResult_color) + "</a>&nbsp;";
                        Pagestr += "<a href=\"" + getPageresult(ID, ReadType, ContentType, n, getFileName, getFileEXName, isPop) + "\" title=\"尾页\">" + getPageStyle("<font face=webdings>:</font>", postResult_color) + "</a></div>";
                    }
                    break;

            }
            return Pagestr;
        }

        /// <summary>
        /// 处理模板
        /// </summary>
        /// <param name="tempRe">模板实例</param>
        /// <param name="existFlag">该模板是否存在于模板列表</param>
        protected void makeHtmlFile(Template tempRe, bool existFlag, string classID, string NewsID)
        {
            tempRe.ReplaceLabels();
            tempRe.ReplaceIMLabels();
            if (tempRe.MyTempType == TempType.News)
            {
                string FinlContent = tempRe.FinallyContent;
                int pos1 = FinlContent.IndexOf("<!-NT:STAR=");
                int pos2 = FinlContent.IndexOf("NT:END->");
                if (pos1 > -1)
                {
                    int getFiledot = saveNewsPath.LastIndexOf(".");
                    int getFileg = saveNewsPath.LastIndexOf("\\");
                    string getFileName = saveNewsPath.Substring((getFileg + 1), ((getFiledot - getFileg) - 1));
                    string getFileEXName = saveNewsPath.Substring(getFiledot);
                    string PageHead = FinlContent.Substring(0, pos1);
                    string PageEnd = FinlContent.Substring(pos2 + 8);
                    string PageMid = FinlContent.Substring(pos1 + 11, pos2 - pos1 - 11);
                    string[] ArrayCon = PageMid.Split(new string[] { "[NT:PAGE]" }, StringSplitOptions.RemoveEmptyEntries);
                    int n = ArrayCon.Length;
                    //if (ArrayCon[n - 1] == null || ArrayCon[n - 1].Trim() == string.Empty)
                    //    n--;
                    for (int i = 0; i < n; i++)
                    {
                        string filepath = SiteRootPath + saveNewsPath;
                        if (i > 0)
                        {
                            int laspot = filepath.LastIndexOf('.');
                            filepath = filepath.Substring(0, laspot) + "_" + (i + 1) + filepath.Substring(laspot);
                        }
                        string PageContent = PageHead + ArrayCon[i] + PageEnd;
                        string getFileContent = General.ReplaceResultPage(NewsID, PageContent.Replace("[NT:PAGE]", "").Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), getFileName, getFileEXName, n, (i + 1), 0);
                        General.WriteHtml(getFileContent, filepath);
                    }
                    if (n > 0)
                    {
                        if (!existFlag)
                        {
                            templateList.Add(tempRe);
                        }
                        return;
                    }
                }
            }
            General.WriteHtml(tempRe.FinallyContent.Replace("NT:END->", "").Replace("<!-NT:STAR=", ""), SiteRootPath + saveNewsPath);
            if (!existFlag)
            {
                templateList.Add(tempRe);
            }
        }

        /// <summary>
        /// 得到要发布的所有新闻
        /// </summary>
        /// <param name="newsFlag">页面发布种类标志位</param>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得所有新闻的查询结果</returns>
        protected IDataReader getAllNews()
        {
            switch (_newsFlag)
            {
                case 0: return getNewsAll();
                case 1: return getNewsLast();
                case 2: return getNewsUnhtml();
                case 3: return getNewsClasses();
                case 4: return getNewsDate();
                case 5: return getNewsId();
                default: return null;
            }
        }

        /// <summary>
        /// 选择发布所有新闻时，取得所有新闻
        /// </summary> 
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsAll()
        {
            return CommonData.DalPublish.GetPublishNewsAll(out nNewsCount);
        }
        /// <summary>
        /// 选择发布最新时，取得所有新闻
        /// </summary>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsLast()
        {
            int ncount;
            IDataReader rd = CommonData.DalPublish.GetPublishNewsLast(Convert.ToInt32(_strNewsParams), false, out ncount);
            nNewsCount = Convert.ToInt32(_strNewsParams);
            if (ncount < nNewsCount)
            {
                nNewsCount = ncount;
            }
            return rd;
        }
        /// <summary>
        /// 选择只发布未生成时，取得所有新闻
        /// </summary>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsUnhtml()
        {
            int ncount;
            IDataReader rd = CommonData.DalPublish.GetPublishNewsLast(Convert.ToInt32(_strNewsParams), true, out ncount);
            nNewsCount = Convert.ToInt32(_strNewsParams);
            if (ncount < nNewsCount)
            {
                nNewsCount = ncount;
            }
            return rd;
        }
        /// <summary>
        /// 选择选择栏目时，取得所有新闻
        /// </summary>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsClasses()
        {
            bool IsHtml = false;//还没有起作用
            bool IsDesc = false;//还没有起作用
            if (_strNewsParams.IndexOf("#") >= 0)
            {
                //只发布未发布的
                IsHtml = true;
                _strNewsParams = _strNewsParams.Replace("#", "");
            }
            if (_strNewsParams.IndexOf("&") >= 0)
            {
                //倒序
                IsDesc = true;
                _strNewsParams = _strNewsParams.Replace("&", "");
            }
            string classid = "";
            string[] PublishParam = _strNewsParams.Split('$');
            int n = PublishParam.Length;
            for (int i = 0; i < n - 1; i++)
            {
                if (i > 0)
                    classid += ",";
                classid += "'" + PublishParam[i] + "'";
            }
            return CommonData.DalPublish.GetPublishNewsByClass(classid, IsHtml, IsDesc, PublishParam[n - 1], out nNewsCount);
        }
        /// <summary>
        /// 选择按照日期发布时，取得所有新闻
        /// </summary>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsDate()
        {
            DateTime StartTm = Convert.ToDateTime(_strNewsParams.Split('$')[0]);
            DateTime EndTm = Convert.ToDateTime(_strNewsParams.Split('$')[1]);
            return CommonData.DalPublish.GetPublishNewsByTime(StartTm, EndTm, out nNewsCount);
        }
        /// <summary>
        /// 选择按照ID发布时，取得所有新闻
        /// </summary>
        /// <param name="strParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有新闻的查询结果</returns>
        protected IDataReader getNewsId()
        {
            int MinID = Convert.ToInt32(_strNewsParams.Split('$')[0]);
            int MaxID = Convert.ToInt32(_strNewsParams.Split('$')[1]);
            return CommonData.DalPublish.GetPublishNewsByID(MinID, MaxID, out nNewsCount);
        }
        /// <summary>
        /// 得到要发布的所有栏目
        /// </summary>
        /// <param name="ClassFlag">页面发布种类标志位</param>
        /// <returns>取得所有栏目的查询结果</returns>
        protected IDataReader getAllClass()
        {
            switch (_ClassFlag)
            {
                case 0: return getClassesAll();
                case 1: return getClassesSelect();
                default: return null;
            }
        }
        /// <summary>
        ///  选择发布所有栏目时，取得所有栏目
        /// </summary>
        /// <param name="strClassParams">页面信息字符串</param>
        /// <returns>取得符合条件的所有栏目的查询结果</returns>
        protected IDataReader getClassesAll()
        {
            if (_strClassParams.IndexOf("#") >= 0)
            {
                return CommonData.DalPublish.GetPublishClass(NetCMS.Global.Current.SiteID, "", true, out nClassCount);

            }
            else
            {
                return CommonData.DalPublish.GetPublishClass(NetCMS.Global.Current.SiteID, "", false, out nClassCount);
            }
        }
        /// <summary>
        /// 选择发选择栏目时，取得所有栏目
        /// </summary>        
        /// <returns>取得符合条件的所有栏目的查询结果</returns>
        protected IDataReader getClassesSelect()
        {
            if (_strClassParams != null)
            {
                string classid = "";
                string[] classparm = _strClassParams.Split('$');
                for (int i = 0; i < classparm.Length; i++)
                {
                    if (i > 0)
                    {
                        classid += ",";

                    }
                    classid += "'" + classparm[i] + "'";
                }
                return CommonData.DalPublish.GetPublishClass("", classid, true, out nClassCount);
            }
            else
            {
                HProgressBar.Roll("请选择栏目", 0);
                return null;
            }
        }
        /// <summary>
        /// 得到要发布的所有专题
        /// </summary>
        /// <param name="specialFlag">页面发布种类标志位</param>        
        /// <returns>取得所有专题的查询结果</returns>
        protected IDataReader getAllSpecials()
        {
            string spid = string.Empty;
            switch (_specialFlag)
            {
                case 0:
                    break;
                case 1:
                    spid = getSpecialsSelect();
                    break;
                default:
                    return null;
            }
            return CommonData.DalPublish.GetPublishSpecial(spid, out nSpecialCount);
        }
        /// <summary>
        /// 选择选择专题时，取得所有专题
        /// </summary>        
        /// <returns>取得符合条件的所有专题的查询结果</returns>
        protected string getSpecialsSelect()
        {
            if (_strSpecialParams != null)
            {
                string reslt = "";
                string[] spparam = _strSpecialParams.Split('$');
                for (int i = 0; i < spparam.Length; i++)
                {
                    if (i > 0)
                        reslt += ",";
                    reslt += "'" + spparam[i] + "'";
                }
                return reslt;
            }
            else
            {
                HProgressBar.Roll("请选择专题", 0);
                return "";
            }
        }
    }
}