//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using NetCMS.Config;
using NetCMS.Model;
using NetCMS.Content;

namespace NetCMS.Web.UI
{
    public class BasePage : System.Web.UI.Page
    {
        protected readonly int PAGESIZE = Config.UIConfig.GetPageSize();
        protected internal UserLogin _UserLogin;
        protected internal string CopyRight = "<span style=\"font-size:10px;\">(c)2008 AspxCMS Inc. By " + NetCMS.Config.verConfig.Productversion + "</span>";
        protected void AddStyleSheet(Page page, string cssPath)
        {
            HtmlLink link = new HtmlLink();
            link.Href = cssPath;
            link.Attributes["rel"] = "stylesheet";
            link.Attributes["type"] = "text/css";
        }
        public BasePage()
        {
            _UserLogin = new UserLogin();
        }
        protected void PageRight(string RightMsg, string Url)
        {
            PageRight(RightMsg, Url, false);
        }

        protected void PageRight(string ErrMsg, string Url, bool RetrunUrl)
        {
            WebHint.ShowRight(ErrMsg, Url, RetrunUrl);
        }

        protected void PageError(string ErrMsg, string Url)
        {
            PageError(ErrMsg, Url, false);
        }

        protected void PageError(string ErrMsg, string Url, bool RetrunUrl)
        {
            WebHint.ShowError(ErrMsg, Url, RetrunUrl);
        }

        /// <summary>
        /// ˳
        /// </summary>
        protected virtual void Logout()
        {
            Context.Session.Remove("SITEINFO");
        }
        /// <summary>
        /// ִһJS
        /// </summary>
        /// <param name="sentence">Ҫִе</param>
        protected void ExecuteJs(string sentence)
        {
            Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
            Context.Response.Write(sentence);
            Context.Response.Write("</script>");
        }
        /// <summary>
        /// ûϢỰǷʱ
        /// </summary>
        /// <returns></returns>
        protected bool Validate_Session()
        {
            return !NetCMS.Global.Current.IsTimeout();
        }
        protected void LoginResultShow(EnumLoginState state)
        {
            LoginResultShow(state, false);
        }
        protected void LoginResultShow(EnumLoginState state, bool isAjax)
        {
            string ErrorMsg = string.Empty;
            int isAdminReturn = 0;
            switch (state)
            {
                case EnumLoginState.Err_IPLimited:
                    ErrorMsg = "IP[" + NetCMS.Common.Public.getUserIP() + "]ƣܵ½!";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_Locked:
                    ErrorMsg = "Ѿ!";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_UnEmail:
                    ErrorMsg = "ûͨʼܵ½ϵͳ!";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_AdminTimeOut:
                    ErrorMsg = "Ựڣµ½";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_UserTimeOut:
                    ErrorMsg = "Ựڣµ½";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_UnMobile:
                    ErrorMsg = "ûֻ֤ͨܵ½ϵͳ!<li><a href=\"" + (UIConfig.dirDumm.Equals(string.Empty) ? "" : (UIConfig.dirDumm + "/")) + UIConfig.dirUser + "info/MobileValidate.aspx?uid=" + Global.Current.UserName + "\"><font color=\"Blue\">˴ֻ֤</font></li>";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_UnCert:
                    ErrorMsg = "<script language=\"javascript\" type=\"text/javascript\">alert('û֤ϣ\\n [ȷ] ʵ֤');location.href='" + (UIConfig.dirDumm.Equals(string.Empty) ? "" : (UIConfig.dirDumm + "/")) + UIConfig.dirUser + "/info/userinfo_idcard.aspx?type=CreatCert\';</script>";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_NoAuthority:
                    ErrorMsg = "ûдĲȨ!";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_AdminLocked:
                    ErrorMsg = "ѱ";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_DbException:
                    ErrorMsg = "ϵͳ<li><span style=\"color:red\">ԭ</span></li><li>ݿͨʧܡ</li><li>ݿַȷ</li><li>ݿⷢ쳣</li>";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_UserNumInexistent:
                    ErrorMsg = "û";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_AdminNumInexistent:
                    ErrorMsg = "Ȩ޲㣡";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_DurativeLogError:
                    ErrorMsg = "½Ѿ," + _UserLogin.GetLoginSpan() + "Ӻٵ¼!";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_AdminNameOrPwdError:
                    ErrorMsg = "ûڻ";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_UserNameOrPwdError:
                    ErrorMsg = "ûڻ";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_GroupExpire:
                    ErrorMsg = "ʺѹ";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_NotAdmin:
                    ErrorMsg = "ǸǹԱĲѾ¼<li>IP[" + NetCMS.Common.Public.getUserIP() + "]ѱ¼</li>";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Succeed:
                    return;
                default:
                    ErrorMsg = "쳣" + state.ToString();
                    isAdminReturn = 0;
                    break;
            }
            string dimm = NetCMS.Config.UIConfig.dirDumm.Trim();
            if (dimm != string.Empty)
            {
                dimm = "/" + dimm;
            }
            string ReturnUrl = string.Empty;
            switch (isAdminReturn)
            {
                case 0:
                    ReturnUrl = dimm + "/" + NetCMS.Config.UIConfig.dirUser + "/login.aspx";
                    break;
                case 1:
                    if (state == EnumLoginState.Err_NoAuthority)
                    {
                        ReturnUrl = dimm + "/" + NetCMS.Config.UIConfig.dirMana + "/main.aspx";
                    }
                    else
                    {
                        ReturnUrl = dimm + "/" + NetCMS.Config.UIConfig.dirMana + "/login.aspx";
                    }
                    break;
                default:
                    ReturnUrl = dimm + "/";
                    break;
            }
            if (isAjax)
                throw new Exception(ErrorMsg);
            else
                PageError(ErrorMsg, ReturnUrl, true);
        }
        protected void CheckUserLogin()
        {
            if (!Validate_Session())
                LoginResultShow(EnumLoginState.Err_UserTimeOut);
            else
                LoginResultShow(CheckUserLogin(NetCMS.Global.Current.UserNum, false));
        }
        protected void CheckUserLoginCert()
        {
            if (!Validate_Session())
                LoginResultShow(EnumLoginState.Err_UserTimeOut);
            else
                LoginResultShow(CheckUserLogin(NetCMS.Global.Current.UserNum, true));
        }
        protected void CheckAdminLogin()
        {
            if (!Validate_Session())
                LoginResultShow(EnumLoginState.Err_AdminTimeOut);
            else
                LoginResultShow(CheckUserLogin(NetCMS.Global.Current.UserNum, true));
        }
        /// <summary>
        /// ͨԱ¼״̬
        /// </summary>
        /// <param name="UserNum"></param>
        /// <param name="IsCert"></param>
        /// <param name="LimitedIP"></param>
        /// <returns></returns>
        private EnumLoginState CheckUserLogin(string UserNum, bool IsCert)
        {
            return _UserLogin.CheckUserLogin(UserNum, IsCert);
        }
        /// <summary>
        /// Ա¼״̬
        /// </summary>
        /// <param name="UserNum"></param>
        /// <param name="LimitedIP"></param>
        /// <returns></returns>
        private EnumLoginState CheckAdminLogin(string UserNum)
        {
            return _UserLogin.CheckAdminLogin(UserNum);
        }
       /// <summary>
       /// û¼
       /// </summary>
       /// <param name="UserName"></param>
       /// <param name="Password"></param>
       /// <param name="info"></param>
       /// <param name="IsAdmin"></param>
       /// <returns></returns>
        protected EnumLoginState Login(string UserName,string Password,out GlobalUserInfo info, bool IsAdmin)
        {
            if (IsAdmin)
                return _UserLogin.AdminLogin(UserName, Password, out info);
            else
                return _UserLogin.PersonLogin(UserName, Password, out info);
                
        }
       /// <summary>
        /// û¼
       /// </summary>
       /// <param name="UserName"></param>
       /// <param name="Password"></param>
       /// <param name="info"></param>
       /// <returns></returns>
        protected EnumLoginState Login(string UserName, string Password, out GlobalUserInfo info)
        {
                return _UserLogin.PersonLogin(UserName, Password, out info);
        }
        /// <summary>
        /// û¼
        /// </summary>
        /// <param name="UserName"></param>
        /// <param name="Password"></param>
        protected void Login(string UserName, string Password)
        {
            GlobalUserInfo info;
            EnumLoginState state = _UserLogin.PersonLogin(UserName, Password, out info);
            if (state == EnumLoginState.Succeed)
                Global.Current.Set(info);
            else
                LoginResultShow(state);
        }

        /// <summary>
        /// û¼
        /// </summary>
        /// <param name="UserName"></param>
        /// <param name="Password"></param>
        protected void AjaxLogin(string UserName, string Password)
        {
            GlobalUserInfo info;
            EnumLoginState state = _UserLogin.PersonLogin(UserName, Password, out info);
            if (state == EnumLoginState.Succeed)
                Global.Current.Set(info);
            else
                LoginResultShow(state, true);
        }

    }
}
