﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetCMS.Content;
using NetCMS.Model;

public partial class manage_channel_class_manage : NetCMS.Web.UI.ManagePage
{
    public static string ChID = string.Empty;
    public static string Action = string.Empty;
    Channel rd = new Channel();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (SiteID != "0")
            {
                PageError("分站没权限操作", "javascript:history.back();", true);
            }
            ChID = Request.QueryString["ChID"];
            Action = Request.QueryString["Action"];
            if (ChID != null && ChID != string.Empty)
            {
                copyright.InnerHtml = CopyRight;
                if (Action != string.Empty && Action != null)
                {
                    this.sClass.Items.Clear();
                    switch (Action.ToString())
                    {
                        case "until":
                            this.tClass.Items.Clear();
                            this.ButtonAction.Text = "执行 > 合并栏目";
                            this.StatAction.Value = "Toutil";
                            this.Panel1.Visible = true;
                            this.Panel2.Visible = true;
                            this.Panel3.Visible = false;
                            GetClassList((this.sClass), 0, 0);
                            GetClassList((this.tClass), 0, 0);
                            break;
                        case "move":
                            this.ButtonAction.Text = "执行 > 移动栏目";
                            this.StatAction.Value = "ToMove";
                            this.Panel1.Visible = true;
                            this.Panel2.Visible = true;
                            this.Panel3.Visible = false;
                            GetClassList((this.sClass), 0, 0);
                            GetClassList((this.tClass), 0, 0);
                            break;
                        default:
                            this.ButtonAction.Text = "执行 > 批量设置";
                            this.StatAction.Value = "ToSet";
                            this.Panel1.Visible = true;
                            this.Panel2.Visible = false;
                            this.Panel3.Visible = true;
                            GetClassList((this.sClass), 0, 0);
                            //GetClassList((this.tClass), 0, 0);
                            break;
                    }
                }
            }
            else
            {
                PageError("错误的参数", "javascript:history.back();", true);
            }
        }
    }

    protected void GetClassList(DropDownList lst, int ParentID, int Layer)
    {
        IDataReader dr = rd.getClassList(ParentID, int.Parse(ChID.ToString()));
        while (dr.Read())
        {
            ListItem it = new ListItem();
            string stxt = "";
            it.Value = dr["ID"].ToString();
            if (Layer > 0)
                stxt = "┝";
            for (int i = 1; i < Layer; i++)
            {
                stxt += "┉";
            }
            it.Text = stxt + dr["ClassCName"].ToString();
            lst.Items.Add(it);
            GetClassList(lst, int.Parse(dr["ID"].ToString()), (Layer + 1));

        }
        dr.Close();
    }

    protected void ButtonAction_Click(object sender, EventArgs e)
    {
        int sClassID = int.Parse(this.sClass.SelectedValue);
        int tClassID = int.Parse(this.tClass.SelectedValue);
        switch (Action)
        { 
            case "until":
                if (sClassID == tClassID)
                {
                    PageError("目标栏目和源不能一样", "javascript:history.back();", true);
                }
                rd.utilClass(sClassID, tClassID, int.Parse(ChID.ToString()));
                PageRight("合并栏目成功", "class_list.aspx?ChID=" + ChID + "", true);
                break;
            case "move":
                if (sClassID == tClassID)
                {
                    PageError("目标栏目和源不能一样", "javascript:history.back();", true);
                }
                rd.moveClass(sClassID, tClassID);
                PageRight("移动栏目成功", "class_list.aspx?ChID=" + ChID + "", true);
                break;
            default:
                break;
        }
    }
}
