﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetCMS.Content;

public partial class manage_channel_list : NetCMS.Web.UI.ManagePage
{
    UserMisc rd = new UserMisc();
    Channel md = new Channel();
    public string addStr = string.Empty;
    protected void Page_Load(object sender, EventArgs e)
    {
        addStr = checkPr("C035", "&nbsp;┋&nbsp;<a href=\"channel_add.aspx\" class=\"topnavichar\" >添加频道</a>");
        this.PageNavigator1.OnPageChange += new PageChangeHandler(PageNavigator1_PageChange);
        if (!IsPostBack)
        {
            copyright.InnerHtml = CopyRight;            //获取版权信息
            Response.CacheControl = "no-cache";                        //设置页面无缓存
            //ChID=8&action=del
            string Act = Request.QueryString["action"];
            string isLock = Request.QueryString["isLock"];
            if (Act != null && Act != string.Empty)
            {
                string ChID = Request.QueryString["ChID"];
                if (ChID == null && ChID == string.Empty)
                {
                    PageError("错误的参数", "list.aspx", true);
                }
                switch (Act)
                { 
                    case "del":
                        delModel(ChID.ToString());
                        break;
                    case "copy":
                        break;
                }
            }
            if (isLock != null && isLock != string.Empty)
            {
                string ChID = Request.QueryString["ChID"];
                if (ChID == null && ChID == string.Empty)
                {
                    PageError("错误的参数", "list.aspx", true);
                }
                ModelStat(ChID.ToString(), isLock.ToString());
            }
            StartLoad(1);
        }
    }

    /// <summary>
    /// 缩定频道
    /// </summary>
    /// <param name="ChID"></param>
    /// <param name="isLock"></param>
    protected void ModelStat(string ChID, string isLock)
    {
        md.ModelStat(int.Parse(ChID), int.Parse(isLock));
        if (isLock == "1")
        {
            PageRight("频道已设置为锁定", "list.aspx", true);
        }
        else
        {
            PageRight("频道已设置为开放", "list.aspx", true);
        }
    }

    protected void delModel(string ChID)
    {
        if (md.getSysCord(int.Parse(ChID)) == 1)
        {
            PageError("系统频道不能删除", "list.aspx", true);
        }
        else
        {
            md.delModel(int.Parse(ChID));
            Response.Write("<script>alert('删除成功');window.top.location.href=\"../index.aspx?urls=channel/list.aspx\"</script>");
            Response.End();
        }
    }

    /// <summary>
    /// PageNavigator1_PageChange 的摘要说明
    /// 分页加载函数
    /// </summary>
    protected void PageNavigator1_PageChange(object sender, int PageIndex)
    {
        StartLoad(PageIndex);
    }

    /// <summary>
    /// PageNavigator1_PageChange 的摘要说明
    /// 分页加载列表函数
    /// </summary>
    protected void StartLoad(int PageIndex)
    {
        int i, j;
        DataTable dt = null;
        dt = NetCMS.Content.Pagination.GetPage(this.GetType().Name, PageIndex, 20, out i, out j, null);
        this.PageNavigator1.PageCount = j;
        this.PageNavigator1.PageIndex = PageIndex;
        this.PageNavigator1.RecordCount = i;
        if (dt != null)
        {
            if (dt.Rows.Count > 0)
            {
                //----------------------------------------添加列------------------------------------------------
                dt.Columns.Add("op", typeof(string));
                dt.Columns.Add("islocks", typeof(string));
                dt.Columns.Add("systf", typeof(string));
                dt.Columns.Add("cNames1", typeof(string));
                //----------------------------------------添加列结束--------------------------------------------
                //权限判断
                string addFont = string.Empty;//添加字段
                string fontManage = string.Empty;//字段管理
                string updateStr = string.Empty;//修改频道
                string open = string.Empty;//开放/关闭频道
                string close = string.Empty;//关闭频道 
                string delete = string.Empty;//删除频道

                addFont = checkPr("D013", "0");
                fontManage = checkPr("D014", "0");
                updateStr = checkPr("C036", "0");
                open = checkPr("C065", "0");
                close = checkPr("C066", "0");
                delete = checkPr("C037", "0");
                
                //定义变量
                string getIsSysTF=string.Empty;
                for (int k = 0; dt.Rows.Count > k; k++)
                {
                    if (dt.Rows[k]["cNames"].ToString().Length < 1)
                    {
                        dt.Rows[k]["cNames1"] = "根频道";
                    }
                    else
                    {
                        dt.Rows[k]["cNames1"] = dt.Rows[k]["cNames"].ToString();
                    }
                    if (dt.Rows[k]["issys"].ToString() == "1")
                    {
                        if (delete != string.Empty)
                        {
                            getIsSysTF = "&nbsp;┊&nbsp;<span style=\"color:#999999\" title=\"系统频道不能删除\">删除</span>";
                        }
                        dt.Rows[k]["systf"] = "<span class=\"tbie\">系统</span>";
                    }
                    else
                    {
                        if (delete != string.Empty)
                        {
                            getIsSysTF = "&nbsp;┊&nbsp;<a  onClick=\"{if(confirm('确定要删除吗？')){return true;}return false;}\" title=\"点击删除\" href=\"list.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "&action=del\" class=\"list_link\">删除</a>";
                        }
                        dt.Rows[k]["systf"] = "自定义";
                    }
                    string lockStr = "";
                    if (dt.Rows[k]["islock"].ToString() == "1")
                    {
                        if (open != string.Empty)
                        {
                            lockStr = "&nbsp;┊&nbsp;<a href=\"list.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "&isLock=0\"  onClick=\"{if(confirm('确定要开放此频道吗？')){return true;}return false;}\" class=\"reshow\" title=\"点击开放\">已禁用</a>";
                        }
                    }
                    else
                    {
                        if (close != string.Empty)
                        {
                            lockStr = "&nbsp;┊&nbsp;<a href=\"list.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "&isLock=1\"  onClick=\"{if(confirm('确定要禁用此频道吗？')){return true;}return false;}\" class=\"list_link\" title=\"点击锁定\">已开放</a>";
                        }
                    }
                    //┊&nbsp;<a href=\"list.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "&action=copy\" class=\"list_link\">复制</a>&nbsp;
                    if (addFont != string.Empty)
                    {
                        dt.Rows[k]["op"] = "<a href=\"value_add.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "\" class=\"list_link\">增加字段</a>";
                    }

                    if(fontManage!=string.Empty)
                    {
                        dt.Rows[k]["op"] += "&nbsp;┊&nbsp;<a href=\"value.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "\" class=\"list_link\">字段管理</a>";
                    }
                    
                    if(updateStr!=string.Empty)
                    {
                        dt.Rows[k]["op"] += "&nbsp;┊&nbsp;<a href=\"channel_add.aspx?ChID=" + dt.Rows[k]["ID"].ToString() + "\" class=\"list_link\">修改</a>";
                    }

                    dt.Rows[k]["op"] += lockStr +getIsSysTF + "";
                    if (dt.Rows[k]["islock"].ToString() == "0"){ dt.Rows[k]["islocks"] = "正常"; }
                    else{dt.Rows[k]["islocks"] = "<span class=\"tbie\">锁定</span>";}
                }
            }
        }
        Channlist.DataSource = dt;                              //设置datalist数据源
        Channlist.DataBind();                                   //绑定数据源
    }


    protected void DataList1_ItemCommand(object source, RepeaterCommandEventArgs e)
    {

    }

    /// <summary>
    /// 权限判断
    /// </summary>
    /// <param name="code">权限代码</param>
    /// <returns></returns>
    public string checkPr(string code, string tempStr)
    {
        this.Authority_Code = code;
        string str = string.Empty;
        if (CheckAuthority())
        {
            str = tempStr;
        }
        return str;
    }
}
