﻿//======================================================
//==     (c)2008 aspxcms inc by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetCMS.Content;

public partial class manage_channel_value_add : NetCMS.Web.UI.ManagePage
{
    public manage_channel_value_add()
    {
        this.Authority_Code = "D013";
    }
    Channel rd = new Channel();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            copyright.InnerHtml = CopyRight;
            string ChID = Request.QueryString["ChID"];
            string vID = Request.QueryString["vID"];
            if (SiteID.Trim() != "0")
            {
                PageError("您没权限创建字段", "javascript:history.back();", true);
            }
            if (ChID == string.Empty || ChID == null)
            {
                PageError("错误的参数", "javascript:history.back()", true);
            }
            else
            {
                IDataReader dr = rd.getModelinfo(int.Parse(ChID.ToString()));
                if (dr.Read())
                {
                    ChannelName.InnerHtml = dr["channelName"].ToString();
                }
                dr.Close();
                if (vID != string.Empty && vID != null)
                {
                    IDataReader Cr = rd.getChValue(int.Parse(vID.ToString()));
                    if (Cr.Read())
                    {
                        vType.InnerHtml = NetCMS.Common.Public.getValueType(Cr["vType"].ToString());
                        this.CName.Text = Cr["CName"].ToString();
                        this.EName.Text = Cr["EName"].ToString();
                        this.EName.Enabled = false;
                        this.vitem.Text = Cr["vitem"].ToString();
                        this.vValue.Text = Cr["vValue"].ToString();
                        this.vDescript.Text = Cr["vDescript"].ToString();
                        this.vLength.Text = Cr["vLength"].ToString();
                        this.vHeight.Text = Cr["vHeight"].ToString();
                        if (Cr["isNulls"].ToString() == "1")
                        {
                            this.isNulls.Checked = true;
                        }
                        else
                        {
                            this.isNulls.Checked = false;
                        }
                        if (Cr["isLock"].ToString() == "1")
                        {
                            this.isLock.Checked = true;
                        }
                        if (Cr["isUser"].ToString() == "1")
                        {
                            this.isUser.Checked = true;
                        }
                        if (Cr["isSearch"].ToString() == "1")
                        {
                            this.isSearch.Checked = true;
                        }
                        this.OrderID.Text = Cr["OrderID"].ToString();
                        for (int i = 0; i < this.HTMLedit.Items.Count; i++)
                        {
                            if (Cr["Htmledit"].ToString() == this.HTMLedit.Items[i].Value)
                            {
                                this.HTMLedit.Items[i].Selected = true;
                            }
                        }
                    }
                    Cr.Close();
                }
                else
                {
                    this.Authority_Code = "D013";
                    this.CheckAdminAuthority();
                    vType.InnerHtml = NetCMS.Common.Public.getValueType("999");
                }
            }
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            string CName = this.CName.Text;
            string EName = this.EName.Text;
            if (EName.Trim().Length < 4)
            {
                PageError("请正确填写字段英文名称(别名)", "javascript:history.back();", true);
            }
            if (EName.Substring(0, 3) != "ch_")
            {
                PageError("字段英文名称(别名)必须以ch_开头", "javascript:history.back();", true);
            }
            int vID = 0;
            int vType = 0;
            if (Request.QueryString["vID"] != null && Request.QueryString["vID"] != string.Empty)
            {
                vID = int.Parse(Request.QueryString["vID"]);
                IDataReader dr=rd.getChValue(vID);
                if(dr.Read())
                {
                    vType = int.Parse(dr["vType"].ToString());
                }
                dr.Close();
            }
            else
            {
                vType = int.Parse(Request.Form["vType"]);
            }
            string vitem = this.vitem.Text;
            string vValue = this.vValue.Text;
            string vDescript = this.vDescript.Text;
            string vLength = this.vLength.Text;
            int isNulls = 0;
            if (this.isNulls.Checked)
            {
                isNulls = 1;
            }
            int isLock = 0;
            if (this.isLock.Checked)
            {
                isLock = 1;
            }
            int isUser=0;
            if (this.isUser.Checked)
            {
                isUser = 1;
            }
            int OrderID = 0;
            if (NetCMS.Common.Input.IsInteger(this.OrderID.Text))
            { 
                OrderID = int.Parse(this.OrderID.Text);
            }
            int ChID = int.Parse(Request.QueryString["ChID"]);
            string TableSTR = rd.getChannelTable(ChID);
            if (TableSTR == "#")
            {
                PageError("错误的参数，找不到数据库表。", "javascript:history.back();", true);
            }
            if (rd.getChannelValueTF(ChID, EName,vID))
            {
                PageError("字段名已经存在！", "javascript:history.back();", true);
            }
            int isSearch = 0;
            if (this.isSearch.Checked)
            {
                isSearch = 1;
            }
            int HTMLedit = 0;
            HTMLedit = int.Parse(this.HTMLedit.SelectedValue);
            string vHeight = "100";
            if(this.vHeight.Text.Trim()!=string.Empty)
            {
                vHeight = this.vHeight.Text;
            }
            NetCMS.Model.ChannelValue uc = new NetCMS.Model.ChannelValue();
            uc.Id = vID;
            uc.ChID = ChID;
            uc.CName = CName;
            uc.OrderID = OrderID;
            uc.EName = EName;
            uc.vDescript = vDescript;
            uc.vType = vType;
            uc.vLength = vLength;
            if (vType == 16 || vType == 15)
            {
                vValue = vValue.Trim() + "|";
                uc.vValue = vValue.Trim().Replace("||", "|");
            }
            else
            {
                uc.vValue = vValue;
            }
            uc.isNulls = isNulls;
            uc.isUser = isUser;
            uc.vitem = vitem;
            uc.isLock = isLock;
            uc.SiteID = SiteID;
            uc.vHeight = vHeight;
            uc.isSearch = isSearch;
            uc.HTMLedit = HTMLedit;
            uc.fieldLength = getLength(vType);
            if (Request.QueryString["vID"] != null && Request.QueryString["vID"] != string.Empty)
            {
                rd.UpdateFields(uc, TableSTR);
                PageRight("修改数据库字段成功", "value.aspx?ChID=" + ChID + "", true);
            }
            else
            {
                rd.insertFields(uc, TableSTR);
                PageRight("创建数据库字段成功", "value.aspx?ChID=" + ChID + "", true);
            }
        }
    }

    /// <summary>
    /// 得到每个字段的长度
    /// </summary>
    /// <param name="vType"></param>
    /// <returns></returns>
    protected string getLength(int vType)
    {
        string LenStr = string.Empty;
        switch (vType)
        {
            case 0:
                LenStr = "20";
                break;
            case 1:
                LenStr = "50";
                break;
            case 2:
                LenStr = "100";
                break;
            case 3:
                LenStr = "180";
                break;
            case 4:
                LenStr = "225";
                break;
            case 5:
                LenStr = "16";
                break;
            case 6:
                LenStr = "200";
                break;
            case 7:
                LenStr = "4";
                break;
            case 8:
                LenStr = "1";
                break;
            case 9:
                LenStr = "8";
                break;
            case 10:
                LenStr = "8";
                break;
            case 11:
                LenStr = "4";
                break;
            case 12:
                LenStr = "200";
                break;
            case 13:
                LenStr = "16";
                break;
            case 14:
                LenStr = "200";
                break;
            case 15:
                LenStr = "200";
                break;
            case 16:
                LenStr = "16";
                break;
            case 17:
                LenStr = "16";
                break;
            default:
                LenStr = "200";
                break;
        }
        return LenStr;
    }
}
